@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.aws.cognito.kotlin

import com.pulumi.core.Output
import com.pulumi.kotlin.KotlinCustomResource
import com.pulumi.kotlin.PulumiTagMarker
import com.pulumi.kotlin.ResourceMapper
import com.pulumi.kotlin.options.CustomResourceOptions
import com.pulumi.kotlin.options.CustomResourceOptionsBuilder
import com.pulumi.resources.Resource
import kotlin.Boolean
import kotlin.String
import kotlin.Suppress
import kotlin.Unit
import kotlin.collections.List
import kotlin.collections.Map

/**
 * Builder for [IdentityProvider].
 */
@PulumiTagMarker
public class IdentityProviderResourceBuilder internal constructor() {
    public var name: String? = null

    public var args: IdentityProviderArgs = IdentityProviderArgs()

    public var opts: CustomResourceOptions = CustomResourceOptions()

    /**
     * @param name The _unique_ name of the resulting resource.
     */
    public fun name(`value`: String) {
        this.name = value
    }

    /**
     * @param block The arguments to use to populate this resource's properties.
     */
    public suspend fun args(block: suspend IdentityProviderArgsBuilder.() -> Unit) {
        val builder = IdentityProviderArgsBuilder()
        block(builder)
        this.args = builder.build()
    }

    /**
     * @param block A bag of options that control this resource's behavior.
     */
    public suspend fun opts(block: suspend CustomResourceOptionsBuilder.() -> Unit) {
        this.opts = com.pulumi.kotlin.options.CustomResourceOptions.opts(block)
    }

    internal fun build(): IdentityProvider {
        val builtJavaResource = com.pulumi.aws.cognito.IdentityProvider(
            this.name,
            this.args.toJava(),
            this.opts.toJava(),
        )
        return IdentityProvider(builtJavaResource)
    }
}

/**
 * Provides a Cognito User Identity Provider resource.
 * ## Example Usage
 * <!--Start PulumiCodeChooser -->
 * ```typescript
 * import * as pulumi from "@pulumi/pulumi";
 * import * as aws from "@pulumi/aws";
 * const example = new aws.cognito.UserPool("example", {
 *     name: "example-pool",
 *     autoVerifiedAttributes: ["email"],
 * });
 * const exampleProvider = new aws.cognito.IdentityProvider("example_provider", {
 *     userPoolId: example.id,
 *     providerName: "Google",
 *     providerType: "Google",
 *     providerDetails: {
 *         authorize_scopes: "email",
 *         client_id: "your client_id",
 *         client_secret: "your client_secret",
 *     },
 *     attributeMapping: {
 *         email: "email",
 *         username: "sub",
 *     },
 * });
 * ```
 * ```python
 * import pulumi
 * import pulumi_aws as aws
 * example = aws.cognito.UserPool("example",
 *     name="example-pool",
 *     auto_verified_attributes=["email"])
 * example_provider = aws.cognito.IdentityProvider("example_provider",
 *     user_pool_id=example.id,
 *     provider_name="Google",
 *     provider_type="Google",
 *     provider_details={
 *         "authorize_scopes": "email",
 *         "client_id": "your client_id",
 *         "client_secret": "your client_secret",
 *     },
 *     attribute_mapping={
 *         "email": "email",
 *         "username": "sub",
 *     })
 * ```
 * ```csharp
 * using System.Collections.Generic;
 * using System.Linq;
 * using Pulumi;
 * using Aws = Pulumi.Aws;
 * return await Deployment.RunAsync(() =>
 * {
 *     var example = new Aws.Cognito.UserPool("example", new()
 *     {
 *         Name = "example-pool",
 *         AutoVerifiedAttributes = new[]
 *         {
 *             "email",
 *         },
 *     });
 *     var exampleProvider = new Aws.Cognito.IdentityProvider("example_provider", new()
 *     {
 *         UserPoolId = example.Id,
 *         ProviderName = "Google",
 *         ProviderType = "Google",
 *         ProviderDetails =
 *         {
 *             { "authorize_scopes", "email" },
 *             { "client_id", "your client_id" },
 *             { "client_secret", "your client_secret" },
 *         },
 *         AttributeMapping =
 *         {
 *             { "email", "email" },
 *             { "username", "sub" },
 *         },
 *     });
 * });
 * ```
 * ```go
 * package main
 * import (
 * 	"github.com/pulumi/pulumi-aws/sdk/v6/go/aws/cognito"
 * 	"github.com/pulumi/pulumi/sdk/v3/go/pulumi"
 * )
 * func main() {
 * 	pulumi.Run(func(ctx *pulumi.Context) error {
 * 		example, err := cognito.NewUserPool(ctx, "example", &cognito.UserPoolArgs{
 * 			Name: pulumi.String("example-pool"),
 * 			AutoVerifiedAttributes: pulumi.StringArray{
 * 				pulumi.String("email"),
 * 			},
 * 		})
 * 		if err != nil {
 * 			return err
 * 		}
 * 		_, err = cognito.NewIdentityProvider(ctx, "example_provider", &cognito.IdentityProviderArgs{
 * 			UserPoolId:   example.ID(),
 * 			ProviderName: pulumi.String("Google"),
 * 			ProviderType: pulumi.String("Google"),
 * 			ProviderDetails: pulumi.StringMap{
 * 				"authorize_scopes": pulumi.String("email"),
 * 				"client_id":        pulumi.String("your client_id"),
 * 				"client_secret":    pulumi.String("your client_secret"),
 * 			},
 * 			AttributeMapping: pulumi.StringMap{
 * 				"email":    pulumi.String("email"),
 * 				"username": pulumi.String("sub"),
 * 			},
 * 		})
 * 		if err != nil {
 * 			return err
 * 		}
 * 		return nil
 * 	})
 * }
 * ```
 * ```java
 * package generated_program;
 * import com.pulumi.Context;
 * import com.pulumi.Pulumi;
 * import com.pulumi.core.Output;
 * import com.pulumi.aws.cognito.UserPool;
 * import com.pulumi.aws.cognito.UserPoolArgs;
 * import com.pulumi.aws.cognito.IdentityProvider;
 * import com.pulumi.aws.cognito.IdentityProviderArgs;
 * import java.util.List;
 * import java.util.ArrayList;
 * import java.util.Map;
 * import java.io.File;
 * import java.nio.file.Files;
 * import java.nio.file.Paths;
 * public class App {
 *     public static void main(String[] args) {
 *         Pulumi.run(App::stack);
 *     }
 *     public static void stack(Context ctx) {
 *         var example = new UserPool("example", UserPoolArgs.builder()
 *             .name("example-pool")
 *             .autoVerifiedAttributes("email")
 *             .build());
 *         var exampleProvider = new IdentityProvider("exampleProvider", IdentityProviderArgs.builder()
 *             .userPoolId(example.id())
 *             .providerName("Google")
 *             .providerType("Google")
 *             .providerDetails(Map.ofEntries(
 *                 Map.entry("authorize_scopes", "email"),
 *                 Map.entry("client_id", "your client_id"),
 *                 Map.entry("client_secret", "your client_secret")
 *             ))
 *             .attributeMapping(Map.ofEntries(
 *                 Map.entry("email", "email"),
 *                 Map.entry("username", "sub")
 *             ))
 *             .build());
 *     }
 * }
 * ```
 * ```yaml
 * resources:
 *   example:
 *     type: aws:cognito:UserPool
 *     properties:
 *       name: example-pool
 *       autoVerifiedAttributes:
 *         - email
 *   exampleProvider:
 *     type: aws:cognito:IdentityProvider
 *     name: example_provider
 *     properties:
 *       userPoolId: ${example.id}
 *       providerName: Google
 *       providerType: Google
 *       providerDetails:
 *         authorize_scopes: email
 *         client_id: your client_id
 *         client_secret: your client_secret
 *       attributeMapping:
 *         email: email
 *         username: sub
 * ```
 * <!--End PulumiCodeChooser -->
 * ## Import
 * Using `pulumi import`, import `aws_cognito_identity_provider` resources using their User Pool ID and Provider Name. For example:
 * ```sh
 * $ pulumi import aws:cognito/identityProvider:IdentityProvider example us-west-2_abc123:CorpAD
 * ```
 */
public class IdentityProvider internal constructor(
    override val javaResource: com.pulumi.aws.cognito.IdentityProvider,
) : KotlinCustomResource(javaResource, IdentityProviderMapper) {
    /**
     * The map of attribute mapping of user pool attributes. [AttributeMapping in AWS API documentation](https://docs.aws.amazon.com/cognito-user-identity-pools/latest/APIReference/API_CreateIdentityProvider.html#CognitoUserPools-CreateIdentityProvider-request-AttributeMapping)
     */
    public val attributeMapping: Output<Map<String, String>>
        get() = javaResource.attributeMapping().applyValue({ args0 ->
            args0.map({ args0 ->
                args0.key.to(args0.value)
            }).toMap()
        })

    /**
     * The list of identity providers.
     */
    public val idpIdentifiers: Output<List<String>>?
        get() = javaResource.idpIdentifiers().applyValue({ args0 ->
            args0.map({ args0 ->
                args0.map({ args0 -> args0 })
            }).orElse(null)
        })

    /**
     * The map of identity details, such as access token
     */
    public val providerDetails: Output<Map<String, String>>
        get() = javaResource.providerDetails().applyValue({ args0 ->
            args0.map({ args0 ->
                args0.key.to(args0.value)
            }).toMap()
        })

    /**
     * The provider name
     */
    public val providerName: Output<String>
        get() = javaResource.providerName().applyValue({ args0 -> args0 })

    /**
     * The provider type.  [See AWS API for valid values](https://docs.aws.amazon.com/cognito-user-identity-pools/latest/APIReference/API_CreateIdentityProvider.html#CognitoUserPools-CreateIdentityProvider-request-ProviderType)
     */
    public val providerType: Output<String>
        get() = javaResource.providerType().applyValue({ args0 -> args0 })

    /**
     * The user pool id
     */
    public val userPoolId: Output<String>
        get() = javaResource.userPoolId().applyValue({ args0 -> args0 })
}

public object IdentityProviderMapper : ResourceMapper<IdentityProvider> {
    override fun supportsMappingOfType(javaResource: Resource): Boolean =
        com.pulumi.aws.cognito.IdentityProvider::class == javaResource::class

    override fun map(javaResource: Resource): IdentityProvider = IdentityProvider(
        javaResource as
            com.pulumi.aws.cognito.IdentityProvider,
    )
}

/**
 * @see [IdentityProvider].
 * @param name The _unique_ name of the resulting resource.
 * @param block Builder for [IdentityProvider].
 */
public suspend fun identityProvider(
    name: String,
    block: suspend IdentityProviderResourceBuilder.() -> Unit,
): IdentityProvider {
    val builder = IdentityProviderResourceBuilder()
    builder.name(name)
    block(builder)
    return builder.build()
}

/**
 * @see [IdentityProvider].
 * @param name The _unique_ name of the resulting resource.
 */
public fun identityProvider(name: String): IdentityProvider {
    val builder = IdentityProviderResourceBuilder()
    builder.name(name)
    return builder.build()
}
