@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.aws.cognito.kotlin

import com.pulumi.aws.cognito.IdentityProviderArgs.builder
import com.pulumi.core.Output
import com.pulumi.core.Output.of
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiTagMarker
import kotlin.Pair
import kotlin.String
import kotlin.Suppress
import kotlin.collections.List
import kotlin.collections.Map
import kotlin.jvm.JvmName

/**
 * Provides a Cognito User Identity Provider resource.
 * ## Example Usage
 * <!--Start PulumiCodeChooser -->
 * ```typescript
 * import * as pulumi from "@pulumi/pulumi";
 * import * as aws from "@pulumi/aws";
 * const example = new aws.cognito.UserPool("example", {
 *     name: "example-pool",
 *     autoVerifiedAttributes: ["email"],
 * });
 * const exampleProvider = new aws.cognito.IdentityProvider("example_provider", {
 *     userPoolId: example.id,
 *     providerName: "Google",
 *     providerType: "Google",
 *     providerDetails: {
 *         authorize_scopes: "email",
 *         client_id: "your client_id",
 *         client_secret: "your client_secret",
 *     },
 *     attributeMapping: {
 *         email: "email",
 *         username: "sub",
 *     },
 * });
 * ```
 * ```python
 * import pulumi
 * import pulumi_aws as aws
 * example = aws.cognito.UserPool("example",
 *     name="example-pool",
 *     auto_verified_attributes=["email"])
 * example_provider = aws.cognito.IdentityProvider("example_provider",
 *     user_pool_id=example.id,
 *     provider_name="Google",
 *     provider_type="Google",
 *     provider_details={
 *         "authorize_scopes": "email",
 *         "client_id": "your client_id",
 *         "client_secret": "your client_secret",
 *     },
 *     attribute_mapping={
 *         "email": "email",
 *         "username": "sub",
 *     })
 * ```
 * ```csharp
 * using System.Collections.Generic;
 * using System.Linq;
 * using Pulumi;
 * using Aws = Pulumi.Aws;
 * return await Deployment.RunAsync(() =>
 * {
 *     var example = new Aws.Cognito.UserPool("example", new()
 *     {
 *         Name = "example-pool",
 *         AutoVerifiedAttributes = new[]
 *         {
 *             "email",
 *         },
 *     });
 *     var exampleProvider = new Aws.Cognito.IdentityProvider("example_provider", new()
 *     {
 *         UserPoolId = example.Id,
 *         ProviderName = "Google",
 *         ProviderType = "Google",
 *         ProviderDetails =
 *         {
 *             { "authorize_scopes", "email" },
 *             { "client_id", "your client_id" },
 *             { "client_secret", "your client_secret" },
 *         },
 *         AttributeMapping =
 *         {
 *             { "email", "email" },
 *             { "username", "sub" },
 *         },
 *     });
 * });
 * ```
 * ```go
 * package main
 * import (
 * 	"github.com/pulumi/pulumi-aws/sdk/v6/go/aws/cognito"
 * 	"github.com/pulumi/pulumi/sdk/v3/go/pulumi"
 * )
 * func main() {
 * 	pulumi.Run(func(ctx *pulumi.Context) error {
 * 		example, err := cognito.NewUserPool(ctx, "example", &cognito.UserPoolArgs{
 * 			Name: pulumi.String("example-pool"),
 * 			AutoVerifiedAttributes: pulumi.StringArray{
 * 				pulumi.String("email"),
 * 			},
 * 		})
 * 		if err != nil {
 * 			return err
 * 		}
 * 		_, err = cognito.NewIdentityProvider(ctx, "example_provider", &cognito.IdentityProviderArgs{
 * 			UserPoolId:   example.ID(),
 * 			ProviderName: pulumi.String("Google"),
 * 			ProviderType: pulumi.String("Google"),
 * 			ProviderDetails: pulumi.StringMap{
 * 				"authorize_scopes": pulumi.String("email"),
 * 				"client_id":        pulumi.String("your client_id"),
 * 				"client_secret":    pulumi.String("your client_secret"),
 * 			},
 * 			AttributeMapping: pulumi.StringMap{
 * 				"email":    pulumi.String("email"),
 * 				"username": pulumi.String("sub"),
 * 			},
 * 		})
 * 		if err != nil {
 * 			return err
 * 		}
 * 		return nil
 * 	})
 * }
 * ```
 * ```java
 * package generated_program;
 * import com.pulumi.Context;
 * import com.pulumi.Pulumi;
 * import com.pulumi.core.Output;
 * import com.pulumi.aws.cognito.UserPool;
 * import com.pulumi.aws.cognito.UserPoolArgs;
 * import com.pulumi.aws.cognito.IdentityProvider;
 * import com.pulumi.aws.cognito.IdentityProviderArgs;
 * import java.util.List;
 * import java.util.ArrayList;
 * import java.util.Map;
 * import java.io.File;
 * import java.nio.file.Files;
 * import java.nio.file.Paths;
 * public class App {
 *     public static void main(String[] args) {
 *         Pulumi.run(App::stack);
 *     }
 *     public static void stack(Context ctx) {
 *         var example = new UserPool("example", UserPoolArgs.builder()
 *             .name("example-pool")
 *             .autoVerifiedAttributes("email")
 *             .build());
 *         var exampleProvider = new IdentityProvider("exampleProvider", IdentityProviderArgs.builder()
 *             .userPoolId(example.id())
 *             .providerName("Google")
 *             .providerType("Google")
 *             .providerDetails(Map.ofEntries(
 *                 Map.entry("authorize_scopes", "email"),
 *                 Map.entry("client_id", "your client_id"),
 *                 Map.entry("client_secret", "your client_secret")
 *             ))
 *             .attributeMapping(Map.ofEntries(
 *                 Map.entry("email", "email"),
 *                 Map.entry("username", "sub")
 *             ))
 *             .build());
 *     }
 * }
 * ```
 * ```yaml
 * resources:
 *   example:
 *     type: aws:cognito:UserPool
 *     properties:
 *       name: example-pool
 *       autoVerifiedAttributes:
 *         - email
 *   exampleProvider:
 *     type: aws:cognito:IdentityProvider
 *     name: example_provider
 *     properties:
 *       userPoolId: ${example.id}
 *       providerName: Google
 *       providerType: Google
 *       providerDetails:
 *         authorize_scopes: email
 *         client_id: your client_id
 *         client_secret: your client_secret
 *       attributeMapping:
 *         email: email
 *         username: sub
 * ```
 * <!--End PulumiCodeChooser -->
 * ## Import
 * Using `pulumi import`, import `aws_cognito_identity_provider` resources using their User Pool ID and Provider Name. For example:
 * ```sh
 * $ pulumi import aws:cognito/identityProvider:IdentityProvider example us-west-2_abc123:CorpAD
 * ```
 * @property attributeMapping The map of attribute mapping of user pool attributes. [AttributeMapping in AWS API documentation](https://docs.aws.amazon.com/cognito-user-identity-pools/latest/APIReference/API_CreateIdentityProvider.html#CognitoUserPools-CreateIdentityProvider-request-AttributeMapping)
 * @property idpIdentifiers The list of identity providers.
 * @property providerDetails The map of identity details, such as access token
 * @property providerName The provider name
 * @property providerType The provider type.  [See AWS API for valid values](https://docs.aws.amazon.com/cognito-user-identity-pools/latest/APIReference/API_CreateIdentityProvider.html#CognitoUserPools-CreateIdentityProvider-request-ProviderType)
 * @property userPoolId The user pool id
 */
public data class IdentityProviderArgs(
    public val attributeMapping: Output<Map<String, String>>? = null,
    public val idpIdentifiers: Output<List<String>>? = null,
    public val providerDetails: Output<Map<String, String>>? = null,
    public val providerName: Output<String>? = null,
    public val providerType: Output<String>? = null,
    public val userPoolId: Output<String>? = null,
) : ConvertibleToJava<com.pulumi.aws.cognito.IdentityProviderArgs> {
    override fun toJava(): com.pulumi.aws.cognito.IdentityProviderArgs =
        com.pulumi.aws.cognito.IdentityProviderArgs.builder()
            .attributeMapping(
                attributeMapping?.applyValue({ args0 ->
                    args0.map({ args0 ->
                        args0.key.to(args0.value)
                    }).toMap()
                }),
            )
            .idpIdentifiers(idpIdentifiers?.applyValue({ args0 -> args0.map({ args0 -> args0 }) }))
            .providerDetails(
                providerDetails?.applyValue({ args0 ->
                    args0.map({ args0 ->
                        args0.key.to(args0.value)
                    }).toMap()
                }),
            )
            .providerName(providerName?.applyValue({ args0 -> args0 }))
            .providerType(providerType?.applyValue({ args0 -> args0 }))
            .userPoolId(userPoolId?.applyValue({ args0 -> args0 })).build()
}

/**
 * Builder for [IdentityProviderArgs].
 */
@PulumiTagMarker
public class IdentityProviderArgsBuilder internal constructor() {
    private var attributeMapping: Output<Map<String, String>>? = null

    private var idpIdentifiers: Output<List<String>>? = null

    private var providerDetails: Output<Map<String, String>>? = null

    private var providerName: Output<String>? = null

    private var providerType: Output<String>? = null

    private var userPoolId: Output<String>? = null

    /**
     * @param value The map of attribute mapping of user pool attributes. [AttributeMapping in AWS API documentation](https://docs.aws.amazon.com/cognito-user-identity-pools/latest/APIReference/API_CreateIdentityProvider.html#CognitoUserPools-CreateIdentityProvider-request-AttributeMapping)
     */
    @JvmName("hxokrpsywhlisgos")
    public suspend fun attributeMapping(`value`: Output<Map<String, String>>) {
        this.attributeMapping = value
    }

    /**
     * @param value The list of identity providers.
     */
    @JvmName("iqgpljfqcyquvtdc")
    public suspend fun idpIdentifiers(`value`: Output<List<String>>) {
        this.idpIdentifiers = value
    }

    @JvmName("yuxqmkpbhaofeagt")
    public suspend fun idpIdentifiers(vararg values: Output<String>) {
        this.idpIdentifiers = Output.all(values.asList())
    }

    /**
     * @param values The list of identity providers.
     */
    @JvmName("ebvoqdfhtjtcakdp")
    public suspend fun idpIdentifiers(values: List<Output<String>>) {
        this.idpIdentifiers = Output.all(values)
    }

    /**
     * @param value The map of identity details, such as access token
     */
    @JvmName("qwveqmyrbfetvhei")
    public suspend fun providerDetails(`value`: Output<Map<String, String>>) {
        this.providerDetails = value
    }

    /**
     * @param value The provider name
     */
    @JvmName("rchtnvssjbyqdjfe")
    public suspend fun providerName(`value`: Output<String>) {
        this.providerName = value
    }

    /**
     * @param value The provider type.  [See AWS API for valid values](https://docs.aws.amazon.com/cognito-user-identity-pools/latest/APIReference/API_CreateIdentityProvider.html#CognitoUserPools-CreateIdentityProvider-request-ProviderType)
     */
    @JvmName("oapfliywaohhpnir")
    public suspend fun providerType(`value`: Output<String>) {
        this.providerType = value
    }

    /**
     * @param value The user pool id
     */
    @JvmName("xhuwoqefxmnyvepn")
    public suspend fun userPoolId(`value`: Output<String>) {
        this.userPoolId = value
    }

    /**
     * @param value The map of attribute mapping of user pool attributes. [AttributeMapping in AWS API documentation](https://docs.aws.amazon.com/cognito-user-identity-pools/latest/APIReference/API_CreateIdentityProvider.html#CognitoUserPools-CreateIdentityProvider-request-AttributeMapping)
     */
    @JvmName("fqtuidcetglejcux")
    public suspend fun attributeMapping(`value`: Map<String, String>?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.attributeMapping = mapped
    }

    /**
     * @param values The map of attribute mapping of user pool attributes. [AttributeMapping in AWS API documentation](https://docs.aws.amazon.com/cognito-user-identity-pools/latest/APIReference/API_CreateIdentityProvider.html#CognitoUserPools-CreateIdentityProvider-request-AttributeMapping)
     */
    @JvmName("utescodokgbydnke")
    public fun attributeMapping(vararg values: Pair<String, String>) {
        val toBeMapped = values.toMap()
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.attributeMapping = mapped
    }

    /**
     * @param value The list of identity providers.
     */
    @JvmName("kidmtilhnhdnhaet")
    public suspend fun idpIdentifiers(`value`: List<String>?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.idpIdentifiers = mapped
    }

    /**
     * @param values The list of identity providers.
     */
    @JvmName("uvawcgjolwilyvxl")
    public suspend fun idpIdentifiers(vararg values: String) {
        val toBeMapped = values.toList()
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.idpIdentifiers = mapped
    }

    /**
     * @param value The map of identity details, such as access token
     */
    @JvmName("qrlgkcpbnhdjlrct")
    public suspend fun providerDetails(`value`: Map<String, String>?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.providerDetails = mapped
    }

    /**
     * @param values The map of identity details, such as access token
     */
    @JvmName("bosabjbmbrjfwdsy")
    public fun providerDetails(vararg values: Pair<String, String>) {
        val toBeMapped = values.toMap()
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.providerDetails = mapped
    }

    /**
     * @param value The provider name
     */
    @JvmName("aekpnmblfwnstkci")
    public suspend fun providerName(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.providerName = mapped
    }

    /**
     * @param value The provider type.  [See AWS API for valid values](https://docs.aws.amazon.com/cognito-user-identity-pools/latest/APIReference/API_CreateIdentityProvider.html#CognitoUserPools-CreateIdentityProvider-request-ProviderType)
     */
    @JvmName("txpxukilqgocavec")
    public suspend fun providerType(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.providerType = mapped
    }

    /**
     * @param value The user pool id
     */
    @JvmName("uuhloqwmhwbkfoch")
    public suspend fun userPoolId(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.userPoolId = mapped
    }

    internal fun build(): IdentityProviderArgs = IdentityProviderArgs(
        attributeMapping = attributeMapping,
        idpIdentifiers = idpIdentifiers,
        providerDetails = providerDetails,
        providerName = providerName,
        providerType = providerType,
        userPoolId = userPoolId,
    )
}
