@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.aws.cognito.kotlin

import com.pulumi.aws.cognito.kotlin.outputs.ManagedUserPoolClientAnalyticsConfiguration
import com.pulumi.aws.cognito.kotlin.outputs.ManagedUserPoolClientTokenValidityUnits
import com.pulumi.core.Output
import com.pulumi.kotlin.KotlinCustomResource
import com.pulumi.kotlin.PulumiTagMarker
import com.pulumi.kotlin.ResourceMapper
import com.pulumi.kotlin.options.CustomResourceOptions
import com.pulumi.kotlin.options.CustomResourceOptionsBuilder
import com.pulumi.resources.Resource
import kotlin.Boolean
import kotlin.Int
import kotlin.String
import kotlin.Suppress
import kotlin.Unit
import kotlin.collections.List
import com.pulumi.aws.cognito.kotlin.outputs.ManagedUserPoolClientAnalyticsConfiguration.Companion.toKotlin as managedUserPoolClientAnalyticsConfigurationToKotlin
import com.pulumi.aws.cognito.kotlin.outputs.ManagedUserPoolClientTokenValidityUnits.Companion.toKotlin as managedUserPoolClientTokenValidityUnitsToKotlin

/**
 * Builder for [ManagedUserPoolClient].
 */
@PulumiTagMarker
public class ManagedUserPoolClientResourceBuilder internal constructor() {
    public var name: String? = null

    public var args: ManagedUserPoolClientArgs = ManagedUserPoolClientArgs()

    public var opts: CustomResourceOptions = CustomResourceOptions()

    /**
     * @param name The _unique_ name of the resulting resource.
     */
    public fun name(`value`: String) {
        this.name = value
    }

    /**
     * @param block The arguments to use to populate this resource's properties.
     */
    public suspend fun args(block: suspend ManagedUserPoolClientArgsBuilder.() -> Unit) {
        val builder = ManagedUserPoolClientArgsBuilder()
        block(builder)
        this.args = builder.build()
    }

    /**
     * @param block A bag of options that control this resource's behavior.
     */
    public suspend fun opts(block: suspend CustomResourceOptionsBuilder.() -> Unit) {
        this.opts = com.pulumi.kotlin.options.CustomResourceOptions.opts(block)
    }

    internal fun build(): ManagedUserPoolClient {
        val builtJavaResource = com.pulumi.aws.cognito.ManagedUserPoolClient(
            this.name,
            this.args.toJava(),
            this.opts.toJava(),
        )
        return ManagedUserPoolClient(builtJavaResource)
    }
}

/**
 * Use the `aws.cognito.UserPoolClient` resource to manage a Cognito User Pool Client.
 * **This resource is advanced** and has special caveats to consider before use. Please read this document completely before using the resource.
 * Use the `aws.cognito.ManagedUserPoolClient` resource to manage a Cognito User Pool Client that is automatically created by an AWS service. For instance, when [configuring an OpenSearch Domain to use Cognito authentication](https://docs.aws.amazon.com/opensearch-service/latest/developerguide/cognito-auth.html), the OpenSearch service creates the User Pool Client during setup and removes it when it is no longer required. As a result, the `aws.cognito.ManagedUserPoolClient` resource does not create or delete this resource, but instead assumes management of it.
 * Use the `aws.cognito.UserPoolClient` resource to manage Cognito User Pool Clients for normal use cases.
 * ## Example Usage
 * <!--Start PulumiCodeChooser -->
 * ```typescript
 * import * as pulumi from "@pulumi/pulumi";
 * import * as aws from "@pulumi/aws";
 * const exampleUserPool = new aws.cognito.UserPool("example", {name: "example"});
 * const exampleIdentityPool = new aws.cognito.IdentityPool("example", {identityPoolName: "example"});
 * const current = aws.getPartition({});
 * const example = current.then(current => aws.iam.getPolicyDocument({
 *     statements: [{
 *         sid: "",
 *         actions: ["sts:AssumeRole"],
 *         effect: "Allow",
 *         principals: [{
 *             type: "Service",
 *             identifiers: [`es&#46;${current&#46;dnsSuffix}`],
 *         }],
 *     }],
 * }));
 * const exampleRole = new aws.iam.Role("example", {
 *     name: "example-role",
 *     path: "/service-role/",
 *     assumeRolePolicy: example.then(example => example.json),
 * });
 * const exampleRolePolicyAttachment = new aws.iam.RolePolicyAttachment("example", {
 *     role: exampleRole.name,
 *     policyArn: current.then(current => `arn:${current.partition}:iam::aws:policy/AmazonESCognitoAccess`),
 * });
 * const exampleDomain = new aws.opensearch.Domain("example", {
 *     domainName: "example",
 *     cognitoOptions: {
 *         enabled: true,
 *         userPoolId: exampleUserPool.id,
 *         identityPoolId: exampleIdentityPool.id,
 *         roleArn: exampleRole.arn,
 *     },
 *     ebsOptions: {
 *         ebsEnabled: true,
 *         volumeSize: 10,
 *     },
 * }, {
 *     dependsOn: [
 *         exampleAwsCognitoUserPoolDomain,
 *         exampleRolePolicyAttachment,
 *     ],
 * });
 * const exampleManagedUserPoolClient = new aws.cognito.ManagedUserPoolClient("example", {
 *     namePrefix: "AmazonOpenSearchService-example",
 *     userPoolId: exampleUserPool.id,
 * }, {
 *     dependsOn: [exampleDomain],
 * });
 * ```
 * ```python
 * import pulumi
 * import pulumi_aws as aws
 * example_user_pool = aws.cognito.UserPool("example", name="example")
 * example_identity_pool = aws.cognito.IdentityPool("example", identity_pool_name="example")
 * current = aws.get_partition()
 * example = aws.iam.get_policy_document(statements=[{
 *     "sid": "",
 *     "actions": ["sts:AssumeRole"],
 *     "effect": "Allow",
 *     "principals": [{
 *         "type": "Service",
 *         "identifiers": [f"es&#46;{current&#46;dns_suffix}"],
 *     }],
 * }])
 * example_role = aws.iam.Role("example",
 *     name="example-role",
 *     path="/service-role/",
 *     assume_role_policy=example.json)
 * example_role_policy_attachment = aws.iam.RolePolicyAttachment("example",
 *     role=example_role.name,
 *     policy_arn=f"arn:{current.partition}:iam::aws:policy/AmazonESCognitoAccess")
 * example_domain = aws.opensearch.Domain("example",
 *     domain_name="example",
 *     cognito_options={
 *         "enabled": True,
 *         "user_pool_id": example_user_pool.id,
 *         "identity_pool_id": example_identity_pool.id,
 *         "role_arn": example_role.arn,
 *     },
 *     ebs_options={
 *         "ebs_enabled": True,
 *         "volume_size": 10,
 *     },
 *     opts = pulumi.ResourceOptions(depends_on=[
 *             example_aws_cognito_user_pool_domain,
 *             example_role_policy_attachment,
 *         ]))
 * example_managed_user_pool_client = aws.cognito.ManagedUserPoolClient("example",
 *     name_prefix="AmazonOpenSearchService-example",
 *     user_pool_id=example_user_pool.id,
 *     opts = pulumi.ResourceOptions(depends_on=[example_domain]))
 * ```
 * ```csharp
 * using System.Collections.Generic;
 * using System.Linq;
 * using Pulumi;
 * using Aws = Pulumi.Aws;
 * return await Deployment.RunAsync(() =>
 * {
 *     var exampleUserPool = new Aws.Cognito.UserPool("example", new()
 *     {
 *         Name = "example",
 *     });
 *     var exampleIdentityPool = new Aws.Cognito.IdentityPool("example", new()
 *     {
 *         IdentityPoolName = "example",
 *     });
 *     var current = Aws.GetPartition.Invoke();
 *     var example = Aws.Iam.GetPolicyDocument.Invoke(new()
 *     {
 *         Statements = new[]
 *         {
 *             new Aws.Iam.Inputs.GetPolicyDocumentStatementInputArgs
 *             {
 *                 Sid = "",
 *                 Actions = new[]
 *                 {
 *                     "sts:AssumeRole",
 *                 },
 *                 Effect = "Allow",
 *                 Principals = new[]
 *                 {
 *                     new Aws.Iam.Inputs.GetPolicyDocumentStatementPrincipalInputArgs
 *                     {
 *                         Type = "Service",
 *                         Identifiers = new[]
 *                         {
 *                             $"es.{current.Apply(getPartitionResult => getPartitionResult.DnsSuffix)}",
 *                         },
 *                     },
 *                 },
 *             },
 *         },
 *     });
 *     var exampleRole = new Aws.Iam.Role("example", new()
 *     {
 *         Name = "example-role",
 *         Path = "/service-role/",
 *         AssumeRolePolicy = example.Apply(getPolicyDocumentResult => getPolicyDocumentResult.Json),
 *     });
 *     var exampleRolePolicyAttachment = new Aws.Iam.RolePolicyAttachment("example", new()
 *     {
 *         Role = exampleRole.Name,
 *         PolicyArn = $"arn:{current.Apply(getPartitionResult => getPartitionResult.Partition)}:iam::aws:policy/AmazonESCognitoAccess",
 *     });
 *     var exampleDomain = new Aws.OpenSearch.Domain("example", new()
 *     {
 *         DomainName = "example",
 *         CognitoOptions = new Aws.OpenSearch.Inputs.DomainCognitoOptionsArgs
 *         {
 *             Enabled = true,
 *             UserPoolId = exampleUserPool.Id,
 *             IdentityPoolId = exampleIdentityPool.Id,
 *             RoleArn = exampleRole.Arn,
 *         },
 *         EbsOptions = new Aws.OpenSearch.Inputs.DomainEbsOptionsArgs
 *         {
 *             EbsEnabled = true,
 *             VolumeSize = 10,
 *         },
 *     }, new CustomResourceOptions
 *     {
 *         DependsOn =
 *         {
 *             exampleAwsCognitoUserPoolDomain,
 *             exampleRolePolicyAttachment,
 *         },
 *     });
 *     var exampleManagedUserPoolClient = new Aws.Cognito.ManagedUserPoolClient("example", new()
 *     {
 *         NamePrefix = "AmazonOpenSearchService-example",
 *         UserPoolId = exampleUserPool.Id,
 *     }, new CustomResourceOptions
 *     {
 *         DependsOn =
 *         {
 *             exampleDomain,
 *         },
 *     });
 * });
 * ```
 * ```go
 * package main
 * import (
 * 	"fmt"
 * 	"github.com/pulumi/pulumi-aws/sdk/v6/go/aws"
 * 	"github.com/pulumi/pulumi-aws/sdk/v6/go/aws/cognito"
 * 	"github.com/pulumi/pulumi-aws/sdk/v6/go/aws/iam"
 * 	"github.com/pulumi/pulumi-aws/sdk/v6/go/aws/opensearch"
 * 	"github.com/pulumi/pulumi/sdk/v3/go/pulumi"
 * )
 * func main() {
 * 	pulumi.Run(func(ctx *pulumi.Context) error {
 * 		exampleUserPool, err := cognito.NewUserPool(ctx, "example", &cognito.UserPoolArgs{
 * 			Name: pulumi.String("example"),
 * 		})
 * 		if err != nil {
 * 			return err
 * 		}
 * 		exampleIdentityPool, err := cognito.NewIdentityPool(ctx, "example", &cognito.IdentityPoolArgs{
 * 			IdentityPoolName: pulumi.String("example"),
 * 		})
 * 		if err != nil {
 * 			return err
 * 		}
 * 		current, err := aws.GetPartition(ctx, nil, nil)
 * 		if err != nil {
 * 			return err
 * 		}
 * 		example, err := iam.GetPolicyDocument(ctx, &iam.GetPolicyDocumentArgs{
 * 			Statements: []iam.GetPolicyDocumentStatement{
 * 				{
 * 					Sid: pulumi.StringRef(""),
 * 					Actions: []string{
 * 						"sts:AssumeRole",
 * 					},
 * 					Effect: pulumi.StringRef("Allow"),
 * 					Principals: []iam.GetPolicyDocumentStatementPrincipal{
 * 						{
 * 							Type: "Service",
 * 							Identifiers: []string{
 * 								fmt.Sprintf("es.%v", current.DnsSuffix),
 * 							},
 * 						},
 * 					},
 * 				},
 * 			},
 * 		}, nil)
 * 		if err != nil {
 * 			return err
 * 		}
 * 		exampleRole, err := iam.NewRole(ctx, "example", &iam.RoleArgs{
 * 			Name:             pulumi.String("example-role"),
 * 			Path:             pulumi.String("/service-role/"),
 * 			AssumeRolePolicy: pulumi.String(example.Json),
 * 		})
 * 		if err != nil {
 * 			return err
 * 		}
 * 		exampleRolePolicyAttachment, err := iam.NewRolePolicyAttachment(ctx, "example", &iam.RolePolicyAttachmentArgs{
 * 			Role:      exampleRole.Name,
 * 			PolicyArn: pulumi.Sprintf("arn:%v:iam::aws:policy/AmazonESCognitoAccess", current.Partition),
 * 		})
 * 		if err != nil {
 * 			return err
 * 		}
 * 		exampleDomain, err := opensearch.NewDomain(ctx, "example", &opensearch.DomainArgs{
 * 			DomainName: pulumi.String("example"),
 * 			CognitoOptions: &opensearch.DomainCognitoOptionsArgs{
 * 				Enabled:        pulumi.Bool(true),
 * 				UserPoolId:     exampleUserPool.ID(),
 * 				IdentityPoolId: exampleIdentityPool.ID(),
 * 				RoleArn:        exampleRole.Arn,
 * 			},
 * 			EbsOptions: &opensearch.DomainEbsOptionsArgs{
 * 				EbsEnabled: pulumi.Bool(true),
 * 				VolumeSize: pulumi.Int(10),
 * 			},
 * 		}, pulumi.DependsOn([]pulumi.Resource{
 * 			exampleAwsCognitoUserPoolDomain,
 * 			exampleRolePolicyAttachment,
 * 		}))
 * 		if err != nil {
 * 			return err
 * 		}
 * 		_, err = cognito.NewManagedUserPoolClient(ctx, "example", &cognito.ManagedUserPoolClientArgs{
 * 			NamePrefix: pulumi.String("AmazonOpenSearchService-example"),
 * 			UserPoolId: exampleUserPool.ID(),
 * 		}, pulumi.DependsOn([]pulumi.Resource{
 * 			exampleDomain,
 * 		}))
 * 		if err != nil {
 * 			return err
 * 		}
 * 		return nil
 * 	})
 * }
 * ```
 * ```java
 * package generated_program;
 * import com.pulumi.Context;
 * import com.pulumi.Pulumi;
 * import com.pulumi.core.Output;
 * import com.pulumi.aws.cognito.UserPool;
 * import com.pulumi.aws.cognito.UserPoolArgs;
 * import com.pulumi.aws.cognito.IdentityPool;
 * import com.pulumi.aws.cognito.IdentityPoolArgs;
 * import com.pulumi.aws.AwsFunctions;
 * import com.pulumi.aws.inputs.GetPartitionArgs;
 * import com.pulumi.aws.iam.IamFunctions;
 * import com.pulumi.aws.iam.inputs.GetPolicyDocumentArgs;
 * import com.pulumi.aws.iam.Role;
 * import com.pulumi.aws.iam.RoleArgs;
 * import com.pulumi.aws.iam.RolePolicyAttachment;
 * import com.pulumi.aws.iam.RolePolicyAttachmentArgs;
 * import com.pulumi.aws.opensearch.Domain;
 * import com.pulumi.aws.opensearch.DomainArgs;
 * import com.pulumi.aws.opensearch.inputs.DomainCognitoOptionsArgs;
 * import com.pulumi.aws.opensearch.inputs.DomainEbsOptionsArgs;
 * import com.pulumi.aws.cognito.ManagedUserPoolClient;
 * import com.pulumi.aws.cognito.ManagedUserPoolClientArgs;
 * import com.pulumi.resources.CustomResourceOptions;
 * import java.util.List;
 * import java.util.ArrayList;
 * import java.util.Map;
 * import java.io.File;
 * import java.nio.file.Files;
 * import java.nio.file.Paths;
 * public class App {
 *     public static void main(String[] args) {
 *         Pulumi.run(App::stack);
 *     }
 *     public static void stack(Context ctx) {
 *         var exampleUserPool = new UserPool("exampleUserPool", UserPoolArgs.builder()
 *             .name("example")
 *             .build());
 *         var exampleIdentityPool = new IdentityPool("exampleIdentityPool", IdentityPoolArgs.builder()
 *             .identityPoolName("example")
 *             .build());
 *         final var current = AwsFunctions.getPartition();
 *         final var example = IamFunctions.getPolicyDocument(GetPolicyDocumentArgs.builder()
 *             .statements(GetPolicyDocumentStatementArgs.builder()
 *                 .sid("")
 *                 .actions("sts:AssumeRole")
 *                 .effect("Allow")
 *                 .principals(GetPolicyDocumentStatementPrincipalArgs.builder()
 *                     .type("Service")
 *                     .identifiers(String.format("es.%s", current.applyValue(getPartitionResult -> getPartitionResult.dnsSuffix())))
 *                     .build())
 *                 .build())
 *             .build());
 *         var exampleRole = new Role("exampleRole", RoleArgs.builder()
 *             .name("example-role")
 *             .path("/service-role/")
 *             .assumeRolePolicy(example.applyValue(getPolicyDocumentResult -> getPolicyDocumentResult.json()))
 *             .build());
 *         var exampleRolePolicyAttachment = new RolePolicyAttachment("exampleRolePolicyAttachment", RolePolicyAttachmentArgs.builder()
 *             .role(exampleRole.name())
 *             .policyArn(String.format("arn:%s:iam::aws:policy/AmazonESCognitoAccess", current.applyValue(getPartitionResult -> getPartitionResult.partition())))
 *             .build());
 *         var exampleDomain = new Domain("exampleDomain", DomainArgs.builder()
 *             .domainName("example")
 *             .cognitoOptions(DomainCognitoOptionsArgs.builder()
 *                 .enabled(true)
 *                 .userPoolId(exampleUserPool.id())
 *                 .identityPoolId(exampleIdentityPool.id())
 *                 .roleArn(exampleRole.arn())
 *                 .build())
 *             .ebsOptions(DomainEbsOptionsArgs.builder()
 *                 .ebsEnabled(true)
 *                 .volumeSize(10)
 *                 .build())
 *             .build(), CustomResourceOptions.builder()
 *                 .dependsOn(
 *                     exampleAwsCognitoUserPoolDomain,
 *                     exampleRolePolicyAttachment)
 *                 .build());
 *         var exampleManagedUserPoolClient = new ManagedUserPoolClient("exampleManagedUserPoolClient", ManagedUserPoolClientArgs.builder()
 *             .namePrefix("AmazonOpenSearchService-example")
 *             .userPoolId(exampleUserPool.id())
 *             .build(), CustomResourceOptions.builder()
 *                 .dependsOn(exampleDomain)
 *                 .build());
 *     }
 * }
 * ```
 * ```yaml
 * resources:
 *   exampleManagedUserPoolClient:
 *     type: aws:cognito:ManagedUserPoolClient
 *     name: example
 *     properties:
 *       namePrefix: AmazonOpenSearchService-example
 *       userPoolId: ${exampleUserPool.id}
 *     options:
 *       dependson:
 *         - ${exampleDomain}
 *   exampleUserPool:
 *     type: aws:cognito:UserPool
 *     name: example
 *     properties:
 *       name: example
 *   exampleIdentityPool:
 *     type: aws:cognito:IdentityPool
 *     name: example
 *     properties:
 *       identityPoolName: example
 *   exampleDomain:
 *     type: aws:opensearch:Domain
 *     name: example
 *     properties:
 *       domainName: example
 *       cognitoOptions:
 *         enabled: true
 *         userPoolId: ${exampleUserPool.id}
 *         identityPoolId: ${exampleIdentityPool.id}
 *         roleArn: ${exampleRole.arn}
 *       ebsOptions:
 *         ebsEnabled: true
 *         volumeSize: 10
 *     options:
 *       dependson:
 *         - ${exampleAwsCognitoUserPoolDomain}
 *         - ${exampleRolePolicyAttachment}
 *   exampleRole:
 *     type: aws:iam:Role
 *     name: example
 *     properties:
 *       name: example-role
 *       path: /service-role/
 *       assumeRolePolicy: ${example.json}
 *   exampleRolePolicyAttachment:
 *     type: aws:iam:RolePolicyAttachment
 *     name: example
 *     properties:
 *       role: ${exampleRole.name}
 *       policyArn: arn:${current.partition}:iam::aws:policy/AmazonESCognitoAccess
 * variables:
 *   example:
 *     fn::invoke:
 *       Function: aws:iam:getPolicyDocument
 *       Arguments:
 *         statements:
 *           - sid:
 *             actions:
 *               - sts:AssumeRole
 *             effect: Allow
 *             principals:
 *               - type: Service
 *                 identifiers:
 *                   - es.${current.dnsSuffix}
 *   current:
 *     fn::invoke:
 *       Function: aws:getPartition
 *       Arguments: {}
 * ```
 * <!--End PulumiCodeChooser -->
 * ## Import
 * Using `pulumi import`, import Cognito User Pool Clients using the `id` of the Cognito User Pool and the `id` of the Cognito User Pool Client. For example:
 * ```sh
 * $ pulumi import aws:cognito/managedUserPoolClient:ManagedUserPoolClient client us-west-2_abc123/3ho4ek12345678909nh3fmhpko
 * ```
 */
public class ManagedUserPoolClient internal constructor(
    override val javaResource: com.pulumi.aws.cognito.ManagedUserPoolClient,
) : KotlinCustomResource(javaResource, ManagedUserPoolClientMapper) {
    /**
     * Time limit, between 5 minutes and 1 day, after which the access token is no longer valid and cannot be used. By default, the unit is hours. The unit can be overridden by a value in `token_validity_units.access_token`.
     */
    public val accessTokenValidity: Output<Int>
        get() = javaResource.accessTokenValidity().applyValue({ args0 -> args0 })

    /**
     * List of allowed OAuth flows, including code, implicit, and client_credentials.
     */
    public val allowedOauthFlows: Output<List<String>>
        get() = javaResource.allowedOauthFlows().applyValue({ args0 -> args0.map({ args0 -> args0 }) })

    /**
     * Whether the client is allowed to use the OAuth protocol when interacting with Cognito user pools.
     */
    public val allowedOauthFlowsUserPoolClient: Output<Boolean>
        get() = javaResource.allowedOauthFlowsUserPoolClient().applyValue({ args0 -> args0 })

    /**
     * List of allowed OAuth scopes, including phone, email, openid, profile, and aws.cognito.signin.user.admin.
     */
    public val allowedOauthScopes: Output<List<String>>
        get() = javaResource.allowedOauthScopes().applyValue({ args0 -> args0.map({ args0 -> args0 }) })

    /**
     * Configuration block for Amazon Pinpoint analytics that collects metrics for this user pool. See details below.
     */
    public val analyticsConfiguration: Output<ManagedUserPoolClientAnalyticsConfiguration>?
        get() = javaResource.analyticsConfiguration().applyValue({ args0 ->
            args0.map({ args0 ->
                args0.let({ args0 ->
                    managedUserPoolClientAnalyticsConfigurationToKotlin(args0)
                })
            }).orElse(null)
        })

    /**
     * Duration, in minutes, of the session token created by Amazon Cognito for each API request in an authentication flow. The session token must be responded to by the native user of the user pool before it expires. Valid values for `auth_session_validity` are between `3` and `15`, with a default value of `3`.
     */
    public val authSessionValidity: Output<Int>
        get() = javaResource.authSessionValidity().applyValue({ args0 -> args0 })

    /**
     * List of allowed callback URLs for the identity providers.
     */
    public val callbackUrls: Output<List<String>>
        get() = javaResource.callbackUrls().applyValue({ args0 -> args0.map({ args0 -> args0 }) })

    /**
     * Client secret of the user pool client.
     */
    public val clientSecret: Output<String>
        get() = javaResource.clientSecret().applyValue({ args0 -> args0 })

    /**
     * Default redirect URI and must be included in the list of callback URLs.
     */
    public val defaultRedirectUri: Output<String>
        get() = javaResource.defaultRedirectUri().applyValue({ args0 -> args0 })

    /**
     * Enables the propagation of additional user context data.
     */
    public val enablePropagateAdditionalUserContextData: Output<Boolean>
        get() = javaResource.enablePropagateAdditionalUserContextData().applyValue({ args0 -> args0 })

    /**
     * Enables or disables token revocation.
     */
    public val enableTokenRevocation: Output<Boolean>
        get() = javaResource.enableTokenRevocation().applyValue({ args0 -> args0 })

    /**
     * List of authentication flows. The available options include ADMIN_NO_SRP_AUTH, CUSTOM_AUTH_FLOW_ONLY, USER_PASSWORD_AUTH, ALLOW_ADMIN_USER_PASSWORD_AUTH, ALLOW_CUSTOM_AUTH, ALLOW_USER_PASSWORD_AUTH, ALLOW_USER_SRP_AUTH, and ALLOW_REFRESH_TOKEN_AUTH.
     */
    public val explicitAuthFlows: Output<List<String>>
        get() = javaResource.explicitAuthFlows().applyValue({ args0 -> args0.map({ args0 -> args0 }) })

    /**
     * Time limit, between 5 minutes and 1 day, after which the ID token is no longer valid and cannot be used. By default, the unit is hours. The unit can be overridden by a value in `token_validity_units.id_token`.
     */
    public val idTokenValidity: Output<Int>
        get() = javaResource.idTokenValidity().applyValue({ args0 -> args0 })

    /**
     * List of allowed logout URLs for the identity providers.
     */
    public val logoutUrls: Output<List<String>>
        get() = javaResource.logoutUrls().applyValue({ args0 -> args0.map({ args0 -> args0 }) })

    /**
     * Name of the user pool client.
     */
    public val name: Output<String>
        get() = javaResource.name().applyValue({ args0 -> args0 })

    /**
     * Regular expression that matches the name of the desired User Pool Client. It must only match one User Pool Client.
     */
    public val namePattern: Output<String>?
        get() = javaResource.namePattern().applyValue({ args0 ->
            args0.map({ args0 ->
                args0
            }).orElse(null)
        })

    /**
     * String that matches the beginning of the name of the desired User Pool Client. It must match only one User Pool Client.
     * The following arguments are optional:
     */
    public val namePrefix: Output<String>?
        get() = javaResource.namePrefix().applyValue({ args0 ->
            args0.map({ args0 ->
                args0
            }).orElse(null)
        })

    /**
     * Setting determines the errors and responses returned by Cognito APIs when a user does not exist in the user pool during authentication, account confirmation, and password recovery.
     */
    public val preventUserExistenceErrors: Output<String>
        get() = javaResource.preventUserExistenceErrors().applyValue({ args0 -> args0 })

    /**
     * List of user pool attributes that the application client can read from.
     */
    public val readAttributes: Output<List<String>>
        get() = javaResource.readAttributes().applyValue({ args0 -> args0.map({ args0 -> args0 }) })

    /**
     * Time limit, between 60 minutes and 10 years, after which the refresh token is no longer valid and cannot be used. By default, the unit is days. The unit can be overridden by a value in `token_validity_units.refresh_token`.
     */
    public val refreshTokenValidity: Output<Int>
        get() = javaResource.refreshTokenValidity().applyValue({ args0 -> args0 })

    /**
     * List of provider names for the identity providers that are supported on this client. It uses the `provider_name` attribute of the `aws.cognito.IdentityProvider` resource(s), or the equivalent string(s).
     */
    public val supportedIdentityProviders: Output<List<String>>
        get() = javaResource.supportedIdentityProviders().applyValue({ args0 ->
            args0.map({ args0 ->
                args0
            })
        })

    /**
     * Configuration block for representing the validity times in units. See details below. Detailed below.
     */
    public val tokenValidityUnits: Output<ManagedUserPoolClientTokenValidityUnits>?
        get() = javaResource.tokenValidityUnits().applyValue({ args0 ->
            args0.map({ args0 ->
                args0.let({ args0 ->
                    managedUserPoolClientTokenValidityUnitsToKotlin(args0)
                })
            }).orElse(null)
        })

    /**
     * User pool that the client belongs to.
     */
    public val userPoolId: Output<String>
        get() = javaResource.userPoolId().applyValue({ args0 -> args0 })

    /**
     * List of user pool attributes that the application client can write to.
     */
    public val writeAttributes: Output<List<String>>
        get() = javaResource.writeAttributes().applyValue({ args0 -> args0.map({ args0 -> args0 }) })
}

public object ManagedUserPoolClientMapper : ResourceMapper<ManagedUserPoolClient> {
    override fun supportsMappingOfType(javaResource: Resource): Boolean =
        com.pulumi.aws.cognito.ManagedUserPoolClient::class == javaResource::class

    override fun map(javaResource: Resource): ManagedUserPoolClient =
        ManagedUserPoolClient(javaResource as com.pulumi.aws.cognito.ManagedUserPoolClient)
}

/**
 * @see [ManagedUserPoolClient].
 * @param name The _unique_ name of the resulting resource.
 * @param block Builder for [ManagedUserPoolClient].
 */
public suspend fun managedUserPoolClient(
    name: String,
    block: suspend ManagedUserPoolClientResourceBuilder.() -> Unit,
): ManagedUserPoolClient {
    val builder = ManagedUserPoolClientResourceBuilder()
    builder.name(name)
    block(builder)
    return builder.build()
}

/**
 * @see [ManagedUserPoolClient].
 * @param name The _unique_ name of the resulting resource.
 */
public fun managedUserPoolClient(name: String): ManagedUserPoolClient {
    val builder = ManagedUserPoolClientResourceBuilder()
    builder.name(name)
    return builder.build()
}
