@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.aws.cognito.kotlin

import com.pulumi.aws.cognito.kotlin.outputs.ResourceServerScope
import com.pulumi.aws.cognito.kotlin.outputs.ResourceServerScope.Companion.toKotlin
import com.pulumi.core.Output
import com.pulumi.kotlin.KotlinCustomResource
import com.pulumi.kotlin.PulumiTagMarker
import com.pulumi.kotlin.ResourceMapper
import com.pulumi.kotlin.options.CustomResourceOptions
import com.pulumi.kotlin.options.CustomResourceOptionsBuilder
import com.pulumi.resources.Resource
import kotlin.Boolean
import kotlin.String
import kotlin.Suppress
import kotlin.Unit
import kotlin.collections.List

/**
 * Builder for [ResourceServer].
 */
@PulumiTagMarker
public class ResourceServerResourceBuilder internal constructor() {
    public var name: String? = null

    public var args: ResourceServerArgs = ResourceServerArgs()

    public var opts: CustomResourceOptions = CustomResourceOptions()

    /**
     * @param name The _unique_ name of the resulting resource.
     */
    public fun name(`value`: String) {
        this.name = value
    }

    /**
     * @param block The arguments to use to populate this resource's properties.
     */
    public suspend fun args(block: suspend ResourceServerArgsBuilder.() -> Unit) {
        val builder = ResourceServerArgsBuilder()
        block(builder)
        this.args = builder.build()
    }

    /**
     * @param block A bag of options that control this resource's behavior.
     */
    public suspend fun opts(block: suspend CustomResourceOptionsBuilder.() -> Unit) {
        this.opts = com.pulumi.kotlin.options.CustomResourceOptions.opts(block)
    }

    internal fun build(): ResourceServer {
        val builtJavaResource = com.pulumi.aws.cognito.ResourceServer(
            this.name,
            this.args.toJava(),
            this.opts.toJava(),
        )
        return ResourceServer(builtJavaResource)
    }
}

/**
 * Provides a Cognito Resource Server.
 * ## Example Usage
 * ### Create a basic resource server
 * <!--Start PulumiCodeChooser -->
 * ```typescript
 * import * as pulumi from "@pulumi/pulumi";
 * import * as aws from "@pulumi/aws";
 * const pool = new aws.cognito.UserPool("pool", {name: "pool"});
 * const resource = new aws.cognito.ResourceServer("resource", {
 *     identifier: "https://example.com",
 *     name: "example",
 *     userPoolId: pool.id,
 * });
 * ```
 * ```python
 * import pulumi
 * import pulumi_aws as aws
 * pool = aws.cognito.UserPool("pool", name="pool")
 * resource = aws.cognito.ResourceServer("resource",
 *     identifier="https://example.com",
 *     name="example",
 *     user_pool_id=pool.id)
 * ```
 * ```csharp
 * using System.Collections.Generic;
 * using System.Linq;
 * using Pulumi;
 * using Aws = Pulumi.Aws;
 * return await Deployment.RunAsync(() =>
 * {
 *     var pool = new Aws.Cognito.UserPool("pool", new()
 *     {
 *         Name = "pool",
 *     });
 *     var resource = new Aws.Cognito.ResourceServer("resource", new()
 *     {
 *         Identifier = "https://example.com",
 *         Name = "example",
 *         UserPoolId = pool.Id,
 *     });
 * });
 * ```
 * ```go
 * package main
 * import (
 * 	"github.com/pulumi/pulumi-aws/sdk/v6/go/aws/cognito"
 * 	"github.com/pulumi/pulumi/sdk/v3/go/pulumi"
 * )
 * func main() {
 * 	pulumi.Run(func(ctx *pulumi.Context) error {
 * 		pool, err := cognito.NewUserPool(ctx, "pool", &cognito.UserPoolArgs{
 * 			Name: pulumi.String("pool"),
 * 		})
 * 		if err != nil {
 * 			return err
 * 		}
 * 		_, err = cognito.NewResourceServer(ctx, "resource", &cognito.ResourceServerArgs{
 * 			Identifier: pulumi.String("https://example.com"),
 * 			Name:       pulumi.String("example"),
 * 			UserPoolId: pool.ID(),
 * 		})
 * 		if err != nil {
 * 			return err
 * 		}
 * 		return nil
 * 	})
 * }
 * ```
 * ```java
 * package generated_program;
 * import com.pulumi.Context;
 * import com.pulumi.Pulumi;
 * import com.pulumi.core.Output;
 * import com.pulumi.aws.cognito.UserPool;
 * import com.pulumi.aws.cognito.UserPoolArgs;
 * import com.pulumi.aws.cognito.ResourceServer;
 * import com.pulumi.aws.cognito.ResourceServerArgs;
 * import java.util.List;
 * import java.util.ArrayList;
 * import java.util.Map;
 * import java.io.File;
 * import java.nio.file.Files;
 * import java.nio.file.Paths;
 * public class App {
 *     public static void main(String[] args) {
 *         Pulumi.run(App::stack);
 *     }
 *     public static void stack(Context ctx) {
 *         var pool = new UserPool("pool", UserPoolArgs.builder()
 *             .name("pool")
 *             .build());
 *         var resource = new ResourceServer("resource", ResourceServerArgs.builder()
 *             .identifier("https://example.com")
 *             .name("example")
 *             .userPoolId(pool.id())
 *             .build());
 *     }
 * }
 * ```
 * ```yaml
 * resources:
 *   pool:
 *     type: aws:cognito:UserPool
 *     properties:
 *       name: pool
 *   resource:
 *     type: aws:cognito:ResourceServer
 *     properties:
 *       identifier: https://example.com
 *       name: example
 *       userPoolId: ${pool.id}
 * ```
 * <!--End PulumiCodeChooser -->
 * ### Create a resource server with sample-scope
 * <!--Start PulumiCodeChooser -->
 * ```typescript
 * import * as pulumi from "@pulumi/pulumi";
 * import * as aws from "@pulumi/aws";
 * const pool = new aws.cognito.UserPool("pool", {name: "pool"});
 * const resource = new aws.cognito.ResourceServer("resource", {
 *     identifier: "https://example.com",
 *     name: "example",
 *     scopes: [{
 *         scopeName: "sample-scope",
 *         scopeDescription: "a Sample Scope Description",
 *     }],
 *     userPoolId: pool.id,
 * });
 * ```
 * ```python
 * import pulumi
 * import pulumi_aws as aws
 * pool = aws.cognito.UserPool("pool", name="pool")
 * resource = aws.cognito.ResourceServer("resource",
 *     identifier="https://example.com",
 *     name="example",
 *     scopes=[{
 *         "scope_name": "sample-scope",
 *         "scope_description": "a Sample Scope Description",
 *     }],
 *     user_pool_id=pool.id)
 * ```
 * ```csharp
 * using System.Collections.Generic;
 * using System.Linq;
 * using Pulumi;
 * using Aws = Pulumi.Aws;
 * return await Deployment.RunAsync(() =>
 * {
 *     var pool = new Aws.Cognito.UserPool("pool", new()
 *     {
 *         Name = "pool",
 *     });
 *     var resource = new Aws.Cognito.ResourceServer("resource", new()
 *     {
 *         Identifier = "https://example.com",
 *         Name = "example",
 *         Scopes = new[]
 *         {
 *             new Aws.Cognito.Inputs.ResourceServerScopeArgs
 *             {
 *                 ScopeName = "sample-scope",
 *                 ScopeDescription = "a Sample Scope Description",
 *             },
 *         },
 *         UserPoolId = pool.Id,
 *     });
 * });
 * ```
 * ```go
 * package main
 * import (
 * 	"github.com/pulumi/pulumi-aws/sdk/v6/go/aws/cognito"
 * 	"github.com/pulumi/pulumi/sdk/v3/go/pulumi"
 * )
 * func main() {
 * 	pulumi.Run(func(ctx *pulumi.Context) error {
 * 		pool, err := cognito.NewUserPool(ctx, "pool", &cognito.UserPoolArgs{
 * 			Name: pulumi.String("pool"),
 * 		})
 * 		if err != nil {
 * 			return err
 * 		}
 * 		_, err = cognito.NewResourceServer(ctx, "resource", &cognito.ResourceServerArgs{
 * 			Identifier: pulumi.String("https://example.com"),
 * 			Name:       pulumi.String("example"),
 * 			Scopes: cognito.ResourceServerScopeArray{
 * 				&cognito.ResourceServerScopeArgs{
 * 					ScopeName:        pulumi.String("sample-scope"),
 * 					ScopeDescription: pulumi.String("a Sample Scope Description"),
 * 				},
 * 			},
 * 			UserPoolId: pool.ID(),
 * 		})
 * 		if err != nil {
 * 			return err
 * 		}
 * 		return nil
 * 	})
 * }
 * ```
 * ```java
 * package generated_program;
 * import com.pulumi.Context;
 * import com.pulumi.Pulumi;
 * import com.pulumi.core.Output;
 * import com.pulumi.aws.cognito.UserPool;
 * import com.pulumi.aws.cognito.UserPoolArgs;
 * import com.pulumi.aws.cognito.ResourceServer;
 * import com.pulumi.aws.cognito.ResourceServerArgs;
 * import com.pulumi.aws.cognito.inputs.ResourceServerScopeArgs;
 * import java.util.List;
 * import java.util.ArrayList;
 * import java.util.Map;
 * import java.io.File;
 * import java.nio.file.Files;
 * import java.nio.file.Paths;
 * public class App {
 *     public static void main(String[] args) {
 *         Pulumi.run(App::stack);
 *     }
 *     public static void stack(Context ctx) {
 *         var pool = new UserPool("pool", UserPoolArgs.builder()
 *             .name("pool")
 *             .build());
 *         var resource = new ResourceServer("resource", ResourceServerArgs.builder()
 *             .identifier("https://example.com")
 *             .name("example")
 *             .scopes(ResourceServerScopeArgs.builder()
 *                 .scopeName("sample-scope")
 *                 .scopeDescription("a Sample Scope Description")
 *                 .build())
 *             .userPoolId(pool.id())
 *             .build());
 *     }
 * }
 * ```
 * ```yaml
 * resources:
 *   pool:
 *     type: aws:cognito:UserPool
 *     properties:
 *       name: pool
 *   resource:
 *     type: aws:cognito:ResourceServer
 *     properties:
 *       identifier: https://example.com
 *       name: example
 *       scopes:
 *         - scopeName: sample-scope
 *           scopeDescription: a Sample Scope Description
 *       userPoolId: ${pool.id}
 * ```
 * <!--End PulumiCodeChooser -->
 * ## Import
 * Using `pulumi import`, import `aws_cognito_resource_server` using their User Pool ID and Identifier. For example:
 * ```sh
 * $ pulumi import aws:cognito/resourceServer:ResourceServer example "us-west-2_abc123|https://example.com"
 * ```
 */
public class ResourceServer internal constructor(
    override val javaResource: com.pulumi.aws.cognito.ResourceServer,
) : KotlinCustomResource(javaResource, ResourceServerMapper) {
    /**
     * An identifier for the resource server.
     */
    public val identifier: Output<String>
        get() = javaResource.identifier().applyValue({ args0 -> args0 })

    /**
     * A name for the resource server.
     */
    public val name: Output<String>
        get() = javaResource.name().applyValue({ args0 -> args0 })

    /**
     * A list of all scopes configured for this resource server in the format identifier/scope_name.
     */
    public val scopeIdentifiers: Output<List<String>>
        get() = javaResource.scopeIdentifiers().applyValue({ args0 -> args0.map({ args0 -> args0 }) })

    /**
     * A list of Authorization Scope.
     */
    public val scopes: Output<List<ResourceServerScope>>?
        get() = javaResource.scopes().applyValue({ args0 ->
            args0.map({ args0 ->
                args0.map({ args0 ->
                    args0.let({ args0 -> toKotlin(args0) })
                })
            }).orElse(null)
        })

    /**
     * User pool the client belongs to.
     */
    public val userPoolId: Output<String>
        get() = javaResource.userPoolId().applyValue({ args0 -> args0 })
}

public object ResourceServerMapper : ResourceMapper<ResourceServer> {
    override fun supportsMappingOfType(javaResource: Resource): Boolean =
        com.pulumi.aws.cognito.ResourceServer::class == javaResource::class

    override fun map(javaResource: Resource): ResourceServer = ResourceServer(
        javaResource as
            com.pulumi.aws.cognito.ResourceServer,
    )
}

/**
 * @see [ResourceServer].
 * @param name The _unique_ name of the resulting resource.
 * @param block Builder for [ResourceServer].
 */
public suspend fun resourceServer(
    name: String,
    block: suspend ResourceServerResourceBuilder.() -> Unit,
): ResourceServer {
    val builder = ResourceServerResourceBuilder()
    builder.name(name)
    block(builder)
    return builder.build()
}

/**
 * @see [ResourceServer].
 * @param name The _unique_ name of the resulting resource.
 */
public fun resourceServer(name: String): ResourceServer {
    val builder = ResourceServerResourceBuilder()
    builder.name(name)
    return builder.build()
}
