@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.aws.cognito.kotlin

import com.pulumi.aws.cognito.ResourceServerArgs.builder
import com.pulumi.aws.cognito.kotlin.inputs.ResourceServerScopeArgs
import com.pulumi.aws.cognito.kotlin.inputs.ResourceServerScopeArgsBuilder
import com.pulumi.core.Output
import com.pulumi.core.Output.of
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiTagMarker
import com.pulumi.kotlin.applySuspend
import kotlin.String
import kotlin.Suppress
import kotlin.Unit
import kotlin.collections.List
import kotlin.jvm.JvmName

/**
 * Provides a Cognito Resource Server.
 * ## Example Usage
 * ### Create a basic resource server
 * <!--Start PulumiCodeChooser -->
 * ```typescript
 * import * as pulumi from "@pulumi/pulumi";
 * import * as aws from "@pulumi/aws";
 * const pool = new aws.cognito.UserPool("pool", {name: "pool"});
 * const resource = new aws.cognito.ResourceServer("resource", {
 *     identifier: "https://example.com",
 *     name: "example",
 *     userPoolId: pool.id,
 * });
 * ```
 * ```python
 * import pulumi
 * import pulumi_aws as aws
 * pool = aws.cognito.UserPool("pool", name="pool")
 * resource = aws.cognito.ResourceServer("resource",
 *     identifier="https://example.com",
 *     name="example",
 *     user_pool_id=pool.id)
 * ```
 * ```csharp
 * using System.Collections.Generic;
 * using System.Linq;
 * using Pulumi;
 * using Aws = Pulumi.Aws;
 * return await Deployment.RunAsync(() =>
 * {
 *     var pool = new Aws.Cognito.UserPool("pool", new()
 *     {
 *         Name = "pool",
 *     });
 *     var resource = new Aws.Cognito.ResourceServer("resource", new()
 *     {
 *         Identifier = "https://example.com",
 *         Name = "example",
 *         UserPoolId = pool.Id,
 *     });
 * });
 * ```
 * ```go
 * package main
 * import (
 * 	"github.com/pulumi/pulumi-aws/sdk/v6/go/aws/cognito"
 * 	"github.com/pulumi/pulumi/sdk/v3/go/pulumi"
 * )
 * func main() {
 * 	pulumi.Run(func(ctx *pulumi.Context) error {
 * 		pool, err := cognito.NewUserPool(ctx, "pool", &cognito.UserPoolArgs{
 * 			Name: pulumi.String("pool"),
 * 		})
 * 		if err != nil {
 * 			return err
 * 		}
 * 		_, err = cognito.NewResourceServer(ctx, "resource", &cognito.ResourceServerArgs{
 * 			Identifier: pulumi.String("https://example.com"),
 * 			Name:       pulumi.String("example"),
 * 			UserPoolId: pool.ID(),
 * 		})
 * 		if err != nil {
 * 			return err
 * 		}
 * 		return nil
 * 	})
 * }
 * ```
 * ```java
 * package generated_program;
 * import com.pulumi.Context;
 * import com.pulumi.Pulumi;
 * import com.pulumi.core.Output;
 * import com.pulumi.aws.cognito.UserPool;
 * import com.pulumi.aws.cognito.UserPoolArgs;
 * import com.pulumi.aws.cognito.ResourceServer;
 * import com.pulumi.aws.cognito.ResourceServerArgs;
 * import java.util.List;
 * import java.util.ArrayList;
 * import java.util.Map;
 * import java.io.File;
 * import java.nio.file.Files;
 * import java.nio.file.Paths;
 * public class App {
 *     public static void main(String[] args) {
 *         Pulumi.run(App::stack);
 *     }
 *     public static void stack(Context ctx) {
 *         var pool = new UserPool("pool", UserPoolArgs.builder()
 *             .name("pool")
 *             .build());
 *         var resource = new ResourceServer("resource", ResourceServerArgs.builder()
 *             .identifier("https://example.com")
 *             .name("example")
 *             .userPoolId(pool.id())
 *             .build());
 *     }
 * }
 * ```
 * ```yaml
 * resources:
 *   pool:
 *     type: aws:cognito:UserPool
 *     properties:
 *       name: pool
 *   resource:
 *     type: aws:cognito:ResourceServer
 *     properties:
 *       identifier: https://example.com
 *       name: example
 *       userPoolId: ${pool.id}
 * ```
 * <!--End PulumiCodeChooser -->
 * ### Create a resource server with sample-scope
 * <!--Start PulumiCodeChooser -->
 * ```typescript
 * import * as pulumi from "@pulumi/pulumi";
 * import * as aws from "@pulumi/aws";
 * const pool = new aws.cognito.UserPool("pool", {name: "pool"});
 * const resource = new aws.cognito.ResourceServer("resource", {
 *     identifier: "https://example.com",
 *     name: "example",
 *     scopes: [{
 *         scopeName: "sample-scope",
 *         scopeDescription: "a Sample Scope Description",
 *     }],
 *     userPoolId: pool.id,
 * });
 * ```
 * ```python
 * import pulumi
 * import pulumi_aws as aws
 * pool = aws.cognito.UserPool("pool", name="pool")
 * resource = aws.cognito.ResourceServer("resource",
 *     identifier="https://example.com",
 *     name="example",
 *     scopes=[{
 *         "scope_name": "sample-scope",
 *         "scope_description": "a Sample Scope Description",
 *     }],
 *     user_pool_id=pool.id)
 * ```
 * ```csharp
 * using System.Collections.Generic;
 * using System.Linq;
 * using Pulumi;
 * using Aws = Pulumi.Aws;
 * return await Deployment.RunAsync(() =>
 * {
 *     var pool = new Aws.Cognito.UserPool("pool", new()
 *     {
 *         Name = "pool",
 *     });
 *     var resource = new Aws.Cognito.ResourceServer("resource", new()
 *     {
 *         Identifier = "https://example.com",
 *         Name = "example",
 *         Scopes = new[]
 *         {
 *             new Aws.Cognito.Inputs.ResourceServerScopeArgs
 *             {
 *                 ScopeName = "sample-scope",
 *                 ScopeDescription = "a Sample Scope Description",
 *             },
 *         },
 *         UserPoolId = pool.Id,
 *     });
 * });
 * ```
 * ```go
 * package main
 * import (
 * 	"github.com/pulumi/pulumi-aws/sdk/v6/go/aws/cognito"
 * 	"github.com/pulumi/pulumi/sdk/v3/go/pulumi"
 * )
 * func main() {
 * 	pulumi.Run(func(ctx *pulumi.Context) error {
 * 		pool, err := cognito.NewUserPool(ctx, "pool", &cognito.UserPoolArgs{
 * 			Name: pulumi.String("pool"),
 * 		})
 * 		if err != nil {
 * 			return err
 * 		}
 * 		_, err = cognito.NewResourceServer(ctx, "resource", &cognito.ResourceServerArgs{
 * 			Identifier: pulumi.String("https://example.com"),
 * 			Name:       pulumi.String("example"),
 * 			Scopes: cognito.ResourceServerScopeArray{
 * 				&cognito.ResourceServerScopeArgs{
 * 					ScopeName:        pulumi.String("sample-scope"),
 * 					ScopeDescription: pulumi.String("a Sample Scope Description"),
 * 				},
 * 			},
 * 			UserPoolId: pool.ID(),
 * 		})
 * 		if err != nil {
 * 			return err
 * 		}
 * 		return nil
 * 	})
 * }
 * ```
 * ```java
 * package generated_program;
 * import com.pulumi.Context;
 * import com.pulumi.Pulumi;
 * import com.pulumi.core.Output;
 * import com.pulumi.aws.cognito.UserPool;
 * import com.pulumi.aws.cognito.UserPoolArgs;
 * import com.pulumi.aws.cognito.ResourceServer;
 * import com.pulumi.aws.cognito.ResourceServerArgs;
 * import com.pulumi.aws.cognito.inputs.ResourceServerScopeArgs;
 * import java.util.List;
 * import java.util.ArrayList;
 * import java.util.Map;
 * import java.io.File;
 * import java.nio.file.Files;
 * import java.nio.file.Paths;
 * public class App {
 *     public static void main(String[] args) {
 *         Pulumi.run(App::stack);
 *     }
 *     public static void stack(Context ctx) {
 *         var pool = new UserPool("pool", UserPoolArgs.builder()
 *             .name("pool")
 *             .build());
 *         var resource = new ResourceServer("resource", ResourceServerArgs.builder()
 *             .identifier("https://example.com")
 *             .name("example")
 *             .scopes(ResourceServerScopeArgs.builder()
 *                 .scopeName("sample-scope")
 *                 .scopeDescription("a Sample Scope Description")
 *                 .build())
 *             .userPoolId(pool.id())
 *             .build());
 *     }
 * }
 * ```
 * ```yaml
 * resources:
 *   pool:
 *     type: aws:cognito:UserPool
 *     properties:
 *       name: pool
 *   resource:
 *     type: aws:cognito:ResourceServer
 *     properties:
 *       identifier: https://example.com
 *       name: example
 *       scopes:
 *         - scopeName: sample-scope
 *           scopeDescription: a Sample Scope Description
 *       userPoolId: ${pool.id}
 * ```
 * <!--End PulumiCodeChooser -->
 * ## Import
 * Using `pulumi import`, import `aws_cognito_resource_server` using their User Pool ID and Identifier. For example:
 * ```sh
 * $ pulumi import aws:cognito/resourceServer:ResourceServer example "us-west-2_abc123|https://example.com"
 * ```
 * @property identifier An identifier for the resource server.
 * @property name A name for the resource server.
 * @property scopes A list of Authorization Scope.
 * @property userPoolId User pool the client belongs to.
 */
public data class ResourceServerArgs(
    public val identifier: Output<String>? = null,
    public val name: Output<String>? = null,
    public val scopes: Output<List<ResourceServerScopeArgs>>? = null,
    public val userPoolId: Output<String>? = null,
) : ConvertibleToJava<com.pulumi.aws.cognito.ResourceServerArgs> {
    override fun toJava(): com.pulumi.aws.cognito.ResourceServerArgs =
        com.pulumi.aws.cognito.ResourceServerArgs.builder()
            .identifier(identifier?.applyValue({ args0 -> args0 }))
            .name(name?.applyValue({ args0 -> args0 }))
            .scopes(scopes?.applyValue({ args0 -> args0.map({ args0 -> args0.let({ args0 -> args0.toJava() }) }) }))
            .userPoolId(userPoolId?.applyValue({ args0 -> args0 })).build()
}

/**
 * Builder for [ResourceServerArgs].
 */
@PulumiTagMarker
public class ResourceServerArgsBuilder internal constructor() {
    private var identifier: Output<String>? = null

    private var name: Output<String>? = null

    private var scopes: Output<List<ResourceServerScopeArgs>>? = null

    private var userPoolId: Output<String>? = null

    /**
     * @param value An identifier for the resource server.
     */
    @JvmName("wnwtjassbkfnilal")
    public suspend fun identifier(`value`: Output<String>) {
        this.identifier = value
    }

    /**
     * @param value A name for the resource server.
     */
    @JvmName("cilxbshhfemfyogu")
    public suspend fun name(`value`: Output<String>) {
        this.name = value
    }

    /**
     * @param value A list of Authorization Scope.
     */
    @JvmName("wpmevhesjiqeaalb")
    public suspend fun scopes(`value`: Output<List<ResourceServerScopeArgs>>) {
        this.scopes = value
    }

    @JvmName("udgnwbjhageycmhc")
    public suspend fun scopes(vararg values: Output<ResourceServerScopeArgs>) {
        this.scopes = Output.all(values.asList())
    }

    /**
     * @param values A list of Authorization Scope.
     */
    @JvmName("xwwmighqjsgtmcdf")
    public suspend fun scopes(values: List<Output<ResourceServerScopeArgs>>) {
        this.scopes = Output.all(values)
    }

    /**
     * @param value User pool the client belongs to.
     */
    @JvmName("fddjqvtkgmjalefo")
    public suspend fun userPoolId(`value`: Output<String>) {
        this.userPoolId = value
    }

    /**
     * @param value An identifier for the resource server.
     */
    @JvmName("wvykxdfanpdurddf")
    public suspend fun identifier(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.identifier = mapped
    }

    /**
     * @param value A name for the resource server.
     */
    @JvmName("maqdqfsxolfjcsvl")
    public suspend fun name(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.name = mapped
    }

    /**
     * @param value A list of Authorization Scope.
     */
    @JvmName("hlxbleqhhxbejgkj")
    public suspend fun scopes(`value`: List<ResourceServerScopeArgs>?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.scopes = mapped
    }

    /**
     * @param argument A list of Authorization Scope.
     */
    @JvmName("sfplrhtkdqldextc")
    public suspend fun scopes(argument: List<suspend ResourceServerScopeArgsBuilder.() -> Unit>) {
        val toBeMapped = argument.toList().map {
            ResourceServerScopeArgsBuilder().applySuspend {
                it()
            }.build()
        }
        val mapped = of(toBeMapped)
        this.scopes = mapped
    }

    /**
     * @param argument A list of Authorization Scope.
     */
    @JvmName("xilkgtyjjsvevaqx")
    public suspend fun scopes(vararg argument: suspend ResourceServerScopeArgsBuilder.() -> Unit) {
        val toBeMapped = argument.toList().map {
            ResourceServerScopeArgsBuilder().applySuspend {
                it()
            }.build()
        }
        val mapped = of(toBeMapped)
        this.scopes = mapped
    }

    /**
     * @param argument A list of Authorization Scope.
     */
    @JvmName("eefcdsxctlytvjme")
    public suspend fun scopes(argument: suspend ResourceServerScopeArgsBuilder.() -> Unit) {
        val toBeMapped = listOf(ResourceServerScopeArgsBuilder().applySuspend { argument() }.build())
        val mapped = of(toBeMapped)
        this.scopes = mapped
    }

    /**
     * @param values A list of Authorization Scope.
     */
    @JvmName("kwjinffotirxdovq")
    public suspend fun scopes(vararg values: ResourceServerScopeArgs) {
        val toBeMapped = values.toList()
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.scopes = mapped
    }

    /**
     * @param value User pool the client belongs to.
     */
    @JvmName("pcikjnmpvwihoajj")
    public suspend fun userPoolId(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.userPoolId = mapped
    }

    internal fun build(): ResourceServerArgs = ResourceServerArgs(
        identifier = identifier,
        name = name,
        scopes = scopes,
        userPoolId = userPoolId,
    )
}
