@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.aws.cognito.kotlin

import com.pulumi.aws.cognito.kotlin.outputs.RiskConfigurationAccountTakeoverRiskConfiguration
import com.pulumi.aws.cognito.kotlin.outputs.RiskConfigurationCompromisedCredentialsRiskConfiguration
import com.pulumi.aws.cognito.kotlin.outputs.RiskConfigurationRiskExceptionConfiguration
import com.pulumi.core.Output
import com.pulumi.kotlin.KotlinCustomResource
import com.pulumi.kotlin.PulumiTagMarker
import com.pulumi.kotlin.ResourceMapper
import com.pulumi.kotlin.options.CustomResourceOptions
import com.pulumi.kotlin.options.CustomResourceOptionsBuilder
import com.pulumi.resources.Resource
import kotlin.Boolean
import kotlin.String
import kotlin.Suppress
import kotlin.Unit
import com.pulumi.aws.cognito.kotlin.outputs.RiskConfigurationAccountTakeoverRiskConfiguration.Companion.toKotlin as riskConfigurationAccountTakeoverRiskConfigurationToKotlin
import com.pulumi.aws.cognito.kotlin.outputs.RiskConfigurationCompromisedCredentialsRiskConfiguration.Companion.toKotlin as riskConfigurationCompromisedCredentialsRiskConfigurationToKotlin
import com.pulumi.aws.cognito.kotlin.outputs.RiskConfigurationRiskExceptionConfiguration.Companion.toKotlin as riskConfigurationRiskExceptionConfigurationToKotlin

/**
 * Builder for [RiskConfiguration].
 */
@PulumiTagMarker
public class RiskConfigurationResourceBuilder internal constructor() {
    public var name: String? = null

    public var args: RiskConfigurationArgs = RiskConfigurationArgs()

    public var opts: CustomResourceOptions = CustomResourceOptions()

    /**
     * @param name The _unique_ name of the resulting resource.
     */
    public fun name(`value`: String) {
        this.name = value
    }

    /**
     * @param block The arguments to use to populate this resource's properties.
     */
    public suspend fun args(block: suspend RiskConfigurationArgsBuilder.() -> Unit) {
        val builder = RiskConfigurationArgsBuilder()
        block(builder)
        this.args = builder.build()
    }

    /**
     * @param block A bag of options that control this resource's behavior.
     */
    public suspend fun opts(block: suspend CustomResourceOptionsBuilder.() -> Unit) {
        this.opts = com.pulumi.kotlin.options.CustomResourceOptions.opts(block)
    }

    internal fun build(): RiskConfiguration {
        val builtJavaResource = com.pulumi.aws.cognito.RiskConfiguration(
            this.name,
            this.args.toJava(),
            this.opts.toJava(),
        )
        return RiskConfiguration(builtJavaResource)
    }
}

/**
 * Provides a Cognito Risk Configuration resource.
 * ## Example Usage
 * <!--Start PulumiCodeChooser -->
 * ```typescript
 * import * as pulumi from "@pulumi/pulumi";
 * import * as aws from "@pulumi/aws";
 * const example = new aws.cognito.RiskConfiguration("example", {
 *     userPoolId: exampleAwsCognitoUserPool.id,
 *     riskExceptionConfiguration: {
 *         blockedIpRangeLists: ["10&#46;10&#46;10&#46;10/32"],
 *     },
 * });
 * ```
 * ```python
 * import pulumi
 * import pulumi_aws as aws
 * example = aws.cognito.RiskConfiguration("example",
 *     user_pool_id=example_aws_cognito_user_pool["id"],
 *     risk_exception_configuration={
 *         "blocked_ip_range_lists": ["10&#46;10&#46;10&#46;10/32"],
 *     })
 * ```
 * ```csharp
 * using System.Collections.Generic;
 * using System.Linq;
 * using Pulumi;
 * using Aws = Pulumi.Aws;
 * return await Deployment.RunAsync(() =>
 * {
 *     var example = new Aws.Cognito.RiskConfiguration("example", new()
 *     {
 *         UserPoolId = exampleAwsCognitoUserPool.Id,
 *         RiskExceptionConfiguration = new Aws.Cognito.Inputs.RiskConfigurationRiskExceptionConfigurationArgs
 *         {
 *             BlockedIpRangeLists = new[]
 *             {
 *                 "10.10.10.10/32",
 *             },
 *         },
 *     });
 * });
 * ```
 * ```go
 * package main
 * import (
 * 	"github.com/pulumi/pulumi-aws/sdk/v6/go/aws/cognito"
 * 	"github.com/pulumi/pulumi/sdk/v3/go/pulumi"
 * )
 * func main() {
 * 	pulumi.Run(func(ctx *pulumi.Context) error {
 * 		_, err := cognito.NewRiskConfiguration(ctx, "example", &cognito.RiskConfigurationArgs{
 * 			UserPoolId: pulumi.Any(exampleAwsCognitoUserPool.Id),
 * 			RiskExceptionConfiguration: &cognito.RiskConfigurationRiskExceptionConfigurationArgs{
 * 				BlockedIpRangeLists: pulumi.StringArray{
 * 					pulumi.String("10.10.10.10/32"),
 * 				},
 * 			},
 * 		})
 * 		if err != nil {
 * 			return err
 * 		}
 * 		return nil
 * 	})
 * }
 * ```
 * ```java
 * package generated_program;
 * import com.pulumi.Context;
 * import com.pulumi.Pulumi;
 * import com.pulumi.core.Output;
 * import com.pulumi.aws.cognito.RiskConfiguration;
 * import com.pulumi.aws.cognito.RiskConfigurationArgs;
 * import com.pulumi.aws.cognito.inputs.RiskConfigurationRiskExceptionConfigurationArgs;
 * import java.util.List;
 * import java.util.ArrayList;
 * import java.util.Map;
 * import java.io.File;
 * import java.nio.file.Files;
 * import java.nio.file.Paths;
 * public class App {
 *     public static void main(String[] args) {
 *         Pulumi.run(App::stack);
 *     }
 *     public static void stack(Context ctx) {
 *         var example = new RiskConfiguration("example", RiskConfigurationArgs.builder()
 *             .userPoolId(exampleAwsCognitoUserPool.id())
 *             .riskExceptionConfiguration(RiskConfigurationRiskExceptionConfigurationArgs.builder()
 *                 .blockedIpRangeLists("10.10.10.10/32")
 *                 .build())
 *             .build());
 *     }
 * }
 * ```
 * ```yaml
 * resources:
 *   example:
 *     type: aws:cognito:RiskConfiguration
 *     properties:
 *       userPoolId: ${exampleAwsCognitoUserPool.id}
 *       riskExceptionConfiguration:
 *         blockedIpRangeLists:
 *           - 10.10.10.10/32
 * ```
 * <!--End PulumiCodeChooser -->
 * ## Import
 * Import using the user pool ID and Client ID separated by a `:`:
 * __Using `pulumi import` to import__ Cognito Risk Configurations using the user pool ID or the user pool ID and Client Id separated by a `:`. For example:
 * Import using the user pool ID:
 * ```sh
 * $ pulumi import aws:cognito/riskConfiguration:RiskConfiguration main example
 * ```
 * Import using the user pool ID and Client ID separated by a `:`:
 * ```sh
 * $ pulumi import aws:cognito/riskConfiguration:RiskConfiguration main example:example
 * ```
 */
public class RiskConfiguration internal constructor(
    override val javaResource: com.pulumi.aws.cognito.RiskConfiguration,
) : KotlinCustomResource(javaResource, RiskConfigurationMapper) {
    /**
     * The account takeover risk configuration. See details below.
     */
    public val accountTakeoverRiskConfiguration:
        Output<RiskConfigurationAccountTakeoverRiskConfiguration>?
        get() = javaResource.accountTakeoverRiskConfiguration().applyValue({ args0 ->
            args0.map({ args0 ->
                args0.let({ args0 ->
                    riskConfigurationAccountTakeoverRiskConfigurationToKotlin(args0)
                })
            }).orElse(null)
        })

    /**
     * The app client ID. When the client ID is not provided, the same risk configuration is applied to all the clients in the User Pool.
     */
    public val clientId: Output<String>?
        get() = javaResource.clientId().applyValue({ args0 -> args0.map({ args0 -> args0 }).orElse(null) })

    /**
     * The compromised credentials risk configuration. See details below.
     */
    public val compromisedCredentialsRiskConfiguration:
        Output<RiskConfigurationCompromisedCredentialsRiskConfiguration>?
        get() = javaResource.compromisedCredentialsRiskConfiguration().applyValue({ args0 ->
            args0.map({ args0 ->
                args0.let({ args0 ->
                    riskConfigurationCompromisedCredentialsRiskConfigurationToKotlin(args0)
                })
            }).orElse(null)
        })

    /**
     * The configuration to override the risk decision. See details below.
     */
    public val riskExceptionConfiguration: Output<RiskConfigurationRiskExceptionConfiguration>?
        get() = javaResource.riskExceptionConfiguration().applyValue({ args0 ->
            args0.map({ args0 ->
                args0.let({ args0 ->
                    riskConfigurationRiskExceptionConfigurationToKotlin(args0)
                })
            }).orElse(null)
        })

    /**
     * The user pool ID.
     */
    public val userPoolId: Output<String>
        get() = javaResource.userPoolId().applyValue({ args0 -> args0 })
}

public object RiskConfigurationMapper : ResourceMapper<RiskConfiguration> {
    override fun supportsMappingOfType(javaResource: Resource): Boolean =
        com.pulumi.aws.cognito.RiskConfiguration::class == javaResource::class

    override fun map(javaResource: Resource): RiskConfiguration = RiskConfiguration(
        javaResource as
            com.pulumi.aws.cognito.RiskConfiguration,
    )
}

/**
 * @see [RiskConfiguration].
 * @param name The _unique_ name of the resulting resource.
 * @param block Builder for [RiskConfiguration].
 */
public suspend fun riskConfiguration(
    name: String,
    block: suspend RiskConfigurationResourceBuilder.() -> Unit,
): RiskConfiguration {
    val builder = RiskConfigurationResourceBuilder()
    builder.name(name)
    block(builder)
    return builder.build()
}

/**
 * @see [RiskConfiguration].
 * @param name The _unique_ name of the resulting resource.
 */
public fun riskConfiguration(name: String): RiskConfiguration {
    val builder = RiskConfigurationResourceBuilder()
    builder.name(name)
    return builder.build()
}
