@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.aws.cognito.kotlin

import com.pulumi.core.Output
import com.pulumi.kotlin.KotlinCustomResource
import com.pulumi.kotlin.PulumiTagMarker
import com.pulumi.kotlin.ResourceMapper
import com.pulumi.kotlin.options.CustomResourceOptions
import com.pulumi.kotlin.options.CustomResourceOptionsBuilder
import com.pulumi.resources.Resource
import kotlin.Boolean
import kotlin.String
import kotlin.Suppress
import kotlin.Unit
import kotlin.collections.List
import kotlin.collections.Map

/**
 * Builder for [User].
 */
@PulumiTagMarker
public class UserResourceBuilder internal constructor() {
    public var name: String? = null

    public var args: UserArgs = UserArgs()

    public var opts: CustomResourceOptions = CustomResourceOptions()

    /**
     * @param name The _unique_ name of the resulting resource.
     */
    public fun name(`value`: String) {
        this.name = value
    }

    /**
     * @param block The arguments to use to populate this resource's properties.
     */
    public suspend fun args(block: suspend UserArgsBuilder.() -> Unit) {
        val builder = UserArgsBuilder()
        block(builder)
        this.args = builder.build()
    }

    /**
     * @param block A bag of options that control this resource's behavior.
     */
    public suspend fun opts(block: suspend CustomResourceOptionsBuilder.() -> Unit) {
        this.opts = com.pulumi.kotlin.options.CustomResourceOptions.opts(block)
    }

    internal fun build(): User {
        val builtJavaResource = com.pulumi.aws.cognito.User(
            this.name,
            this.args.toJava(),
            this.opts.toJava(),
        )
        return User(builtJavaResource)
    }
}

/**
 * Provides a Cognito User Resource.
 * ## Example Usage
 * ### Basic configuration
 * <!--Start PulumiCodeChooser -->
 * ```typescript
 * import * as pulumi from "@pulumi/pulumi";
 * import * as aws from "@pulumi/aws";
 * const example = new aws.cognito.UserPool("example", {name: "MyExamplePool"});
 * const exampleUser = new aws.cognito.User("example", {
 *     userPoolId: example.id,
 *     username: "example",
 * });
 * ```
 * ```python
 * import pulumi
 * import pulumi_aws as aws
 * example = aws.cognito.UserPool("example", name="MyExamplePool")
 * example_user = aws.cognito.User("example",
 *     user_pool_id=example.id,
 *     username="example")
 * ```
 * ```csharp
 * using System.Collections.Generic;
 * using System.Linq;
 * using Pulumi;
 * using Aws = Pulumi.Aws;
 * return await Deployment.RunAsync(() =>
 * {
 *     var example = new Aws.Cognito.UserPool("example", new()
 *     {
 *         Name = "MyExamplePool",
 *     });
 *     var exampleUser = new Aws.Cognito.User("example", new()
 *     {
 *         UserPoolId = example.Id,
 *         Username = "example",
 *     });
 * });
 * ```
 * ```go
 * package main
 * import (
 * 	"github.com/pulumi/pulumi-aws/sdk/v6/go/aws/cognito"
 * 	"github.com/pulumi/pulumi/sdk/v3/go/pulumi"
 * )
 * func main() {
 * 	pulumi.Run(func(ctx *pulumi.Context) error {
 * 		example, err := cognito.NewUserPool(ctx, "example", &cognito.UserPoolArgs{
 * 			Name: pulumi.String("MyExamplePool"),
 * 		})
 * 		if err != nil {
 * 			return err
 * 		}
 * 		_, err = cognito.NewUser(ctx, "example", &cognito.UserArgs{
 * 			UserPoolId: example.ID(),
 * 			Username:   pulumi.String("example"),
 * 		})
 * 		if err != nil {
 * 			return err
 * 		}
 * 		return nil
 * 	})
 * }
 * ```
 * ```java
 * package generated_program;
 * import com.pulumi.Context;
 * import com.pulumi.Pulumi;
 * import com.pulumi.core.Output;
 * import com.pulumi.aws.cognito.UserPool;
 * import com.pulumi.aws.cognito.UserPoolArgs;
 * import com.pulumi.aws.cognito.User;
 * import com.pulumi.aws.cognito.UserArgs;
 * import java.util.List;
 * import java.util.ArrayList;
 * import java.util.Map;
 * import java.io.File;
 * import java.nio.file.Files;
 * import java.nio.file.Paths;
 * public class App {
 *     public static void main(String[] args) {
 *         Pulumi.run(App::stack);
 *     }
 *     public static void stack(Context ctx) {
 *         var example = new UserPool("example", UserPoolArgs.builder()
 *             .name("MyExamplePool")
 *             .build());
 *         var exampleUser = new User("exampleUser", UserArgs.builder()
 *             .userPoolId(example.id())
 *             .username("example")
 *             .build());
 *     }
 * }
 * ```
 * ```yaml
 * resources:
 *   example:
 *     type: aws:cognito:UserPool
 *     properties:
 *       name: MyExamplePool
 *   exampleUser:
 *     type: aws:cognito:User
 *     name: example
 *     properties:
 *       userPoolId: ${example.id}
 *       username: example
 * ```
 * <!--End PulumiCodeChooser -->
 * ### Setting user attributes
 * <!--Start PulumiCodeChooser -->
 * ```typescript
 * import * as pulumi from "@pulumi/pulumi";
 * import * as aws from "@pulumi/aws";
 * const example = new aws.cognito.UserPool("example", {
 *     name: "mypool",
 *     schemas: [
 *         {
 *             name: "example",
 *             attributeDataType: "Boolean",
 *             mutable: false,
 *             required: false,
 *             developerOnlyAttribute: false,
 *         },
 *         {
 *             name: "foo",
 *             attributeDataType: "String",
 *             mutable: false,
 *             required: false,
 *             developerOnlyAttribute: false,
 *             stringAttributeConstraints: {},
 *         },
 *     ],
 * });
 * const exampleUser = new aws.cognito.User("example", {
 *     userPoolId: example.id,
 *     username: "example",
 *     attributes: {
 *         example: "true",
 *         foo: "bar",
 *         email: "no-reply@example.com",
 *         email_verified: "true",
 *     },
 * });
 * ```
 * ```python
 * import pulumi
 * import pulumi_aws as aws
 * example = aws.cognito.UserPool("example",
 *     name="mypool",
 *     schemas=[
 *         {
 *             "name": "example",
 *             "attribute_data_type": "Boolean",
 *             "mutable": False,
 *             "required": False,
 *             "developer_only_attribute": False,
 *         },
 *         {
 *             "name": "foo",
 *             "attribute_data_type": "String",
 *             "mutable": False,
 *             "required": False,
 *             "developer_only_attribute": False,
 *             "string_attribute_constraints": {},
 *         },
 *     ])
 * example_user = aws.cognito.User("example",
 *     user_pool_id=example.id,
 *     username="example",
 *     attributes={
 *         "example": "true",
 *         "foo": "bar",
 *         "email": "no-reply@example.com",
 *         "email_verified": "true",
 *     })
 * ```
 * ```csharp
 * using System.Collections.Generic;
 * using System.Linq;
 * using Pulumi;
 * using Aws = Pulumi.Aws;
 * return await Deployment.RunAsync(() =>
 * {
 *     var example = new Aws.Cognito.UserPool("example", new()
 *     {
 *         Name = "mypool",
 *         Schemas = new[]
 *         {
 *             new Aws.Cognito.Inputs.UserPoolSchemaArgs
 *             {
 *                 Name = "example",
 *                 AttributeDataType = "Boolean",
 *                 Mutable = false,
 *                 Required = false,
 *                 DeveloperOnlyAttribute = false,
 *             },
 *             new Aws.Cognito.Inputs.UserPoolSchemaArgs
 *             {
 *                 Name = "foo",
 *                 AttributeDataType = "String",
 *                 Mutable = false,
 *                 Required = false,
 *                 DeveloperOnlyAttribute = false,
 *                 StringAttributeConstraints = null,
 *             },
 *         },
 *     });
 *     var exampleUser = new Aws.Cognito.User("example", new()
 *     {
 *         UserPoolId = example.Id,
 *         Username = "example",
 *         Attributes =
 *         {
 *             { "example", "true" },
 *             { "foo", "bar" },
 *             { "email", "no-reply@example.com" },
 *             { "email_verified", "true" },
 *         },
 *     });
 * });
 * ```
 * ```go
 * package main
 * import (
 * 	"github.com/pulumi/pulumi-aws/sdk/v6/go/aws/cognito"
 * 	"github.com/pulumi/pulumi/sdk/v3/go/pulumi"
 * )
 * func main() {
 * 	pulumi.Run(func(ctx *pulumi.Context) error {
 * 		example, err := cognito.NewUserPool(ctx, "example", &cognito.UserPoolArgs{
 * 			Name: pulumi.String("mypool"),
 * 			Schemas: cognito.UserPoolSchemaArray{
 * 				&cognito.UserPoolSchemaArgs{
 * 					Name:                   pulumi.String("example"),
 * 					AttributeDataType:      pulumi.String("Boolean"),
 * 					Mutable:                pulumi.Bool(false),
 * 					Required:               pulumi.Bool(false),
 * 					DeveloperOnlyAttribute: pulumi.Bool(false),
 * 				},
 * 				&cognito.UserPoolSchemaArgs{
 * 					Name:                       pulumi.String("foo"),
 * 					AttributeDataType:          pulumi.String("String"),
 * 					Mutable:                    pulumi.Bool(false),
 * 					Required:                   pulumi.Bool(false),
 * 					DeveloperOnlyAttribute:     pulumi.Bool(false),
 * 					StringAttributeConstraints: nil,
 * 				},
 * 			},
 * 		})
 * 		if err != nil {
 * 			return err
 * 		}
 * 		_, err = cognito.NewUser(ctx, "example", &cognito.UserArgs{
 * 			UserPoolId: example.ID(),
 * 			Username:   pulumi.String("example"),
 * 			Attributes: pulumi.StringMap{
 * 				"example":        pulumi.String("true"),
 * 				"foo":            pulumi.String("bar"),
 * 				"email":          pulumi.String("no-reply@example.com"),
 * 				"email_verified": pulumi.String("true"),
 * 			},
 * 		})
 * 		if err != nil {
 * 			return err
 * 		}
 * 		return nil
 * 	})
 * }
 * ```
 * ```java
 * package generated_program;
 * import com.pulumi.Context;
 * import com.pulumi.Pulumi;
 * import com.pulumi.core.Output;
 * import com.pulumi.aws.cognito.UserPool;
 * import com.pulumi.aws.cognito.UserPoolArgs;
 * import com.pulumi.aws.cognito.inputs.UserPoolSchemaArgs;
 * import com.pulumi.aws.cognito.inputs.UserPoolSchemaStringAttributeConstraintsArgs;
 * import com.pulumi.aws.cognito.User;
 * import com.pulumi.aws.cognito.UserArgs;
 * import java.util.List;
 * import java.util.ArrayList;
 * import java.util.Map;
 * import java.io.File;
 * import java.nio.file.Files;
 * import java.nio.file.Paths;
 * public class App {
 *     public static void main(String[] args) {
 *         Pulumi.run(App::stack);
 *     }
 *     public static void stack(Context ctx) {
 *         var example = new UserPool("example", UserPoolArgs.builder()
 *             .name("mypool")
 *             .schemas(
 *                 UserPoolSchemaArgs.builder()
 *                     .name("example")
 *                     .attributeDataType("Boolean")
 *                     .mutable(false)
 *                     .required(false)
 *                     .developerOnlyAttribute(false)
 *                     .build(),
 *                 UserPoolSchemaArgs.builder()
 *                     .name("foo")
 *                     .attributeDataType("String")
 *                     .mutable(false)
 *                     .required(false)
 *                     .developerOnlyAttribute(false)
 *                     .stringAttributeConstraints()
 *                     .build())
 *             .build());
 *         var exampleUser = new User("exampleUser", UserArgs.builder()
 *             .userPoolId(example.id())
 *             .username("example")
 *             .attributes(Map.ofEntries(
 *                 Map.entry("example", true),
 *                 Map.entry("foo", "bar"),
 *                 Map.entry("email", "no-reply@example.com"),
 *                 Map.entry("email_verified", true)
 *             ))
 *             .build());
 *     }
 * }
 * ```
 * ```yaml
 * resources:
 *   example:
 *     type: aws:cognito:UserPool
 *     properties:
 *       name: mypool
 *       schemas:
 *         - name: example
 *           attributeDataType: Boolean
 *           mutable: false
 *           required: false
 *           developerOnlyAttribute: false
 *         - name: foo
 *           attributeDataType: String
 *           mutable: false
 *           required: false
 *           developerOnlyAttribute: false
 *           stringAttributeConstraints: {}
 *   exampleUser:
 *     type: aws:cognito:User
 *     name: example
 *     properties:
 *       userPoolId: ${example.id}
 *       username: example
 *       attributes:
 *         example: true
 *         foo: bar
 *         email: no-reply@example.com
 *         email_verified: true
 * ```
 * <!--End PulumiCodeChooser -->
 * ## Import
 * Using `pulumi import`, import Cognito User using the `user_pool_id`/`name` attributes concatenated. For example:
 * ```sh
 * $ pulumi import aws:cognito/user:User user us-east-1_vG78M4goG/user
 * ```
 */
public class User internal constructor(
    override val javaResource: com.pulumi.aws.cognito.User,
) : KotlinCustomResource(javaResource, UserMapper) {
    /**
     * A map that contains user attributes and attribute values to be set for the user.
     */
    public val attributes: Output<Map<String, String>>?
        get() = javaResource.attributes().applyValue({ args0 ->
            args0.map({ args0 ->
                args0.map({ args0 ->
                    args0.key.to(args0.value)
                }).toMap()
            }).orElse(null)
        })

    /**
     * A map of custom key-value pairs that you can provide as input for any custom workflows that user creation triggers. Amazon Cognito does not store the `client_metadata` value. This data is available only to Lambda triggers that are assigned to a user pool to support custom workflows. If your user pool configuration does not include triggers, the ClientMetadata parameter serves no purpose. For more information, see [Customizing User Pool Workflows with Lambda Triggers](https://docs.aws.amazon.com/cognito/latest/developerguide/cognito-user-identity-pools-working-with-aws-lambda-triggers.html).
     */
    public val clientMetadata: Output<Map<String, String>>?
        get() = javaResource.clientMetadata().applyValue({ args0 ->
            args0.map({ args0 ->
                args0.map({ args0 -> args0.key.to(args0.value) }).toMap()
            }).orElse(null)
        })

    public val creationDate: Output<String>
        get() = javaResource.creationDate().applyValue({ args0 -> args0 })

    /**
     * A list of mediums to the welcome message will be sent through. Allowed values are `EMAIL` and `SMS`. If it's provided, make sure you have also specified `email` attribute for the `EMAIL` medium and `phone_number` for the `SMS`. More than one value can be specified. Amazon Cognito does not store the `desired_delivery_mediums` value. Defaults to `["SMS"]`.
     */
    public val desiredDeliveryMediums: Output<List<String>>?
        get() = javaResource.desiredDeliveryMediums().applyValue({ args0 ->
            args0.map({ args0 ->
                args0.map({ args0 -> args0 })
            }).orElse(null)
        })

    /**
     * Specifies whether the user should be enabled after creation. The welcome message will be sent regardless of the `enabled` value. The behavior can be changed with `message_action` argument. Defaults to `true`.
     */
    public val enabled: Output<Boolean>?
        get() = javaResource.enabled().applyValue({ args0 -> args0.map({ args0 -> args0 }).orElse(null) })

    /**
     * If this parameter is set to True and the `phone_number` or `email` address specified in the `attributes` parameter already exists as an alias with a different user, Amazon Cognito will migrate the alias from the previous user to the newly created user. The previous user will no longer be able to log in using that alias. Amazon Cognito does not store the `force_alias_creation` value. Defaults to `false`.
     */
    public val forceAliasCreation: Output<Boolean>?
        get() = javaResource.forceAliasCreation().applyValue({ args0 ->
            args0.map({ args0 ->
                args0
            }).orElse(null)
        })

    public val lastModifiedDate: Output<String>
        get() = javaResource.lastModifiedDate().applyValue({ args0 -> args0 })

    /**
     * Set to `RESEND` to resend the invitation message to a user that already exists and reset the expiration limit on the user's account. Set to `SUPPRESS` to suppress sending the message. Only one value can be specified. Amazon Cognito does not store the `message_action` value.
     */
    public val messageAction: Output<String>?
        get() = javaResource.messageAction().applyValue({ args0 ->
            args0.map({ args0 ->
                args0
            }).orElse(null)
        })

    public val mfaSettingLists: Output<List<String>>
        get() = javaResource.mfaSettingLists().applyValue({ args0 -> args0.map({ args0 -> args0 }) })

    /**
     * The user's permanent password. This password must conform to the password policy specified by user pool the user belongs to. The welcome message always contains only `temporary_password` value. You can suppress sending the welcome message with the `message_action` argument. Amazon Cognito does not store the `password` value. Conflicts with `temporary_password`.
     */
    public val password: Output<String>?
        get() = javaResource.password().applyValue({ args0 -> args0.map({ args0 -> args0 }).orElse(null) })

    public val preferredMfaSetting: Output<String>
        get() = javaResource.preferredMfaSetting().applyValue({ args0 -> args0 })

    /**
     * current user status.
     */
    public val status: Output<String>
        get() = javaResource.status().applyValue({ args0 -> args0 })

    /**
     * unique user id that is never reassignable to another user.
     */
    public val sub: Output<String>
        get() = javaResource.sub().applyValue({ args0 -> args0 })

    /**
     * The user's temporary password. Conflicts with `password`.
     */
    public val temporaryPassword: Output<String>?
        get() = javaResource.temporaryPassword().applyValue({ args0 ->
            args0.map({ args0 ->
                args0
            }).orElse(null)
        })

    /**
     * The user pool ID for the user pool where the user will be created.
     */
    public val userPoolId: Output<String>
        get() = javaResource.userPoolId().applyValue({ args0 -> args0 })

    /**
     * The username for the user. Must be unique within the user pool. Must be a UTF-8 string between 1 and 128 characters. After the user is created, the username cannot be changed.
     * The following arguments are optional:
     */
    public val username: Output<String>
        get() = javaResource.username().applyValue({ args0 -> args0 })

    /**
     * The user's validation data. This is an array of name-value pairs that contain user attributes and attribute values that you can use for custom validation, such as restricting the types of user accounts that can be registered. Amazon Cognito does not store the `validation_data` value. For more information, see [Customizing User Pool Workflows with Lambda Triggers](https://docs.aws.amazon.com/cognito/latest/developerguide/cognito-user-identity-pools-working-with-aws-lambda-triggers.html).
     * > **NOTE:** Clearing `password` or `temporary_password` does not reset user's password in Cognito.
     */
    public val validationData: Output<Map<String, String>>?
        get() = javaResource.validationData().applyValue({ args0 ->
            args0.map({ args0 ->
                args0.map({ args0 -> args0.key.to(args0.value) }).toMap()
            }).orElse(null)
        })
}

public object UserMapper : ResourceMapper<User> {
    override fun supportsMappingOfType(javaResource: Resource): Boolean =
        com.pulumi.aws.cognito.User::class == javaResource::class

    override fun map(javaResource: Resource): User = User(javaResource as com.pulumi.aws.cognito.User)
}

/**
 * @see [User].
 * @param name The _unique_ name of the resulting resource.
 * @param block Builder for [User].
 */
public suspend fun user(name: String, block: suspend UserResourceBuilder.() -> Unit): User {
    val builder = UserResourceBuilder()
    builder.name(name)
    block(builder)
    return builder.build()
}

/**
 * @see [User].
 * @param name The _unique_ name of the resulting resource.
 */
public fun user(name: String): User {
    val builder = UserResourceBuilder()
    builder.name(name)
    return builder.build()
}
