@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.aws.cognito.kotlin

import com.pulumi.aws.cognito.UserArgs.builder
import com.pulumi.core.Output
import com.pulumi.core.Output.of
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiTagMarker
import kotlin.Boolean
import kotlin.Pair
import kotlin.String
import kotlin.Suppress
import kotlin.collections.List
import kotlin.collections.Map
import kotlin.jvm.JvmName

/**
 * Provides a Cognito User Resource.
 * ## Example Usage
 * ### Basic configuration
 * <!--Start PulumiCodeChooser -->
 * ```typescript
 * import * as pulumi from "@pulumi/pulumi";
 * import * as aws from "@pulumi/aws";
 * const example = new aws.cognito.UserPool("example", {name: "MyExamplePool"});
 * const exampleUser = new aws.cognito.User("example", {
 *     userPoolId: example.id,
 *     username: "example",
 * });
 * ```
 * ```python
 * import pulumi
 * import pulumi_aws as aws
 * example = aws.cognito.UserPool("example", name="MyExamplePool")
 * example_user = aws.cognito.User("example",
 *     user_pool_id=example.id,
 *     username="example")
 * ```
 * ```csharp
 * using System.Collections.Generic;
 * using System.Linq;
 * using Pulumi;
 * using Aws = Pulumi.Aws;
 * return await Deployment.RunAsync(() =>
 * {
 *     var example = new Aws.Cognito.UserPool("example", new()
 *     {
 *         Name = "MyExamplePool",
 *     });
 *     var exampleUser = new Aws.Cognito.User("example", new()
 *     {
 *         UserPoolId = example.Id,
 *         Username = "example",
 *     });
 * });
 * ```
 * ```go
 * package main
 * import (
 * 	"github.com/pulumi/pulumi-aws/sdk/v6/go/aws/cognito"
 * 	"github.com/pulumi/pulumi/sdk/v3/go/pulumi"
 * )
 * func main() {
 * 	pulumi.Run(func(ctx *pulumi.Context) error {
 * 		example, err := cognito.NewUserPool(ctx, "example", &cognito.UserPoolArgs{
 * 			Name: pulumi.String("MyExamplePool"),
 * 		})
 * 		if err != nil {
 * 			return err
 * 		}
 * 		_, err = cognito.NewUser(ctx, "example", &cognito.UserArgs{
 * 			UserPoolId: example.ID(),
 * 			Username:   pulumi.String("example"),
 * 		})
 * 		if err != nil {
 * 			return err
 * 		}
 * 		return nil
 * 	})
 * }
 * ```
 * ```java
 * package generated_program;
 * import com.pulumi.Context;
 * import com.pulumi.Pulumi;
 * import com.pulumi.core.Output;
 * import com.pulumi.aws.cognito.UserPool;
 * import com.pulumi.aws.cognito.UserPoolArgs;
 * import com.pulumi.aws.cognito.User;
 * import com.pulumi.aws.cognito.UserArgs;
 * import java.util.List;
 * import java.util.ArrayList;
 * import java.util.Map;
 * import java.io.File;
 * import java.nio.file.Files;
 * import java.nio.file.Paths;
 * public class App {
 *     public static void main(String[] args) {
 *         Pulumi.run(App::stack);
 *     }
 *     public static void stack(Context ctx) {
 *         var example = new UserPool("example", UserPoolArgs.builder()
 *             .name("MyExamplePool")
 *             .build());
 *         var exampleUser = new User("exampleUser", UserArgs.builder()
 *             .userPoolId(example.id())
 *             .username("example")
 *             .build());
 *     }
 * }
 * ```
 * ```yaml
 * resources:
 *   example:
 *     type: aws:cognito:UserPool
 *     properties:
 *       name: MyExamplePool
 *   exampleUser:
 *     type: aws:cognito:User
 *     name: example
 *     properties:
 *       userPoolId: ${example.id}
 *       username: example
 * ```
 * <!--End PulumiCodeChooser -->
 * ### Setting user attributes
 * <!--Start PulumiCodeChooser -->
 * ```typescript
 * import * as pulumi from "@pulumi/pulumi";
 * import * as aws from "@pulumi/aws";
 * const example = new aws.cognito.UserPool("example", {
 *     name: "mypool",
 *     schemas: [
 *         {
 *             name: "example",
 *             attributeDataType: "Boolean",
 *             mutable: false,
 *             required: false,
 *             developerOnlyAttribute: false,
 *         },
 *         {
 *             name: "foo",
 *             attributeDataType: "String",
 *             mutable: false,
 *             required: false,
 *             developerOnlyAttribute: false,
 *             stringAttributeConstraints: {},
 *         },
 *     ],
 * });
 * const exampleUser = new aws.cognito.User("example", {
 *     userPoolId: example.id,
 *     username: "example",
 *     attributes: {
 *         example: "true",
 *         foo: "bar",
 *         email: "no-reply@example.com",
 *         email_verified: "true",
 *     },
 * });
 * ```
 * ```python
 * import pulumi
 * import pulumi_aws as aws
 * example = aws.cognito.UserPool("example",
 *     name="mypool",
 *     schemas=[
 *         {
 *             "name": "example",
 *             "attribute_data_type": "Boolean",
 *             "mutable": False,
 *             "required": False,
 *             "developer_only_attribute": False,
 *         },
 *         {
 *             "name": "foo",
 *             "attribute_data_type": "String",
 *             "mutable": False,
 *             "required": False,
 *             "developer_only_attribute": False,
 *             "string_attribute_constraints": {},
 *         },
 *     ])
 * example_user = aws.cognito.User("example",
 *     user_pool_id=example.id,
 *     username="example",
 *     attributes={
 *         "example": "true",
 *         "foo": "bar",
 *         "email": "no-reply@example.com",
 *         "email_verified": "true",
 *     })
 * ```
 * ```csharp
 * using System.Collections.Generic;
 * using System.Linq;
 * using Pulumi;
 * using Aws = Pulumi.Aws;
 * return await Deployment.RunAsync(() =>
 * {
 *     var example = new Aws.Cognito.UserPool("example", new()
 *     {
 *         Name = "mypool",
 *         Schemas = new[]
 *         {
 *             new Aws.Cognito.Inputs.UserPoolSchemaArgs
 *             {
 *                 Name = "example",
 *                 AttributeDataType = "Boolean",
 *                 Mutable = false,
 *                 Required = false,
 *                 DeveloperOnlyAttribute = false,
 *             },
 *             new Aws.Cognito.Inputs.UserPoolSchemaArgs
 *             {
 *                 Name = "foo",
 *                 AttributeDataType = "String",
 *                 Mutable = false,
 *                 Required = false,
 *                 DeveloperOnlyAttribute = false,
 *                 StringAttributeConstraints = null,
 *             },
 *         },
 *     });
 *     var exampleUser = new Aws.Cognito.User("example", new()
 *     {
 *         UserPoolId = example.Id,
 *         Username = "example",
 *         Attributes =
 *         {
 *             { "example", "true" },
 *             { "foo", "bar" },
 *             { "email", "no-reply@example.com" },
 *             { "email_verified", "true" },
 *         },
 *     });
 * });
 * ```
 * ```go
 * package main
 * import (
 * 	"github.com/pulumi/pulumi-aws/sdk/v6/go/aws/cognito"
 * 	"github.com/pulumi/pulumi/sdk/v3/go/pulumi"
 * )
 * func main() {
 * 	pulumi.Run(func(ctx *pulumi.Context) error {
 * 		example, err := cognito.NewUserPool(ctx, "example", &cognito.UserPoolArgs{
 * 			Name: pulumi.String("mypool"),
 * 			Schemas: cognito.UserPoolSchemaArray{
 * 				&cognito.UserPoolSchemaArgs{
 * 					Name:                   pulumi.String("example"),
 * 					AttributeDataType:      pulumi.String("Boolean"),
 * 					Mutable:                pulumi.Bool(false),
 * 					Required:               pulumi.Bool(false),
 * 					DeveloperOnlyAttribute: pulumi.Bool(false),
 * 				},
 * 				&cognito.UserPoolSchemaArgs{
 * 					Name:                       pulumi.String("foo"),
 * 					AttributeDataType:          pulumi.String("String"),
 * 					Mutable:                    pulumi.Bool(false),
 * 					Required:                   pulumi.Bool(false),
 * 					DeveloperOnlyAttribute:     pulumi.Bool(false),
 * 					StringAttributeConstraints: nil,
 * 				},
 * 			},
 * 		})
 * 		if err != nil {
 * 			return err
 * 		}
 * 		_, err = cognito.NewUser(ctx, "example", &cognito.UserArgs{
 * 			UserPoolId: example.ID(),
 * 			Username:   pulumi.String("example"),
 * 			Attributes: pulumi.StringMap{
 * 				"example":        pulumi.String("true"),
 * 				"foo":            pulumi.String("bar"),
 * 				"email":          pulumi.String("no-reply@example.com"),
 * 				"email_verified": pulumi.String("true"),
 * 			},
 * 		})
 * 		if err != nil {
 * 			return err
 * 		}
 * 		return nil
 * 	})
 * }
 * ```
 * ```java
 * package generated_program;
 * import com.pulumi.Context;
 * import com.pulumi.Pulumi;
 * import com.pulumi.core.Output;
 * import com.pulumi.aws.cognito.UserPool;
 * import com.pulumi.aws.cognito.UserPoolArgs;
 * import com.pulumi.aws.cognito.inputs.UserPoolSchemaArgs;
 * import com.pulumi.aws.cognito.inputs.UserPoolSchemaStringAttributeConstraintsArgs;
 * import com.pulumi.aws.cognito.User;
 * import com.pulumi.aws.cognito.UserArgs;
 * import java.util.List;
 * import java.util.ArrayList;
 * import java.util.Map;
 * import java.io.File;
 * import java.nio.file.Files;
 * import java.nio.file.Paths;
 * public class App {
 *     public static void main(String[] args) {
 *         Pulumi.run(App::stack);
 *     }
 *     public static void stack(Context ctx) {
 *         var example = new UserPool("example", UserPoolArgs.builder()
 *             .name("mypool")
 *             .schemas(
 *                 UserPoolSchemaArgs.builder()
 *                     .name("example")
 *                     .attributeDataType("Boolean")
 *                     .mutable(false)
 *                     .required(false)
 *                     .developerOnlyAttribute(false)
 *                     .build(),
 *                 UserPoolSchemaArgs.builder()
 *                     .name("foo")
 *                     .attributeDataType("String")
 *                     .mutable(false)
 *                     .required(false)
 *                     .developerOnlyAttribute(false)
 *                     .stringAttributeConstraints()
 *                     .build())
 *             .build());
 *         var exampleUser = new User("exampleUser", UserArgs.builder()
 *             .userPoolId(example.id())
 *             .username("example")
 *             .attributes(Map.ofEntries(
 *                 Map.entry("example", true),
 *                 Map.entry("foo", "bar"),
 *                 Map.entry("email", "no-reply@example.com"),
 *                 Map.entry("email_verified", true)
 *             ))
 *             .build());
 *     }
 * }
 * ```
 * ```yaml
 * resources:
 *   example:
 *     type: aws:cognito:UserPool
 *     properties:
 *       name: mypool
 *       schemas:
 *         - name: example
 *           attributeDataType: Boolean
 *           mutable: false
 *           required: false
 *           developerOnlyAttribute: false
 *         - name: foo
 *           attributeDataType: String
 *           mutable: false
 *           required: false
 *           developerOnlyAttribute: false
 *           stringAttributeConstraints: {}
 *   exampleUser:
 *     type: aws:cognito:User
 *     name: example
 *     properties:
 *       userPoolId: ${example.id}
 *       username: example
 *       attributes:
 *         example: true
 *         foo: bar
 *         email: no-reply@example.com
 *         email_verified: true
 * ```
 * <!--End PulumiCodeChooser -->
 * ## Import
 * Using `pulumi import`, import Cognito User using the `user_pool_id`/`name` attributes concatenated. For example:
 * ```sh
 * $ pulumi import aws:cognito/user:User user us-east-1_vG78M4goG/user
 * ```
 * @property attributes A map that contains user attributes and attribute values to be set for the user.
 * @property clientMetadata A map of custom key-value pairs that you can provide as input for any custom workflows that user creation triggers. Amazon Cognito does not store the `client_metadata` value. This data is available only to Lambda triggers that are assigned to a user pool to support custom workflows. If your user pool configuration does not include triggers, the ClientMetadata parameter serves no purpose. For more information, see [Customizing User Pool Workflows with Lambda Triggers](https://docs.aws.amazon.com/cognito/latest/developerguide/cognito-user-identity-pools-working-with-aws-lambda-triggers.html).
 * @property desiredDeliveryMediums A list of mediums to the welcome message will be sent through. Allowed values are `EMAIL` and `SMS`. If it's provided, make sure you have also specified `email` attribute for the `EMAIL` medium and `phone_number` for the `SMS`. More than one value can be specified. Amazon Cognito does not store the `desired_delivery_mediums` value. Defaults to `["SMS"]`.
 * @property enabled Specifies whether the user should be enabled after creation. The welcome message will be sent regardless of the `enabled` value. The behavior can be changed with `message_action` argument. Defaults to `true`.
 * @property forceAliasCreation If this parameter is set to True and the `phone_number` or `email` address specified in the `attributes` parameter already exists as an alias with a different user, Amazon Cognito will migrate the alias from the previous user to the newly created user. The previous user will no longer be able to log in using that alias. Amazon Cognito does not store the `force_alias_creation` value. Defaults to `false`.
 * @property messageAction Set to `RESEND` to resend the invitation message to a user that already exists and reset the expiration limit on the user's account. Set to `SUPPRESS` to suppress sending the message. Only one value can be specified. Amazon Cognito does not store the `message_action` value.
 * @property password The user's permanent password. This password must conform to the password policy specified by user pool the user belongs to. The welcome message always contains only `temporary_password` value. You can suppress sending the welcome message with the `message_action` argument. Amazon Cognito does not store the `password` value. Conflicts with `temporary_password`.
 * @property temporaryPassword The user's temporary password. Conflicts with `password`.
 * @property userPoolId The user pool ID for the user pool where the user will be created.
 * @property username The username for the user. Must be unique within the user pool. Must be a UTF-8 string between 1 and 128 characters. After the user is created, the username cannot be changed.
 * The following arguments are optional:
 * @property validationData The user's validation data. This is an array of name-value pairs that contain user attributes and attribute values that you can use for custom validation, such as restricting the types of user accounts that can be registered. Amazon Cognito does not store the `validation_data` value. For more information, see [Customizing User Pool Workflows with Lambda Triggers](https://docs.aws.amazon.com/cognito/latest/developerguide/cognito-user-identity-pools-working-with-aws-lambda-triggers.html).
 * > **NOTE:** Clearing `password` or `temporary_password` does not reset user's password in Cognito.
 */
public data class UserArgs(
    public val attributes: Output<Map<String, String>>? = null,
    public val clientMetadata: Output<Map<String, String>>? = null,
    public val desiredDeliveryMediums: Output<List<String>>? = null,
    public val enabled: Output<Boolean>? = null,
    public val forceAliasCreation: Output<Boolean>? = null,
    public val messageAction: Output<String>? = null,
    public val password: Output<String>? = null,
    public val temporaryPassword: Output<String>? = null,
    public val userPoolId: Output<String>? = null,
    public val username: Output<String>? = null,
    public val validationData: Output<Map<String, String>>? = null,
) : ConvertibleToJava<com.pulumi.aws.cognito.UserArgs> {
    override fun toJava(): com.pulumi.aws.cognito.UserArgs = com.pulumi.aws.cognito.UserArgs.builder()
        .attributes(
            attributes?.applyValue({ args0 ->
                args0.map({ args0 ->
                    args0.key.to(args0.value)
                }).toMap()
            }),
        )
        .clientMetadata(
            clientMetadata?.applyValue({ args0 ->
                args0.map({ args0 ->
                    args0.key.to(args0.value)
                }).toMap()
            }),
        )
        .desiredDeliveryMediums(
            desiredDeliveryMediums?.applyValue({ args0 ->
                args0.map({ args0 ->
                    args0
                })
            }),
        )
        .enabled(enabled?.applyValue({ args0 -> args0 }))
        .forceAliasCreation(forceAliasCreation?.applyValue({ args0 -> args0 }))
        .messageAction(messageAction?.applyValue({ args0 -> args0 }))
        .password(password?.applyValue({ args0 -> args0 }))
        .temporaryPassword(temporaryPassword?.applyValue({ args0 -> args0 }))
        .userPoolId(userPoolId?.applyValue({ args0 -> args0 }))
        .username(username?.applyValue({ args0 -> args0 }))
        .validationData(
            validationData?.applyValue({ args0 ->
                args0.map({ args0 ->
                    args0.key.to(args0.value)
                }).toMap()
            }),
        ).build()
}

/**
 * Builder for [UserArgs].
 */
@PulumiTagMarker
public class UserArgsBuilder internal constructor() {
    private var attributes: Output<Map<String, String>>? = null

    private var clientMetadata: Output<Map<String, String>>? = null

    private var desiredDeliveryMediums: Output<List<String>>? = null

    private var enabled: Output<Boolean>? = null

    private var forceAliasCreation: Output<Boolean>? = null

    private var messageAction: Output<String>? = null

    private var password: Output<String>? = null

    private var temporaryPassword: Output<String>? = null

    private var userPoolId: Output<String>? = null

    private var username: Output<String>? = null

    private var validationData: Output<Map<String, String>>? = null

    /**
     * @param value A map that contains user attributes and attribute values to be set for the user.
     */
    @JvmName("suaomrnobvgscorm")
    public suspend fun attributes(`value`: Output<Map<String, String>>) {
        this.attributes = value
    }

    /**
     * @param value A map of custom key-value pairs that you can provide as input for any custom workflows that user creation triggers. Amazon Cognito does not store the `client_metadata` value. This data is available only to Lambda triggers that are assigned to a user pool to support custom workflows. If your user pool configuration does not include triggers, the ClientMetadata parameter serves no purpose. For more information, see [Customizing User Pool Workflows with Lambda Triggers](https://docs.aws.amazon.com/cognito/latest/developerguide/cognito-user-identity-pools-working-with-aws-lambda-triggers.html).
     */
    @JvmName("vdtoaffebyxrircb")
    public suspend fun clientMetadata(`value`: Output<Map<String, String>>) {
        this.clientMetadata = value
    }

    /**
     * @param value A list of mediums to the welcome message will be sent through. Allowed values are `EMAIL` and `SMS`. If it's provided, make sure you have also specified `email` attribute for the `EMAIL` medium and `phone_number` for the `SMS`. More than one value can be specified. Amazon Cognito does not store the `desired_delivery_mediums` value. Defaults to `["SMS"]`.
     */
    @JvmName("qrbcxckrfxoodryl")
    public suspend fun desiredDeliveryMediums(`value`: Output<List<String>>) {
        this.desiredDeliveryMediums = value
    }

    @JvmName("ighggerelgoqcrgf")
    public suspend fun desiredDeliveryMediums(vararg values: Output<String>) {
        this.desiredDeliveryMediums = Output.all(values.asList())
    }

    /**
     * @param values A list of mediums to the welcome message will be sent through. Allowed values are `EMAIL` and `SMS`. If it's provided, make sure you have also specified `email` attribute for the `EMAIL` medium and `phone_number` for the `SMS`. More than one value can be specified. Amazon Cognito does not store the `desired_delivery_mediums` value. Defaults to `["SMS"]`.
     */
    @JvmName("xommfhjjjqcoxemt")
    public suspend fun desiredDeliveryMediums(values: List<Output<String>>) {
        this.desiredDeliveryMediums = Output.all(values)
    }

    /**
     * @param value Specifies whether the user should be enabled after creation. The welcome message will be sent regardless of the `enabled` value. The behavior can be changed with `message_action` argument. Defaults to `true`.
     */
    @JvmName("fvhoalqihksqlpar")
    public suspend fun enabled(`value`: Output<Boolean>) {
        this.enabled = value
    }

    /**
     * @param value If this parameter is set to True and the `phone_number` or `email` address specified in the `attributes` parameter already exists as an alias with a different user, Amazon Cognito will migrate the alias from the previous user to the newly created user. The previous user will no longer be able to log in using that alias. Amazon Cognito does not store the `force_alias_creation` value. Defaults to `false`.
     */
    @JvmName("ktsjdvvkfsayakgn")
    public suspend fun forceAliasCreation(`value`: Output<Boolean>) {
        this.forceAliasCreation = value
    }

    /**
     * @param value Set to `RESEND` to resend the invitation message to a user that already exists and reset the expiration limit on the user's account. Set to `SUPPRESS` to suppress sending the message. Only one value can be specified. Amazon Cognito does not store the `message_action` value.
     */
    @JvmName("xfucydibaosxkpmt")
    public suspend fun messageAction(`value`: Output<String>) {
        this.messageAction = value
    }

    /**
     * @param value The user's permanent password. This password must conform to the password policy specified by user pool the user belongs to. The welcome message always contains only `temporary_password` value. You can suppress sending the welcome message with the `message_action` argument. Amazon Cognito does not store the `password` value. Conflicts with `temporary_password`.
     */
    @JvmName("ujyniggljgtryqud")
    public suspend fun password(`value`: Output<String>) {
        this.password = value
    }

    /**
     * @param value The user's temporary password. Conflicts with `password`.
     */
    @JvmName("hvspsorcdydsymwb")
    public suspend fun temporaryPassword(`value`: Output<String>) {
        this.temporaryPassword = value
    }

    /**
     * @param value The user pool ID for the user pool where the user will be created.
     */
    @JvmName("dxhrksmyetvsjxbs")
    public suspend fun userPoolId(`value`: Output<String>) {
        this.userPoolId = value
    }

    /**
     * @param value The username for the user. Must be unique within the user pool. Must be a UTF-8 string between 1 and 128 characters. After the user is created, the username cannot be changed.
     * The following arguments are optional:
     */
    @JvmName("libgwyfavfwrokvd")
    public suspend fun username(`value`: Output<String>) {
        this.username = value
    }

    /**
     * @param value The user's validation data. This is an array of name-value pairs that contain user attributes and attribute values that you can use for custom validation, such as restricting the types of user accounts that can be registered. Amazon Cognito does not store the `validation_data` value. For more information, see [Customizing User Pool Workflows with Lambda Triggers](https://docs.aws.amazon.com/cognito/latest/developerguide/cognito-user-identity-pools-working-with-aws-lambda-triggers.html).
     * > **NOTE:** Clearing `password` or `temporary_password` does not reset user's password in Cognito.
     */
    @JvmName("rumqubyaupemqkno")
    public suspend fun validationData(`value`: Output<Map<String, String>>) {
        this.validationData = value
    }

    /**
     * @param value A map that contains user attributes and attribute values to be set for the user.
     */
    @JvmName("uubqkpxtxjllvjne")
    public suspend fun attributes(`value`: Map<String, String>?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.attributes = mapped
    }

    /**
     * @param values A map that contains user attributes and attribute values to be set for the user.
     */
    @JvmName("ocikpcltiyjvoeod")
    public fun attributes(vararg values: Pair<String, String>) {
        val toBeMapped = values.toMap()
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.attributes = mapped
    }

    /**
     * @param value A map of custom key-value pairs that you can provide as input for any custom workflows that user creation triggers. Amazon Cognito does not store the `client_metadata` value. This data is available only to Lambda triggers that are assigned to a user pool to support custom workflows. If your user pool configuration does not include triggers, the ClientMetadata parameter serves no purpose. For more information, see [Customizing User Pool Workflows with Lambda Triggers](https://docs.aws.amazon.com/cognito/latest/developerguide/cognito-user-identity-pools-working-with-aws-lambda-triggers.html).
     */
    @JvmName("bppyncfyblcafngd")
    public suspend fun clientMetadata(`value`: Map<String, String>?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.clientMetadata = mapped
    }

    /**
     * @param values A map of custom key-value pairs that you can provide as input for any custom workflows that user creation triggers. Amazon Cognito does not store the `client_metadata` value. This data is available only to Lambda triggers that are assigned to a user pool to support custom workflows. If your user pool configuration does not include triggers, the ClientMetadata parameter serves no purpose. For more information, see [Customizing User Pool Workflows with Lambda Triggers](https://docs.aws.amazon.com/cognito/latest/developerguide/cognito-user-identity-pools-working-with-aws-lambda-triggers.html).
     */
    @JvmName("qqtabnijjjhyxeth")
    public fun clientMetadata(vararg values: Pair<String, String>) {
        val toBeMapped = values.toMap()
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.clientMetadata = mapped
    }

    /**
     * @param value A list of mediums to the welcome message will be sent through. Allowed values are `EMAIL` and `SMS`. If it's provided, make sure you have also specified `email` attribute for the `EMAIL` medium and `phone_number` for the `SMS`. More than one value can be specified. Amazon Cognito does not store the `desired_delivery_mediums` value. Defaults to `["SMS"]`.
     */
    @JvmName("rxwrctoqlklodpoc")
    public suspend fun desiredDeliveryMediums(`value`: List<String>?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.desiredDeliveryMediums = mapped
    }

    /**
     * @param values A list of mediums to the welcome message will be sent through. Allowed values are `EMAIL` and `SMS`. If it's provided, make sure you have also specified `email` attribute for the `EMAIL` medium and `phone_number` for the `SMS`. More than one value can be specified. Amazon Cognito does not store the `desired_delivery_mediums` value. Defaults to `["SMS"]`.
     */
    @JvmName("xctddhcdhscfqvet")
    public suspend fun desiredDeliveryMediums(vararg values: String) {
        val toBeMapped = values.toList()
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.desiredDeliveryMediums = mapped
    }

    /**
     * @param value Specifies whether the user should be enabled after creation. The welcome message will be sent regardless of the `enabled` value. The behavior can be changed with `message_action` argument. Defaults to `true`.
     */
    @JvmName("udybswglfyhayowg")
    public suspend fun enabled(`value`: Boolean?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.enabled = mapped
    }

    /**
     * @param value If this parameter is set to True and the `phone_number` or `email` address specified in the `attributes` parameter already exists as an alias with a different user, Amazon Cognito will migrate the alias from the previous user to the newly created user. The previous user will no longer be able to log in using that alias. Amazon Cognito does not store the `force_alias_creation` value. Defaults to `false`.
     */
    @JvmName("xthlulvpjmpgcdjf")
    public suspend fun forceAliasCreation(`value`: Boolean?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.forceAliasCreation = mapped
    }

    /**
     * @param value Set to `RESEND` to resend the invitation message to a user that already exists and reset the expiration limit on the user's account. Set to `SUPPRESS` to suppress sending the message. Only one value can be specified. Amazon Cognito does not store the `message_action` value.
     */
    @JvmName("sepdnnqahvlhdicl")
    public suspend fun messageAction(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.messageAction = mapped
    }

    /**
     * @param value The user's permanent password. This password must conform to the password policy specified by user pool the user belongs to. The welcome message always contains only `temporary_password` value. You can suppress sending the welcome message with the `message_action` argument. Amazon Cognito does not store the `password` value. Conflicts with `temporary_password`.
     */
    @JvmName("nywtabnqehitbckq")
    public suspend fun password(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.password = mapped
    }

    /**
     * @param value The user's temporary password. Conflicts with `password`.
     */
    @JvmName("hkjgibmymbjhkwbu")
    public suspend fun temporaryPassword(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.temporaryPassword = mapped
    }

    /**
     * @param value The user pool ID for the user pool where the user will be created.
     */
    @JvmName("evssjaqbmucmanyx")
    public suspend fun userPoolId(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.userPoolId = mapped
    }

    /**
     * @param value The username for the user. Must be unique within the user pool. Must be a UTF-8 string between 1 and 128 characters. After the user is created, the username cannot be changed.
     * The following arguments are optional:
     */
    @JvmName("sasuokagvvchaqlp")
    public suspend fun username(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.username = mapped
    }

    /**
     * @param value The user's validation data. This is an array of name-value pairs that contain user attributes and attribute values that you can use for custom validation, such as restricting the types of user accounts that can be registered. Amazon Cognito does not store the `validation_data` value. For more information, see [Customizing User Pool Workflows with Lambda Triggers](https://docs.aws.amazon.com/cognito/latest/developerguide/cognito-user-identity-pools-working-with-aws-lambda-triggers.html).
     * > **NOTE:** Clearing `password` or `temporary_password` does not reset user's password in Cognito.
     */
    @JvmName("hxelcnokbmdbrhdg")
    public suspend fun validationData(`value`: Map<String, String>?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.validationData = mapped
    }

    /**
     * @param values The user's validation data. This is an array of name-value pairs that contain user attributes and attribute values that you can use for custom validation, such as restricting the types of user accounts that can be registered. Amazon Cognito does not store the `validation_data` value. For more information, see [Customizing User Pool Workflows with Lambda Triggers](https://docs.aws.amazon.com/cognito/latest/developerguide/cognito-user-identity-pools-working-with-aws-lambda-triggers.html).
     * > **NOTE:** Clearing `password` or `temporary_password` does not reset user's password in Cognito.
     */
    @JvmName("ccrtepaiayccqyuo")
    public fun validationData(vararg values: Pair<String, String>) {
        val toBeMapped = values.toMap()
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.validationData = mapped
    }

    internal fun build(): UserArgs = UserArgs(
        attributes = attributes,
        clientMetadata = clientMetadata,
        desiredDeliveryMediums = desiredDeliveryMediums,
        enabled = enabled,
        forceAliasCreation = forceAliasCreation,
        messageAction = messageAction,
        password = password,
        temporaryPassword = temporaryPassword,
        userPoolId = userPoolId,
        username = username,
        validationData = validationData,
    )
}
