@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.aws.cognito.kotlin

import com.pulumi.core.Output
import com.pulumi.kotlin.KotlinCustomResource
import com.pulumi.kotlin.PulumiTagMarker
import com.pulumi.kotlin.ResourceMapper
import com.pulumi.kotlin.options.CustomResourceOptions
import com.pulumi.kotlin.options.CustomResourceOptionsBuilder
import com.pulumi.resources.Resource
import kotlin.Boolean
import kotlin.Int
import kotlin.String
import kotlin.Suppress
import kotlin.Unit

/**
 * Builder for [UserGroup].
 */
@PulumiTagMarker
public class UserGroupResourceBuilder internal constructor() {
    public var name: String? = null

    public var args: UserGroupArgs = UserGroupArgs()

    public var opts: CustomResourceOptions = CustomResourceOptions()

    /**
     * @param name The _unique_ name of the resulting resource.
     */
    public fun name(`value`: String) {
        this.name = value
    }

    /**
     * @param block The arguments to use to populate this resource's properties.
     */
    public suspend fun args(block: suspend UserGroupArgsBuilder.() -> Unit) {
        val builder = UserGroupArgsBuilder()
        block(builder)
        this.args = builder.build()
    }

    /**
     * @param block A bag of options that control this resource's behavior.
     */
    public suspend fun opts(block: suspend CustomResourceOptionsBuilder.() -> Unit) {
        this.opts = com.pulumi.kotlin.options.CustomResourceOptions.opts(block)
    }

    internal fun build(): UserGroup {
        val builtJavaResource = com.pulumi.aws.cognito.UserGroup(
            this.name,
            this.args.toJava(),
            this.opts.toJava(),
        )
        return UserGroup(builtJavaResource)
    }
}

/**
 * Provides a Cognito User Group resource.
 * ## Example Usage
 * <!--Start PulumiCodeChooser -->
 * ```typescript
 * import * as pulumi from "@pulumi/pulumi";
 * import * as aws from "@pulumi/aws";
 * const main = new aws.cognito.UserPool("main", {name: "identity pool"});
 * const groupRole = aws.iam.getPolicyDocument({
 *     statements: [{
 *         effect: "Allow",
 *         principals: [{
 *             type: "Federated",
 *             identifiers: ["cognito-identity&#46;amazonaws&#46;com"],
 *         }],
 *         actions: ["sts:AssumeRoleWithWebIdentity"],
 *         conditions: [
 *             {
 *                 test: "StringEquals",
 *                 variable: "cognito-identity.amazonaws.com:aud",
 *                 values: ["us-east-1:12345678-dead-beef-cafe-123456790ab"],
 *             },
 *             {
 *                 test: "ForAnyValue:StringLike",
 *                 variable: "cognito-identity.amazonaws.com:amr",
 *                 values: ["authenticated"],
 *             },
 *         ],
 *     }],
 * });
 * const groupRoleRole = new aws.iam.Role("group_role", {
 *     name: "user-group-role",
 *     assumeRolePolicy: groupRole.then(groupRole => groupRole.json),
 * });
 * const mainUserGroup = new aws.cognito.UserGroup("main", {
 *     name: "user-group",
 *     userPoolId: main.id,
 *     description: "Managed by Pulumi",
 *     precedence: 42,
 *     roleArn: groupRoleRole.arn,
 * });
 * ```
 * ```python
 * import pulumi
 * import pulumi_aws as aws
 * main = aws.cognito.UserPool("main", name="identity pool")
 * group_role = aws.iam.get_policy_document(statements=[{
 *     "effect": "Allow",
 *     "principals": [{
 *         "type": "Federated",
 *         "identifiers": ["cognito-identity&#46;amazonaws&#46;com"],
 *     }],
 *     "actions": ["sts:AssumeRoleWithWebIdentity"],
 *     "conditions": [
 *         {
 *             "test": "StringEquals",
 *             "variable": "cognito-identity.amazonaws.com:aud",
 *             "values": ["us-east-1:12345678-dead-beef-cafe-123456790ab"],
 *         },
 *         {
 *             "test": "ForAnyValue:StringLike",
 *             "variable": "cognito-identity.amazonaws.com:amr",
 *             "values": ["authenticated"],
 *         },
 *     ],
 * }])
 * group_role_role = aws.iam.Role("group_role",
 *     name="user-group-role",
 *     assume_role_policy=group_role.json)
 * main_user_group = aws.cognito.UserGroup("main",
 *     name="user-group",
 *     user_pool_id=main.id,
 *     description="Managed by Pulumi",
 *     precedence=42,
 *     role_arn=group_role_role.arn)
 * ```
 * ```csharp
 * using System.Collections.Generic;
 * using System.Linq;
 * using Pulumi;
 * using Aws = Pulumi.Aws;
 * return await Deployment.RunAsync(() =>
 * {
 *     var main = new Aws.Cognito.UserPool("main", new()
 *     {
 *         Name = "identity pool",
 *     });
 *     var groupRole = Aws.Iam.GetPolicyDocument.Invoke(new()
 *     {
 *         Statements = new[]
 *         {
 *             new Aws.Iam.Inputs.GetPolicyDocumentStatementInputArgs
 *             {
 *                 Effect = "Allow",
 *                 Principals = new[]
 *                 {
 *                     new Aws.Iam.Inputs.GetPolicyDocumentStatementPrincipalInputArgs
 *                     {
 *                         Type = "Federated",
 *                         Identifiers = new[]
 *                         {
 *                             "cognito-identity.amazonaws.com",
 *                         },
 *                     },
 *                 },
 *                 Actions = new[]
 *                 {
 *                     "sts:AssumeRoleWithWebIdentity",
 *                 },
 *                 Conditions = new[]
 *                 {
 *                     new Aws.Iam.Inputs.GetPolicyDocumentStatementConditionInputArgs
 *                     {
 *                         Test = "StringEquals",
 *                         Variable = "cognito-identity.amazonaws.com:aud",
 *                         Values = new[]
 *                         {
 *                             "us-east-1:12345678-dead-beef-cafe-123456790ab",
 *                         },
 *                     },
 *                     new Aws.Iam.Inputs.GetPolicyDocumentStatementConditionInputArgs
 *                     {
 *                         Test = "ForAnyValue:StringLike",
 *                         Variable = "cognito-identity.amazonaws.com:amr",
 *                         Values = new[]
 *                         {
 *                             "authenticated",
 *                         },
 *                     },
 *                 },
 *             },
 *         },
 *     });
 *     var groupRoleRole = new Aws.Iam.Role("group_role", new()
 *     {
 *         Name = "user-group-role",
 *         AssumeRolePolicy = groupRole.Apply(getPolicyDocumentResult => getPolicyDocumentResult.Json),
 *     });
 *     var mainUserGroup = new Aws.Cognito.UserGroup("main", new()
 *     {
 *         Name = "user-group",
 *         UserPoolId = main.Id,
 *         Description = "Managed by Pulumi",
 *         Precedence = 42,
 *         RoleArn = groupRoleRole.Arn,
 *     });
 * });
 * ```
 * ```go
 * package main
 * import (
 * 	"github.com/pulumi/pulumi-aws/sdk/v6/go/aws/cognito"
 * 	"github.com/pulumi/pulumi-aws/sdk/v6/go/aws/iam"
 * 	"github.com/pulumi/pulumi/sdk/v3/go/pulumi"
 * )
 * func main() {
 * 	pulumi.Run(func(ctx *pulumi.Context) error {
 * 		main, err := cognito.NewUserPool(ctx, "main", &cognito.UserPoolArgs{
 * 			Name: pulumi.String("identity pool"),
 * 		})
 * 		if err != nil {
 * 			return err
 * 		}
 * 		groupRole, err := iam.GetPolicyDocument(ctx, &iam.GetPolicyDocumentArgs{
 * 			Statements: []iam.GetPolicyDocumentStatement{
 * 				{
 * 					Effect: pulumi.StringRef("Allow"),
 * 					Principals: []iam.GetPolicyDocumentStatementPrincipal{
 * 						{
 * 							Type: "Federated",
 * 							Identifiers: []string{
 * 								"cognito-identity.amazonaws.com",
 * 							},
 * 						},
 * 					},
 * 					Actions: []string{
 * 						"sts:AssumeRoleWithWebIdentity",
 * 					},
 * 					Conditions: []iam.GetPolicyDocumentStatementCondition{
 * 						{
 * 							Test:     "StringEquals",
 * 							Variable: "cognito-identity.amazonaws.com:aud",
 * 							Values: []string{
 * 								"us-east-1:12345678-dead-beef-cafe-123456790ab",
 * 							},
 * 						},
 * 						{
 * 							Test:     "ForAnyValue:StringLike",
 * 							Variable: "cognito-identity.amazonaws.com:amr",
 * 							Values: []string{
 * 								"authenticated",
 * 							},
 * 						},
 * 					},
 * 				},
 * 			},
 * 		}, nil)
 * 		if err != nil {
 * 			return err
 * 		}
 * 		groupRoleRole, err := iam.NewRole(ctx, "group_role", &iam.RoleArgs{
 * 			Name:             pulumi.String("user-group-role"),
 * 			AssumeRolePolicy: pulumi.String(groupRole.Json),
 * 		})
 * 		if err != nil {
 * 			return err
 * 		}
 * 		_, err = cognito.NewUserGroup(ctx, "main", &cognito.UserGroupArgs{
 * 			Name:        pulumi.String("user-group"),
 * 			UserPoolId:  main.ID(),
 * 			Description: pulumi.String("Managed by Pulumi"),
 * 			Precedence:  pulumi.Int(42),
 * 			RoleArn:     groupRoleRole.Arn,
 * 		})
 * 		if err != nil {
 * 			return err
 * 		}
 * 		return nil
 * 	})
 * }
 * ```
 * ```java
 * package generated_program;
 * import com.pulumi.Context;
 * import com.pulumi.Pulumi;
 * import com.pulumi.core.Output;
 * import com.pulumi.aws.cognito.UserPool;
 * import com.pulumi.aws.cognito.UserPoolArgs;
 * import com.pulumi.aws.iam.IamFunctions;
 * import com.pulumi.aws.iam.inputs.GetPolicyDocumentArgs;
 * import com.pulumi.aws.iam.Role;
 * import com.pulumi.aws.iam.RoleArgs;
 * import com.pulumi.aws.cognito.UserGroup;
 * import com.pulumi.aws.cognito.UserGroupArgs;
 * import java.util.List;
 * import java.util.ArrayList;
 * import java.util.Map;
 * import java.io.File;
 * import java.nio.file.Files;
 * import java.nio.file.Paths;
 * public class App {
 *     public static void main(String[] args) {
 *         Pulumi.run(App::stack);
 *     }
 *     public static void stack(Context ctx) {
 *         var main = new UserPool("main", UserPoolArgs.builder()
 *             .name("identity pool")
 *             .build());
 *         final var groupRole = IamFunctions.getPolicyDocument(GetPolicyDocumentArgs.builder()
 *             .statements(GetPolicyDocumentStatementArgs.builder()
 *                 .effect("Allow")
 *                 .principals(GetPolicyDocumentStatementPrincipalArgs.builder()
 *                     .type("Federated")
 *                     .identifiers("cognito-identity.amazonaws.com")
 *                     .build())
 *                 .actions("sts:AssumeRoleWithWebIdentity")
 *                 .conditions(
 *                     GetPolicyDocumentStatementConditionArgs.builder()
 *                         .test("StringEquals")
 *                         .variable("cognito-identity.amazonaws.com:aud")
 *                         .values("us-east-1:12345678-dead-beef-cafe-123456790ab")
 *                         .build(),
 *                     GetPolicyDocumentStatementConditionArgs.builder()
 *                         .test("ForAnyValue:StringLike")
 *                         .variable("cognito-identity.amazonaws.com:amr")
 *                         .values("authenticated")
 *                         .build())
 *                 .build())
 *             .build());
 *         var groupRoleRole = new Role("groupRoleRole", RoleArgs.builder()
 *             .name("user-group-role")
 *             .assumeRolePolicy(groupRole.applyValue(getPolicyDocumentResult -> getPolicyDocumentResult.json()))
 *             .build());
 *         var mainUserGroup = new UserGroup("mainUserGroup", UserGroupArgs.builder()
 *             .name("user-group")
 *             .userPoolId(main.id())
 *             .description("Managed by Pulumi")
 *             .precedence(42)
 *             .roleArn(groupRoleRole.arn())
 *             .build());
 *     }
 * }
 * ```
 * ```yaml
 * resources:
 *   main:
 *     type: aws:cognito:UserPool
 *     properties:
 *       name: identity pool
 *   groupRoleRole:
 *     type: aws:iam:Role
 *     name: group_role
 *     properties:
 *       name: user-group-role
 *       assumeRolePolicy: ${groupRole.json}
 *   mainUserGroup:
 *     type: aws:cognito:UserGroup
 *     name: main
 *     properties:
 *       name: user-group
 *       userPoolId: ${main.id}
 *       description: Managed by Pulumi
 *       precedence: 42
 *       roleArn: ${groupRoleRole.arn}
 * variables:
 *   groupRole:
 *     fn::invoke:
 *       Function: aws:iam:getPolicyDocument
 *       Arguments:
 *         statements:
 *           - effect: Allow
 *             principals:
 *               - type: Federated
 *                 identifiers:
 *                   - cognito-identity.amazonaws.com
 *             actions:
 *               - sts:AssumeRoleWithWebIdentity
 *             conditions:
 *               - test: StringEquals
 *                 variable: cognito-identity.amazonaws.com:aud
 *                 values:
 *                   - us-east-1:12345678-dead-beef-cafe-123456790ab
 *               - test: ForAnyValue:StringLike
 *                 variable: cognito-identity.amazonaws.com:amr
 *                 values:
 *                   - authenticated
 * ```
 * <!--End PulumiCodeChooser -->
 * ## Import
 * Using `pulumi import`, import Cognito User Groups using the `user_pool_id`/`name` attributes concatenated. For example:
 * ```sh
 * $ pulumi import aws:cognito/userGroup:UserGroup group us-east-1_vG78M4goG/user-group
 * ```
 */
public class UserGroup internal constructor(
    override val javaResource: com.pulumi.aws.cognito.UserGroup,
) : KotlinCustomResource(javaResource, UserGroupMapper) {
    /**
     * The description of the user group.
     */
    public val description: Output<String>?
        get() = javaResource.description().applyValue({ args0 ->
            args0.map({ args0 ->
                args0
            }).orElse(null)
        })

    /**
     * The name of the user group.
     */
    public val name: Output<String>
        get() = javaResource.name().applyValue({ args0 -> args0 })

    /**
     * The precedence of the user group.
     */
    public val precedence: Output<Int>?
        get() = javaResource.precedence().applyValue({ args0 ->
            args0.map({ args0 ->
                args0
            }).orElse(null)
        })

    /**
     * The ARN of the IAM role to be associated with the user group.
     */
    public val roleArn: Output<String>?
        get() = javaResource.roleArn().applyValue({ args0 -> args0.map({ args0 -> args0 }).orElse(null) })

    /**
     * The user pool ID.
     */
    public val userPoolId: Output<String>
        get() = javaResource.userPoolId().applyValue({ args0 -> args0 })
}

public object UserGroupMapper : ResourceMapper<UserGroup> {
    override fun supportsMappingOfType(javaResource: Resource): Boolean =
        com.pulumi.aws.cognito.UserGroup::class == javaResource::class

    override fun map(javaResource: Resource): UserGroup = UserGroup(
        javaResource as
            com.pulumi.aws.cognito.UserGroup,
    )
}

/**
 * @see [UserGroup].
 * @param name The _unique_ name of the resulting resource.
 * @param block Builder for [UserGroup].
 */
public suspend fun userGroup(name: String, block: suspend UserGroupResourceBuilder.() -> Unit): UserGroup {
    val builder = UserGroupResourceBuilder()
    builder.name(name)
    block(builder)
    return builder.build()
}

/**
 * @see [UserGroup].
 * @param name The _unique_ name of the resulting resource.
 */
public fun userGroup(name: String): UserGroup {
    val builder = UserGroupResourceBuilder()
    builder.name(name)
    return builder.build()
}
