@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.aws.cognito.kotlin

import com.pulumi.aws.cognito.UserGroupArgs.builder
import com.pulumi.core.Output
import com.pulumi.core.Output.of
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiTagMarker
import kotlin.Int
import kotlin.String
import kotlin.Suppress
import kotlin.jvm.JvmName

/**
 * Provides a Cognito User Group resource.
 * ## Example Usage
 * <!--Start PulumiCodeChooser -->
 * ```typescript
 * import * as pulumi from "@pulumi/pulumi";
 * import * as aws from "@pulumi/aws";
 * const main = new aws.cognito.UserPool("main", {name: "identity pool"});
 * const groupRole = aws.iam.getPolicyDocument({
 *     statements: [{
 *         effect: "Allow",
 *         principals: [{
 *             type: "Federated",
 *             identifiers: ["cognito-identity&#46;amazonaws&#46;com"],
 *         }],
 *         actions: ["sts:AssumeRoleWithWebIdentity"],
 *         conditions: [
 *             {
 *                 test: "StringEquals",
 *                 variable: "cognito-identity.amazonaws.com:aud",
 *                 values: ["us-east-1:12345678-dead-beef-cafe-123456790ab"],
 *             },
 *             {
 *                 test: "ForAnyValue:StringLike",
 *                 variable: "cognito-identity.amazonaws.com:amr",
 *                 values: ["authenticated"],
 *             },
 *         ],
 *     }],
 * });
 * const groupRoleRole = new aws.iam.Role("group_role", {
 *     name: "user-group-role",
 *     assumeRolePolicy: groupRole.then(groupRole => groupRole.json),
 * });
 * const mainUserGroup = new aws.cognito.UserGroup("main", {
 *     name: "user-group",
 *     userPoolId: main.id,
 *     description: "Managed by Pulumi",
 *     precedence: 42,
 *     roleArn: groupRoleRole.arn,
 * });
 * ```
 * ```python
 * import pulumi
 * import pulumi_aws as aws
 * main = aws.cognito.UserPool("main", name="identity pool")
 * group_role = aws.iam.get_policy_document(statements=[{
 *     "effect": "Allow",
 *     "principals": [{
 *         "type": "Federated",
 *         "identifiers": ["cognito-identity&#46;amazonaws&#46;com"],
 *     }],
 *     "actions": ["sts:AssumeRoleWithWebIdentity"],
 *     "conditions": [
 *         {
 *             "test": "StringEquals",
 *             "variable": "cognito-identity.amazonaws.com:aud",
 *             "values": ["us-east-1:12345678-dead-beef-cafe-123456790ab"],
 *         },
 *         {
 *             "test": "ForAnyValue:StringLike",
 *             "variable": "cognito-identity.amazonaws.com:amr",
 *             "values": ["authenticated"],
 *         },
 *     ],
 * }])
 * group_role_role = aws.iam.Role("group_role",
 *     name="user-group-role",
 *     assume_role_policy=group_role.json)
 * main_user_group = aws.cognito.UserGroup("main",
 *     name="user-group",
 *     user_pool_id=main.id,
 *     description="Managed by Pulumi",
 *     precedence=42,
 *     role_arn=group_role_role.arn)
 * ```
 * ```csharp
 * using System.Collections.Generic;
 * using System.Linq;
 * using Pulumi;
 * using Aws = Pulumi.Aws;
 * return await Deployment.RunAsync(() =>
 * {
 *     var main = new Aws.Cognito.UserPool("main", new()
 *     {
 *         Name = "identity pool",
 *     });
 *     var groupRole = Aws.Iam.GetPolicyDocument.Invoke(new()
 *     {
 *         Statements = new[]
 *         {
 *             new Aws.Iam.Inputs.GetPolicyDocumentStatementInputArgs
 *             {
 *                 Effect = "Allow",
 *                 Principals = new[]
 *                 {
 *                     new Aws.Iam.Inputs.GetPolicyDocumentStatementPrincipalInputArgs
 *                     {
 *                         Type = "Federated",
 *                         Identifiers = new[]
 *                         {
 *                             "cognito-identity.amazonaws.com",
 *                         },
 *                     },
 *                 },
 *                 Actions = new[]
 *                 {
 *                     "sts:AssumeRoleWithWebIdentity",
 *                 },
 *                 Conditions = new[]
 *                 {
 *                     new Aws.Iam.Inputs.GetPolicyDocumentStatementConditionInputArgs
 *                     {
 *                         Test = "StringEquals",
 *                         Variable = "cognito-identity.amazonaws.com:aud",
 *                         Values = new[]
 *                         {
 *                             "us-east-1:12345678-dead-beef-cafe-123456790ab",
 *                         },
 *                     },
 *                     new Aws.Iam.Inputs.GetPolicyDocumentStatementConditionInputArgs
 *                     {
 *                         Test = "ForAnyValue:StringLike",
 *                         Variable = "cognito-identity.amazonaws.com:amr",
 *                         Values = new[]
 *                         {
 *                             "authenticated",
 *                         },
 *                     },
 *                 },
 *             },
 *         },
 *     });
 *     var groupRoleRole = new Aws.Iam.Role("group_role", new()
 *     {
 *         Name = "user-group-role",
 *         AssumeRolePolicy = groupRole.Apply(getPolicyDocumentResult => getPolicyDocumentResult.Json),
 *     });
 *     var mainUserGroup = new Aws.Cognito.UserGroup("main", new()
 *     {
 *         Name = "user-group",
 *         UserPoolId = main.Id,
 *         Description = "Managed by Pulumi",
 *         Precedence = 42,
 *         RoleArn = groupRoleRole.Arn,
 *     });
 * });
 * ```
 * ```go
 * package main
 * import (
 * 	"github.com/pulumi/pulumi-aws/sdk/v6/go/aws/cognito"
 * 	"github.com/pulumi/pulumi-aws/sdk/v6/go/aws/iam"
 * 	"github.com/pulumi/pulumi/sdk/v3/go/pulumi"
 * )
 * func main() {
 * 	pulumi.Run(func(ctx *pulumi.Context) error {
 * 		main, err := cognito.NewUserPool(ctx, "main", &cognito.UserPoolArgs{
 * 			Name: pulumi.String("identity pool"),
 * 		})
 * 		if err != nil {
 * 			return err
 * 		}
 * 		groupRole, err := iam.GetPolicyDocument(ctx, &iam.GetPolicyDocumentArgs{
 * 			Statements: []iam.GetPolicyDocumentStatement{
 * 				{
 * 					Effect: pulumi.StringRef("Allow"),
 * 					Principals: []iam.GetPolicyDocumentStatementPrincipal{
 * 						{
 * 							Type: "Federated",
 * 							Identifiers: []string{
 * 								"cognito-identity.amazonaws.com",
 * 							},
 * 						},
 * 					},
 * 					Actions: []string{
 * 						"sts:AssumeRoleWithWebIdentity",
 * 					},
 * 					Conditions: []iam.GetPolicyDocumentStatementCondition{
 * 						{
 * 							Test:     "StringEquals",
 * 							Variable: "cognito-identity.amazonaws.com:aud",
 * 							Values: []string{
 * 								"us-east-1:12345678-dead-beef-cafe-123456790ab",
 * 							},
 * 						},
 * 						{
 * 							Test:     "ForAnyValue:StringLike",
 * 							Variable: "cognito-identity.amazonaws.com:amr",
 * 							Values: []string{
 * 								"authenticated",
 * 							},
 * 						},
 * 					},
 * 				},
 * 			},
 * 		}, nil)
 * 		if err != nil {
 * 			return err
 * 		}
 * 		groupRoleRole, err := iam.NewRole(ctx, "group_role", &iam.RoleArgs{
 * 			Name:             pulumi.String("user-group-role"),
 * 			AssumeRolePolicy: pulumi.String(groupRole.Json),
 * 		})
 * 		if err != nil {
 * 			return err
 * 		}
 * 		_, err = cognito.NewUserGroup(ctx, "main", &cognito.UserGroupArgs{
 * 			Name:        pulumi.String("user-group"),
 * 			UserPoolId:  main.ID(),
 * 			Description: pulumi.String("Managed by Pulumi"),
 * 			Precedence:  pulumi.Int(42),
 * 			RoleArn:     groupRoleRole.Arn,
 * 		})
 * 		if err != nil {
 * 			return err
 * 		}
 * 		return nil
 * 	})
 * }
 * ```
 * ```java
 * package generated_program;
 * import com.pulumi.Context;
 * import com.pulumi.Pulumi;
 * import com.pulumi.core.Output;
 * import com.pulumi.aws.cognito.UserPool;
 * import com.pulumi.aws.cognito.UserPoolArgs;
 * import com.pulumi.aws.iam.IamFunctions;
 * import com.pulumi.aws.iam.inputs.GetPolicyDocumentArgs;
 * import com.pulumi.aws.iam.Role;
 * import com.pulumi.aws.iam.RoleArgs;
 * import com.pulumi.aws.cognito.UserGroup;
 * import com.pulumi.aws.cognito.UserGroupArgs;
 * import java.util.List;
 * import java.util.ArrayList;
 * import java.util.Map;
 * import java.io.File;
 * import java.nio.file.Files;
 * import java.nio.file.Paths;
 * public class App {
 *     public static void main(String[] args) {
 *         Pulumi.run(App::stack);
 *     }
 *     public static void stack(Context ctx) {
 *         var main = new UserPool("main", UserPoolArgs.builder()
 *             .name("identity pool")
 *             .build());
 *         final var groupRole = IamFunctions.getPolicyDocument(GetPolicyDocumentArgs.builder()
 *             .statements(GetPolicyDocumentStatementArgs.builder()
 *                 .effect("Allow")
 *                 .principals(GetPolicyDocumentStatementPrincipalArgs.builder()
 *                     .type("Federated")
 *                     .identifiers("cognito-identity.amazonaws.com")
 *                     .build())
 *                 .actions("sts:AssumeRoleWithWebIdentity")
 *                 .conditions(
 *                     GetPolicyDocumentStatementConditionArgs.builder()
 *                         .test("StringEquals")
 *                         .variable("cognito-identity.amazonaws.com:aud")
 *                         .values("us-east-1:12345678-dead-beef-cafe-123456790ab")
 *                         .build(),
 *                     GetPolicyDocumentStatementConditionArgs.builder()
 *                         .test("ForAnyValue:StringLike")
 *                         .variable("cognito-identity.amazonaws.com:amr")
 *                         .values("authenticated")
 *                         .build())
 *                 .build())
 *             .build());
 *         var groupRoleRole = new Role("groupRoleRole", RoleArgs.builder()
 *             .name("user-group-role")
 *             .assumeRolePolicy(groupRole.applyValue(getPolicyDocumentResult -> getPolicyDocumentResult.json()))
 *             .build());
 *         var mainUserGroup = new UserGroup("mainUserGroup", UserGroupArgs.builder()
 *             .name("user-group")
 *             .userPoolId(main.id())
 *             .description("Managed by Pulumi")
 *             .precedence(42)
 *             .roleArn(groupRoleRole.arn())
 *             .build());
 *     }
 * }
 * ```
 * ```yaml
 * resources:
 *   main:
 *     type: aws:cognito:UserPool
 *     properties:
 *       name: identity pool
 *   groupRoleRole:
 *     type: aws:iam:Role
 *     name: group_role
 *     properties:
 *       name: user-group-role
 *       assumeRolePolicy: ${groupRole.json}
 *   mainUserGroup:
 *     type: aws:cognito:UserGroup
 *     name: main
 *     properties:
 *       name: user-group
 *       userPoolId: ${main.id}
 *       description: Managed by Pulumi
 *       precedence: 42
 *       roleArn: ${groupRoleRole.arn}
 * variables:
 *   groupRole:
 *     fn::invoke:
 *       Function: aws:iam:getPolicyDocument
 *       Arguments:
 *         statements:
 *           - effect: Allow
 *             principals:
 *               - type: Federated
 *                 identifiers:
 *                   - cognito-identity.amazonaws.com
 *             actions:
 *               - sts:AssumeRoleWithWebIdentity
 *             conditions:
 *               - test: StringEquals
 *                 variable: cognito-identity.amazonaws.com:aud
 *                 values:
 *                   - us-east-1:12345678-dead-beef-cafe-123456790ab
 *               - test: ForAnyValue:StringLike
 *                 variable: cognito-identity.amazonaws.com:amr
 *                 values:
 *                   - authenticated
 * ```
 * <!--End PulumiCodeChooser -->
 * ## Import
 * Using `pulumi import`, import Cognito User Groups using the `user_pool_id`/`name` attributes concatenated. For example:
 * ```sh
 * $ pulumi import aws:cognito/userGroup:UserGroup group us-east-1_vG78M4goG/user-group
 * ```
 * @property description The description of the user group.
 * @property name The name of the user group.
 * @property precedence The precedence of the user group.
 * @property roleArn The ARN of the IAM role to be associated with the user group.
 * @property userPoolId The user pool ID.
 */
public data class UserGroupArgs(
    public val description: Output<String>? = null,
    public val name: Output<String>? = null,
    public val precedence: Output<Int>? = null,
    public val roleArn: Output<String>? = null,
    public val userPoolId: Output<String>? = null,
) : ConvertibleToJava<com.pulumi.aws.cognito.UserGroupArgs> {
    override fun toJava(): com.pulumi.aws.cognito.UserGroupArgs =
        com.pulumi.aws.cognito.UserGroupArgs.builder()
            .description(description?.applyValue({ args0 -> args0 }))
            .name(name?.applyValue({ args0 -> args0 }))
            .precedence(precedence?.applyValue({ args0 -> args0 }))
            .roleArn(roleArn?.applyValue({ args0 -> args0 }))
            .userPoolId(userPoolId?.applyValue({ args0 -> args0 })).build()
}

/**
 * Builder for [UserGroupArgs].
 */
@PulumiTagMarker
public class UserGroupArgsBuilder internal constructor() {
    private var description: Output<String>? = null

    private var name: Output<String>? = null

    private var precedence: Output<Int>? = null

    private var roleArn: Output<String>? = null

    private var userPoolId: Output<String>? = null

    /**
     * @param value The description of the user group.
     */
    @JvmName("myooxhfeiwccmden")
    public suspend fun description(`value`: Output<String>) {
        this.description = value
    }

    /**
     * @param value The name of the user group.
     */
    @JvmName("urxsukgoupgmypwb")
    public suspend fun name(`value`: Output<String>) {
        this.name = value
    }

    /**
     * @param value The precedence of the user group.
     */
    @JvmName("koflapofiwnviufg")
    public suspend fun precedence(`value`: Output<Int>) {
        this.precedence = value
    }

    /**
     * @param value The ARN of the IAM role to be associated with the user group.
     */
    @JvmName("bubjbglumalqrpjh")
    public suspend fun roleArn(`value`: Output<String>) {
        this.roleArn = value
    }

    /**
     * @param value The user pool ID.
     */
    @JvmName("whcpsypgfslxudbe")
    public suspend fun userPoolId(`value`: Output<String>) {
        this.userPoolId = value
    }

    /**
     * @param value The description of the user group.
     */
    @JvmName("enpycffivxoyqlwp")
    public suspend fun description(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.description = mapped
    }

    /**
     * @param value The name of the user group.
     */
    @JvmName("ymlwbknwxtuwkylo")
    public suspend fun name(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.name = mapped
    }

    /**
     * @param value The precedence of the user group.
     */
    @JvmName("vutullhorydxwbbh")
    public suspend fun precedence(`value`: Int?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.precedence = mapped
    }

    /**
     * @param value The ARN of the IAM role to be associated with the user group.
     */
    @JvmName("wnyyjjikmcdwqkjj")
    public suspend fun roleArn(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.roleArn = mapped
    }

    /**
     * @param value The user pool ID.
     */
    @JvmName("vhplrkdoisutqwgb")
    public suspend fun userPoolId(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.userPoolId = mapped
    }

    internal fun build(): UserGroupArgs = UserGroupArgs(
        description = description,
        name = name,
        precedence = precedence,
        roleArn = roleArn,
        userPoolId = userPoolId,
    )
}
