@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.aws.cognito.kotlin

import com.pulumi.aws.cognito.kotlin.outputs.UserPoolAccountRecoverySetting
import com.pulumi.aws.cognito.kotlin.outputs.UserPoolAdminCreateUserConfig
import com.pulumi.aws.cognito.kotlin.outputs.UserPoolDeviceConfiguration
import com.pulumi.aws.cognito.kotlin.outputs.UserPoolEmailConfiguration
import com.pulumi.aws.cognito.kotlin.outputs.UserPoolLambdaConfig
import com.pulumi.aws.cognito.kotlin.outputs.UserPoolPasswordPolicy
import com.pulumi.aws.cognito.kotlin.outputs.UserPoolSchema
import com.pulumi.aws.cognito.kotlin.outputs.UserPoolSmsConfiguration
import com.pulumi.aws.cognito.kotlin.outputs.UserPoolSoftwareTokenMfaConfiguration
import com.pulumi.aws.cognito.kotlin.outputs.UserPoolUserAttributeUpdateSettings
import com.pulumi.aws.cognito.kotlin.outputs.UserPoolUserPoolAddOns
import com.pulumi.aws.cognito.kotlin.outputs.UserPoolUsernameConfiguration
import com.pulumi.aws.cognito.kotlin.outputs.UserPoolVerificationMessageTemplate
import com.pulumi.core.Output
import com.pulumi.kotlin.KotlinCustomResource
import com.pulumi.kotlin.PulumiTagMarker
import com.pulumi.kotlin.ResourceMapper
import com.pulumi.kotlin.options.CustomResourceOptions
import com.pulumi.kotlin.options.CustomResourceOptionsBuilder
import com.pulumi.resources.Resource
import kotlin.Boolean
import kotlin.Deprecated
import kotlin.Int
import kotlin.String
import kotlin.Suppress
import kotlin.Unit
import kotlin.collections.List
import kotlin.collections.Map
import com.pulumi.aws.cognito.kotlin.outputs.UserPoolAccountRecoverySetting.Companion.toKotlin as userPoolAccountRecoverySettingToKotlin
import com.pulumi.aws.cognito.kotlin.outputs.UserPoolAdminCreateUserConfig.Companion.toKotlin as userPoolAdminCreateUserConfigToKotlin
import com.pulumi.aws.cognito.kotlin.outputs.UserPoolDeviceConfiguration.Companion.toKotlin as userPoolDeviceConfigurationToKotlin
import com.pulumi.aws.cognito.kotlin.outputs.UserPoolEmailConfiguration.Companion.toKotlin as userPoolEmailConfigurationToKotlin
import com.pulumi.aws.cognito.kotlin.outputs.UserPoolLambdaConfig.Companion.toKotlin as userPoolLambdaConfigToKotlin
import com.pulumi.aws.cognito.kotlin.outputs.UserPoolPasswordPolicy.Companion.toKotlin as userPoolPasswordPolicyToKotlin
import com.pulumi.aws.cognito.kotlin.outputs.UserPoolSchema.Companion.toKotlin as userPoolSchemaToKotlin
import com.pulumi.aws.cognito.kotlin.outputs.UserPoolSmsConfiguration.Companion.toKotlin as userPoolSmsConfigurationToKotlin
import com.pulumi.aws.cognito.kotlin.outputs.UserPoolSoftwareTokenMfaConfiguration.Companion.toKotlin as userPoolSoftwareTokenMfaConfigurationToKotlin
import com.pulumi.aws.cognito.kotlin.outputs.UserPoolUserAttributeUpdateSettings.Companion.toKotlin as userPoolUserAttributeUpdateSettingsToKotlin
import com.pulumi.aws.cognito.kotlin.outputs.UserPoolUserPoolAddOns.Companion.toKotlin as userPoolUserPoolAddOnsToKotlin
import com.pulumi.aws.cognito.kotlin.outputs.UserPoolUsernameConfiguration.Companion.toKotlin as userPoolUsernameConfigurationToKotlin
import com.pulumi.aws.cognito.kotlin.outputs.UserPoolVerificationMessageTemplate.Companion.toKotlin as userPoolVerificationMessageTemplateToKotlin

/**
 * Builder for [UserPool].
 */
@PulumiTagMarker
public class UserPoolResourceBuilder internal constructor() {
    public var name: String? = null

    public var args: UserPoolArgs = UserPoolArgs()

    public var opts: CustomResourceOptions = CustomResourceOptions()

    /**
     * @param name The _unique_ name of the resulting resource.
     */
    public fun name(`value`: String) {
        this.name = value
    }

    /**
     * @param block The arguments to use to populate this resource's properties.
     */
    public suspend fun args(block: suspend UserPoolArgsBuilder.() -> Unit) {
        val builder = UserPoolArgsBuilder()
        block(builder)
        this.args = builder.build()
    }

    /**
     * @param block A bag of options that control this resource's behavior.
     */
    public suspend fun opts(block: suspend CustomResourceOptionsBuilder.() -> Unit) {
        this.opts = com.pulumi.kotlin.options.CustomResourceOptions.opts(block)
    }

    internal fun build(): UserPool {
        val builtJavaResource = com.pulumi.aws.cognito.UserPool(
            this.name,
            this.args.toJava(),
            this.opts.toJava(),
        )
        return UserPool(builtJavaResource)
    }
}

/**
 * Provides a Cognito User Pool resource.
 * ## Example Usage
 * ### Basic configuration
 * <!--Start PulumiCodeChooser -->
 * ```typescript
 * import * as pulumi from "@pulumi/pulumi";
 * import * as aws from "@pulumi/aws";
 * const pool = new aws.cognito.UserPool("pool", {name: "mypool"});
 * ```
 * ```python
 * import pulumi
 * import pulumi_aws as aws
 * pool = aws.cognito.UserPool("pool", name="mypool")
 * ```
 * ```csharp
 * using System.Collections.Generic;
 * using System.Linq;
 * using Pulumi;
 * using Aws = Pulumi.Aws;
 * return await Deployment.RunAsync(() =>
 * {
 *     var pool = new Aws.Cognito.UserPool("pool", new()
 *     {
 *         Name = "mypool",
 *     });
 * });
 * ```
 * ```go
 * package main
 * import (
 * 	"github.com/pulumi/pulumi-aws/sdk/v6/go/aws/cognito"
 * 	"github.com/pulumi/pulumi/sdk/v3/go/pulumi"
 * )
 * func main() {
 * 	pulumi.Run(func(ctx *pulumi.Context) error {
 * 		_, err := cognito.NewUserPool(ctx, "pool", &cognito.UserPoolArgs{
 * 			Name: pulumi.String("mypool"),
 * 		})
 * 		if err != nil {
 * 			return err
 * 		}
 * 		return nil
 * 	})
 * }
 * ```
 * ```java
 * package generated_program;
 * import com.pulumi.Context;
 * import com.pulumi.Pulumi;
 * import com.pulumi.core.Output;
 * import com.pulumi.aws.cognito.UserPool;
 * import com.pulumi.aws.cognito.UserPoolArgs;
 * import java.util.List;
 * import java.util.ArrayList;
 * import java.util.Map;
 * import java.io.File;
 * import java.nio.file.Files;
 * import java.nio.file.Paths;
 * public class App {
 *     public static void main(String[] args) {
 *         Pulumi.run(App::stack);
 *     }
 *     public static void stack(Context ctx) {
 *         var pool = new UserPool("pool", UserPoolArgs.builder()
 *             .name("mypool")
 *             .build());
 *     }
 * }
 * ```
 * ```yaml
 * resources:
 *   pool:
 *     type: aws:cognito:UserPool
 *     properties:
 *       name: mypool
 * ```
 * <!--End PulumiCodeChooser -->
 * ### Enabling SMS and Software Token Multi-Factor Authentication
 * <!--Start PulumiCodeChooser -->
 * ```typescript
 * import * as pulumi from "@pulumi/pulumi";
 * import * as aws from "@pulumi/aws";
 * const example = new aws.cognito.UserPool("example", {
 *     mfaConfiguration: "ON",
 *     smsAuthenticationMessage: "Your code is {####}",
 *     smsConfiguration: {
 *         externalId: "example",
 *         snsCallerArn: exampleAwsIamRole.arn,
 *         snsRegion: "us-east-1",
 *     },
 *     softwareTokenMfaConfiguration: {
 *         enabled: true,
 *     },
 * });
 * ```
 * ```python
 * import pulumi
 * import pulumi_aws as aws
 * example = aws.cognito.UserPool("example",
 *     mfa_configuration="ON",
 *     sms_authentication_message="Your code is {####}",
 *     sms_configuration={
 *         "external_id": "example",
 *         "sns_caller_arn": example_aws_iam_role["arn"],
 *         "sns_region": "us-east-1",
 *     },
 *     software_token_mfa_configuration={
 *         "enabled": True,
 *     })
 * ```
 * ```csharp
 * using System.Collections.Generic;
 * using System.Linq;
 * using Pulumi;
 * using Aws = Pulumi.Aws;
 * return await Deployment.RunAsync(() =>
 * {
 *     var example = new Aws.Cognito.UserPool("example", new()
 *     {
 *         MfaConfiguration = "ON",
 *         SmsAuthenticationMessage = "Your code is {####}",
 *         SmsConfiguration = new Aws.Cognito.Inputs.UserPoolSmsConfigurationArgs
 *         {
 *             ExternalId = "example",
 *             SnsCallerArn = exampleAwsIamRole.Arn,
 *             SnsRegion = "us-east-1",
 *         },
 *         SoftwareTokenMfaConfiguration = new Aws.Cognito.Inputs.UserPoolSoftwareTokenMfaConfigurationArgs
 *         {
 *             Enabled = true,
 *         },
 *     });
 * });
 * ```
 * ```go
 * package main
 * import (
 * 	"github.com/pulumi/pulumi-aws/sdk/v6/go/aws/cognito"
 * 	"github.com/pulumi/pulumi/sdk/v3/go/pulumi"
 * )
 * func main() {
 * 	pulumi.Run(func(ctx *pulumi.Context) error {
 * 		_, err := cognito.NewUserPool(ctx, "example", &cognito.UserPoolArgs{
 * 			MfaConfiguration:         pulumi.String("ON"),
 * 			SmsAuthenticationMessage: pulumi.String("Your code is {####}"),
 * 			SmsConfiguration: &cognito.UserPoolSmsConfigurationArgs{
 * 				ExternalId:   pulumi.String("example"),
 * 				SnsCallerArn: pulumi.Any(exampleAwsIamRole.Arn),
 * 				SnsRegion:    pulumi.String("us-east-1"),
 * 			},
 * 			SoftwareTokenMfaConfiguration: &cognito.UserPoolSoftwareTokenMfaConfigurationArgs{
 * 				Enabled: pulumi.Bool(true),
 * 			},
 * 		})
 * 		if err != nil {
 * 			return err
 * 		}
 * 		return nil
 * 	})
 * }
 * ```
 * ```java
 * package generated_program;
 * import com.pulumi.Context;
 * import com.pulumi.Pulumi;
 * import com.pulumi.core.Output;
 * import com.pulumi.aws.cognito.UserPool;
 * import com.pulumi.aws.cognito.UserPoolArgs;
 * import com.pulumi.aws.cognito.inputs.UserPoolSmsConfigurationArgs;
 * import com.pulumi.aws.cognito.inputs.UserPoolSoftwareTokenMfaConfigurationArgs;
 * import java.util.List;
 * import java.util.ArrayList;
 * import java.util.Map;
 * import java.io.File;
 * import java.nio.file.Files;
 * import java.nio.file.Paths;
 * public class App {
 *     public static void main(String[] args) {
 *         Pulumi.run(App::stack);
 *     }
 *     public static void stack(Context ctx) {
 *         var example = new UserPool("example", UserPoolArgs.builder()
 *             .mfaConfiguration("ON")
 *             .smsAuthenticationMessage("Your code is {####}")
 *             .smsConfiguration(UserPoolSmsConfigurationArgs.builder()
 *                 .externalId("example")
 *                 .snsCallerArn(exampleAwsIamRole.arn())
 *                 .snsRegion("us-east-1")
 *                 .build())
 *             .softwareTokenMfaConfiguration(UserPoolSoftwareTokenMfaConfigurationArgs.builder()
 *                 .enabled(true)
 *                 .build())
 *             .build());
 *     }
 * }
 * ```
 * ```yaml
 * resources:
 *   example:
 *     type: aws:cognito:UserPool
 *     properties:
 *       mfaConfiguration: ON
 *       smsAuthenticationMessage: Your code is {####}
 *       smsConfiguration:
 *         externalId: example
 *         snsCallerArn: ${exampleAwsIamRole.arn}
 *         snsRegion: us-east-1
 *       softwareTokenMfaConfiguration:
 *         enabled: true
 * ```
 * <!--End PulumiCodeChooser -->
 * ### Using Account Recovery Setting
 * <!--Start PulumiCodeChooser -->
 * ```typescript
 * import * as pulumi from "@pulumi/pulumi";
 * import * as aws from "@pulumi/aws";
 * const test = new aws.cognito.UserPool("test", {
 *     name: "mypool",
 *     accountRecoverySetting: {
 *         recoveryMechanisms: [
 *             {
 *                 name: "verified_email",
 *                 priority: 1,
 *             },
 *             {
 *                 name: "verified_phone_number",
 *                 priority: 2,
 *             },
 *         ],
 *     },
 * });
 * ```
 * ```python
 * import pulumi
 * import pulumi_aws as aws
 * test = aws.cognito.UserPool("test",
 *     name="mypool",
 *     account_recovery_setting={
 *         "recovery_mechanisms": [
 *             {
 *                 "name": "verified_email",
 *                 "priority": 1,
 *             },
 *             {
 *                 "name": "verified_phone_number",
 *                 "priority": 2,
 *             },
 *         ],
 *     })
 * ```
 * ```csharp
 * using System.Collections.Generic;
 * using System.Linq;
 * using Pulumi;
 * using Aws = Pulumi.Aws;
 * return await Deployment.RunAsync(() =>
 * {
 *     var test = new Aws.Cognito.UserPool("test", new()
 *     {
 *         Name = "mypool",
 *         AccountRecoverySetting = new Aws.Cognito.Inputs.UserPoolAccountRecoverySettingArgs
 *         {
 *             RecoveryMechanisms = new[]
 *             {
 *                 new Aws.Cognito.Inputs.UserPoolAccountRecoverySettingRecoveryMechanismArgs
 *                 {
 *                     Name = "verified_email",
 *                     Priority = 1,
 *                 },
 *                 new Aws.Cognito.Inputs.UserPoolAccountRecoverySettingRecoveryMechanismArgs
 *                 {
 *                     Name = "verified_phone_number",
 *                     Priority = 2,
 *                 },
 *             },
 *         },
 *     });
 * });
 * ```
 * ```go
 * package main
 * import (
 * 	"github.com/pulumi/pulumi-aws/sdk/v6/go/aws/cognito"
 * 	"github.com/pulumi/pulumi/sdk/v3/go/pulumi"
 * )
 * func main() {
 * 	pulumi.Run(func(ctx *pulumi.Context) error {
 * 		_, err := cognito.NewUserPool(ctx, "test", &cognito.UserPoolArgs{
 * 			Name: pulumi.String("mypool"),
 * 			AccountRecoverySetting: &cognito.UserPoolAccountRecoverySettingArgs{
 * 				RecoveryMechanisms: cognito.UserPoolAccountRecoverySettingRecoveryMechanismArray{
 * 					&cognito.UserPoolAccountRecoverySettingRecoveryMechanismArgs{
 * 						Name:     pulumi.String("verified_email"),
 * 						Priority: pulumi.Int(1),
 * 					},
 * 					&cognito.UserPoolAccountRecoverySettingRecoveryMechanismArgs{
 * 						Name:     pulumi.String("verified_phone_number"),
 * 						Priority: pulumi.Int(2),
 * 					},
 * 				},
 * 			},
 * 		})
 * 		if err != nil {
 * 			return err
 * 		}
 * 		return nil
 * 	})
 * }
 * ```
 * ```java
 * package generated_program;
 * import com.pulumi.Context;
 * import com.pulumi.Pulumi;
 * import com.pulumi.core.Output;
 * import com.pulumi.aws.cognito.UserPool;
 * import com.pulumi.aws.cognito.UserPoolArgs;
 * import com.pulumi.aws.cognito.inputs.UserPoolAccountRecoverySettingArgs;
 * import java.util.List;
 * import java.util.ArrayList;
 * import java.util.Map;
 * import java.io.File;
 * import java.nio.file.Files;
 * import java.nio.file.Paths;
 * public class App {
 *     public static void main(String[] args) {
 *         Pulumi.run(App::stack);
 *     }
 *     public static void stack(Context ctx) {
 *         var test = new UserPool("test", UserPoolArgs.builder()
 *             .name("mypool")
 *             .accountRecoverySetting(UserPoolAccountRecoverySettingArgs.builder()
 *                 .recoveryMechanisms(
 *                     UserPoolAccountRecoverySettingRecoveryMechanismArgs.builder()
 *                         .name("verified_email")
 *                         .priority(1)
 *                         .build(),
 *                     UserPoolAccountRecoverySettingRecoveryMechanismArgs.builder()
 *                         .name("verified_phone_number")
 *                         .priority(2)
 *                         .build())
 *                 .build())
 *             .build());
 *     }
 * }
 * ```
 * ```yaml
 * resources:
 *   test:
 *     type: aws:cognito:UserPool
 *     properties:
 *       name: mypool
 *       accountRecoverySetting:
 *         recoveryMechanisms:
 *           - name: verified_email
 *             priority: 1
 *           - name: verified_phone_number
 *             priority: 2
 * ```
 * <!--End PulumiCodeChooser -->
 * ## Import
 * Using `pulumi import`, import Cognito User Pools using the `id`. For example:
 * ```sh
 * $ pulumi import aws:cognito/userPool:UserPool pool us-west-2_abc123
 * ```
 */
public class UserPool internal constructor(
    override val javaResource: com.pulumi.aws.cognito.UserPool,
) : KotlinCustomResource(javaResource, UserPoolMapper) {
    /**
     * Configuration block to define which verified available method a user can use to recover their forgotten password. Detailed below.
     */
    public val accountRecoverySetting: Output<UserPoolAccountRecoverySetting>?
        get() = javaResource.accountRecoverySetting().applyValue({ args0 ->
            args0.map({ args0 ->
                args0.let({ args0 -> userPoolAccountRecoverySettingToKotlin(args0) })
            }).orElse(null)
        })

    /**
     * Configuration block for creating a new user profile. Detailed below.
     */
    public val adminCreateUserConfig: Output<UserPoolAdminCreateUserConfig>
        get() = javaResource.adminCreateUserConfig().applyValue({ args0 ->
            args0.let({ args0 ->
                userPoolAdminCreateUserConfigToKotlin(args0)
            })
        })

    /**
     * Attributes supported as an alias for this user pool. Valid values: `phone_number`, `email`, or `preferred_username`. Conflicts with `username_attributes`.
     */
    public val aliasAttributes: Output<List<String>>?
        get() = javaResource.aliasAttributes().applyValue({ args0 ->
            args0.map({ args0 ->
                args0.map({ args0 -> args0 })
            }).orElse(null)
        })

    /**
     * ARN of the user pool.
     */
    public val arn: Output<String>
        get() = javaResource.arn().applyValue({ args0 -> args0 })

    /**
     * Attributes to be auto-verified. Valid values: `email`, `phone_number`.
     */
    public val autoVerifiedAttributes: Output<List<String>>?
        get() = javaResource.autoVerifiedAttributes().applyValue({ args0 ->
            args0.map({ args0 ->
                args0.map({ args0 -> args0 })
            }).orElse(null)
        })

    /**
     * Date the user pool was created.
     */
    public val creationDate: Output<String>
        get() = javaResource.creationDate().applyValue({ args0 -> args0 })

    /**
     * A custom domain name that you provide to Amazon Cognito. This parameter applies only if you use a custom domain to host the sign-up and sign-in pages for your application. For example: `auth.example.com`.
     */
    public val customDomain: Output<String>
        get() = javaResource.customDomain().applyValue({ args0 -> args0 })

    /**
     * When active, DeletionProtection prevents accidental deletion of your user pool. Before you can delete a user pool that you have protected against deletion, you must deactivate this feature. Valid values are `ACTIVE` and `INACTIVE`, Default value is `INACTIVE`.
     */
    public val deletionProtection: Output<String>?
        get() = javaResource.deletionProtection().applyValue({ args0 ->
            args0.map({ args0 ->
                args0
            }).orElse(null)
        })

    /**
     * Configuration block for the user pool's device tracking. Detailed below.
     */
    public val deviceConfiguration: Output<UserPoolDeviceConfiguration>?
        get() = javaResource.deviceConfiguration().applyValue({ args0 ->
            args0.map({ args0 ->
                args0.let({ args0 -> userPoolDeviceConfigurationToKotlin(args0) })
            }).orElse(null)
        })

    /**
     * Holds the domain prefix if the user pool has a domain associated with it.
     */
    public val domain: Output<String>
        get() = javaResource.domain().applyValue({ args0 -> args0 })

    /**
     * Configuration block for configuring email. Detailed below.
     */
    public val emailConfiguration: Output<UserPoolEmailConfiguration>?
        get() = javaResource.emailConfiguration().applyValue({ args0 ->
            args0.map({ args0 ->
                args0.let({ args0 -> userPoolEmailConfigurationToKotlin(args0) })
            }).orElse(null)
        })

    /**
     * String representing the email verification message. Conflicts with `verification_message_template` configuration block `email_message` argument.
     */
    public val emailVerificationMessage: Output<String>
        get() = javaResource.emailVerificationMessage().applyValue({ args0 -> args0 })

    /**
     * String representing the email verification subject. Conflicts with `verification_message_template` configuration block `email_subject` argument.
     */
    public val emailVerificationSubject: Output<String>
        get() = javaResource.emailVerificationSubject().applyValue({ args0 -> args0 })

    /**
     * Endpoint name of the user pool. Example format: `cognito-idp.REGION.amazonaws.com/xxxx_yyyyy`
     */
    public val endpoint: Output<String>
        get() = javaResource.endpoint().applyValue({ args0 -> args0 })

    /**
     * A number estimating the size of the user pool.
     */
    public val estimatedNumberOfUsers: Output<Int>
        get() = javaResource.estimatedNumberOfUsers().applyValue({ args0 -> args0 })

    /**
     * Configuration block for the AWS Lambda triggers associated with the user pool. Detailed below.
     */
    public val lambdaConfig: Output<UserPoolLambdaConfig>?
        get() = javaResource.lambdaConfig().applyValue({ args0 ->
            args0.map({ args0 ->
                args0.let({ args0 ->
                    userPoolLambdaConfigToKotlin(args0)
                })
            }).orElse(null)
        })

    /**
     * Date the user pool was last modified.
     */
    public val lastModifiedDate: Output<String>
        get() = javaResource.lastModifiedDate().applyValue({ args0 -> args0 })

    /**
     * Multi-Factor Authentication (MFA) configuration for the User Pool. Defaults of `OFF`. Valid values are `OFF` (MFA Tokens are not required), `ON` (MFA is required for all users to sign in; requires at least one of `sms_configuration` or `software_token_mfa_configuration` to be configured), or `OPTIONAL` (MFA Will be required only for individual users who have MFA Enabled; requires at least one of `sms_configuration` or `software_token_mfa_configuration` to be configured).
     */
    public val mfaConfiguration: Output<String>?
        get() = javaResource.mfaConfiguration().applyValue({ args0 ->
            args0.map({ args0 ->
                args0
            }).orElse(null)
        })

    /**
     * Name of the user pool.
     * The following arguments are optional:
     */
    public val name: Output<String>
        get() = javaResource.name().applyValue({ args0 -> args0 })

    /**
     * Configuration block for information about the user pool password policy. Detailed below.
     */
    public val passwordPolicy: Output<UserPoolPasswordPolicy>
        get() = javaResource.passwordPolicy().applyValue({ args0 ->
            args0.let({ args0 ->
                userPoolPasswordPolicyToKotlin(args0)
            })
        })

    /**
     * Configuration block for the schema attributes of a user pool. Detailed below. Schema attributes from the [standard attribute set](https://docs.aws.amazon.com/cognito/latest/developerguide/user-pool-settings-attributes.html#cognito-user-pools-standard-attributes) only need to be specified if they are different from the default configuration. Attributes can be added, but not modified or removed. Maximum of 50 attributes.
     */
    public val schemas: Output<List<UserPoolSchema>>?
        get() = javaResource.schemas().applyValue({ args0 ->
            args0.map({ args0 ->
                args0.map({ args0 ->
                    args0.let({ args0 -> userPoolSchemaToKotlin(args0) })
                })
            }).orElse(null)
        })

    /**
     * String representing the SMS authentication message. The Message must contain the `{####}` placeholder, which will be replaced with the code.
     */
    public val smsAuthenticationMessage: Output<String>?
        get() = javaResource.smsAuthenticationMessage().applyValue({ args0 ->
            args0.map({ args0 ->
                args0
            }).orElse(null)
        })

    /**
     * Configuration block for Short Message Service (SMS) settings. Detailed below. These settings apply to SMS user verification and SMS Multi-Factor Authentication (MFA). Due to Cognito API restrictions, the SMS configuration cannot be removed without recreating the Cognito User Pool. For user data safety, this resource will ignore the removal of this configuration by disabling drift detection. To force resource recreation after this configuration has been applied, see the `taint` command.
     */
    public val smsConfiguration: Output<UserPoolSmsConfiguration>
        get() = javaResource.smsConfiguration().applyValue({ args0 ->
            args0.let({ args0 ->
                userPoolSmsConfigurationToKotlin(args0)
            })
        })

    /**
     * String representing the SMS verification message. Conflicts with `verification_message_template` configuration block `sms_message` argument.
     */
    public val smsVerificationMessage: Output<String>
        get() = javaResource.smsVerificationMessage().applyValue({ args0 -> args0 })

    /**
     * Configuration block for software token Mult-Factor Authentication (MFA) settings. Detailed below.
     */
    public val softwareTokenMfaConfiguration: Output<UserPoolSoftwareTokenMfaConfiguration>?
        get() = javaResource.softwareTokenMfaConfiguration().applyValue({ args0 ->
            args0.map({ args0 ->
                args0.let({ args0 -> userPoolSoftwareTokenMfaConfigurationToKotlin(args0) })
            }).orElse(null)
        })

    /**
     * Map of tags to assign to the User Pool. If configured with a provider `default_tags` configuration block present, tags with matching keys will overwrite those defined at the provider-level.
     */
    public val tags: Output<Map<String, String>>?
        get() = javaResource.tags().applyValue({ args0 ->
            args0.map({ args0 ->
                args0.map({ args0 ->
                    args0.key.to(args0.value)
                }).toMap()
            }).orElse(null)
        })

    /**
     * A map of tags assigned to the resource, including those inherited from the provider `default_tags` configuration block.
     */
    @Deprecated(
        message = """
  Please use `tags` instead.
  """,
    )
    public val tagsAll: Output<Map<String, String>>
        get() = javaResource.tagsAll().applyValue({ args0 ->
            args0.map({ args0 ->
                args0.key.to(args0.value)
            }).toMap()
        })

    /**
     * Configuration block for user attribute update settings. Detailed below.
     */
    public val userAttributeUpdateSettings: Output<UserPoolUserAttributeUpdateSettings>?
        get() = javaResource.userAttributeUpdateSettings().applyValue({ args0 ->
            args0.map({ args0 ->
                args0.let({ args0 -> userPoolUserAttributeUpdateSettingsToKotlin(args0) })
            }).orElse(null)
        })

    /**
     * Configuration block for user pool add-ons to enable user pool advanced security mode features. Detailed below.
     */
    public val userPoolAddOns: Output<UserPoolUserPoolAddOns>?
        get() = javaResource.userPoolAddOns().applyValue({ args0 ->
            args0.map({ args0 ->
                args0.let({ args0 -> userPoolUserPoolAddOnsToKotlin(args0) })
            }).orElse(null)
        })

    /**
     * Whether email addresses or phone numbers can be specified as usernames when a user signs up. Conflicts with `alias_attributes`.
     */
    public val usernameAttributes: Output<List<String>>?
        get() = javaResource.usernameAttributes().applyValue({ args0 ->
            args0.map({ args0 ->
                args0.map({ args0 -> args0 })
            }).orElse(null)
        })

    /**
     * Configuration block for username configuration. Detailed below.
     */
    public val usernameConfiguration: Output<UserPoolUsernameConfiguration>?
        get() = javaResource.usernameConfiguration().applyValue({ args0 ->
            args0.map({ args0 ->
                args0.let({ args0 -> userPoolUsernameConfigurationToKotlin(args0) })
            }).orElse(null)
        })

    /**
     * Configuration block for verification message templates. Detailed below.
     */
    public val verificationMessageTemplate: Output<UserPoolVerificationMessageTemplate>
        get() = javaResource.verificationMessageTemplate().applyValue({ args0 ->
            args0.let({ args0 ->
                userPoolVerificationMessageTemplateToKotlin(args0)
            })
        })
}

public object UserPoolMapper : ResourceMapper<UserPool> {
    override fun supportsMappingOfType(javaResource: Resource): Boolean =
        com.pulumi.aws.cognito.UserPool::class == javaResource::class

    override fun map(javaResource: Resource): UserPool = UserPool(
        javaResource as
            com.pulumi.aws.cognito.UserPool,
    )
}

/**
 * @see [UserPool].
 * @param name The _unique_ name of the resulting resource.
 * @param block Builder for [UserPool].
 */
public suspend fun userPool(name: String, block: suspend UserPoolResourceBuilder.() -> Unit): UserPool {
    val builder = UserPoolResourceBuilder()
    builder.name(name)
    block(builder)
    return builder.build()
}

/**
 * @see [UserPool].
 * @param name The _unique_ name of the resulting resource.
 */
public fun userPool(name: String): UserPool {
    val builder = UserPoolResourceBuilder()
    builder.name(name)
    return builder.build()
}
