@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.aws.cognito.kotlin

import com.pulumi.aws.cognito.UserPoolArgs.builder
import com.pulumi.aws.cognito.kotlin.inputs.UserPoolAccountRecoverySettingArgs
import com.pulumi.aws.cognito.kotlin.inputs.UserPoolAccountRecoverySettingArgsBuilder
import com.pulumi.aws.cognito.kotlin.inputs.UserPoolAdminCreateUserConfigArgs
import com.pulumi.aws.cognito.kotlin.inputs.UserPoolAdminCreateUserConfigArgsBuilder
import com.pulumi.aws.cognito.kotlin.inputs.UserPoolDeviceConfigurationArgs
import com.pulumi.aws.cognito.kotlin.inputs.UserPoolDeviceConfigurationArgsBuilder
import com.pulumi.aws.cognito.kotlin.inputs.UserPoolEmailConfigurationArgs
import com.pulumi.aws.cognito.kotlin.inputs.UserPoolEmailConfigurationArgsBuilder
import com.pulumi.aws.cognito.kotlin.inputs.UserPoolLambdaConfigArgs
import com.pulumi.aws.cognito.kotlin.inputs.UserPoolLambdaConfigArgsBuilder
import com.pulumi.aws.cognito.kotlin.inputs.UserPoolPasswordPolicyArgs
import com.pulumi.aws.cognito.kotlin.inputs.UserPoolPasswordPolicyArgsBuilder
import com.pulumi.aws.cognito.kotlin.inputs.UserPoolSchemaArgs
import com.pulumi.aws.cognito.kotlin.inputs.UserPoolSchemaArgsBuilder
import com.pulumi.aws.cognito.kotlin.inputs.UserPoolSmsConfigurationArgs
import com.pulumi.aws.cognito.kotlin.inputs.UserPoolSmsConfigurationArgsBuilder
import com.pulumi.aws.cognito.kotlin.inputs.UserPoolSoftwareTokenMfaConfigurationArgs
import com.pulumi.aws.cognito.kotlin.inputs.UserPoolSoftwareTokenMfaConfigurationArgsBuilder
import com.pulumi.aws.cognito.kotlin.inputs.UserPoolUserAttributeUpdateSettingsArgs
import com.pulumi.aws.cognito.kotlin.inputs.UserPoolUserAttributeUpdateSettingsArgsBuilder
import com.pulumi.aws.cognito.kotlin.inputs.UserPoolUserPoolAddOnsArgs
import com.pulumi.aws.cognito.kotlin.inputs.UserPoolUserPoolAddOnsArgsBuilder
import com.pulumi.aws.cognito.kotlin.inputs.UserPoolUsernameConfigurationArgs
import com.pulumi.aws.cognito.kotlin.inputs.UserPoolUsernameConfigurationArgsBuilder
import com.pulumi.aws.cognito.kotlin.inputs.UserPoolVerificationMessageTemplateArgs
import com.pulumi.aws.cognito.kotlin.inputs.UserPoolVerificationMessageTemplateArgsBuilder
import com.pulumi.core.Output
import com.pulumi.core.Output.of
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiTagMarker
import com.pulumi.kotlin.applySuspend
import kotlin.Pair
import kotlin.String
import kotlin.Suppress
import kotlin.Unit
import kotlin.collections.List
import kotlin.collections.Map
import kotlin.jvm.JvmName

/**
 * Provides a Cognito User Pool resource.
 * ## Example Usage
 * ### Basic configuration
 * <!--Start PulumiCodeChooser -->
 * ```typescript
 * import * as pulumi from "@pulumi/pulumi";
 * import * as aws from "@pulumi/aws";
 * const pool = new aws.cognito.UserPool("pool", {name: "mypool"});
 * ```
 * ```python
 * import pulumi
 * import pulumi_aws as aws
 * pool = aws.cognito.UserPool("pool", name="mypool")
 * ```
 * ```csharp
 * using System.Collections.Generic;
 * using System.Linq;
 * using Pulumi;
 * using Aws = Pulumi.Aws;
 * return await Deployment.RunAsync(() =>
 * {
 *     var pool = new Aws.Cognito.UserPool("pool", new()
 *     {
 *         Name = "mypool",
 *     });
 * });
 * ```
 * ```go
 * package main
 * import (
 * 	"github.com/pulumi/pulumi-aws/sdk/v6/go/aws/cognito"
 * 	"github.com/pulumi/pulumi/sdk/v3/go/pulumi"
 * )
 * func main() {
 * 	pulumi.Run(func(ctx *pulumi.Context) error {
 * 		_, err := cognito.NewUserPool(ctx, "pool", &cognito.UserPoolArgs{
 * 			Name: pulumi.String("mypool"),
 * 		})
 * 		if err != nil {
 * 			return err
 * 		}
 * 		return nil
 * 	})
 * }
 * ```
 * ```java
 * package generated_program;
 * import com.pulumi.Context;
 * import com.pulumi.Pulumi;
 * import com.pulumi.core.Output;
 * import com.pulumi.aws.cognito.UserPool;
 * import com.pulumi.aws.cognito.UserPoolArgs;
 * import java.util.List;
 * import java.util.ArrayList;
 * import java.util.Map;
 * import java.io.File;
 * import java.nio.file.Files;
 * import java.nio.file.Paths;
 * public class App {
 *     public static void main(String[] args) {
 *         Pulumi.run(App::stack);
 *     }
 *     public static void stack(Context ctx) {
 *         var pool = new UserPool("pool", UserPoolArgs.builder()
 *             .name("mypool")
 *             .build());
 *     }
 * }
 * ```
 * ```yaml
 * resources:
 *   pool:
 *     type: aws:cognito:UserPool
 *     properties:
 *       name: mypool
 * ```
 * <!--End PulumiCodeChooser -->
 * ### Enabling SMS and Software Token Multi-Factor Authentication
 * <!--Start PulumiCodeChooser -->
 * ```typescript
 * import * as pulumi from "@pulumi/pulumi";
 * import * as aws from "@pulumi/aws";
 * const example = new aws.cognito.UserPool("example", {
 *     mfaConfiguration: "ON",
 *     smsAuthenticationMessage: "Your code is {####}",
 *     smsConfiguration: {
 *         externalId: "example",
 *         snsCallerArn: exampleAwsIamRole.arn,
 *         snsRegion: "us-east-1",
 *     },
 *     softwareTokenMfaConfiguration: {
 *         enabled: true,
 *     },
 * });
 * ```
 * ```python
 * import pulumi
 * import pulumi_aws as aws
 * example = aws.cognito.UserPool("example",
 *     mfa_configuration="ON",
 *     sms_authentication_message="Your code is {####}",
 *     sms_configuration={
 *         "external_id": "example",
 *         "sns_caller_arn": example_aws_iam_role["arn"],
 *         "sns_region": "us-east-1",
 *     },
 *     software_token_mfa_configuration={
 *         "enabled": True,
 *     })
 * ```
 * ```csharp
 * using System.Collections.Generic;
 * using System.Linq;
 * using Pulumi;
 * using Aws = Pulumi.Aws;
 * return await Deployment.RunAsync(() =>
 * {
 *     var example = new Aws.Cognito.UserPool("example", new()
 *     {
 *         MfaConfiguration = "ON",
 *         SmsAuthenticationMessage = "Your code is {####}",
 *         SmsConfiguration = new Aws.Cognito.Inputs.UserPoolSmsConfigurationArgs
 *         {
 *             ExternalId = "example",
 *             SnsCallerArn = exampleAwsIamRole.Arn,
 *             SnsRegion = "us-east-1",
 *         },
 *         SoftwareTokenMfaConfiguration = new Aws.Cognito.Inputs.UserPoolSoftwareTokenMfaConfigurationArgs
 *         {
 *             Enabled = true,
 *         },
 *     });
 * });
 * ```
 * ```go
 * package main
 * import (
 * 	"github.com/pulumi/pulumi-aws/sdk/v6/go/aws/cognito"
 * 	"github.com/pulumi/pulumi/sdk/v3/go/pulumi"
 * )
 * func main() {
 * 	pulumi.Run(func(ctx *pulumi.Context) error {
 * 		_, err := cognito.NewUserPool(ctx, "example", &cognito.UserPoolArgs{
 * 			MfaConfiguration:         pulumi.String("ON"),
 * 			SmsAuthenticationMessage: pulumi.String("Your code is {####}"),
 * 			SmsConfiguration: &cognito.UserPoolSmsConfigurationArgs{
 * 				ExternalId:   pulumi.String("example"),
 * 				SnsCallerArn: pulumi.Any(exampleAwsIamRole.Arn),
 * 				SnsRegion:    pulumi.String("us-east-1"),
 * 			},
 * 			SoftwareTokenMfaConfiguration: &cognito.UserPoolSoftwareTokenMfaConfigurationArgs{
 * 				Enabled: pulumi.Bool(true),
 * 			},
 * 		})
 * 		if err != nil {
 * 			return err
 * 		}
 * 		return nil
 * 	})
 * }
 * ```
 * ```java
 * package generated_program;
 * import com.pulumi.Context;
 * import com.pulumi.Pulumi;
 * import com.pulumi.core.Output;
 * import com.pulumi.aws.cognito.UserPool;
 * import com.pulumi.aws.cognito.UserPoolArgs;
 * import com.pulumi.aws.cognito.inputs.UserPoolSmsConfigurationArgs;
 * import com.pulumi.aws.cognito.inputs.UserPoolSoftwareTokenMfaConfigurationArgs;
 * import java.util.List;
 * import java.util.ArrayList;
 * import java.util.Map;
 * import java.io.File;
 * import java.nio.file.Files;
 * import java.nio.file.Paths;
 * public class App {
 *     public static void main(String[] args) {
 *         Pulumi.run(App::stack);
 *     }
 *     public static void stack(Context ctx) {
 *         var example = new UserPool("example", UserPoolArgs.builder()
 *             .mfaConfiguration("ON")
 *             .smsAuthenticationMessage("Your code is {####}")
 *             .smsConfiguration(UserPoolSmsConfigurationArgs.builder()
 *                 .externalId("example")
 *                 .snsCallerArn(exampleAwsIamRole.arn())
 *                 .snsRegion("us-east-1")
 *                 .build())
 *             .softwareTokenMfaConfiguration(UserPoolSoftwareTokenMfaConfigurationArgs.builder()
 *                 .enabled(true)
 *                 .build())
 *             .build());
 *     }
 * }
 * ```
 * ```yaml
 * resources:
 *   example:
 *     type: aws:cognito:UserPool
 *     properties:
 *       mfaConfiguration: ON
 *       smsAuthenticationMessage: Your code is {####}
 *       smsConfiguration:
 *         externalId: example
 *         snsCallerArn: ${exampleAwsIamRole.arn}
 *         snsRegion: us-east-1
 *       softwareTokenMfaConfiguration:
 *         enabled: true
 * ```
 * <!--End PulumiCodeChooser -->
 * ### Using Account Recovery Setting
 * <!--Start PulumiCodeChooser -->
 * ```typescript
 * import * as pulumi from "@pulumi/pulumi";
 * import * as aws from "@pulumi/aws";
 * const test = new aws.cognito.UserPool("test", {
 *     name: "mypool",
 *     accountRecoverySetting: {
 *         recoveryMechanisms: [
 *             {
 *                 name: "verified_email",
 *                 priority: 1,
 *             },
 *             {
 *                 name: "verified_phone_number",
 *                 priority: 2,
 *             },
 *         ],
 *     },
 * });
 * ```
 * ```python
 * import pulumi
 * import pulumi_aws as aws
 * test = aws.cognito.UserPool("test",
 *     name="mypool",
 *     account_recovery_setting={
 *         "recovery_mechanisms": [
 *             {
 *                 "name": "verified_email",
 *                 "priority": 1,
 *             },
 *             {
 *                 "name": "verified_phone_number",
 *                 "priority": 2,
 *             },
 *         ],
 *     })
 * ```
 * ```csharp
 * using System.Collections.Generic;
 * using System.Linq;
 * using Pulumi;
 * using Aws = Pulumi.Aws;
 * return await Deployment.RunAsync(() =>
 * {
 *     var test = new Aws.Cognito.UserPool("test", new()
 *     {
 *         Name = "mypool",
 *         AccountRecoverySetting = new Aws.Cognito.Inputs.UserPoolAccountRecoverySettingArgs
 *         {
 *             RecoveryMechanisms = new[]
 *             {
 *                 new Aws.Cognito.Inputs.UserPoolAccountRecoverySettingRecoveryMechanismArgs
 *                 {
 *                     Name = "verified_email",
 *                     Priority = 1,
 *                 },
 *                 new Aws.Cognito.Inputs.UserPoolAccountRecoverySettingRecoveryMechanismArgs
 *                 {
 *                     Name = "verified_phone_number",
 *                     Priority = 2,
 *                 },
 *             },
 *         },
 *     });
 * });
 * ```
 * ```go
 * package main
 * import (
 * 	"github.com/pulumi/pulumi-aws/sdk/v6/go/aws/cognito"
 * 	"github.com/pulumi/pulumi/sdk/v3/go/pulumi"
 * )
 * func main() {
 * 	pulumi.Run(func(ctx *pulumi.Context) error {
 * 		_, err := cognito.NewUserPool(ctx, "test", &cognito.UserPoolArgs{
 * 			Name: pulumi.String("mypool"),
 * 			AccountRecoverySetting: &cognito.UserPoolAccountRecoverySettingArgs{
 * 				RecoveryMechanisms: cognito.UserPoolAccountRecoverySettingRecoveryMechanismArray{
 * 					&cognito.UserPoolAccountRecoverySettingRecoveryMechanismArgs{
 * 						Name:     pulumi.String("verified_email"),
 * 						Priority: pulumi.Int(1),
 * 					},
 * 					&cognito.UserPoolAccountRecoverySettingRecoveryMechanismArgs{
 * 						Name:     pulumi.String("verified_phone_number"),
 * 						Priority: pulumi.Int(2),
 * 					},
 * 				},
 * 			},
 * 		})
 * 		if err != nil {
 * 			return err
 * 		}
 * 		return nil
 * 	})
 * }
 * ```
 * ```java
 * package generated_program;
 * import com.pulumi.Context;
 * import com.pulumi.Pulumi;
 * import com.pulumi.core.Output;
 * import com.pulumi.aws.cognito.UserPool;
 * import com.pulumi.aws.cognito.UserPoolArgs;
 * import com.pulumi.aws.cognito.inputs.UserPoolAccountRecoverySettingArgs;
 * import java.util.List;
 * import java.util.ArrayList;
 * import java.util.Map;
 * import java.io.File;
 * import java.nio.file.Files;
 * import java.nio.file.Paths;
 * public class App {
 *     public static void main(String[] args) {
 *         Pulumi.run(App::stack);
 *     }
 *     public static void stack(Context ctx) {
 *         var test = new UserPool("test", UserPoolArgs.builder()
 *             .name("mypool")
 *             .accountRecoverySetting(UserPoolAccountRecoverySettingArgs.builder()
 *                 .recoveryMechanisms(
 *                     UserPoolAccountRecoverySettingRecoveryMechanismArgs.builder()
 *                         .name("verified_email")
 *                         .priority(1)
 *                         .build(),
 *                     UserPoolAccountRecoverySettingRecoveryMechanismArgs.builder()
 *                         .name("verified_phone_number")
 *                         .priority(2)
 *                         .build())
 *                 .build())
 *             .build());
 *     }
 * }
 * ```
 * ```yaml
 * resources:
 *   test:
 *     type: aws:cognito:UserPool
 *     properties:
 *       name: mypool
 *       accountRecoverySetting:
 *         recoveryMechanisms:
 *           - name: verified_email
 *             priority: 1
 *           - name: verified_phone_number
 *             priority: 2
 * ```
 * <!--End PulumiCodeChooser -->
 * ## Import
 * Using `pulumi import`, import Cognito User Pools using the `id`. For example:
 * ```sh
 * $ pulumi import aws:cognito/userPool:UserPool pool us-west-2_abc123
 * ```
 * @property accountRecoverySetting Configuration block to define which verified available method a user can use to recover their forgotten password. Detailed below.
 * @property adminCreateUserConfig Configuration block for creating a new user profile. Detailed below.
 * @property aliasAttributes Attributes supported as an alias for this user pool. Valid values: `phone_number`, `email`, or `preferred_username`. Conflicts with `username_attributes`.
 * @property autoVerifiedAttributes Attributes to be auto-verified. Valid values: `email`, `phone_number`.
 * @property deletionProtection When active, DeletionProtection prevents accidental deletion of your user pool. Before you can delete a user pool that you have protected against deletion, you must deactivate this feature. Valid values are `ACTIVE` and `INACTIVE`, Default value is `INACTIVE`.
 * @property deviceConfiguration Configuration block for the user pool's device tracking. Detailed below.
 * @property emailConfiguration Configuration block for configuring email. Detailed below.
 * @property emailVerificationMessage String representing the email verification message. Conflicts with `verification_message_template` configuration block `email_message` argument.
 * @property emailVerificationSubject String representing the email verification subject. Conflicts with `verification_message_template` configuration block `email_subject` argument.
 * @property lambdaConfig Configuration block for the AWS Lambda triggers associated with the user pool. Detailed below.
 * @property mfaConfiguration Multi-Factor Authentication (MFA) configuration for the User Pool. Defaults of `OFF`. Valid values are `OFF` (MFA Tokens are not required), `ON` (MFA is required for all users to sign in; requires at least one of `sms_configuration` or `software_token_mfa_configuration` to be configured), or `OPTIONAL` (MFA Will be required only for individual users who have MFA Enabled; requires at least one of `sms_configuration` or `software_token_mfa_configuration` to be configured).
 * @property name Name of the user pool.
 * The following arguments are optional:
 * @property passwordPolicy Configuration block for information about the user pool password policy. Detailed below.
 * @property schemas Configuration block for the schema attributes of a user pool. Detailed below. Schema attributes from the [standard attribute set](https://docs.aws.amazon.com/cognito/latest/developerguide/user-pool-settings-attributes.html#cognito-user-pools-standard-attributes) only need to be specified if they are different from the default configuration. Attributes can be added, but not modified or removed. Maximum of 50 attributes.
 * @property smsAuthenticationMessage String representing the SMS authentication message. The Message must contain the `{####}` placeholder, which will be replaced with the code.
 * @property smsConfiguration Configuration block for Short Message Service (SMS) settings. Detailed below. These settings apply to SMS user verification and SMS Multi-Factor Authentication (MFA). Due to Cognito API restrictions, the SMS configuration cannot be removed without recreating the Cognito User Pool. For user data safety, this resource will ignore the removal of this configuration by disabling drift detection. To force resource recreation after this configuration has been applied, see the `taint` command.
 * @property smsVerificationMessage String representing the SMS verification message. Conflicts with `verification_message_template` configuration block `sms_message` argument.
 * @property softwareTokenMfaConfiguration Configuration block for software token Mult-Factor Authentication (MFA) settings. Detailed below.
 * @property tags Map of tags to assign to the User Pool. If configured with a provider `default_tags` configuration block present, tags with matching keys will overwrite those defined at the provider-level.
 * @property userAttributeUpdateSettings Configuration block for user attribute update settings. Detailed below.
 * @property userPoolAddOns Configuration block for user pool add-ons to enable user pool advanced security mode features. Detailed below.
 * @property usernameAttributes Whether email addresses or phone numbers can be specified as usernames when a user signs up. Conflicts with `alias_attributes`.
 * @property usernameConfiguration Configuration block for username configuration. Detailed below.
 * @property verificationMessageTemplate Configuration block for verification message templates. Detailed below.
 */
public data class UserPoolArgs(
    public val accountRecoverySetting: Output<UserPoolAccountRecoverySettingArgs>? = null,
    public val adminCreateUserConfig: Output<UserPoolAdminCreateUserConfigArgs>? = null,
    public val aliasAttributes: Output<List<String>>? = null,
    public val autoVerifiedAttributes: Output<List<String>>? = null,
    public val deletionProtection: Output<String>? = null,
    public val deviceConfiguration: Output<UserPoolDeviceConfigurationArgs>? = null,
    public val emailConfiguration: Output<UserPoolEmailConfigurationArgs>? = null,
    public val emailVerificationMessage: Output<String>? = null,
    public val emailVerificationSubject: Output<String>? = null,
    public val lambdaConfig: Output<UserPoolLambdaConfigArgs>? = null,
    public val mfaConfiguration: Output<String>? = null,
    public val name: Output<String>? = null,
    public val passwordPolicy: Output<UserPoolPasswordPolicyArgs>? = null,
    public val schemas: Output<List<UserPoolSchemaArgs>>? = null,
    public val smsAuthenticationMessage: Output<String>? = null,
    public val smsConfiguration: Output<UserPoolSmsConfigurationArgs>? = null,
    public val smsVerificationMessage: Output<String>? = null,
    public val softwareTokenMfaConfiguration: Output<UserPoolSoftwareTokenMfaConfigurationArgs>? =
        null,
    public val tags: Output<Map<String, String>>? = null,
    public val userAttributeUpdateSettings: Output<UserPoolUserAttributeUpdateSettingsArgs>? = null,
    public val userPoolAddOns: Output<UserPoolUserPoolAddOnsArgs>? = null,
    public val usernameAttributes: Output<List<String>>? = null,
    public val usernameConfiguration: Output<UserPoolUsernameConfigurationArgs>? = null,
    public val verificationMessageTemplate: Output<UserPoolVerificationMessageTemplateArgs>? = null,
) : ConvertibleToJava<com.pulumi.aws.cognito.UserPoolArgs> {
    override fun toJava(): com.pulumi.aws.cognito.UserPoolArgs =
        com.pulumi.aws.cognito.UserPoolArgs.builder()
            .accountRecoverySetting(
                accountRecoverySetting?.applyValue({ args0 ->
                    args0.let({ args0 ->
                        args0.toJava()
                    })
                }),
            )
            .adminCreateUserConfig(
                adminCreateUserConfig?.applyValue({ args0 ->
                    args0.let({ args0 ->
                        args0.toJava()
                    })
                }),
            )
            .aliasAttributes(aliasAttributes?.applyValue({ args0 -> args0.map({ args0 -> args0 }) }))
            .autoVerifiedAttributes(
                autoVerifiedAttributes?.applyValue({ args0 ->
                    args0.map({ args0 ->
                        args0
                    })
                }),
            )
            .deletionProtection(deletionProtection?.applyValue({ args0 -> args0 }))
            .deviceConfiguration(
                deviceConfiguration?.applyValue({ args0 ->
                    args0.let({ args0 ->
                        args0.toJava()
                    })
                }),
            )
            .emailConfiguration(
                emailConfiguration?.applyValue({ args0 ->
                    args0.let({ args0 ->
                        args0.toJava()
                    })
                }),
            )
            .emailVerificationMessage(emailVerificationMessage?.applyValue({ args0 -> args0 }))
            .emailVerificationSubject(emailVerificationSubject?.applyValue({ args0 -> args0 }))
            .lambdaConfig(lambdaConfig?.applyValue({ args0 -> args0.let({ args0 -> args0.toJava() }) }))
            .mfaConfiguration(mfaConfiguration?.applyValue({ args0 -> args0 }))
            .name(name?.applyValue({ args0 -> args0 }))
            .passwordPolicy(passwordPolicy?.applyValue({ args0 -> args0.let({ args0 -> args0.toJava() }) }))
            .schemas(
                schemas?.applyValue({ args0 ->
                    args0.map({ args0 ->
                        args0.let({ args0 ->
                            args0.toJava()
                        })
                    })
                }),
            )
            .smsAuthenticationMessage(smsAuthenticationMessage?.applyValue({ args0 -> args0 }))
            .smsConfiguration(smsConfiguration?.applyValue({ args0 -> args0.let({ args0 -> args0.toJava() }) }))
            .smsVerificationMessage(smsVerificationMessage?.applyValue({ args0 -> args0 }))
            .softwareTokenMfaConfiguration(
                softwareTokenMfaConfiguration?.applyValue({ args0 ->
                    args0.let({ args0 -> args0.toJava() })
                }),
            )
            .tags(tags?.applyValue({ args0 -> args0.map({ args0 -> args0.key.to(args0.value) }).toMap() }))
            .userAttributeUpdateSettings(
                userAttributeUpdateSettings?.applyValue({ args0 ->
                    args0.let({ args0 ->
                        args0.toJava()
                    })
                }),
            )
            .userPoolAddOns(userPoolAddOns?.applyValue({ args0 -> args0.let({ args0 -> args0.toJava() }) }))
            .usernameAttributes(usernameAttributes?.applyValue({ args0 -> args0.map({ args0 -> args0 }) }))
            .usernameConfiguration(
                usernameConfiguration?.applyValue({ args0 ->
                    args0.let({ args0 ->
                        args0.toJava()
                    })
                }),
            )
            .verificationMessageTemplate(
                verificationMessageTemplate?.applyValue({ args0 ->
                    args0.let({ args0 ->
                        args0.toJava()
                    })
                }),
            ).build()
}

/**
 * Builder for [UserPoolArgs].
 */
@PulumiTagMarker
public class UserPoolArgsBuilder internal constructor() {
    private var accountRecoverySetting: Output<UserPoolAccountRecoverySettingArgs>? = null

    private var adminCreateUserConfig: Output<UserPoolAdminCreateUserConfigArgs>? = null

    private var aliasAttributes: Output<List<String>>? = null

    private var autoVerifiedAttributes: Output<List<String>>? = null

    private var deletionProtection: Output<String>? = null

    private var deviceConfiguration: Output<UserPoolDeviceConfigurationArgs>? = null

    private var emailConfiguration: Output<UserPoolEmailConfigurationArgs>? = null

    private var emailVerificationMessage: Output<String>? = null

    private var emailVerificationSubject: Output<String>? = null

    private var lambdaConfig: Output<UserPoolLambdaConfigArgs>? = null

    private var mfaConfiguration: Output<String>? = null

    private var name: Output<String>? = null

    private var passwordPolicy: Output<UserPoolPasswordPolicyArgs>? = null

    private var schemas: Output<List<UserPoolSchemaArgs>>? = null

    private var smsAuthenticationMessage: Output<String>? = null

    private var smsConfiguration: Output<UserPoolSmsConfigurationArgs>? = null

    private var smsVerificationMessage: Output<String>? = null

    private var softwareTokenMfaConfiguration: Output<UserPoolSoftwareTokenMfaConfigurationArgs>? =
        null

    private var tags: Output<Map<String, String>>? = null

    private var userAttributeUpdateSettings: Output<UserPoolUserAttributeUpdateSettingsArgs>? = null

    private var userPoolAddOns: Output<UserPoolUserPoolAddOnsArgs>? = null

    private var usernameAttributes: Output<List<String>>? = null

    private var usernameConfiguration: Output<UserPoolUsernameConfigurationArgs>? = null

    private var verificationMessageTemplate: Output<UserPoolVerificationMessageTemplateArgs>? = null

    /**
     * @param value Configuration block to define which verified available method a user can use to recover their forgotten password. Detailed below.
     */
    @JvmName("unpcobtkdraofida")
    public suspend fun accountRecoverySetting(`value`: Output<UserPoolAccountRecoverySettingArgs>) {
        this.accountRecoverySetting = value
    }

    /**
     * @param value Configuration block for creating a new user profile. Detailed below.
     */
    @JvmName("gqqbfbiahdmslwex")
    public suspend fun adminCreateUserConfig(`value`: Output<UserPoolAdminCreateUserConfigArgs>) {
        this.adminCreateUserConfig = value
    }

    /**
     * @param value Attributes supported as an alias for this user pool. Valid values: `phone_number`, `email`, or `preferred_username`. Conflicts with `username_attributes`.
     */
    @JvmName("syxvunmrbpqxdufa")
    public suspend fun aliasAttributes(`value`: Output<List<String>>) {
        this.aliasAttributes = value
    }

    @JvmName("qopufjrffcajnuyg")
    public suspend fun aliasAttributes(vararg values: Output<String>) {
        this.aliasAttributes = Output.all(values.asList())
    }

    /**
     * @param values Attributes supported as an alias for this user pool. Valid values: `phone_number`, `email`, or `preferred_username`. Conflicts with `username_attributes`.
     */
    @JvmName("yxkxehcydgosxjcf")
    public suspend fun aliasAttributes(values: List<Output<String>>) {
        this.aliasAttributes = Output.all(values)
    }

    /**
     * @param value Attributes to be auto-verified. Valid values: `email`, `phone_number`.
     */
    @JvmName("nqhgbvwniiaaryyv")
    public suspend fun autoVerifiedAttributes(`value`: Output<List<String>>) {
        this.autoVerifiedAttributes = value
    }

    @JvmName("fdlrvrwqeopyjsjp")
    public suspend fun autoVerifiedAttributes(vararg values: Output<String>) {
        this.autoVerifiedAttributes = Output.all(values.asList())
    }

    /**
     * @param values Attributes to be auto-verified. Valid values: `email`, `phone_number`.
     */
    @JvmName("akclmscbpeptqmxa")
    public suspend fun autoVerifiedAttributes(values: List<Output<String>>) {
        this.autoVerifiedAttributes = Output.all(values)
    }

    /**
     * @param value When active, DeletionProtection prevents accidental deletion of your user pool. Before you can delete a user pool that you have protected against deletion, you must deactivate this feature. Valid values are `ACTIVE` and `INACTIVE`, Default value is `INACTIVE`.
     */
    @JvmName("qsonxjxcjvntmdng")
    public suspend fun deletionProtection(`value`: Output<String>) {
        this.deletionProtection = value
    }

    /**
     * @param value Configuration block for the user pool's device tracking. Detailed below.
     */
    @JvmName("ktywpmtosxoiwuce")
    public suspend fun deviceConfiguration(`value`: Output<UserPoolDeviceConfigurationArgs>) {
        this.deviceConfiguration = value
    }

    /**
     * @param value Configuration block for configuring email. Detailed below.
     */
    @JvmName("etbmnmmbwewodjil")
    public suspend fun emailConfiguration(`value`: Output<UserPoolEmailConfigurationArgs>) {
        this.emailConfiguration = value
    }

    /**
     * @param value String representing the email verification message. Conflicts with `verification_message_template` configuration block `email_message` argument.
     */
    @JvmName("gdqegafmuidqfqcp")
    public suspend fun emailVerificationMessage(`value`: Output<String>) {
        this.emailVerificationMessage = value
    }

    /**
     * @param value String representing the email verification subject. Conflicts with `verification_message_template` configuration block `email_subject` argument.
     */
    @JvmName("abrhihuahpbkiwyo")
    public suspend fun emailVerificationSubject(`value`: Output<String>) {
        this.emailVerificationSubject = value
    }

    /**
     * @param value Configuration block for the AWS Lambda triggers associated with the user pool. Detailed below.
     */
    @JvmName("cfwvbmtlchqvjeuc")
    public suspend fun lambdaConfig(`value`: Output<UserPoolLambdaConfigArgs>) {
        this.lambdaConfig = value
    }

    /**
     * @param value Multi-Factor Authentication (MFA) configuration for the User Pool. Defaults of `OFF`. Valid values are `OFF` (MFA Tokens are not required), `ON` (MFA is required for all users to sign in; requires at least one of `sms_configuration` or `software_token_mfa_configuration` to be configured), or `OPTIONAL` (MFA Will be required only for individual users who have MFA Enabled; requires at least one of `sms_configuration` or `software_token_mfa_configuration` to be configured).
     */
    @JvmName("rvergkudcudkucgv")
    public suspend fun mfaConfiguration(`value`: Output<String>) {
        this.mfaConfiguration = value
    }

    /**
     * @param value Name of the user pool.
     * The following arguments are optional:
     */
    @JvmName("lohtfmophgqcratv")
    public suspend fun name(`value`: Output<String>) {
        this.name = value
    }

    /**
     * @param value Configuration block for information about the user pool password policy. Detailed below.
     */
    @JvmName("yuoatfpwrbrsidaa")
    public suspend fun passwordPolicy(`value`: Output<UserPoolPasswordPolicyArgs>) {
        this.passwordPolicy = value
    }

    /**
     * @param value Configuration block for the schema attributes of a user pool. Detailed below. Schema attributes from the [standard attribute set](https://docs.aws.amazon.com/cognito/latest/developerguide/user-pool-settings-attributes.html#cognito-user-pools-standard-attributes) only need to be specified if they are different from the default configuration. Attributes can be added, but not modified or removed. Maximum of 50 attributes.
     */
    @JvmName("gpocxcygqcoljgyg")
    public suspend fun schemas(`value`: Output<List<UserPoolSchemaArgs>>) {
        this.schemas = value
    }

    @JvmName("jmjbkwhfjmdplvfx")
    public suspend fun schemas(vararg values: Output<UserPoolSchemaArgs>) {
        this.schemas = Output.all(values.asList())
    }

    /**
     * @param values Configuration block for the schema attributes of a user pool. Detailed below. Schema attributes from the [standard attribute set](https://docs.aws.amazon.com/cognito/latest/developerguide/user-pool-settings-attributes.html#cognito-user-pools-standard-attributes) only need to be specified if they are different from the default configuration. Attributes can be added, but not modified or removed. Maximum of 50 attributes.
     */
    @JvmName("fusyqunrtrrumklw")
    public suspend fun schemas(values: List<Output<UserPoolSchemaArgs>>) {
        this.schemas = Output.all(values)
    }

    /**
     * @param value String representing the SMS authentication message. The Message must contain the `{####}` placeholder, which will be replaced with the code.
     */
    @JvmName("dcgprehynmscigie")
    public suspend fun smsAuthenticationMessage(`value`: Output<String>) {
        this.smsAuthenticationMessage = value
    }

    /**
     * @param value Configuration block for Short Message Service (SMS) settings. Detailed below. These settings apply to SMS user verification and SMS Multi-Factor Authentication (MFA). Due to Cognito API restrictions, the SMS configuration cannot be removed without recreating the Cognito User Pool. For user data safety, this resource will ignore the removal of this configuration by disabling drift detection. To force resource recreation after this configuration has been applied, see the `taint` command.
     */
    @JvmName("jtubjmpcqdrhytcw")
    public suspend fun smsConfiguration(`value`: Output<UserPoolSmsConfigurationArgs>) {
        this.smsConfiguration = value
    }

    /**
     * @param value String representing the SMS verification message. Conflicts with `verification_message_template` configuration block `sms_message` argument.
     */
    @JvmName("xtdnyjcltwfjhcnu")
    public suspend fun smsVerificationMessage(`value`: Output<String>) {
        this.smsVerificationMessage = value
    }

    /**
     * @param value Configuration block for software token Mult-Factor Authentication (MFA) settings. Detailed below.
     */
    @JvmName("xagldcbsqduogelc")
    public suspend fun softwareTokenMfaConfiguration(`value`: Output<UserPoolSoftwareTokenMfaConfigurationArgs>) {
        this.softwareTokenMfaConfiguration = value
    }

    /**
     * @param value Map of tags to assign to the User Pool. If configured with a provider `default_tags` configuration block present, tags with matching keys will overwrite those defined at the provider-level.
     */
    @JvmName("qiojmwynsqgjptil")
    public suspend fun tags(`value`: Output<Map<String, String>>) {
        this.tags = value
    }

    /**
     * @param value Configuration block for user attribute update settings. Detailed below.
     */
    @JvmName("yjwwcsdodcyvrsuv")
    public suspend fun userAttributeUpdateSettings(`value`: Output<UserPoolUserAttributeUpdateSettingsArgs>) {
        this.userAttributeUpdateSettings = value
    }

    /**
     * @param value Configuration block for user pool add-ons to enable user pool advanced security mode features. Detailed below.
     */
    @JvmName("ubbnmfohmuqayxmj")
    public suspend fun userPoolAddOns(`value`: Output<UserPoolUserPoolAddOnsArgs>) {
        this.userPoolAddOns = value
    }

    /**
     * @param value Whether email addresses or phone numbers can be specified as usernames when a user signs up. Conflicts with `alias_attributes`.
     */
    @JvmName("wctbxvchicwgrvbg")
    public suspend fun usernameAttributes(`value`: Output<List<String>>) {
        this.usernameAttributes = value
    }

    @JvmName("rjgmnhkbvwlhdobc")
    public suspend fun usernameAttributes(vararg values: Output<String>) {
        this.usernameAttributes = Output.all(values.asList())
    }

    /**
     * @param values Whether email addresses or phone numbers can be specified as usernames when a user signs up. Conflicts with `alias_attributes`.
     */
    @JvmName("irndlwpquhnxnlew")
    public suspend fun usernameAttributes(values: List<Output<String>>) {
        this.usernameAttributes = Output.all(values)
    }

    /**
     * @param value Configuration block for username configuration. Detailed below.
     */
    @JvmName("ocwjdnoxsajlsmfy")
    public suspend fun usernameConfiguration(`value`: Output<UserPoolUsernameConfigurationArgs>) {
        this.usernameConfiguration = value
    }

    /**
     * @param value Configuration block for verification message templates. Detailed below.
     */
    @JvmName("dmyoxhhyffnfvkdo")
    public suspend fun verificationMessageTemplate(`value`: Output<UserPoolVerificationMessageTemplateArgs>) {
        this.verificationMessageTemplate = value
    }

    /**
     * @param value Configuration block to define which verified available method a user can use to recover their forgotten password. Detailed below.
     */
    @JvmName("hxpjjgsnitqcbjgt")
    public suspend fun accountRecoverySetting(`value`: UserPoolAccountRecoverySettingArgs?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.accountRecoverySetting = mapped
    }

    /**
     * @param argument Configuration block to define which verified available method a user can use to recover their forgotten password. Detailed below.
     */
    @JvmName("soxffklljfacxrlq")
    public suspend fun accountRecoverySetting(argument: suspend UserPoolAccountRecoverySettingArgsBuilder.() -> Unit) {
        val toBeMapped = UserPoolAccountRecoverySettingArgsBuilder().applySuspend { argument() }.build()
        val mapped = of(toBeMapped)
        this.accountRecoverySetting = mapped
    }

    /**
     * @param value Configuration block for creating a new user profile. Detailed below.
     */
    @JvmName("gbwaydhpcfodhevg")
    public suspend fun adminCreateUserConfig(`value`: UserPoolAdminCreateUserConfigArgs?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.adminCreateUserConfig = mapped
    }

    /**
     * @param argument Configuration block for creating a new user profile. Detailed below.
     */
    @JvmName("pnrcvvvtepradqse")
    public suspend fun adminCreateUserConfig(argument: suspend UserPoolAdminCreateUserConfigArgsBuilder.() -> Unit) {
        val toBeMapped = UserPoolAdminCreateUserConfigArgsBuilder().applySuspend { argument() }.build()
        val mapped = of(toBeMapped)
        this.adminCreateUserConfig = mapped
    }

    /**
     * @param value Attributes supported as an alias for this user pool. Valid values: `phone_number`, `email`, or `preferred_username`. Conflicts with `username_attributes`.
     */
    @JvmName("xhngwjnljmcwbhko")
    public suspend fun aliasAttributes(`value`: List<String>?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.aliasAttributes = mapped
    }

    /**
     * @param values Attributes supported as an alias for this user pool. Valid values: `phone_number`, `email`, or `preferred_username`. Conflicts with `username_attributes`.
     */
    @JvmName("cgtpsniaeilfvxtx")
    public suspend fun aliasAttributes(vararg values: String) {
        val toBeMapped = values.toList()
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.aliasAttributes = mapped
    }

    /**
     * @param value Attributes to be auto-verified. Valid values: `email`, `phone_number`.
     */
    @JvmName("ttnxmmqaipmhohhq")
    public suspend fun autoVerifiedAttributes(`value`: List<String>?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.autoVerifiedAttributes = mapped
    }

    /**
     * @param values Attributes to be auto-verified. Valid values: `email`, `phone_number`.
     */
    @JvmName("twtxuevbnsyamwin")
    public suspend fun autoVerifiedAttributes(vararg values: String) {
        val toBeMapped = values.toList()
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.autoVerifiedAttributes = mapped
    }

    /**
     * @param value When active, DeletionProtection prevents accidental deletion of your user pool. Before you can delete a user pool that you have protected against deletion, you must deactivate this feature. Valid values are `ACTIVE` and `INACTIVE`, Default value is `INACTIVE`.
     */
    @JvmName("qmxvcevvpumsqymq")
    public suspend fun deletionProtection(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.deletionProtection = mapped
    }

    /**
     * @param value Configuration block for the user pool's device tracking. Detailed below.
     */
    @JvmName("vsweywmgcuxspjae")
    public suspend fun deviceConfiguration(`value`: UserPoolDeviceConfigurationArgs?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.deviceConfiguration = mapped
    }

    /**
     * @param argument Configuration block for the user pool's device tracking. Detailed below.
     */
    @JvmName("gjpkqrucyjacgabe")
    public suspend fun deviceConfiguration(argument: suspend UserPoolDeviceConfigurationArgsBuilder.() -> Unit) {
        val toBeMapped = UserPoolDeviceConfigurationArgsBuilder().applySuspend { argument() }.build()
        val mapped = of(toBeMapped)
        this.deviceConfiguration = mapped
    }

    /**
     * @param value Configuration block for configuring email. Detailed below.
     */
    @JvmName("hglwrhuucdgkgjma")
    public suspend fun emailConfiguration(`value`: UserPoolEmailConfigurationArgs?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.emailConfiguration = mapped
    }

    /**
     * @param argument Configuration block for configuring email. Detailed below.
     */
    @JvmName("tgrcurdkgsjlsseu")
    public suspend fun emailConfiguration(argument: suspend UserPoolEmailConfigurationArgsBuilder.() -> Unit) {
        val toBeMapped = UserPoolEmailConfigurationArgsBuilder().applySuspend { argument() }.build()
        val mapped = of(toBeMapped)
        this.emailConfiguration = mapped
    }

    /**
     * @param value String representing the email verification message. Conflicts with `verification_message_template` configuration block `email_message` argument.
     */
    @JvmName("lccffxdbqqbhtrar")
    public suspend fun emailVerificationMessage(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.emailVerificationMessage = mapped
    }

    /**
     * @param value String representing the email verification subject. Conflicts with `verification_message_template` configuration block `email_subject` argument.
     */
    @JvmName("kmotqxblkqwryjam")
    public suspend fun emailVerificationSubject(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.emailVerificationSubject = mapped
    }

    /**
     * @param value Configuration block for the AWS Lambda triggers associated with the user pool. Detailed below.
     */
    @JvmName("xiggmkselfmsvtcj")
    public suspend fun lambdaConfig(`value`: UserPoolLambdaConfigArgs?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.lambdaConfig = mapped
    }

    /**
     * @param argument Configuration block for the AWS Lambda triggers associated with the user pool. Detailed below.
     */
    @JvmName("qeyvwqophmnhxywu")
    public suspend fun lambdaConfig(argument: suspend UserPoolLambdaConfigArgsBuilder.() -> Unit) {
        val toBeMapped = UserPoolLambdaConfigArgsBuilder().applySuspend { argument() }.build()
        val mapped = of(toBeMapped)
        this.lambdaConfig = mapped
    }

    /**
     * @param value Multi-Factor Authentication (MFA) configuration for the User Pool. Defaults of `OFF`. Valid values are `OFF` (MFA Tokens are not required), `ON` (MFA is required for all users to sign in; requires at least one of `sms_configuration` or `software_token_mfa_configuration` to be configured), or `OPTIONAL` (MFA Will be required only for individual users who have MFA Enabled; requires at least one of `sms_configuration` or `software_token_mfa_configuration` to be configured).
     */
    @JvmName("kocegumtnceetlru")
    public suspend fun mfaConfiguration(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.mfaConfiguration = mapped
    }

    /**
     * @param value Name of the user pool.
     * The following arguments are optional:
     */
    @JvmName("htfwhfvassaomnos")
    public suspend fun name(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.name = mapped
    }

    /**
     * @param value Configuration block for information about the user pool password policy. Detailed below.
     */
    @JvmName("xqywxipvmllrijse")
    public suspend fun passwordPolicy(`value`: UserPoolPasswordPolicyArgs?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.passwordPolicy = mapped
    }

    /**
     * @param argument Configuration block for information about the user pool password policy. Detailed below.
     */
    @JvmName("linsqxiclamjtdua")
    public suspend fun passwordPolicy(argument: suspend UserPoolPasswordPolicyArgsBuilder.() -> Unit) {
        val toBeMapped = UserPoolPasswordPolicyArgsBuilder().applySuspend { argument() }.build()
        val mapped = of(toBeMapped)
        this.passwordPolicy = mapped
    }

    /**
     * @param value Configuration block for the schema attributes of a user pool. Detailed below. Schema attributes from the [standard attribute set](https://docs.aws.amazon.com/cognito/latest/developerguide/user-pool-settings-attributes.html#cognito-user-pools-standard-attributes) only need to be specified if they are different from the default configuration. Attributes can be added, but not modified or removed. Maximum of 50 attributes.
     */
    @JvmName("pwimttwtoffumjat")
    public suspend fun schemas(`value`: List<UserPoolSchemaArgs>?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.schemas = mapped
    }

    /**
     * @param argument Configuration block for the schema attributes of a user pool. Detailed below. Schema attributes from the [standard attribute set](https://docs.aws.amazon.com/cognito/latest/developerguide/user-pool-settings-attributes.html#cognito-user-pools-standard-attributes) only need to be specified if they are different from the default configuration. Attributes can be added, but not modified or removed. Maximum of 50 attributes.
     */
    @JvmName("tycitiohgstseyss")
    public suspend fun schemas(argument: List<suspend UserPoolSchemaArgsBuilder.() -> Unit>) {
        val toBeMapped = argument.toList().map {
            UserPoolSchemaArgsBuilder().applySuspend {
                it()
            }.build()
        }
        val mapped = of(toBeMapped)
        this.schemas = mapped
    }

    /**
     * @param argument Configuration block for the schema attributes of a user pool. Detailed below. Schema attributes from the [standard attribute set](https://docs.aws.amazon.com/cognito/latest/developerguide/user-pool-settings-attributes.html#cognito-user-pools-standard-attributes) only need to be specified if they are different from the default configuration. Attributes can be added, but not modified or removed. Maximum of 50 attributes.
     */
    @JvmName("lhadskxsaoykochq")
    public suspend fun schemas(vararg argument: suspend UserPoolSchemaArgsBuilder.() -> Unit) {
        val toBeMapped = argument.toList().map {
            UserPoolSchemaArgsBuilder().applySuspend {
                it()
            }.build()
        }
        val mapped = of(toBeMapped)
        this.schemas = mapped
    }

    /**
     * @param argument Configuration block for the schema attributes of a user pool. Detailed below. Schema attributes from the [standard attribute set](https://docs.aws.amazon.com/cognito/latest/developerguide/user-pool-settings-attributes.html#cognito-user-pools-standard-attributes) only need to be specified if they are different from the default configuration. Attributes can be added, but not modified or removed. Maximum of 50 attributes.
     */
    @JvmName("ivkalemftalnaunw")
    public suspend fun schemas(argument: suspend UserPoolSchemaArgsBuilder.() -> Unit) {
        val toBeMapped = listOf(UserPoolSchemaArgsBuilder().applySuspend { argument() }.build())
        val mapped = of(toBeMapped)
        this.schemas = mapped
    }

    /**
     * @param values Configuration block for the schema attributes of a user pool. Detailed below. Schema attributes from the [standard attribute set](https://docs.aws.amazon.com/cognito/latest/developerguide/user-pool-settings-attributes.html#cognito-user-pools-standard-attributes) only need to be specified if they are different from the default configuration. Attributes can be added, but not modified or removed. Maximum of 50 attributes.
     */
    @JvmName("fntsnuwpphnkimoi")
    public suspend fun schemas(vararg values: UserPoolSchemaArgs) {
        val toBeMapped = values.toList()
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.schemas = mapped
    }

    /**
     * @param value String representing the SMS authentication message. The Message must contain the `{####}` placeholder, which will be replaced with the code.
     */
    @JvmName("xjmrcjqdjdfrhmvk")
    public suspend fun smsAuthenticationMessage(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.smsAuthenticationMessage = mapped
    }

    /**
     * @param value Configuration block for Short Message Service (SMS) settings. Detailed below. These settings apply to SMS user verification and SMS Multi-Factor Authentication (MFA). Due to Cognito API restrictions, the SMS configuration cannot be removed without recreating the Cognito User Pool. For user data safety, this resource will ignore the removal of this configuration by disabling drift detection. To force resource recreation after this configuration has been applied, see the `taint` command.
     */
    @JvmName("jyephdwllikipuls")
    public suspend fun smsConfiguration(`value`: UserPoolSmsConfigurationArgs?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.smsConfiguration = mapped
    }

    /**
     * @param argument Configuration block for Short Message Service (SMS) settings. Detailed below. These settings apply to SMS user verification and SMS Multi-Factor Authentication (MFA). Due to Cognito API restrictions, the SMS configuration cannot be removed without recreating the Cognito User Pool. For user data safety, this resource will ignore the removal of this configuration by disabling drift detection. To force resource recreation after this configuration has been applied, see the `taint` command.
     */
    @JvmName("rnvsanmaeppgjdeh")
    public suspend fun smsConfiguration(argument: suspend UserPoolSmsConfigurationArgsBuilder.() -> Unit) {
        val toBeMapped = UserPoolSmsConfigurationArgsBuilder().applySuspend { argument() }.build()
        val mapped = of(toBeMapped)
        this.smsConfiguration = mapped
    }

    /**
     * @param value String representing the SMS verification message. Conflicts with `verification_message_template` configuration block `sms_message` argument.
     */
    @JvmName("jrrrwuoulhcaqmpt")
    public suspend fun smsVerificationMessage(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.smsVerificationMessage = mapped
    }

    /**
     * @param value Configuration block for software token Mult-Factor Authentication (MFA) settings. Detailed below.
     */
    @JvmName("rodbycpojdsosuoc")
    public suspend fun softwareTokenMfaConfiguration(`value`: UserPoolSoftwareTokenMfaConfigurationArgs?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.softwareTokenMfaConfiguration = mapped
    }

    /**
     * @param argument Configuration block for software token Mult-Factor Authentication (MFA) settings. Detailed below.
     */
    @JvmName("giwfoknnxumdyucq")
    public suspend fun softwareTokenMfaConfiguration(argument: suspend UserPoolSoftwareTokenMfaConfigurationArgsBuilder.() -> Unit) {
        val toBeMapped = UserPoolSoftwareTokenMfaConfigurationArgsBuilder().applySuspend {
            argument()
        }.build()
        val mapped = of(toBeMapped)
        this.softwareTokenMfaConfiguration = mapped
    }

    /**
     * @param value Map of tags to assign to the User Pool. If configured with a provider `default_tags` configuration block present, tags with matching keys will overwrite those defined at the provider-level.
     */
    @JvmName("xtabhmkigoijkvnw")
    public suspend fun tags(`value`: Map<String, String>?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.tags = mapped
    }

    /**
     * @param values Map of tags to assign to the User Pool. If configured with a provider `default_tags` configuration block present, tags with matching keys will overwrite those defined at the provider-level.
     */
    @JvmName("aotjxihtsvfbqrjn")
    public fun tags(vararg values: Pair<String, String>) {
        val toBeMapped = values.toMap()
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.tags = mapped
    }

    /**
     * @param value Configuration block for user attribute update settings. Detailed below.
     */
    @JvmName("fqomhoucfqytmjeo")
    public suspend fun userAttributeUpdateSettings(`value`: UserPoolUserAttributeUpdateSettingsArgs?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.userAttributeUpdateSettings = mapped
    }

    /**
     * @param argument Configuration block for user attribute update settings. Detailed below.
     */
    @JvmName("dhrgooycpvvwdkmi")
    public suspend fun userAttributeUpdateSettings(argument: suspend UserPoolUserAttributeUpdateSettingsArgsBuilder.() -> Unit) {
        val toBeMapped = UserPoolUserAttributeUpdateSettingsArgsBuilder().applySuspend {
            argument()
        }.build()
        val mapped = of(toBeMapped)
        this.userAttributeUpdateSettings = mapped
    }

    /**
     * @param value Configuration block for user pool add-ons to enable user pool advanced security mode features. Detailed below.
     */
    @JvmName("hxwwgdjhfribbxrm")
    public suspend fun userPoolAddOns(`value`: UserPoolUserPoolAddOnsArgs?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.userPoolAddOns = mapped
    }

    /**
     * @param argument Configuration block for user pool add-ons to enable user pool advanced security mode features. Detailed below.
     */
    @JvmName("abkxphbnfgbskeus")
    public suspend fun userPoolAddOns(argument: suspend UserPoolUserPoolAddOnsArgsBuilder.() -> Unit) {
        val toBeMapped = UserPoolUserPoolAddOnsArgsBuilder().applySuspend { argument() }.build()
        val mapped = of(toBeMapped)
        this.userPoolAddOns = mapped
    }

    /**
     * @param value Whether email addresses or phone numbers can be specified as usernames when a user signs up. Conflicts with `alias_attributes`.
     */
    @JvmName("ufxevlkwrkdmnnef")
    public suspend fun usernameAttributes(`value`: List<String>?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.usernameAttributes = mapped
    }

    /**
     * @param values Whether email addresses or phone numbers can be specified as usernames when a user signs up. Conflicts with `alias_attributes`.
     */
    @JvmName("vywdhcufqjogdben")
    public suspend fun usernameAttributes(vararg values: String) {
        val toBeMapped = values.toList()
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.usernameAttributes = mapped
    }

    /**
     * @param value Configuration block for username configuration. Detailed below.
     */
    @JvmName("djobqmrwwxaxpbco")
    public suspend fun usernameConfiguration(`value`: UserPoolUsernameConfigurationArgs?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.usernameConfiguration = mapped
    }

    /**
     * @param argument Configuration block for username configuration. Detailed below.
     */
    @JvmName("kkgrokyxyerrgfud")
    public suspend fun usernameConfiguration(argument: suspend UserPoolUsernameConfigurationArgsBuilder.() -> Unit) {
        val toBeMapped = UserPoolUsernameConfigurationArgsBuilder().applySuspend { argument() }.build()
        val mapped = of(toBeMapped)
        this.usernameConfiguration = mapped
    }

    /**
     * @param value Configuration block for verification message templates. Detailed below.
     */
    @JvmName("qaqtqkseffjgmcrm")
    public suspend fun verificationMessageTemplate(`value`: UserPoolVerificationMessageTemplateArgs?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.verificationMessageTemplate = mapped
    }

    /**
     * @param argument Configuration block for verification message templates. Detailed below.
     */
    @JvmName("fmkcpuhvlsaloupx")
    public suspend fun verificationMessageTemplate(argument: suspend UserPoolVerificationMessageTemplateArgsBuilder.() -> Unit) {
        val toBeMapped = UserPoolVerificationMessageTemplateArgsBuilder().applySuspend {
            argument()
        }.build()
        val mapped = of(toBeMapped)
        this.verificationMessageTemplate = mapped
    }

    internal fun build(): UserPoolArgs = UserPoolArgs(
        accountRecoverySetting = accountRecoverySetting,
        adminCreateUserConfig = adminCreateUserConfig,
        aliasAttributes = aliasAttributes,
        autoVerifiedAttributes = autoVerifiedAttributes,
        deletionProtection = deletionProtection,
        deviceConfiguration = deviceConfiguration,
        emailConfiguration = emailConfiguration,
        emailVerificationMessage = emailVerificationMessage,
        emailVerificationSubject = emailVerificationSubject,
        lambdaConfig = lambdaConfig,
        mfaConfiguration = mfaConfiguration,
        name = name,
        passwordPolicy = passwordPolicy,
        schemas = schemas,
        smsAuthenticationMessage = smsAuthenticationMessage,
        smsConfiguration = smsConfiguration,
        smsVerificationMessage = smsVerificationMessage,
        softwareTokenMfaConfiguration = softwareTokenMfaConfiguration,
        tags = tags,
        userAttributeUpdateSettings = userAttributeUpdateSettings,
        userPoolAddOns = userPoolAddOns,
        usernameAttributes = usernameAttributes,
        usernameConfiguration = usernameConfiguration,
        verificationMessageTemplate = verificationMessageTemplate,
    )
}
