@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.aws.cognito.kotlin

import com.pulumi.aws.cognito.kotlin.outputs.UserPoolClientAnalyticsConfiguration
import com.pulumi.aws.cognito.kotlin.outputs.UserPoolClientTokenValidityUnits
import com.pulumi.core.Output
import com.pulumi.kotlin.KotlinCustomResource
import com.pulumi.kotlin.PulumiTagMarker
import com.pulumi.kotlin.ResourceMapper
import com.pulumi.kotlin.options.CustomResourceOptions
import com.pulumi.kotlin.options.CustomResourceOptionsBuilder
import com.pulumi.resources.Resource
import kotlin.Boolean
import kotlin.Int
import kotlin.String
import kotlin.Suppress
import kotlin.Unit
import kotlin.collections.List
import com.pulumi.aws.cognito.kotlin.outputs.UserPoolClientAnalyticsConfiguration.Companion.toKotlin as userPoolClientAnalyticsConfigurationToKotlin
import com.pulumi.aws.cognito.kotlin.outputs.UserPoolClientTokenValidityUnits.Companion.toKotlin as userPoolClientTokenValidityUnitsToKotlin

/**
 * Builder for [UserPoolClient].
 */
@PulumiTagMarker
public class UserPoolClientResourceBuilder internal constructor() {
    public var name: String? = null

    public var args: UserPoolClientArgs = UserPoolClientArgs()

    public var opts: CustomResourceOptions = CustomResourceOptions()

    /**
     * @param name The _unique_ name of the resulting resource.
     */
    public fun name(`value`: String) {
        this.name = value
    }

    /**
     * @param block The arguments to use to populate this resource's properties.
     */
    public suspend fun args(block: suspend UserPoolClientArgsBuilder.() -> Unit) {
        val builder = UserPoolClientArgsBuilder()
        block(builder)
        this.args = builder.build()
    }

    /**
     * @param block A bag of options that control this resource's behavior.
     */
    public suspend fun opts(block: suspend CustomResourceOptionsBuilder.() -> Unit) {
        this.opts = com.pulumi.kotlin.options.CustomResourceOptions.opts(block)
    }

    internal fun build(): UserPoolClient {
        val builtJavaResource = com.pulumi.aws.cognito.UserPoolClient(
            this.name,
            this.args.toJava(),
            this.opts.toJava(),
        )
        return UserPoolClient(builtJavaResource)
    }
}

/**
 * Provides a Cognito User Pool Client resource.
 * To manage a User Pool Client created by another service, such as when [configuring an OpenSearch Domain to use Cognito authentication](https://docs.aws.amazon.com/opensearch-service/latest/developerguide/cognito-auth.html),
 * use the `aws.cognito.ManagedUserPoolClient` resource instead.
 * ## Example Usage
 * ### Create a basic user pool client
 * <!--Start PulumiCodeChooser -->
 * ```typescript
 * import * as pulumi from "@pulumi/pulumi";
 * import * as aws from "@pulumi/aws";
 * const pool = new aws.cognito.UserPool("pool", {name: "pool"});
 * const client = new aws.cognito.UserPoolClient("client", {
 *     name: "client",
 *     userPoolId: pool.id,
 * });
 * ```
 * ```python
 * import pulumi
 * import pulumi_aws as aws
 * pool = aws.cognito.UserPool("pool", name="pool")
 * client = aws.cognito.UserPoolClient("client",
 *     name="client",
 *     user_pool_id=pool.id)
 * ```
 * ```csharp
 * using System.Collections.Generic;
 * using System.Linq;
 * using Pulumi;
 * using Aws = Pulumi.Aws;
 * return await Deployment.RunAsync(() =>
 * {
 *     var pool = new Aws.Cognito.UserPool("pool", new()
 *     {
 *         Name = "pool",
 *     });
 *     var client = new Aws.Cognito.UserPoolClient("client", new()
 *     {
 *         Name = "client",
 *         UserPoolId = pool.Id,
 *     });
 * });
 * ```
 * ```go
 * package main
 * import (
 * 	"github.com/pulumi/pulumi-aws/sdk/v6/go/aws/cognito"
 * 	"github.com/pulumi/pulumi/sdk/v3/go/pulumi"
 * )
 * func main() {
 * 	pulumi.Run(func(ctx *pulumi.Context) error {
 * 		pool, err := cognito.NewUserPool(ctx, "pool", &cognito.UserPoolArgs{
 * 			Name: pulumi.String("pool"),
 * 		})
 * 		if err != nil {
 * 			return err
 * 		}
 * 		_, err = cognito.NewUserPoolClient(ctx, "client", &cognito.UserPoolClientArgs{
 * 			Name:       pulumi.String("client"),
 * 			UserPoolId: pool.ID(),
 * 		})
 * 		if err != nil {
 * 			return err
 * 		}
 * 		return nil
 * 	})
 * }
 * ```
 * ```java
 * package generated_program;
 * import com.pulumi.Context;
 * import com.pulumi.Pulumi;
 * import com.pulumi.core.Output;
 * import com.pulumi.aws.cognito.UserPool;
 * import com.pulumi.aws.cognito.UserPoolArgs;
 * import com.pulumi.aws.cognito.UserPoolClient;
 * import com.pulumi.aws.cognito.UserPoolClientArgs;
 * import java.util.List;
 * import java.util.ArrayList;
 * import java.util.Map;
 * import java.io.File;
 * import java.nio.file.Files;
 * import java.nio.file.Paths;
 * public class App {
 *     public static void main(String[] args) {
 *         Pulumi.run(App::stack);
 *     }
 *     public static void stack(Context ctx) {
 *         var pool = new UserPool("pool", UserPoolArgs.builder()
 *             .name("pool")
 *             .build());
 *         var client = new UserPoolClient("client", UserPoolClientArgs.builder()
 *             .name("client")
 *             .userPoolId(pool.id())
 *             .build());
 *     }
 * }
 * ```
 * ```yaml
 * resources:
 *   client:
 *     type: aws:cognito:UserPoolClient
 *     properties:
 *       name: client
 *       userPoolId: ${pool.id}
 *   pool:
 *     type: aws:cognito:UserPool
 *     properties:
 *       name: pool
 * ```
 * <!--End PulumiCodeChooser -->
 * ### Create a user pool client with no SRP authentication
 * <!--Start PulumiCodeChooser -->
 * ```typescript
 * import * as pulumi from "@pulumi/pulumi";
 * import * as aws from "@pulumi/aws";
 * const pool = new aws.cognito.UserPool("pool", {name: "pool"});
 * const client = new aws.cognito.UserPoolClient("client", {
 *     name: "client",
 *     userPoolId: pool.id,
 *     generateSecret: true,
 *     explicitAuthFlows: ["ADMIN_NO_SRP_AUTH"],
 * });
 * ```
 * ```python
 * import pulumi
 * import pulumi_aws as aws
 * pool = aws.cognito.UserPool("pool", name="pool")
 * client = aws.cognito.UserPoolClient("client",
 *     name="client",
 *     user_pool_id=pool.id,
 *     generate_secret=True,
 *     explicit_auth_flows=["ADMIN_NO_SRP_AUTH"])
 * ```
 * ```csharp
 * using System.Collections.Generic;
 * using System.Linq;
 * using Pulumi;
 * using Aws = Pulumi.Aws;
 * return await Deployment.RunAsync(() =>
 * {
 *     var pool = new Aws.Cognito.UserPool("pool", new()
 *     {
 *         Name = "pool",
 *     });
 *     var client = new Aws.Cognito.UserPoolClient("client", new()
 *     {
 *         Name = "client",
 *         UserPoolId = pool.Id,
 *         GenerateSecret = true,
 *         ExplicitAuthFlows = new[]
 *         {
 *             "ADMIN_NO_SRP_AUTH",
 *         },
 *     });
 * });
 * ```
 * ```go
 * package main
 * import (
 * 	"github.com/pulumi/pulumi-aws/sdk/v6/go/aws/cognito"
 * 	"github.com/pulumi/pulumi/sdk/v3/go/pulumi"
 * )
 * func main() {
 * 	pulumi.Run(func(ctx *pulumi.Context) error {
 * 		pool, err := cognito.NewUserPool(ctx, "pool", &cognito.UserPoolArgs{
 * 			Name: pulumi.String("pool"),
 * 		})
 * 		if err != nil {
 * 			return err
 * 		}
 * 		_, err = cognito.NewUserPoolClient(ctx, "client", &cognito.UserPoolClientArgs{
 * 			Name:           pulumi.String("client"),
 * 			UserPoolId:     pool.ID(),
 * 			GenerateSecret: pulumi.Bool(true),
 * 			ExplicitAuthFlows: pulumi.StringArray{
 * 				pulumi.String("ADMIN_NO_SRP_AUTH"),
 * 			},
 * 		})
 * 		if err != nil {
 * 			return err
 * 		}
 * 		return nil
 * 	})
 * }
 * ```
 * ```java
 * package generated_program;
 * import com.pulumi.Context;
 * import com.pulumi.Pulumi;
 * import com.pulumi.core.Output;
 * import com.pulumi.aws.cognito.UserPool;
 * import com.pulumi.aws.cognito.UserPoolArgs;
 * import com.pulumi.aws.cognito.UserPoolClient;
 * import com.pulumi.aws.cognito.UserPoolClientArgs;
 * import java.util.List;
 * import java.util.ArrayList;
 * import java.util.Map;
 * import java.io.File;
 * import java.nio.file.Files;
 * import java.nio.file.Paths;
 * public class App {
 *     public static void main(String[] args) {
 *         Pulumi.run(App::stack);
 *     }
 *     public static void stack(Context ctx) {
 *         var pool = new UserPool("pool", UserPoolArgs.builder()
 *             .name("pool")
 *             .build());
 *         var client = new UserPoolClient("client", UserPoolClientArgs.builder()
 *             .name("client")
 *             .userPoolId(pool.id())
 *             .generateSecret(true)
 *             .explicitAuthFlows("ADMIN_NO_SRP_AUTH")
 *             .build());
 *     }
 * }
 * ```
 * ```yaml
 * resources:
 *   client:
 *     type: aws:cognito:UserPoolClient
 *     properties:
 *       name: client
 *       userPoolId: ${pool.id}
 *       generateSecret: true
 *       explicitAuthFlows:
 *         - ADMIN_NO_SRP_AUTH
 *   pool:
 *     type: aws:cognito:UserPool
 *     properties:
 *       name: pool
 * ```
 * <!--End PulumiCodeChooser -->
 * ### Create a user pool client with pinpoint analytics
 * <!--Start PulumiCodeChooser -->
 * ```typescript
 * import * as pulumi from "@pulumi/pulumi";
 * import * as aws from "@pulumi/aws";
 * const testUserPool = new aws.cognito.UserPool("test", {name: "pool"});
 * const testApp = new aws.pinpoint.App("test", {name: "pinpoint"});
 * const assumeRole = aws.iam.getPolicyDocument({
 *     statements: [{
 *         effect: "Allow",
 *         principals: [{
 *             type: "Service",
 *             identifiers: ["cognito-idp&#46;amazonaws&#46;com"],
 *         }],
 *         actions: ["sts:AssumeRole"],
 *     }],
 * });
 * const testRole = new aws.iam.Role("test", {
 *     name: "role",
 *     assumeRolePolicy: assumeRole.then(assumeRole => assumeRole.json),
 * });
 * const testUserPoolClient = new aws.cognito.UserPoolClient("test", {
 *     name: "pool_client",
 *     userPoolId: testUserPool.id,
 *     analyticsConfiguration: {
 *         applicationId: testApp.applicationId,
 *         externalId: "some_id",
 *         roleArn: testRole.arn,
 *         userDataShared: true,
 *     },
 * });
 * const current = aws.getCallerIdentity({});
 * const test = aws.iam.getPolicyDocumentOutput({
 *     statements: [{
 *         effect: "Allow",
 *         actions: [
 *             "mobiletargeting:UpdateEndpoint",
 *             "mobiletargeting:PutEvents",
 *         ],
 *         resources: [pulumi&#46;all([current, testApp&#46;applicationId])&#46;apply(([current, applicationId]) => `arn:aws:mobiletargeting:*:${current&#46;accountId}:apps/${applicationId}*`)],
 *     }],
 * });
 * const testRolePolicy = new aws.iam.RolePolicy("test", {
 *     name: "role_policy",
 *     role: testRole.id,
 *     policy: test.apply(test => test.json),
 * });
 * ```
 * ```python
 * import pulumi
 * import pulumi_aws as aws
 * test_user_pool = aws.cognito.UserPool("test", name="pool")
 * test_app = aws.pinpoint.App("test", name="pinpoint")
 * assume_role = aws.iam.get_policy_document(statements=[{
 *     "effect": "Allow",
 *     "principals": [{
 *         "type": "Service",
 *         "identifiers": ["cognito-idp&#46;amazonaws&#46;com"],
 *     }],
 *     "actions": ["sts:AssumeRole"],
 * }])
 * test_role = aws.iam.Role("test",
 *     name="role",
 *     assume_role_policy=assume_role.json)
 * test_user_pool_client = aws.cognito.UserPoolClient("test",
 *     name="pool_client",
 *     user_pool_id=test_user_pool.id,
 *     analytics_configuration={
 *         "application_id": test_app.application_id,
 *         "external_id": "some_id",
 *         "role_arn": test_role.arn,
 *         "user_data_shared": True,
 *     })
 * current = aws.get_caller_identity()
 * test = aws.iam.get_policy_document_output(statements=[{
 *     "effect": "Allow",
 *     "actions": [
 *         "mobiletargeting:UpdateEndpoint",
 *         "mobiletargeting:PutEvents",
 *     ],
 *     "resources": [test_app&#46;application_id&#46;apply(lambda application_id: f"arn:aws:mobiletargeting:*:{current&#46;account_id}:apps/{application_id}*")],
 * }])
 * test_role_policy = aws.iam.RolePolicy("test",
 *     name="role_policy",
 *     role=test_role.id,
 *     policy=test.json)
 * ```
 * ```csharp
 * using System.Collections.Generic;
 * using System.Linq;
 * using Pulumi;
 * using Aws = Pulumi.Aws;
 * return await Deployment.RunAsync(() =>
 * {
 *     var testUserPool = new Aws.Cognito.UserPool("test", new()
 *     {
 *         Name = "pool",
 *     });
 *     var testApp = new Aws.Pinpoint.App("test", new()
 *     {
 *         Name = "pinpoint",
 *     });
 *     var assumeRole = Aws.Iam.GetPolicyDocument.Invoke(new()
 *     {
 *         Statements = new[]
 *         {
 *             new Aws.Iam.Inputs.GetPolicyDocumentStatementInputArgs
 *             {
 *                 Effect = "Allow",
 *                 Principals = new[]
 *                 {
 *                     new Aws.Iam.Inputs.GetPolicyDocumentStatementPrincipalInputArgs
 *                     {
 *                         Type = "Service",
 *                         Identifiers = new[]
 *                         {
 *                             "cognito-idp.amazonaws.com",
 *                         },
 *                     },
 *                 },
 *                 Actions = new[]
 *                 {
 *                     "sts:AssumeRole",
 *                 },
 *             },
 *         },
 *     });
 *     var testRole = new Aws.Iam.Role("test", new()
 *     {
 *         Name = "role",
 *         AssumeRolePolicy = assumeRole.Apply(getPolicyDocumentResult => getPolicyDocumentResult.Json),
 *     });
 *     var testUserPoolClient = new Aws.Cognito.UserPoolClient("test", new()
 *     {
 *         Name = "pool_client",
 *         UserPoolId = testUserPool.Id,
 *         AnalyticsConfiguration = new Aws.Cognito.Inputs.UserPoolClientAnalyticsConfigurationArgs
 *         {
 *             ApplicationId = testApp.ApplicationId,
 *             ExternalId = "some_id",
 *             RoleArn = testRole.Arn,
 *             UserDataShared = true,
 *         },
 *     });
 *     var current = Aws.GetCallerIdentity.Invoke();
 *     var test = Aws.Iam.GetPolicyDocument.Invoke(new()
 *     {
 *         Statements = new[]
 *         {
 *             new Aws.Iam.Inputs.GetPolicyDocumentStatementInputArgs
 *             {
 *                 Effect = "Allow",
 *                 Actions = new[]
 *                 {
 *                     "mobiletargeting:UpdateEndpoint",
 *                     "mobiletargeting:PutEvents",
 *                 },
 *                 Resources = new[]
 *                 {
 *                     $"arn:aws:mobiletargeting:*:{current.Apply(getCallerIdentityResult => getCallerIdentityResult.AccountId)}:apps/{testApp.ApplicationId}*",
 *                 },
 *             },
 *         },
 *     });
 *     var testRolePolicy = new Aws.Iam.RolePolicy("test", new()
 *     {
 *         Name = "role_policy",
 *         Role = testRole.Id,
 *         Policy = test.Apply(getPolicyDocumentResult => getPolicyDocumentResult.Json),
 *     });
 * });
 * ```
 * ```go
 * package main
 * import (
 * 	"fmt"
 * 	"github.com/pulumi/pulumi-aws/sdk/v6/go/aws"
 * 	"github.com/pulumi/pulumi-aws/sdk/v6/go/aws/cognito"
 * 	"github.com/pulumi/pulumi-aws/sdk/v6/go/aws/iam"
 * 	"github.com/pulumi/pulumi-aws/sdk/v6/go/aws/pinpoint"
 * 	"github.com/pulumi/pulumi/sdk/v3/go/pulumi"
 * )
 * func main() {
 * 	pulumi.Run(func(ctx *pulumi.Context) error {
 * 		testUserPool, err := cognito.NewUserPool(ctx, "test", &cognito.UserPoolArgs{
 * 			Name: pulumi.String("pool"),
 * 		})
 * 		if err != nil {
 * 			return err
 * 		}
 * 		testApp, err := pinpoint.NewApp(ctx, "test", &pinpoint.AppArgs{
 * 			Name: pulumi.String("pinpoint"),
 * 		})
 * 		if err != nil {
 * 			return err
 * 		}
 * 		assumeRole, err := iam.GetPolicyDocument(ctx, &iam.GetPolicyDocumentArgs{
 * 			Statements: []iam.GetPolicyDocumentStatement{
 * 				{
 * 					Effect: pulumi.StringRef("Allow"),
 * 					Principals: []iam.GetPolicyDocumentStatementPrincipal{
 * 						{
 * 							Type: "Service",
 * 							Identifiers: []string{
 * 								"cognito-idp.amazonaws.com",
 * 							},
 * 						},
 * 					},
 * 					Actions: []string{
 * 						"sts:AssumeRole",
 * 					},
 * 				},
 * 			},
 * 		}, nil)
 * 		if err != nil {
 * 			return err
 * 		}
 * 		testRole, err := iam.NewRole(ctx, "test", &iam.RoleArgs{
 * 			Name:             pulumi.String("role"),
 * 			AssumeRolePolicy: pulumi.String(assumeRole.Json),
 * 		})
 * 		if err != nil {
 * 			return err
 * 		}
 * 		_, err = cognito.NewUserPoolClient(ctx, "test", &cognito.UserPoolClientArgs{
 * 			Name:       pulumi.String("pool_client"),
 * 			UserPoolId: testUserPool.ID(),
 * 			AnalyticsConfiguration: &cognito.UserPoolClientAnalyticsConfigurationArgs{
 * 				ApplicationId:  testApp.ApplicationId,
 * 				ExternalId:     pulumi.String("some_id"),
 * 				RoleArn:        testRole.Arn,
 * 				UserDataShared: pulumi.Bool(true),
 * 			},
 * 		})
 * 		if err != nil {
 * 			return err
 * 		}
 * 		current, err := aws.GetCallerIdentity(ctx, nil, nil)
 * 		if err != nil {
 * 			return err
 * 		}
 * 		test := iam.GetPolicyDocumentOutput(ctx, iam.GetPolicyDocumentOutputArgs{
 * 			Statements: iam.GetPolicyDocumentStatementArray{
 * 				&iam.GetPolicyDocumentStatementArgs{
 * 					Effect: pulumi.String("Allow"),
 * 					Actions: pulumi.StringArray{
 * 						pulumi.String("mobiletargeting:UpdateEndpoint"),
 * 						pulumi.String("mobiletargeting:PutEvents"),
 * 					},
 * 					Resources: pulumi.StringArray{
 * 						testApp.ApplicationId.ApplyT(func(applicationId string) (string, error) {
 * 							return fmt.Sprintf("arn:aws:mobiletargeting:*:%v:apps/%v*", current.AccountId, applicationId), nil
 * 						}).(pulumi.StringOutput),
 * 					},
 * 				},
 * 			},
 * 		}, nil)
 * 		_, err = iam.NewRolePolicy(ctx, "test", &iam.RolePolicyArgs{
 * 			Name: pulumi.String("role_policy"),
 * 			Role: testRole.ID(),
 * 			Policy: pulumi.String(test.ApplyT(func(test iam.GetPolicyDocumentResult) (*string, error) {
 * 				return &test.Json, nil
 * 			}).(pulumi.StringPtrOutput)),
 * 		})
 * 		if err != nil {
 * 			return err
 * 		}
 * 		return nil
 * 	})
 * }
 * ```
 * ```java
 * package generated_program;
 * import com.pulumi.Context;
 * import com.pulumi.Pulumi;
 * import com.pulumi.core.Output;
 * import com.pulumi.aws.cognito.UserPool;
 * import com.pulumi.aws.cognito.UserPoolArgs;
 * import com.pulumi.aws.pinpoint.App;
 * import com.pulumi.aws.pinpoint.AppArgs;
 * import com.pulumi.aws.iam.IamFunctions;
 * import com.pulumi.aws.iam.inputs.GetPolicyDocumentArgs;
 * import com.pulumi.aws.iam.Role;
 * import com.pulumi.aws.iam.RoleArgs;
 * import com.pulumi.aws.cognito.UserPoolClient;
 * import com.pulumi.aws.cognito.UserPoolClientArgs;
 * import com.pulumi.aws.cognito.inputs.UserPoolClientAnalyticsConfigurationArgs;
 * import com.pulumi.aws.AwsFunctions;
 * import com.pulumi.aws.inputs.GetCallerIdentityArgs;
 * import com.pulumi.aws.iam.RolePolicy;
 * import com.pulumi.aws.iam.RolePolicyArgs;
 * import java.util.List;
 * import java.util.ArrayList;
 * import java.util.Map;
 * import java.io.File;
 * import java.nio.file.Files;
 * import java.nio.file.Paths;
 * public class App {
 *     public static void main(String[] args) {
 *         Pulumi.run(App::stack);
 *     }
 *     public static void stack(Context ctx) {
 *         var testUserPool = new UserPool("testUserPool", UserPoolArgs.builder()
 *             .name("pool")
 *             .build());
 *         var testApp = new App("testApp", AppArgs.builder()
 *             .name("pinpoint")
 *             .build());
 *         final var assumeRole = IamFunctions.getPolicyDocument(GetPolicyDocumentArgs.builder()
 *             .statements(GetPolicyDocumentStatementArgs.builder()
 *                 .effect("Allow")
 *                 .principals(GetPolicyDocumentStatementPrincipalArgs.builder()
 *                     .type("Service")
 *                     .identifiers("cognito-idp.amazonaws.com")
 *                     .build())
 *                 .actions("sts:AssumeRole")
 *                 .build())
 *             .build());
 *         var testRole = new Role("testRole", RoleArgs.builder()
 *             .name("role")
 *             .assumeRolePolicy(assumeRole.applyValue(getPolicyDocumentResult -> getPolicyDocumentResult.json()))
 *             .build());
 *         var testUserPoolClient = new UserPoolClient("testUserPoolClient", UserPoolClientArgs.builder()
 *             .name("pool_client")
 *             .userPoolId(testUserPool.id())
 *             .analyticsConfiguration(UserPoolClientAnalyticsConfigurationArgs.builder()
 *                 .applicationId(testApp.applicationId())
 *                 .externalId("some_id")
 *                 .roleArn(testRole.arn())
 *                 .userDataShared(true)
 *                 .build())
 *             .build());
 *         final var current = AwsFunctions.getCallerIdentity();
 *         final var test = IamFunctions.getPolicyDocument(GetPolicyDocumentArgs.builder()
 *             .statements(GetPolicyDocumentStatementArgs.builder()
 *                 .effect("Allow")
 *                 .actions(
 *                     "mobiletargeting:UpdateEndpoint",
 *                     "mobiletargeting:PutEvents")
 *                 .resources(testApp.applicationId().applyValue(applicationId -> String.format("arn:aws:mobiletargeting:*:%s:apps/%s*", current.applyValue(getCallerIdentityResult -> getCallerIdentityResult.accountId()),applicationId)))
 *                 .build())
 *             .build());
 *         var testRolePolicy = new RolePolicy("testRolePolicy", RolePolicyArgs.builder()
 *             .name("role_policy")
 *             .role(testRole.id())
 *             .policy(test.applyValue(getPolicyDocumentResult -> getPolicyDocumentResult).applyValue(test -> test.applyValue(getPolicyDocumentResult -> getPolicyDocumentResult.json())))
 *             .build());
 *     }
 * }
 * ```
 * ```yaml
 * resources:
 *   testUserPoolClient:
 *     type: aws:cognito:UserPoolClient
 *     name: test
 *     properties:
 *       name: pool_client
 *       userPoolId: ${testUserPool.id}
 *       analyticsConfiguration:
 *         applicationId: ${testApp.applicationId}
 *         externalId: some_id
 *         roleArn: ${testRole.arn}
 *         userDataShared: true
 *   testUserPool:
 *     type: aws:cognito:UserPool
 *     name: test
 *     properties:
 *       name: pool
 *   testApp:
 *     type: aws:pinpoint:App
 *     name: test
 *     properties:
 *       name: pinpoint
 *   testRole:
 *     type: aws:iam:Role
 *     name: test
 *     properties:
 *       name: role
 *       assumeRolePolicy: ${assumeRole.json}
 *   testRolePolicy:
 *     type: aws:iam:RolePolicy
 *     name: test
 *     properties:
 *       name: role_policy
 *       role: ${testRole.id}
 *       policy: ${test.json}
 * variables:
 *   current:
 *     fn::invoke:
 *       Function: aws:getCallerIdentity
 *       Arguments: {}
 *   assumeRole:
 *     fn::invoke:
 *       Function: aws:iam:getPolicyDocument
 *       Arguments:
 *         statements:
 *           - effect: Allow
 *             principals:
 *               - type: Service
 *                 identifiers:
 *                   - cognito-idp.amazonaws.com
 *             actions:
 *               - sts:AssumeRole
 *   test:
 *     fn::invoke:
 *       Function: aws:iam:getPolicyDocument
 *       Arguments:
 *         statements:
 *           - effect: Allow
 *             actions:
 *               - mobiletargeting:UpdateEndpoint
 *               - mobiletargeting:PutEvents
 *             resources:
 *               - arn:aws:mobiletargeting:*:${current.accountId}:apps/${testApp.applicationId}*
 * ```
 * <!--End PulumiCodeChooser -->
 * ### Create a user pool client with Cognito as the identity provider
 * <!--Start PulumiCodeChooser -->
 * ```typescript
 * import * as pulumi from "@pulumi/pulumi";
 * import * as aws from "@pulumi/aws";
 * const pool = new aws.cognito.UserPool("pool", {name: "pool"});
 * const userpoolClient = new aws.cognito.UserPoolClient("userpool_client", {
 *     name: "client",
 *     userPoolId: pool.id,
 *     callbackUrls: ["https://example&#46;com"],
 *     allowedOauthFlowsUserPoolClient: true,
 *     allowedOauthFlows: [
 *         "code",
 *         "implicit",
 *     ],
 *     allowedOauthScopes: [
 *         "email",
 *         "openid",
 *     ],
 *     supportedIdentityProviders: ["COGNITO"],
 * });
 * ```
 * ```python
 * import pulumi
 * import pulumi_aws as aws
 * pool = aws.cognito.UserPool("pool", name="pool")
 * userpool_client = aws.cognito.UserPoolClient("userpool_client",
 *     name="client",
 *     user_pool_id=pool.id,
 *     callback_urls=["https://example&#46;com"],
 *     allowed_oauth_flows_user_pool_client=True,
 *     allowed_oauth_flows=[
 *         "code",
 *         "implicit",
 *     ],
 *     allowed_oauth_scopes=[
 *         "email",
 *         "openid",
 *     ],
 *     supported_identity_providers=["COGNITO"])
 * ```
 * ```csharp
 * using System.Collections.Generic;
 * using System.Linq;
 * using Pulumi;
 * using Aws = Pulumi.Aws;
 * return await Deployment.RunAsync(() =>
 * {
 *     var pool = new Aws.Cognito.UserPool("pool", new()
 *     {
 *         Name = "pool",
 *     });
 *     var userpoolClient = new Aws.Cognito.UserPoolClient("userpool_client", new()
 *     {
 *         Name = "client",
 *         UserPoolId = pool.Id,
 *         CallbackUrls = new[]
 *         {
 *             "https://example.com",
 *         },
 *         AllowedOauthFlowsUserPoolClient = true,
 *         AllowedOauthFlows = new[]
 *         {
 *             "code",
 *             "implicit",
 *         },
 *         AllowedOauthScopes = new[]
 *         {
 *             "email",
 *             "openid",
 *         },
 *         SupportedIdentityProviders = new[]
 *         {
 *             "COGNITO",
 *         },
 *     });
 * });
 * ```
 * ```go
 * package main
 * import (
 * 	"github.com/pulumi/pulumi-aws/sdk/v6/go/aws/cognito"
 * 	"github.com/pulumi/pulumi/sdk/v3/go/pulumi"
 * )
 * func main() {
 * 	pulumi.Run(func(ctx *pulumi.Context) error {
 * 		pool, err := cognito.NewUserPool(ctx, "pool", &cognito.UserPoolArgs{
 * 			Name: pulumi.String("pool"),
 * 		})
 * 		if err != nil {
 * 			return err
 * 		}
 * 		_, err = cognito.NewUserPoolClient(ctx, "userpool_client", &cognito.UserPoolClientArgs{
 * 			Name:       pulumi.String("client"),
 * 			UserPoolId: pool.ID(),
 * 			CallbackUrls: pulumi.StringArray{
 * 				pulumi.String("https://example.com"),
 * 			},
 * 			AllowedOauthFlowsUserPoolClient: pulumi.Bool(true),
 * 			AllowedOauthFlows: pulumi.StringArray{
 * 				pulumi.String("code"),
 * 				pulumi.String("implicit"),
 * 			},
 * 			AllowedOauthScopes: pulumi.StringArray{
 * 				pulumi.String("email"),
 * 				pulumi.String("openid"),
 * 			},
 * 			SupportedIdentityProviders: pulumi.StringArray{
 * 				pulumi.String("COGNITO"),
 * 			},
 * 		})
 * 		if err != nil {
 * 			return err
 * 		}
 * 		return nil
 * 	})
 * }
 * ```
 * ```java
 * package generated_program;
 * import com.pulumi.Context;
 * import com.pulumi.Pulumi;
 * import com.pulumi.core.Output;
 * import com.pulumi.aws.cognito.UserPool;
 * import com.pulumi.aws.cognito.UserPoolArgs;
 * import com.pulumi.aws.cognito.UserPoolClient;
 * import com.pulumi.aws.cognito.UserPoolClientArgs;
 * import java.util.List;
 * import java.util.ArrayList;
 * import java.util.Map;
 * import java.io.File;
 * import java.nio.file.Files;
 * import java.nio.file.Paths;
 * public class App {
 *     public static void main(String[] args) {
 *         Pulumi.run(App::stack);
 *     }
 *     public static void stack(Context ctx) {
 *         var pool = new UserPool("pool", UserPoolArgs.builder()
 *             .name("pool")
 *             .build());
 *         var userpoolClient = new UserPoolClient("userpoolClient", UserPoolClientArgs.builder()
 *             .name("client")
 *             .userPoolId(pool.id())
 *             .callbackUrls("https://example.com")
 *             .allowedOauthFlowsUserPoolClient(true)
 *             .allowedOauthFlows(
 *                 "code",
 *                 "implicit")
 *             .allowedOauthScopes(
 *                 "email",
 *                 "openid")
 *             .supportedIdentityProviders("COGNITO")
 *             .build());
 *     }
 * }
 * ```
 * ```yaml
 * resources:
 *   userpoolClient:
 *     type: aws:cognito:UserPoolClient
 *     name: userpool_client
 *     properties:
 *       name: client
 *       userPoolId: ${pool.id}
 *       callbackUrls:
 *         - https://example.com
 *       allowedOauthFlowsUserPoolClient: true
 *       allowedOauthFlows:
 *         - code
 *         - implicit
 *       allowedOauthScopes:
 *         - email
 *         - openid
 *       supportedIdentityProviders:
 *         - COGNITO
 *   pool:
 *     type: aws:cognito:UserPool
 *     properties:
 *       name: pool
 * ```
 * <!--End PulumiCodeChooser -->
 * ## Import
 * Using `pulumi import`, import Cognito User Pool Clients using the `id` of the Cognito User Pool, and the `id` of the Cognito User Pool Client. For example:
 * ```sh
 * $ pulumi import aws:cognito/userPoolClient:UserPoolClient client us-west-2_abc123/3ho4ek12345678909nh3fmhpko
 * ```
 */
public class UserPoolClient internal constructor(
    override val javaResource: com.pulumi.aws.cognito.UserPoolClient,
) : KotlinCustomResource(javaResource, UserPoolClientMapper) {
    /**
     * Time limit, between 5 minutes and 1 day, after which the access token is no longer valid and cannot be used.
     * By default, the unit is hours.
     * The unit can be overridden by a value in `token_validity_units.access_token`.
     */
    public val accessTokenValidity: Output<Int>
        get() = javaResource.accessTokenValidity().applyValue({ args0 -> args0 })

    /**
     * List of allowed OAuth flows (code, implicit, client_credentials).
     */
    public val allowedOauthFlows: Output<List<String>>
        get() = javaResource.allowedOauthFlows().applyValue({ args0 -> args0.map({ args0 -> args0 }) })

    /**
     * Whether the client is allowed to follow the OAuth protocol when interacting with Cognito user pools.
     */
    public val allowedOauthFlowsUserPoolClient: Output<Boolean>
        get() = javaResource.allowedOauthFlowsUserPoolClient().applyValue({ args0 -> args0 })

    /**
     * List of allowed OAuth scopes (phone, email, openid, profile, and aws.cognito.signin.user.admin).
     */
    public val allowedOauthScopes: Output<List<String>>
        get() = javaResource.allowedOauthScopes().applyValue({ args0 -> args0.map({ args0 -> args0 }) })

    /**
     * Configuration block for Amazon Pinpoint analytics for collecting metrics for this user pool. Detailed below.
     */
    public val analyticsConfiguration: Output<UserPoolClientAnalyticsConfiguration>?
        get() = javaResource.analyticsConfiguration().applyValue({ args0 ->
            args0.map({ args0 ->
                args0.let({ args0 -> userPoolClientAnalyticsConfigurationToKotlin(args0) })
            }).orElse(null)
        })

    /**
     * Amazon Cognito creates a session token for each API request in an authentication flow. AuthSessionValidity is the duration, in minutes, of that session token. Your user pool native user must respond to each authentication challenge before the session expires. Valid values between `3` and `15`. Default value is `3`.
     */
    public val authSessionValidity: Output<Int>
        get() = javaResource.authSessionValidity().applyValue({ args0 -> args0 })

    /**
     * List of allowed callback URLs for the identity providers.
     */
    public val callbackUrls: Output<List<String>>
        get() = javaResource.callbackUrls().applyValue({ args0 -> args0.map({ args0 -> args0 }) })

    /**
     * Client secret of the user pool client.
     */
    public val clientSecret: Output<String>
        get() = javaResource.clientSecret().applyValue({ args0 -> args0 })

    /**
     * Default redirect URI. Must be in the list of callback URLs.
     */
    public val defaultRedirectUri: Output<String>
        get() = javaResource.defaultRedirectUri().applyValue({ args0 -> args0 })

    /**
     * Activates the propagation of additional user context data.
     */
    public val enablePropagateAdditionalUserContextData: Output<Boolean>
        get() = javaResource.enablePropagateAdditionalUserContextData().applyValue({ args0 -> args0 })

    /**
     * Enables or disables token revocation.
     */
    public val enableTokenRevocation: Output<Boolean>
        get() = javaResource.enableTokenRevocation().applyValue({ args0 -> args0 })

    /**
     * List of authentication flows (ADMIN_NO_SRP_AUTH, CUSTOM_AUTH_FLOW_ONLY, USER_PASSWORD_AUTH, ALLOW_ADMIN_USER_PASSWORD_AUTH, ALLOW_CUSTOM_AUTH, ALLOW_USER_PASSWORD_AUTH, ALLOW_USER_SRP_AUTH, ALLOW_REFRESH_TOKEN_AUTH).
     */
    public val explicitAuthFlows: Output<List<String>>
        get() = javaResource.explicitAuthFlows().applyValue({ args0 -> args0.map({ args0 -> args0 }) })

    /**
     * Should an application secret be generated.
     */
    public val generateSecret: Output<Boolean>?
        get() = javaResource.generateSecret().applyValue({ args0 ->
            args0.map({ args0 ->
                args0
            }).orElse(null)
        })

    /**
     * Time limit, between 5 minutes and 1 day, after which the ID token is no longer valid and cannot be used.
     * By default, the unit is hours.
     * The unit can be overridden by a value in `token_validity_units.id_token`.
     */
    public val idTokenValidity: Output<Int>
        get() = javaResource.idTokenValidity().applyValue({ args0 -> args0 })

    /**
     * List of allowed logout URLs for the identity providers.
     */
    public val logoutUrls: Output<List<String>>
        get() = javaResource.logoutUrls().applyValue({ args0 -> args0.map({ args0 -> args0 }) })

    /**
     * Name of the application client.
     */
    public val name: Output<String>
        get() = javaResource.name().applyValue({ args0 -> args0 })

    /**
     * Choose which errors and responses are returned by Cognito APIs during authentication, account confirmation, and password recovery when the user does not exist in the user pool. When set to `ENABLED` and the user does not exist, authentication returns an error indicating either the username or password was incorrect, and account confirmation and password recovery return a response indicating a code was sent to a simulated destination. When set to `LEGACY`, those APIs will return a `UserNotFoundException` exception if the user does not exist in the user pool.
     */
    public val preventUserExistenceErrors: Output<String>
        get() = javaResource.preventUserExistenceErrors().applyValue({ args0 -> args0 })

    /**
     * List of user pool attributes the application client can read from.
     */
    public val readAttributes: Output<List<String>>
        get() = javaResource.readAttributes().applyValue({ args0 -> args0.map({ args0 -> args0 }) })

    /**
     * Time limit, between 60 minutes and 10 years, after which the refresh token is no longer valid and cannot be used.
     * By default, the unit is days.
     * The unit can be overridden by a value in `token_validity_units.refresh_token`.
     */
    public val refreshTokenValidity: Output<Int>
        get() = javaResource.refreshTokenValidity().applyValue({ args0 -> args0 })

    /**
     * List of provider names for the identity providers that are supported on this client. Uses the `provider_name` attribute of `aws.cognito.IdentityProvider` resource(s), or the equivalent string(s).
     */
    public val supportedIdentityProviders: Output<List<String>>
        get() = javaResource.supportedIdentityProviders().applyValue({ args0 ->
            args0.map({ args0 ->
                args0
            })
        })

    /**
     * Configuration block for units in which the validity times are represented in. Detailed below.
     */
    public val tokenValidityUnits: Output<UserPoolClientTokenValidityUnits>?
        get() = javaResource.tokenValidityUnits().applyValue({ args0 ->
            args0.map({ args0 ->
                args0.let({ args0 -> userPoolClientTokenValidityUnitsToKotlin(args0) })
            }).orElse(null)
        })

    /**
     * User pool the client belongs to.
     * The following arguments are optional:
     */
    public val userPoolId: Output<String>
        get() = javaResource.userPoolId().applyValue({ args0 -> args0 })

    /**
     * List of user pool attributes the application client can write to.
     */
    public val writeAttributes: Output<List<String>>
        get() = javaResource.writeAttributes().applyValue({ args0 -> args0.map({ args0 -> args0 }) })
}

public object UserPoolClientMapper : ResourceMapper<UserPoolClient> {
    override fun supportsMappingOfType(javaResource: Resource): Boolean =
        com.pulumi.aws.cognito.UserPoolClient::class == javaResource::class

    override fun map(javaResource: Resource): UserPoolClient = UserPoolClient(
        javaResource as
            com.pulumi.aws.cognito.UserPoolClient,
    )
}

/**
 * @see [UserPoolClient].
 * @param name The _unique_ name of the resulting resource.
 * @param block Builder for [UserPoolClient].
 */
public suspend fun userPoolClient(
    name: String,
    block: suspend UserPoolClientResourceBuilder.() -> Unit,
): UserPoolClient {
    val builder = UserPoolClientResourceBuilder()
    builder.name(name)
    block(builder)
    return builder.build()
}

/**
 * @see [UserPoolClient].
 * @param name The _unique_ name of the resulting resource.
 */
public fun userPoolClient(name: String): UserPoolClient {
    val builder = UserPoolClientResourceBuilder()
    builder.name(name)
    return builder.build()
}
