@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.aws.cognito.kotlin

import com.pulumi.core.Output
import com.pulumi.kotlin.KotlinCustomResource
import com.pulumi.kotlin.PulumiTagMarker
import com.pulumi.kotlin.ResourceMapper
import com.pulumi.kotlin.options.CustomResourceOptions
import com.pulumi.kotlin.options.CustomResourceOptionsBuilder
import com.pulumi.resources.Resource
import kotlin.Boolean
import kotlin.String
import kotlin.Suppress
import kotlin.Unit

/**
 * Builder for [UserPoolDomain].
 */
@PulumiTagMarker
public class UserPoolDomainResourceBuilder internal constructor() {
    public var name: String? = null

    public var args: UserPoolDomainArgs = UserPoolDomainArgs()

    public var opts: CustomResourceOptions = CustomResourceOptions()

    /**
     * @param name The _unique_ name of the resulting resource.
     */
    public fun name(`value`: String) {
        this.name = value
    }

    /**
     * @param block The arguments to use to populate this resource's properties.
     */
    public suspend fun args(block: suspend UserPoolDomainArgsBuilder.() -> Unit) {
        val builder = UserPoolDomainArgsBuilder()
        block(builder)
        this.args = builder.build()
    }

    /**
     * @param block A bag of options that control this resource's behavior.
     */
    public suspend fun opts(block: suspend CustomResourceOptionsBuilder.() -> Unit) {
        this.opts = com.pulumi.kotlin.options.CustomResourceOptions.opts(block)
    }

    internal fun build(): UserPoolDomain {
        val builtJavaResource = com.pulumi.aws.cognito.UserPoolDomain(
            this.name,
            this.args.toJava(),
            this.opts.toJava(),
        )
        return UserPoolDomain(builtJavaResource)
    }
}

/**
 * Provides a Cognito User Pool Domain resource.
 * ## Example Usage
 * ### Amazon Cognito domain
 * <!--Start PulumiCodeChooser -->
 * ```typescript
 * import * as pulumi from "@pulumi/pulumi";
 * import * as aws from "@pulumi/aws";
 * const example = new aws.cognito.UserPool("example", {name: "example-pool"});
 * const main = new aws.cognito.UserPoolDomain("main", {
 *     domain: "example-domain",
 *     userPoolId: example.id,
 * });
 * ```
 * ```python
 * import pulumi
 * import pulumi_aws as aws
 * example = aws.cognito.UserPool("example", name="example-pool")
 * main = aws.cognito.UserPoolDomain("main",
 *     domain="example-domain",
 *     user_pool_id=example.id)
 * ```
 * ```csharp
 * using System.Collections.Generic;
 * using System.Linq;
 * using Pulumi;
 * using Aws = Pulumi.Aws;
 * return await Deployment.RunAsync(() =>
 * {
 *     var example = new Aws.Cognito.UserPool("example", new()
 *     {
 *         Name = "example-pool",
 *     });
 *     var main = new Aws.Cognito.UserPoolDomain("main", new()
 *     {
 *         Domain = "example-domain",
 *         UserPoolId = example.Id,
 *     });
 * });
 * ```
 * ```go
 * package main
 * import (
 * 	"github.com/pulumi/pulumi-aws/sdk/v6/go/aws/cognito"
 * 	"github.com/pulumi/pulumi/sdk/v3/go/pulumi"
 * )
 * func main() {
 * 	pulumi.Run(func(ctx *pulumi.Context) error {
 * 		example, err := cognito.NewUserPool(ctx, "example", &cognito.UserPoolArgs{
 * 			Name: pulumi.String("example-pool"),
 * 		})
 * 		if err != nil {
 * 			return err
 * 		}
 * 		_, err = cognito.NewUserPoolDomain(ctx, "main", &cognito.UserPoolDomainArgs{
 * 			Domain:     pulumi.String("example-domain"),
 * 			UserPoolId: example.ID(),
 * 		})
 * 		if err != nil {
 * 			return err
 * 		}
 * 		return nil
 * 	})
 * }
 * ```
 * ```java
 * package generated_program;
 * import com.pulumi.Context;
 * import com.pulumi.Pulumi;
 * import com.pulumi.core.Output;
 * import com.pulumi.aws.cognito.UserPool;
 * import com.pulumi.aws.cognito.UserPoolArgs;
 * import com.pulumi.aws.cognito.UserPoolDomain;
 * import com.pulumi.aws.cognito.UserPoolDomainArgs;
 * import java.util.List;
 * import java.util.ArrayList;
 * import java.util.Map;
 * import java.io.File;
 * import java.nio.file.Files;
 * import java.nio.file.Paths;
 * public class App {
 *     public static void main(String[] args) {
 *         Pulumi.run(App::stack);
 *     }
 *     public static void stack(Context ctx) {
 *         var example = new UserPool("example", UserPoolArgs.builder()
 *             .name("example-pool")
 *             .build());
 *         var main = new UserPoolDomain("main", UserPoolDomainArgs.builder()
 *             .domain("example-domain")
 *             .userPoolId(example.id())
 *             .build());
 *     }
 * }
 * ```
 * ```yaml
 * resources:
 *   main:
 *     type: aws:cognito:UserPoolDomain
 *     properties:
 *       domain: example-domain
 *       userPoolId: ${example.id}
 *   example:
 *     type: aws:cognito:UserPool
 *     properties:
 *       name: example-pool
 * ```
 * <!--End PulumiCodeChooser -->
 * ### Custom Cognito domain
 * <!--Start PulumiCodeChooser -->
 * ```typescript
 * import * as pulumi from "@pulumi/pulumi";
 * import * as aws from "@pulumi/aws";
 * const exampleUserPool = new aws.cognito.UserPool("example", {name: "example-pool"});
 * const main = new aws.cognito.UserPoolDomain("main", {
 *     domain: "example-domain",
 *     certificateArn: cert.arn,
 *     userPoolId: exampleUserPool.id,
 * });
 * const example = aws.route53.getZone({
 *     name: "example.com",
 * });
 * const auth_cognito_A = new aws.route53.Record("auth-cognito-A", {
 *     name: main.domain,
 *     type: aws.route53.RecordType.A,
 *     zoneId: example.then(example => example.zoneId),
 *     aliases: [{
 *         evaluateTargetHealth: false,
 *         name: main.cloudfrontDistribution,
 *         zoneId: main.cloudfrontDistributionZoneId,
 *     }],
 * });
 * ```
 * ```python
 * import pulumi
 * import pulumi_aws as aws
 * example_user_pool = aws.cognito.UserPool("example", name="example-pool")
 * main = aws.cognito.UserPoolDomain("main",
 *     domain="example-domain",
 *     certificate_arn=cert["arn"],
 *     user_pool_id=example_user_pool.id)
 * example = aws.route53.get_zone(name="example.com")
 * auth_cognito__a = aws.route53.Record("auth-cognito-A",
 *     name=main.domain,
 *     type=aws.route53.RecordType.A,
 *     zone_id=example.zone_id,
 *     aliases=[{
 *         "evaluate_target_health": False,
 *         "name": main.cloudfront_distribution,
 *         "zone_id": main.cloudfront_distribution_zone_id,
 *     }])
 * ```
 * ```csharp
 * using System.Collections.Generic;
 * using System.Linq;
 * using Pulumi;
 * using Aws = Pulumi.Aws;
 * return await Deployment.RunAsync(() =>
 * {
 *     var exampleUserPool = new Aws.Cognito.UserPool("example", new()
 *     {
 *         Name = "example-pool",
 *     });
 *     var main = new Aws.Cognito.UserPoolDomain("main", new()
 *     {
 *         Domain = "example-domain",
 *         CertificateArn = cert.Arn,
 *         UserPoolId = exampleUserPool.Id,
 *     });
 *     var example = Aws.Route53.GetZone.Invoke(new()
 *     {
 *         Name = "example.com",
 *     });
 *     var auth_cognito_A = new Aws.Route53.Record("auth-cognito-A", new()
 *     {
 *         Name = main.Domain,
 *         Type = Aws.Route53.RecordType.A,
 *         ZoneId = example.Apply(getZoneResult => getZoneResult.ZoneId),
 *         Aliases = new[]
 *         {
 *             new Aws.Route53.Inputs.RecordAliasArgs
 *             {
 *                 EvaluateTargetHealth = false,
 *                 Name = main.CloudfrontDistribution,
 *                 ZoneId = main.CloudfrontDistributionZoneId,
 *             },
 *         },
 *     });
 * });
 * ```
 * ```go
 * package main
 * import (
 * 	"github.com/pulumi/pulumi-aws/sdk/v6/go/aws/cognito"
 * 	"github.com/pulumi/pulumi-aws/sdk/v6/go/aws/route53"
 * 	"github.com/pulumi/pulumi/sdk/v3/go/pulumi"
 * )
 * func main() {
 * 	pulumi.Run(func(ctx *pulumi.Context) error {
 * 		exampleUserPool, err := cognito.NewUserPool(ctx, "example", &cognito.UserPoolArgs{
 * 			Name: pulumi.String("example-pool"),
 * 		})
 * 		if err != nil {
 * 			return err
 * 		}
 * 		main, err := cognito.NewUserPoolDomain(ctx, "main", &cognito.UserPoolDomainArgs{
 * 			Domain:         pulumi.String("example-domain"),
 * 			CertificateArn: pulumi.Any(cert.Arn),
 * 			UserPoolId:     exampleUserPool.ID(),
 * 		})
 * 		if err != nil {
 * 			return err
 * 		}
 * 		example, err := route53.LookupZone(ctx, &route53.LookupZoneArgs{
 * 			Name: pulumi.StringRef("example.com"),
 * 		}, nil)
 * 		if err != nil {
 * 			return err
 * 		}
 * 		_, err = route53.NewRecord(ctx, "auth-cognito-A", &route53.RecordArgs{
 * 			Name:   main.Domain,
 * 			Type:   pulumi.String(route53.RecordTypeA),
 * 			ZoneId: pulumi.String(example.ZoneId),
 * 			Aliases: route53.RecordAliasArray{
 * 				&route53.RecordAliasArgs{
 * 					EvaluateTargetHealth: pulumi.Bool(false),
 * 					Name:                 main.CloudfrontDistribution,
 * 					ZoneId:               main.CloudfrontDistributionZoneId,
 * 				},
 * 			},
 * 		})
 * 		if err != nil {
 * 			return err
 * 		}
 * 		return nil
 * 	})
 * }
 * ```
 * ```java
 * package generated_program;
 * import com.pulumi.Context;
 * import com.pulumi.Pulumi;
 * import com.pulumi.core.Output;
 * import com.pulumi.aws.cognito.UserPool;
 * import com.pulumi.aws.cognito.UserPoolArgs;
 * import com.pulumi.aws.cognito.UserPoolDomain;
 * import com.pulumi.aws.cognito.UserPoolDomainArgs;
 * import com.pulumi.aws.route53.Route53Functions;
 * import com.pulumi.aws.route53.inputs.GetZoneArgs;
 * import com.pulumi.aws.route53.Record;
 * import com.pulumi.aws.route53.RecordArgs;
 * import com.pulumi.aws.route53.inputs.RecordAliasArgs;
 * import java.util.List;
 * import java.util.ArrayList;
 * import java.util.Map;
 * import java.io.File;
 * import java.nio.file.Files;
 * import java.nio.file.Paths;
 * public class App {
 *     public static void main(String[] args) {
 *         Pulumi.run(App::stack);
 *     }
 *     public static void stack(Context ctx) {
 *         var exampleUserPool = new UserPool("exampleUserPool", UserPoolArgs.builder()
 *             .name("example-pool")
 *             .build());
 *         var main = new UserPoolDomain("main", UserPoolDomainArgs.builder()
 *             .domain("example-domain")
 *             .certificateArn(cert.arn())
 *             .userPoolId(exampleUserPool.id())
 *             .build());
 *         final var example = Route53Functions.getZone(GetZoneArgs.builder()
 *             .name("example.com")
 *             .build());
 *         var auth_cognito_A = new Record("auth-cognito-A", RecordArgs.builder()
 *             .name(main.domain())
 *             .type("A")
 *             .zoneId(example.applyValue(getZoneResult -> getZoneResult.zoneId()))
 *             .aliases(RecordAliasArgs.builder()
 *                 .evaluateTargetHealth(false)
 *                 .name(main.cloudfrontDistribution())
 *                 .zoneId(main.cloudfrontDistributionZoneId())
 *                 .build())
 *             .build());
 *     }
 * }
 * ```
 * ```yaml
 * resources:
 *   main:
 *     type: aws:cognito:UserPoolDomain
 *     properties:
 *       domain: example-domain
 *       certificateArn: ${cert.arn}
 *       userPoolId: ${exampleUserPool.id}
 *   exampleUserPool:
 *     type: aws:cognito:UserPool
 *     name: example
 *     properties:
 *       name: example-pool
 *   auth-cognito-A:
 *     type: aws:route53:Record
 *     properties:
 *       name: ${main.domain}
 *       type: A
 *       zoneId: ${example.zoneId}
 *       aliases:
 *         - evaluateTargetHealth: false
 *           name: ${main.cloudfrontDistribution}
 *           zoneId: ${main.cloudfrontDistributionZoneId}
 * variables:
 *   example:
 *     fn::invoke:
 *       Function: aws:route53:getZone
 *       Arguments:
 *         name: example.com
 * ```
 * <!--End PulumiCodeChooser -->
 * ## Import
 * Using `pulumi import`, import Cognito User Pool Domains using the `domain`. For example:
 * ```sh
 * $ pulumi import aws:cognito/userPoolDomain:UserPoolDomain main auth.example.org
 * ```
 */
public class UserPoolDomain internal constructor(
    override val javaResource: com.pulumi.aws.cognito.UserPoolDomain,
) : KotlinCustomResource(javaResource, UserPoolDomainMapper) {
    /**
     * The AWS account ID for the user pool owner.
     */
    public val awsAccountId: Output<String>
        get() = javaResource.awsAccountId().applyValue({ args0 -> args0 })

    /**
     * The ARN of an ISSUED ACM certificate in us-east-1 for a custom domain.
     */
    public val certificateArn: Output<String>?
        get() = javaResource.certificateArn().applyValue({ args0 ->
            args0.map({ args0 ->
                args0
            }).orElse(null)
        })

    /**
     * The Amazon CloudFront endpoint (e.g. `dpp0gtxikpq3y.cloudfront.net`) that you use as the target of the alias that you set up with your Domain Name Service (DNS) provider.
     */
    public val cloudfrontDistribution: Output<String>
        get() = javaResource.cloudfrontDistribution().applyValue({ args0 -> args0 })

    /**
     * The URL of the CloudFront distribution. This is required to generate the ALIAS `aws.route53.Record`
     */
    public val cloudfrontDistributionArn: Output<String>
        get() = javaResource.cloudfrontDistributionArn().applyValue({ args0 -> args0 })

    /**
     * The Route 53 hosted zone ID of the CloudFront distribution.
     */
    public val cloudfrontDistributionZoneId: Output<String>
        get() = javaResource.cloudfrontDistributionZoneId().applyValue({ args0 -> args0 })

    /**
     * For custom domains, this is the fully-qualified domain name, such as auth.example.com. For Amazon Cognito prefix domains, this is the prefix alone, such as auth.
     */
    public val domain: Output<String>
        get() = javaResource.domain().applyValue({ args0 -> args0 })

    /**
     * The S3 bucket where the static files for this domain are stored.
     */
    public val s3Bucket: Output<String>
        get() = javaResource.s3Bucket().applyValue({ args0 -> args0 })

    /**
     * The user pool ID.
     */
    public val userPoolId: Output<String>
        get() = javaResource.userPoolId().applyValue({ args0 -> args0 })

    /**
     * The app version.
     */
    public val version: Output<String>
        get() = javaResource.version().applyValue({ args0 -> args0 })
}

public object UserPoolDomainMapper : ResourceMapper<UserPoolDomain> {
    override fun supportsMappingOfType(javaResource: Resource): Boolean =
        com.pulumi.aws.cognito.UserPoolDomain::class == javaResource::class

    override fun map(javaResource: Resource): UserPoolDomain = UserPoolDomain(
        javaResource as
            com.pulumi.aws.cognito.UserPoolDomain,
    )
}

/**
 * @see [UserPoolDomain].
 * @param name The _unique_ name of the resulting resource.
 * @param block Builder for [UserPoolDomain].
 */
public suspend fun userPoolDomain(
    name: String,
    block: suspend UserPoolDomainResourceBuilder.() -> Unit,
): UserPoolDomain {
    val builder = UserPoolDomainResourceBuilder()
    builder.name(name)
    block(builder)
    return builder.build()
}

/**
 * @see [UserPoolDomain].
 * @param name The _unique_ name of the resulting resource.
 */
public fun userPoolDomain(name: String): UserPoolDomain {
    val builder = UserPoolDomainResourceBuilder()
    builder.name(name)
    return builder.build()
}
