@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.aws.cognito.kotlin

import com.pulumi.aws.cognito.UserPoolDomainArgs.builder
import com.pulumi.core.Output
import com.pulumi.core.Output.of
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiTagMarker
import kotlin.String
import kotlin.Suppress
import kotlin.jvm.JvmName

/**
 * Provides a Cognito User Pool Domain resource.
 * ## Example Usage
 * ### Amazon Cognito domain
 * <!--Start PulumiCodeChooser -->
 * ```typescript
 * import * as pulumi from "@pulumi/pulumi";
 * import * as aws from "@pulumi/aws";
 * const example = new aws.cognito.UserPool("example", {name: "example-pool"});
 * const main = new aws.cognito.UserPoolDomain("main", {
 *     domain: "example-domain",
 *     userPoolId: example.id,
 * });
 * ```
 * ```python
 * import pulumi
 * import pulumi_aws as aws
 * example = aws.cognito.UserPool("example", name="example-pool")
 * main = aws.cognito.UserPoolDomain("main",
 *     domain="example-domain",
 *     user_pool_id=example.id)
 * ```
 * ```csharp
 * using System.Collections.Generic;
 * using System.Linq;
 * using Pulumi;
 * using Aws = Pulumi.Aws;
 * return await Deployment.RunAsync(() =>
 * {
 *     var example = new Aws.Cognito.UserPool("example", new()
 *     {
 *         Name = "example-pool",
 *     });
 *     var main = new Aws.Cognito.UserPoolDomain("main", new()
 *     {
 *         Domain = "example-domain",
 *         UserPoolId = example.Id,
 *     });
 * });
 * ```
 * ```go
 * package main
 * import (
 * 	"github.com/pulumi/pulumi-aws/sdk/v6/go/aws/cognito"
 * 	"github.com/pulumi/pulumi/sdk/v3/go/pulumi"
 * )
 * func main() {
 * 	pulumi.Run(func(ctx *pulumi.Context) error {
 * 		example, err := cognito.NewUserPool(ctx, "example", &cognito.UserPoolArgs{
 * 			Name: pulumi.String("example-pool"),
 * 		})
 * 		if err != nil {
 * 			return err
 * 		}
 * 		_, err = cognito.NewUserPoolDomain(ctx, "main", &cognito.UserPoolDomainArgs{
 * 			Domain:     pulumi.String("example-domain"),
 * 			UserPoolId: example.ID(),
 * 		})
 * 		if err != nil {
 * 			return err
 * 		}
 * 		return nil
 * 	})
 * }
 * ```
 * ```java
 * package generated_program;
 * import com.pulumi.Context;
 * import com.pulumi.Pulumi;
 * import com.pulumi.core.Output;
 * import com.pulumi.aws.cognito.UserPool;
 * import com.pulumi.aws.cognito.UserPoolArgs;
 * import com.pulumi.aws.cognito.UserPoolDomain;
 * import com.pulumi.aws.cognito.UserPoolDomainArgs;
 * import java.util.List;
 * import java.util.ArrayList;
 * import java.util.Map;
 * import java.io.File;
 * import java.nio.file.Files;
 * import java.nio.file.Paths;
 * public class App {
 *     public static void main(String[] args) {
 *         Pulumi.run(App::stack);
 *     }
 *     public static void stack(Context ctx) {
 *         var example = new UserPool("example", UserPoolArgs.builder()
 *             .name("example-pool")
 *             .build());
 *         var main = new UserPoolDomain("main", UserPoolDomainArgs.builder()
 *             .domain("example-domain")
 *             .userPoolId(example.id())
 *             .build());
 *     }
 * }
 * ```
 * ```yaml
 * resources:
 *   main:
 *     type: aws:cognito:UserPoolDomain
 *     properties:
 *       domain: example-domain
 *       userPoolId: ${example.id}
 *   example:
 *     type: aws:cognito:UserPool
 *     properties:
 *       name: example-pool
 * ```
 * <!--End PulumiCodeChooser -->
 * ### Custom Cognito domain
 * <!--Start PulumiCodeChooser -->
 * ```typescript
 * import * as pulumi from "@pulumi/pulumi";
 * import * as aws from "@pulumi/aws";
 * const exampleUserPool = new aws.cognito.UserPool("example", {name: "example-pool"});
 * const main = new aws.cognito.UserPoolDomain("main", {
 *     domain: "example-domain",
 *     certificateArn: cert.arn,
 *     userPoolId: exampleUserPool.id,
 * });
 * const example = aws.route53.getZone({
 *     name: "example.com",
 * });
 * const auth_cognito_A = new aws.route53.Record("auth-cognito-A", {
 *     name: main.domain,
 *     type: aws.route53.RecordType.A,
 *     zoneId: example.then(example => example.zoneId),
 *     aliases: [{
 *         evaluateTargetHealth: false,
 *         name: main.cloudfrontDistribution,
 *         zoneId: main.cloudfrontDistributionZoneId,
 *     }],
 * });
 * ```
 * ```python
 * import pulumi
 * import pulumi_aws as aws
 * example_user_pool = aws.cognito.UserPool("example", name="example-pool")
 * main = aws.cognito.UserPoolDomain("main",
 *     domain="example-domain",
 *     certificate_arn=cert["arn"],
 *     user_pool_id=example_user_pool.id)
 * example = aws.route53.get_zone(name="example.com")
 * auth_cognito__a = aws.route53.Record("auth-cognito-A",
 *     name=main.domain,
 *     type=aws.route53.RecordType.A,
 *     zone_id=example.zone_id,
 *     aliases=[{
 *         "evaluate_target_health": False,
 *         "name": main.cloudfront_distribution,
 *         "zone_id": main.cloudfront_distribution_zone_id,
 *     }])
 * ```
 * ```csharp
 * using System.Collections.Generic;
 * using System.Linq;
 * using Pulumi;
 * using Aws = Pulumi.Aws;
 * return await Deployment.RunAsync(() =>
 * {
 *     var exampleUserPool = new Aws.Cognito.UserPool("example", new()
 *     {
 *         Name = "example-pool",
 *     });
 *     var main = new Aws.Cognito.UserPoolDomain("main", new()
 *     {
 *         Domain = "example-domain",
 *         CertificateArn = cert.Arn,
 *         UserPoolId = exampleUserPool.Id,
 *     });
 *     var example = Aws.Route53.GetZone.Invoke(new()
 *     {
 *         Name = "example.com",
 *     });
 *     var auth_cognito_A = new Aws.Route53.Record("auth-cognito-A", new()
 *     {
 *         Name = main.Domain,
 *         Type = Aws.Route53.RecordType.A,
 *         ZoneId = example.Apply(getZoneResult => getZoneResult.ZoneId),
 *         Aliases = new[]
 *         {
 *             new Aws.Route53.Inputs.RecordAliasArgs
 *             {
 *                 EvaluateTargetHealth = false,
 *                 Name = main.CloudfrontDistribution,
 *                 ZoneId = main.CloudfrontDistributionZoneId,
 *             },
 *         },
 *     });
 * });
 * ```
 * ```go
 * package main
 * import (
 * 	"github.com/pulumi/pulumi-aws/sdk/v6/go/aws/cognito"
 * 	"github.com/pulumi/pulumi-aws/sdk/v6/go/aws/route53"
 * 	"github.com/pulumi/pulumi/sdk/v3/go/pulumi"
 * )
 * func main() {
 * 	pulumi.Run(func(ctx *pulumi.Context) error {
 * 		exampleUserPool, err := cognito.NewUserPool(ctx, "example", &cognito.UserPoolArgs{
 * 			Name: pulumi.String("example-pool"),
 * 		})
 * 		if err != nil {
 * 			return err
 * 		}
 * 		main, err := cognito.NewUserPoolDomain(ctx, "main", &cognito.UserPoolDomainArgs{
 * 			Domain:         pulumi.String("example-domain"),
 * 			CertificateArn: pulumi.Any(cert.Arn),
 * 			UserPoolId:     exampleUserPool.ID(),
 * 		})
 * 		if err != nil {
 * 			return err
 * 		}
 * 		example, err := route53.LookupZone(ctx, &route53.LookupZoneArgs{
 * 			Name: pulumi.StringRef("example.com"),
 * 		}, nil)
 * 		if err != nil {
 * 			return err
 * 		}
 * 		_, err = route53.NewRecord(ctx, "auth-cognito-A", &route53.RecordArgs{
 * 			Name:   main.Domain,
 * 			Type:   pulumi.String(route53.RecordTypeA),
 * 			ZoneId: pulumi.String(example.ZoneId),
 * 			Aliases: route53.RecordAliasArray{
 * 				&route53.RecordAliasArgs{
 * 					EvaluateTargetHealth: pulumi.Bool(false),
 * 					Name:                 main.CloudfrontDistribution,
 * 					ZoneId:               main.CloudfrontDistributionZoneId,
 * 				},
 * 			},
 * 		})
 * 		if err != nil {
 * 			return err
 * 		}
 * 		return nil
 * 	})
 * }
 * ```
 * ```java
 * package generated_program;
 * import com.pulumi.Context;
 * import com.pulumi.Pulumi;
 * import com.pulumi.core.Output;
 * import com.pulumi.aws.cognito.UserPool;
 * import com.pulumi.aws.cognito.UserPoolArgs;
 * import com.pulumi.aws.cognito.UserPoolDomain;
 * import com.pulumi.aws.cognito.UserPoolDomainArgs;
 * import com.pulumi.aws.route53.Route53Functions;
 * import com.pulumi.aws.route53.inputs.GetZoneArgs;
 * import com.pulumi.aws.route53.Record;
 * import com.pulumi.aws.route53.RecordArgs;
 * import com.pulumi.aws.route53.inputs.RecordAliasArgs;
 * import java.util.List;
 * import java.util.ArrayList;
 * import java.util.Map;
 * import java.io.File;
 * import java.nio.file.Files;
 * import java.nio.file.Paths;
 * public class App {
 *     public static void main(String[] args) {
 *         Pulumi.run(App::stack);
 *     }
 *     public static void stack(Context ctx) {
 *         var exampleUserPool = new UserPool("exampleUserPool", UserPoolArgs.builder()
 *             .name("example-pool")
 *             .build());
 *         var main = new UserPoolDomain("main", UserPoolDomainArgs.builder()
 *             .domain("example-domain")
 *             .certificateArn(cert.arn())
 *             .userPoolId(exampleUserPool.id())
 *             .build());
 *         final var example = Route53Functions.getZone(GetZoneArgs.builder()
 *             .name("example.com")
 *             .build());
 *         var auth_cognito_A = new Record("auth-cognito-A", RecordArgs.builder()
 *             .name(main.domain())
 *             .type("A")
 *             .zoneId(example.applyValue(getZoneResult -> getZoneResult.zoneId()))
 *             .aliases(RecordAliasArgs.builder()
 *                 .evaluateTargetHealth(false)
 *                 .name(main.cloudfrontDistribution())
 *                 .zoneId(main.cloudfrontDistributionZoneId())
 *                 .build())
 *             .build());
 *     }
 * }
 * ```
 * ```yaml
 * resources:
 *   main:
 *     type: aws:cognito:UserPoolDomain
 *     properties:
 *       domain: example-domain
 *       certificateArn: ${cert.arn}
 *       userPoolId: ${exampleUserPool.id}
 *   exampleUserPool:
 *     type: aws:cognito:UserPool
 *     name: example
 *     properties:
 *       name: example-pool
 *   auth-cognito-A:
 *     type: aws:route53:Record
 *     properties:
 *       name: ${main.domain}
 *       type: A
 *       zoneId: ${example.zoneId}
 *       aliases:
 *         - evaluateTargetHealth: false
 *           name: ${main.cloudfrontDistribution}
 *           zoneId: ${main.cloudfrontDistributionZoneId}
 * variables:
 *   example:
 *     fn::invoke:
 *       Function: aws:route53:getZone
 *       Arguments:
 *         name: example.com
 * ```
 * <!--End PulumiCodeChooser -->
 * ## Import
 * Using `pulumi import`, import Cognito User Pool Domains using the `domain`. For example:
 * ```sh
 * $ pulumi import aws:cognito/userPoolDomain:UserPoolDomain main auth.example.org
 * ```
 * @property certificateArn The ARN of an ISSUED ACM certificate in us-east-1 for a custom domain.
 * @property domain For custom domains, this is the fully-qualified domain name, such as auth.example.com. For Amazon Cognito prefix domains, this is the prefix alone, such as auth.
 * @property userPoolId The user pool ID.
 */
public data class UserPoolDomainArgs(
    public val certificateArn: Output<String>? = null,
    public val domain: Output<String>? = null,
    public val userPoolId: Output<String>? = null,
) : ConvertibleToJava<com.pulumi.aws.cognito.UserPoolDomainArgs> {
    override fun toJava(): com.pulumi.aws.cognito.UserPoolDomainArgs =
        com.pulumi.aws.cognito.UserPoolDomainArgs.builder()
            .certificateArn(certificateArn?.applyValue({ args0 -> args0 }))
            .domain(domain?.applyValue({ args0 -> args0 }))
            .userPoolId(userPoolId?.applyValue({ args0 -> args0 })).build()
}

/**
 * Builder for [UserPoolDomainArgs].
 */
@PulumiTagMarker
public class UserPoolDomainArgsBuilder internal constructor() {
    private var certificateArn: Output<String>? = null

    private var domain: Output<String>? = null

    private var userPoolId: Output<String>? = null

    /**
     * @param value The ARN of an ISSUED ACM certificate in us-east-1 for a custom domain.
     */
    @JvmName("kmapqlptcywuqjbi")
    public suspend fun certificateArn(`value`: Output<String>) {
        this.certificateArn = value
    }

    /**
     * @param value For custom domains, this is the fully-qualified domain name, such as auth.example.com. For Amazon Cognito prefix domains, this is the prefix alone, such as auth.
     */
    @JvmName("lfluqyqqlymhlkhy")
    public suspend fun domain(`value`: Output<String>) {
        this.domain = value
    }

    /**
     * @param value The user pool ID.
     */
    @JvmName("josxirbswoymoqbe")
    public suspend fun userPoolId(`value`: Output<String>) {
        this.userPoolId = value
    }

    /**
     * @param value The ARN of an ISSUED ACM certificate in us-east-1 for a custom domain.
     */
    @JvmName("oaewhgbjlkbtlrnt")
    public suspend fun certificateArn(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.certificateArn = mapped
    }

    /**
     * @param value For custom domains, this is the fully-qualified domain name, such as auth.example.com. For Amazon Cognito prefix domains, this is the prefix alone, such as auth.
     */
    @JvmName("syxokeoysvbdtqie")
    public suspend fun domain(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.domain = mapped
    }

    /**
     * @param value The user pool ID.
     */
    @JvmName("lrwluvxpignwtbic")
    public suspend fun userPoolId(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.userPoolId = mapped
    }

    internal fun build(): UserPoolDomainArgs = UserPoolDomainArgs(
        certificateArn = certificateArn,
        domain = domain,
        userPoolId = userPoolId,
    )
}
