@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.aws.cognito.kotlin.inputs

import com.pulumi.aws.cognito.inputs.GetIdentityPoolPlainArgs.builder
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiNullFieldException
import com.pulumi.kotlin.PulumiTagMarker
import kotlin.Pair
import kotlin.String
import kotlin.Suppress
import kotlin.collections.Map
import kotlin.jvm.JvmName

/**
 * A collection of arguments for invoking getIdentityPool.
 * @property identityPoolName The Cognito Identity Pool name.
 * @property tags A map of tags to assigned to the Identity Pool.
 */
public data class GetIdentityPoolPlainArgs(
    public val identityPoolName: String,
    public val tags: Map<String, String>? = null,
) : ConvertibleToJava<com.pulumi.aws.cognito.inputs.GetIdentityPoolPlainArgs> {
    override fun toJava(): com.pulumi.aws.cognito.inputs.GetIdentityPoolPlainArgs =
        com.pulumi.aws.cognito.inputs.GetIdentityPoolPlainArgs.builder()
            .identityPoolName(identityPoolName.let({ args0 -> args0 }))
            .tags(tags?.let({ args0 -> args0.map({ args0 -> args0.key.to(args0.value) }).toMap() })).build()
}

/**
 * Builder for [GetIdentityPoolPlainArgs].
 */
@PulumiTagMarker
public class GetIdentityPoolPlainArgsBuilder internal constructor() {
    private var identityPoolName: String? = null

    private var tags: Map<String, String>? = null

    /**
     * @param value The Cognito Identity Pool name.
     */
    @JvmName("xgnvtfcjaglncsww")
    public suspend fun identityPoolName(`value`: String) {
        val toBeMapped = value
        val mapped = toBeMapped.let({ args0 -> args0 })
        this.identityPoolName = mapped
    }

    /**
     * @param value A map of tags to assigned to the Identity Pool.
     */
    @JvmName("mpuiyrdhivyhrfis")
    public suspend fun tags(`value`: Map<String, String>?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> args0 })
        this.tags = mapped
    }

    /**
     * @param values A map of tags to assigned to the Identity Pool.
     */
    @JvmName("lvrfsnymelrowhrt")
    public fun tags(vararg values: Pair<String, String>) {
        val toBeMapped = values.toMap()
        val mapped = toBeMapped.let({ args0 -> args0 })
        this.tags = mapped
    }

    internal fun build(): GetIdentityPoolPlainArgs = GetIdentityPoolPlainArgs(
        identityPoolName = identityPoolName ?: throw PulumiNullFieldException("identityPoolName"),
        tags = tags,
    )
}
