@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.aws.cognito.kotlin.inputs

import com.pulumi.aws.cognito.inputs.GetUserGroupPlainArgs.builder
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiNullFieldException
import com.pulumi.kotlin.PulumiTagMarker
import kotlin.String
import kotlin.Suppress
import kotlin.jvm.JvmName

/**
 * A collection of arguments for invoking getUserGroup.
 * @property name Name of the user group.
 * @property userPoolId User pool the client belongs to.
 */
public data class GetUserGroupPlainArgs(
    public val name: String,
    public val userPoolId: String,
) : ConvertibleToJava<com.pulumi.aws.cognito.inputs.GetUserGroupPlainArgs> {
    override fun toJava(): com.pulumi.aws.cognito.inputs.GetUserGroupPlainArgs =
        com.pulumi.aws.cognito.inputs.GetUserGroupPlainArgs.builder()
            .name(name.let({ args0 -> args0 }))
            .userPoolId(userPoolId.let({ args0 -> args0 })).build()
}

/**
 * Builder for [GetUserGroupPlainArgs].
 */
@PulumiTagMarker
public class GetUserGroupPlainArgsBuilder internal constructor() {
    private var name: String? = null

    private var userPoolId: String? = null

    /**
     * @param value Name of the user group.
     */
    @JvmName("fwxgjtuqfgfmarmp")
    public suspend fun name(`value`: String) {
        val toBeMapped = value
        val mapped = toBeMapped.let({ args0 -> args0 })
        this.name = mapped
    }

    /**
     * @param value User pool the client belongs to.
     */
    @JvmName("qsdtrcjskxrcjwuf")
    public suspend fun userPoolId(`value`: String) {
        val toBeMapped = value
        val mapped = toBeMapped.let({ args0 -> args0 })
        this.userPoolId = mapped
    }

    internal fun build(): GetUserGroupPlainArgs = GetUserGroupPlainArgs(
        name = name ?: throw PulumiNullFieldException("name"),
        userPoolId = userPoolId ?: throw PulumiNullFieldException("userPoolId"),
    )
}
