@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.aws.cognito.kotlin.inputs

import com.pulumi.aws.cognito.inputs.GetUserGroupsPlainArgs.builder
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiNullFieldException
import com.pulumi.kotlin.PulumiTagMarker
import kotlin.String
import kotlin.Suppress
import kotlin.jvm.JvmName

/**
 * A collection of arguments for invoking getUserGroups.
 * @property userPoolId User pool the client belongs to.
 */
public data class GetUserGroupsPlainArgs(
    public val userPoolId: String,
) : ConvertibleToJava<com.pulumi.aws.cognito.inputs.GetUserGroupsPlainArgs> {
    override fun toJava(): com.pulumi.aws.cognito.inputs.GetUserGroupsPlainArgs =
        com.pulumi.aws.cognito.inputs.GetUserGroupsPlainArgs.builder()
            .userPoolId(userPoolId.let({ args0 -> args0 })).build()
}

/**
 * Builder for [GetUserGroupsPlainArgs].
 */
@PulumiTagMarker
public class GetUserGroupsPlainArgsBuilder internal constructor() {
    private var userPoolId: String? = null

    /**
     * @param value User pool the client belongs to.
     */
    @JvmName("cpowkgcfdbjqsxbe")
    public suspend fun userPoolId(`value`: String) {
        val toBeMapped = value
        val mapped = toBeMapped.let({ args0 -> args0 })
        this.userPoolId = mapped
    }

    internal fun build(): GetUserGroupsPlainArgs = GetUserGroupsPlainArgs(
        userPoolId = userPoolId ?: throw PulumiNullFieldException("userPoolId"),
    )
}
