@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.aws.cognito.kotlin.inputs

import com.pulumi.aws.cognito.inputs.GetUserPoolPlainArgs.builder
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiNullFieldException
import com.pulumi.kotlin.PulumiTagMarker
import kotlin.String
import kotlin.Suppress
import kotlin.jvm.JvmName

/**
 * A collection of arguments for invoking getUserPool.
 * @property userPoolId The cognito pool ID
 */
public data class GetUserPoolPlainArgs(
    public val userPoolId: String,
) : ConvertibleToJava<com.pulumi.aws.cognito.inputs.GetUserPoolPlainArgs> {
    override fun toJava(): com.pulumi.aws.cognito.inputs.GetUserPoolPlainArgs =
        com.pulumi.aws.cognito.inputs.GetUserPoolPlainArgs.builder()
            .userPoolId(userPoolId.let({ args0 -> args0 })).build()
}

/**
 * Builder for [GetUserPoolPlainArgs].
 */
@PulumiTagMarker
public class GetUserPoolPlainArgsBuilder internal constructor() {
    private var userPoolId: String? = null

    /**
     * @param value The cognito pool ID
     */
    @JvmName("bfnoalvktntoryjb")
    public suspend fun userPoolId(`value`: String) {
        val toBeMapped = value
        val mapped = toBeMapped.let({ args0 -> args0 })
        this.userPoolId = mapped
    }

    internal fun build(): GetUserPoolPlainArgs = GetUserPoolPlainArgs(
        userPoolId = userPoolId ?: throw PulumiNullFieldException("userPoolId"),
    )
}
