@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.aws.cognito.kotlin.inputs

import com.pulumi.aws.cognito.inputs.GetUserPoolsPlainArgs.builder
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiNullFieldException
import com.pulumi.kotlin.PulumiTagMarker
import kotlin.String
import kotlin.Suppress
import kotlin.jvm.JvmName

/**
 * A collection of arguments for invoking getUserPools.
 * @property name Name of the cognito user pools. Name is not a unique attribute for cognito user pool, so multiple pools might be returned with given name. If the pool name is expected to be unique, you can reference the pool id via ```tolist(data.aws_cognito_user_pools.selected.ids)[0]```
 */
public data class GetUserPoolsPlainArgs(
    public val name: String,
) : ConvertibleToJava<com.pulumi.aws.cognito.inputs.GetUserPoolsPlainArgs> {
    override fun toJava(): com.pulumi.aws.cognito.inputs.GetUserPoolsPlainArgs =
        com.pulumi.aws.cognito.inputs.GetUserPoolsPlainArgs.builder()
            .name(name.let({ args0 -> args0 })).build()
}

/**
 * Builder for [GetUserPoolsPlainArgs].
 */
@PulumiTagMarker
public class GetUserPoolsPlainArgsBuilder internal constructor() {
    private var name: String? = null

    /**
     * @param value Name of the cognito user pools. Name is not a unique attribute for cognito user pool, so multiple pools might be returned with given name. If the pool name is expected to be unique, you can reference the pool id via ```tolist(data.aws_cognito_user_pools.selected.ids)[0]```
     */
    @JvmName("qmmwgftsnmyuvuns")
    public suspend fun name(`value`: String) {
        val toBeMapped = value
        val mapped = toBeMapped.let({ args0 -> args0 })
        this.name = mapped
    }

    internal fun build(): GetUserPoolsPlainArgs = GetUserPoolsPlainArgs(
        name = name ?: throw PulumiNullFieldException("name"),
    )
}
