@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.aws.cognito.kotlin.inputs

import com.pulumi.aws.cognito.inputs.IdentityPoolRoleAttachmentRoleMappingMappingRuleArgs.builder
import com.pulumi.core.Output
import com.pulumi.core.Output.of
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiNullFieldException
import com.pulumi.kotlin.PulumiTagMarker
import kotlin.String
import kotlin.Suppress
import kotlin.jvm.JvmName

/**
 *
 * @property claim The claim name that must be present in the token, for example, "isAdmin" or "paid".
 * @property matchType The match condition that specifies how closely the claim value in the IdP token must match Value.
 * @property roleArn The role ARN.
 * @property value A brief string that the claim must match, for example, "paid" or "yes".
 */
public data class IdentityPoolRoleAttachmentRoleMappingMappingRuleArgs(
    public val claim: Output<String>,
    public val matchType: Output<String>,
    public val roleArn: Output<String>,
    public val `value`: Output<String>,
) :
    ConvertibleToJava<com.pulumi.aws.cognito.inputs.IdentityPoolRoleAttachmentRoleMappingMappingRuleArgs> {
    override fun toJava(): com.pulumi.aws.cognito.inputs.IdentityPoolRoleAttachmentRoleMappingMappingRuleArgs =
        com.pulumi.aws.cognito.inputs.IdentityPoolRoleAttachmentRoleMappingMappingRuleArgs.builder()
            .claim(claim.applyValue({ args0 -> args0 }))
            .matchType(matchType.applyValue({ args0 -> args0 }))
            .roleArn(roleArn.applyValue({ args0 -> args0 }))
            .`value`(`value`.applyValue({ args0 -> args0 })).build()
}

/**
 * Builder for [IdentityPoolRoleAttachmentRoleMappingMappingRuleArgs].
 */
@PulumiTagMarker
public class IdentityPoolRoleAttachmentRoleMappingMappingRuleArgsBuilder internal constructor() {
    private var claim: Output<String>? = null

    private var matchType: Output<String>? = null

    private var roleArn: Output<String>? = null

    private var `value`: Output<String>? = null

    /**
     * @param value The claim name that must be present in the token, for example, "isAdmin" or "paid".
     */
    @JvmName("odnjwuodxncqfqcr")
    public suspend fun claim(`value`: Output<String>) {
        this.claim = value
    }

    /**
     * @param value The match condition that specifies how closely the claim value in the IdP token must match Value.
     */
    @JvmName("nrntgixnmjigatur")
    public suspend fun matchType(`value`: Output<String>) {
        this.matchType = value
    }

    /**
     * @param value The role ARN.
     */
    @JvmName("eigyxnjfjxhcrfjf")
    public suspend fun roleArn(`value`: Output<String>) {
        this.roleArn = value
    }

    /**
     * @param value A brief string that the claim must match, for example, "paid" or "yes".
     */
    @JvmName("oqqtabukdogjwwov")
    public suspend fun `value`(`value`: Output<String>) {
        this.`value` = value
    }

    /**
     * @param value The claim name that must be present in the token, for example, "isAdmin" or "paid".
     */
    @JvmName("niiotgbwlsyetbgh")
    public suspend fun claim(`value`: String) {
        val toBeMapped = value
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.claim = mapped
    }

    /**
     * @param value The match condition that specifies how closely the claim value in the IdP token must match Value.
     */
    @JvmName("vgmpbgxjpfjcsqeh")
    public suspend fun matchType(`value`: String) {
        val toBeMapped = value
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.matchType = mapped
    }

    /**
     * @param value The role ARN.
     */
    @JvmName("tnqjjwylkljvaqff")
    public suspend fun roleArn(`value`: String) {
        val toBeMapped = value
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.roleArn = mapped
    }

    /**
     * @param value A brief string that the claim must match, for example, "paid" or "yes".
     */
    @JvmName("lgfhuejfwyhxleay")
    public suspend fun `value`(`value`: String) {
        val toBeMapped = value
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.`value` = mapped
    }

    internal fun build(): IdentityPoolRoleAttachmentRoleMappingMappingRuleArgs =
        IdentityPoolRoleAttachmentRoleMappingMappingRuleArgs(
            claim = claim ?: throw PulumiNullFieldException("claim"),
            matchType = matchType ?: throw PulumiNullFieldException("matchType"),
            roleArn = roleArn ?: throw PulumiNullFieldException("roleArn"),
            `value` = `value` ?: throw PulumiNullFieldException("value"),
        )
}
