@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.aws.cognito.kotlin.inputs

import com.pulumi.aws.cognito.inputs.RiskConfigurationAccountTakeoverRiskConfigurationActionsLowActionArgs.builder
import com.pulumi.core.Output
import com.pulumi.core.Output.of
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiNullFieldException
import com.pulumi.kotlin.PulumiTagMarker
import kotlin.Boolean
import kotlin.String
import kotlin.Suppress
import kotlin.jvm.JvmName

/**
 *
 * @property eventAction
 * @property notify Whether to send a notification.
 */
public data class RiskConfigurationAccountTakeoverRiskConfigurationActionsLowActionArgs(
    public val eventAction: Output<String>,
    public val notify: Output<Boolean>,
) :
    ConvertibleToJava<com.pulumi.aws.cognito.inputs.RiskConfigurationAccountTakeoverRiskConfigurationActionsLowActionArgs> {
    override fun toJava(): com.pulumi.aws.cognito.inputs.RiskConfigurationAccountTakeoverRiskConfigurationActionsLowActionArgs =
        com.pulumi.aws.cognito.inputs.RiskConfigurationAccountTakeoverRiskConfigurationActionsLowActionArgs.builder()
            .eventAction(eventAction.applyValue({ args0 -> args0 }))
            .notify_(notify.applyValue({ args0 -> args0 })).build()
}

/**
 * Builder for [RiskConfigurationAccountTakeoverRiskConfigurationActionsLowActionArgs].
 */
@PulumiTagMarker
public class RiskConfigurationAccountTakeoverRiskConfigurationActionsLowActionArgsBuilder internal constructor() {
    private var eventAction: Output<String>? = null

    private var notify: Output<Boolean>? = null

    /**
     * @param value
     */
    @JvmName("pechkiywyvdswyfd")
    public suspend fun eventAction(`value`: Output<String>) {
        this.eventAction = value
    }

    /**
     * @param value Whether to send a notification.
     */
    @JvmName("ahbxcyiydbeqeote")
    public suspend fun notify(`value`: Output<Boolean>) {
        this.notify = value
    }

    /**
     * @param value
     */
    @JvmName("vughbomlofwjhskv")
    public suspend fun eventAction(`value`: String) {
        val toBeMapped = value
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.eventAction = mapped
    }

    /**
     * @param value Whether to send a notification.
     */
    @JvmName("svvgoobplufcyhar")
    public suspend fun notify(`value`: Boolean) {
        val toBeMapped = value
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.notify = mapped
    }

    internal fun build(): RiskConfigurationAccountTakeoverRiskConfigurationActionsLowActionArgs =
        RiskConfigurationAccountTakeoverRiskConfigurationActionsLowActionArgs(
            eventAction = eventAction ?: throw PulumiNullFieldException("eventAction"),
            notify = notify ?: throw PulumiNullFieldException("notify"),
        )
}
