@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.aws.cognito.kotlin.inputs

import com.pulumi.aws.cognito.inputs.RiskConfigurationAccountTakeoverRiskConfigurationArgs.builder
import com.pulumi.core.Output
import com.pulumi.core.Output.of
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiNullFieldException
import com.pulumi.kotlin.PulumiTagMarker
import com.pulumi.kotlin.applySuspend
import kotlin.Suppress
import kotlin.Unit
import kotlin.jvm.JvmName

/**
 *
 * @property actions Account takeover risk configuration actions. See details below.
 * @property notifyConfiguration The notify configuration used to construct email notifications. See details below.
 */
public data class RiskConfigurationAccountTakeoverRiskConfigurationArgs(
    public val actions: Output<RiskConfigurationAccountTakeoverRiskConfigurationActionsArgs>,
    public val notifyConfiguration: Output<RiskConfigurationAccountTakeoverRiskConfigurationNotifyConfigurationArgs>,
) :
    ConvertibleToJava<com.pulumi.aws.cognito.inputs.RiskConfigurationAccountTakeoverRiskConfigurationArgs> {
    override fun toJava(): com.pulumi.aws.cognito.inputs.RiskConfigurationAccountTakeoverRiskConfigurationArgs =
        com.pulumi.aws.cognito.inputs.RiskConfigurationAccountTakeoverRiskConfigurationArgs.builder()
            .actions(actions.applyValue({ args0 -> args0.let({ args0 -> args0.toJava() }) }))
            .notifyConfiguration(
                notifyConfiguration.applyValue({ args0 ->
                    args0.let({ args0 ->
                        args0.toJava()
                    })
                }),
            ).build()
}

/**
 * Builder for [RiskConfigurationAccountTakeoverRiskConfigurationArgs].
 */
@PulumiTagMarker
public class RiskConfigurationAccountTakeoverRiskConfigurationArgsBuilder internal constructor() {
    private var actions: Output<RiskConfigurationAccountTakeoverRiskConfigurationActionsArgs>? = null

    private var notifyConfiguration:
        Output<RiskConfigurationAccountTakeoverRiskConfigurationNotifyConfigurationArgs>? = null

    /**
     * @param value Account takeover risk configuration actions. See details below.
     */
    @JvmName("gfcirrsfjcqitnld")
    public suspend fun actions(`value`: Output<RiskConfigurationAccountTakeoverRiskConfigurationActionsArgs>) {
        this.actions = value
    }

    /**
     * @param value The notify configuration used to construct email notifications. See details below.
     */
    @JvmName("nqvvrybvwoqgghxs")
    public suspend fun notifyConfiguration(`value`: Output<RiskConfigurationAccountTakeoverRiskConfigurationNotifyConfigurationArgs>) {
        this.notifyConfiguration = value
    }

    /**
     * @param value Account takeover risk configuration actions. See details below.
     */
    @JvmName("thotfituhnrtntaj")
    public suspend fun actions(`value`: RiskConfigurationAccountTakeoverRiskConfigurationActionsArgs) {
        val toBeMapped = value
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.actions = mapped
    }

    /**
     * @param argument Account takeover risk configuration actions. See details below.
     */
    @JvmName("dybynykyjgfqjxux")
    public suspend fun actions(argument: suspend RiskConfigurationAccountTakeoverRiskConfigurationActionsArgsBuilder.() -> Unit) {
        val toBeMapped =
            RiskConfigurationAccountTakeoverRiskConfigurationActionsArgsBuilder().applySuspend {
                argument()
            }.build()
        val mapped = of(toBeMapped)
        this.actions = mapped
    }

    /**
     * @param value The notify configuration used to construct email notifications. See details below.
     */
    @JvmName("wvhtqpcihavwfwqr")
    public suspend fun notifyConfiguration(`value`: RiskConfigurationAccountTakeoverRiskConfigurationNotifyConfigurationArgs) {
        val toBeMapped = value
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.notifyConfiguration = mapped
    }

    /**
     * @param argument The notify configuration used to construct email notifications. See details below.
     */
    @JvmName("wfjdxmnyqycdkjec")
    public suspend fun notifyConfiguration(argument: suspend RiskConfigurationAccountTakeoverRiskConfigurationNotifyConfigurationArgsBuilder.() -> Unit) {
        val toBeMapped =
            RiskConfigurationAccountTakeoverRiskConfigurationNotifyConfigurationArgsBuilder().applySuspend {
                argument()
            }.build()
        val mapped = of(toBeMapped)
        this.notifyConfiguration = mapped
    }

    internal fun build(): RiskConfigurationAccountTakeoverRiskConfigurationArgs =
        RiskConfigurationAccountTakeoverRiskConfigurationArgs(
            actions = actions ?: throw PulumiNullFieldException("actions"),
            notifyConfiguration = notifyConfiguration ?: throw PulumiNullFieldException("notifyConfiguration"),
        )
}
