@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.aws.cognito.kotlin.inputs

import com.pulumi.aws.cognito.inputs.RiskConfigurationCompromisedCredentialsRiskConfigurationArgs.builder
import com.pulumi.core.Output
import com.pulumi.core.Output.of
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiNullFieldException
import com.pulumi.kotlin.PulumiTagMarker
import com.pulumi.kotlin.applySuspend
import kotlin.String
import kotlin.Suppress
import kotlin.Unit
import kotlin.collections.List
import kotlin.jvm.JvmName

/**
 *
 * @property actions The compromised credentials risk configuration actions. See details below.
 * @property eventFilters Perform the action for these events. The default is to perform all events if no event filter is specified. Valid values are `SIGN_IN`, `PASSWORD_CHANGE`, and `SIGN_UP`.
 */
public data class RiskConfigurationCompromisedCredentialsRiskConfigurationArgs(
    public val actions: Output<RiskConfigurationCompromisedCredentialsRiskConfigurationActionsArgs>,
    public val eventFilters: Output<List<String>>? = null,
) :
    ConvertibleToJava<com.pulumi.aws.cognito.inputs.RiskConfigurationCompromisedCredentialsRiskConfigurationArgs> {
    override fun toJava(): com.pulumi.aws.cognito.inputs.RiskConfigurationCompromisedCredentialsRiskConfigurationArgs =
        com.pulumi.aws.cognito.inputs.RiskConfigurationCompromisedCredentialsRiskConfigurationArgs.builder()
            .actions(actions.applyValue({ args0 -> args0.let({ args0 -> args0.toJava() }) }))
            .eventFilters(eventFilters?.applyValue({ args0 -> args0.map({ args0 -> args0 }) })).build()
}

/**
 * Builder for [RiskConfigurationCompromisedCredentialsRiskConfigurationArgs].
 */
@PulumiTagMarker
public class RiskConfigurationCompromisedCredentialsRiskConfigurationArgsBuilder internal constructor() {
    private var actions: Output<RiskConfigurationCompromisedCredentialsRiskConfigurationActionsArgs>? =
        null

    private var eventFilters: Output<List<String>>? = null

    /**
     * @param value The compromised credentials risk configuration actions. See details below.
     */
    @JvmName("deacsadoqwpoxnrk")
    public suspend fun actions(`value`: Output<RiskConfigurationCompromisedCredentialsRiskConfigurationActionsArgs>) {
        this.actions = value
    }

    /**
     * @param value Perform the action for these events. The default is to perform all events if no event filter is specified. Valid values are `SIGN_IN`, `PASSWORD_CHANGE`, and `SIGN_UP`.
     */
    @JvmName("crlgdbevrpsejvbd")
    public suspend fun eventFilters(`value`: Output<List<String>>) {
        this.eventFilters = value
    }

    @JvmName("nvtratypibqnxicl")
    public suspend fun eventFilters(vararg values: Output<String>) {
        this.eventFilters = Output.all(values.asList())
    }

    /**
     * @param values Perform the action for these events. The default is to perform all events if no event filter is specified. Valid values are `SIGN_IN`, `PASSWORD_CHANGE`, and `SIGN_UP`.
     */
    @JvmName("fvdgtclpiepirabv")
    public suspend fun eventFilters(values: List<Output<String>>) {
        this.eventFilters = Output.all(values)
    }

    /**
     * @param value The compromised credentials risk configuration actions. See details below.
     */
    @JvmName("qwqwxlemtstpbbmu")
    public suspend fun actions(`value`: RiskConfigurationCompromisedCredentialsRiskConfigurationActionsArgs) {
        val toBeMapped = value
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.actions = mapped
    }

    /**
     * @param argument The compromised credentials risk configuration actions. See details below.
     */
    @JvmName("magqwqutvuqphyrr")
    public suspend fun actions(argument: suspend RiskConfigurationCompromisedCredentialsRiskConfigurationActionsArgsBuilder.() -> Unit) {
        val toBeMapped =
            RiskConfigurationCompromisedCredentialsRiskConfigurationActionsArgsBuilder().applySuspend {
                argument()
            }.build()
        val mapped = of(toBeMapped)
        this.actions = mapped
    }

    /**
     * @param value Perform the action for these events. The default is to perform all events if no event filter is specified. Valid values are `SIGN_IN`, `PASSWORD_CHANGE`, and `SIGN_UP`.
     */
    @JvmName("rfupmxtxxglntrae")
    public suspend fun eventFilters(`value`: List<String>?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.eventFilters = mapped
    }

    /**
     * @param values Perform the action for these events. The default is to perform all events if no event filter is specified. Valid values are `SIGN_IN`, `PASSWORD_CHANGE`, and `SIGN_UP`.
     */
    @JvmName("wdfvbptfhnmlgilg")
    public suspend fun eventFilters(vararg values: String) {
        val toBeMapped = values.toList()
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.eventFilters = mapped
    }

    internal fun build(): RiskConfigurationCompromisedCredentialsRiskConfigurationArgs =
        RiskConfigurationCompromisedCredentialsRiskConfigurationArgs(
            actions = actions ?: throw PulumiNullFieldException("actions"),
            eventFilters = eventFilters,
        )
}
