@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.aws.cognito.kotlin.inputs

import com.pulumi.aws.cognito.inputs.RiskConfigurationRiskExceptionConfigurationArgs.builder
import com.pulumi.core.Output
import com.pulumi.core.Output.of
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiTagMarker
import kotlin.String
import kotlin.Suppress
import kotlin.collections.List
import kotlin.jvm.JvmName

/**
 *
 * @property blockedIpRangeLists Overrides the risk decision to always block the pre-authentication requests.
 * The IP range is in CIDR notation, a compact representation of an IP address and its routing prefix.
 * Can contain a maximum of 200 items.
 * @property skippedIpRangeLists Risk detection isn't performed on the IP addresses in this range list.
 * The IP range is in CIDR notation.
 * Can contain a maximum of 200 items.
 */
public data class RiskConfigurationRiskExceptionConfigurationArgs(
    public val blockedIpRangeLists: Output<List<String>>? = null,
    public val skippedIpRangeLists: Output<List<String>>? = null,
) : ConvertibleToJava<com.pulumi.aws.cognito.inputs.RiskConfigurationRiskExceptionConfigurationArgs> {
    override fun toJava(): com.pulumi.aws.cognito.inputs.RiskConfigurationRiskExceptionConfigurationArgs =
        com.pulumi.aws.cognito.inputs.RiskConfigurationRiskExceptionConfigurationArgs.builder()
            .blockedIpRangeLists(blockedIpRangeLists?.applyValue({ args0 -> args0.map({ args0 -> args0 }) }))
            .skippedIpRangeLists(
                skippedIpRangeLists?.applyValue({ args0 ->
                    args0.map({ args0 ->
                        args0
                    })
                }),
            ).build()
}

/**
 * Builder for [RiskConfigurationRiskExceptionConfigurationArgs].
 */
@PulumiTagMarker
public class RiskConfigurationRiskExceptionConfigurationArgsBuilder internal constructor() {
    private var blockedIpRangeLists: Output<List<String>>? = null

    private var skippedIpRangeLists: Output<List<String>>? = null

    /**
     * @param value Overrides the risk decision to always block the pre-authentication requests.
     * The IP range is in CIDR notation, a compact representation of an IP address and its routing prefix.
     * Can contain a maximum of 200 items.
     */
    @JvmName("manylvbmsjmaahns")
    public suspend fun blockedIpRangeLists(`value`: Output<List<String>>) {
        this.blockedIpRangeLists = value
    }

    @JvmName("gebqbxnhskpnutov")
    public suspend fun blockedIpRangeLists(vararg values: Output<String>) {
        this.blockedIpRangeLists = Output.all(values.asList())
    }

    /**
     * @param values Overrides the risk decision to always block the pre-authentication requests.
     * The IP range is in CIDR notation, a compact representation of an IP address and its routing prefix.
     * Can contain a maximum of 200 items.
     */
    @JvmName("eulmlwlogupaocte")
    public suspend fun blockedIpRangeLists(values: List<Output<String>>) {
        this.blockedIpRangeLists = Output.all(values)
    }

    /**
     * @param value Risk detection isn't performed on the IP addresses in this range list.
     * The IP range is in CIDR notation.
     * Can contain a maximum of 200 items.
     */
    @JvmName("qqfgbkfoilyuyixb")
    public suspend fun skippedIpRangeLists(`value`: Output<List<String>>) {
        this.skippedIpRangeLists = value
    }

    @JvmName("sicmhprhgqyxmqim")
    public suspend fun skippedIpRangeLists(vararg values: Output<String>) {
        this.skippedIpRangeLists = Output.all(values.asList())
    }

    /**
     * @param values Risk detection isn't performed on the IP addresses in this range list.
     * The IP range is in CIDR notation.
     * Can contain a maximum of 200 items.
     */
    @JvmName("cavkwkhkxcuvujsd")
    public suspend fun skippedIpRangeLists(values: List<Output<String>>) {
        this.skippedIpRangeLists = Output.all(values)
    }

    /**
     * @param value Overrides the risk decision to always block the pre-authentication requests.
     * The IP range is in CIDR notation, a compact representation of an IP address and its routing prefix.
     * Can contain a maximum of 200 items.
     */
    @JvmName("hbworsjfkcucxvma")
    public suspend fun blockedIpRangeLists(`value`: List<String>?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.blockedIpRangeLists = mapped
    }

    /**
     * @param values Overrides the risk decision to always block the pre-authentication requests.
     * The IP range is in CIDR notation, a compact representation of an IP address and its routing prefix.
     * Can contain a maximum of 200 items.
     */
    @JvmName("oeijqplvnkyvfvoh")
    public suspend fun blockedIpRangeLists(vararg values: String) {
        val toBeMapped = values.toList()
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.blockedIpRangeLists = mapped
    }

    /**
     * @param value Risk detection isn't performed on the IP addresses in this range list.
     * The IP range is in CIDR notation.
     * Can contain a maximum of 200 items.
     */
    @JvmName("gxxtcvdbohjtrmew")
    public suspend fun skippedIpRangeLists(`value`: List<String>?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.skippedIpRangeLists = mapped
    }

    /**
     * @param values Risk detection isn't performed on the IP addresses in this range list.
     * The IP range is in CIDR notation.
     * Can contain a maximum of 200 items.
     */
    @JvmName("rkvirhlppwmgowhl")
    public suspend fun skippedIpRangeLists(vararg values: String) {
        val toBeMapped = values.toList()
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.skippedIpRangeLists = mapped
    }

    internal fun build(): RiskConfigurationRiskExceptionConfigurationArgs =
        RiskConfigurationRiskExceptionConfigurationArgs(
            blockedIpRangeLists = blockedIpRangeLists,
            skippedIpRangeLists = skippedIpRangeLists,
        )
}
