@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.aws.cognito.kotlin.inputs

import com.pulumi.aws.cognito.inputs.UserPoolAccountRecoverySettingRecoveryMechanismArgs.builder
import com.pulumi.core.Output
import com.pulumi.core.Output.of
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiNullFieldException
import com.pulumi.kotlin.PulumiTagMarker
import kotlin.Int
import kotlin.String
import kotlin.Suppress
import kotlin.jvm.JvmName

/**
 *
 * @property name Recovery method for a user. Can be of the following: `verified_email`, `verified_phone_number`, and `admin_only`.
 * @property priority Positive integer specifying priority of a method with 1 being the highest priority.
 */
public data class UserPoolAccountRecoverySettingRecoveryMechanismArgs(
    public val name: Output<String>,
    public val priority: Output<Int>,
) :
    ConvertibleToJava<com.pulumi.aws.cognito.inputs.UserPoolAccountRecoverySettingRecoveryMechanismArgs> {
    override fun toJava(): com.pulumi.aws.cognito.inputs.UserPoolAccountRecoverySettingRecoveryMechanismArgs =
        com.pulumi.aws.cognito.inputs.UserPoolAccountRecoverySettingRecoveryMechanismArgs.builder()
            .name(name.applyValue({ args0 -> args0 }))
            .priority(priority.applyValue({ args0 -> args0 })).build()
}

/**
 * Builder for [UserPoolAccountRecoverySettingRecoveryMechanismArgs].
 */
@PulumiTagMarker
public class UserPoolAccountRecoverySettingRecoveryMechanismArgsBuilder internal constructor() {
    private var name: Output<String>? = null

    private var priority: Output<Int>? = null

    /**
     * @param value Recovery method for a user. Can be of the following: `verified_email`, `verified_phone_number`, and `admin_only`.
     */
    @JvmName("cjserpnechypfgey")
    public suspend fun name(`value`: Output<String>) {
        this.name = value
    }

    /**
     * @param value Positive integer specifying priority of a method with 1 being the highest priority.
     */
    @JvmName("aexqhdoimamotrsk")
    public suspend fun priority(`value`: Output<Int>) {
        this.priority = value
    }

    /**
     * @param value Recovery method for a user. Can be of the following: `verified_email`, `verified_phone_number`, and `admin_only`.
     */
    @JvmName("mjsddsjxbycwvdgm")
    public suspend fun name(`value`: String) {
        val toBeMapped = value
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.name = mapped
    }

    /**
     * @param value Positive integer specifying priority of a method with 1 being the highest priority.
     */
    @JvmName("yhjfxebcaekpnopg")
    public suspend fun priority(`value`: Int) {
        val toBeMapped = value
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.priority = mapped
    }

    internal fun build(): UserPoolAccountRecoverySettingRecoveryMechanismArgs =
        UserPoolAccountRecoverySettingRecoveryMechanismArgs(
            name = name ?: throw PulumiNullFieldException("name"),
            priority = priority ?: throw PulumiNullFieldException("priority"),
        )
}
