@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.aws.cognito.kotlin.inputs

import com.pulumi.aws.cognito.inputs.UserPoolClientTokenValidityUnitsArgs.builder
import com.pulumi.core.Output
import com.pulumi.core.Output.of
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiTagMarker
import kotlin.String
import kotlin.Suppress
import kotlin.jvm.JvmName

/**
 *
 * @property accessToken Time unit in for the value in `access_token_validity`, defaults to `hours`.
 * @property idToken Time unit in for the value in `id_token_validity`, defaults to `hours`.
 * @property refreshToken Time unit in for the value in `refresh_token_validity`, defaults to `days`.
 */
public data class UserPoolClientTokenValidityUnitsArgs(
    public val accessToken: Output<String>? = null,
    public val idToken: Output<String>? = null,
    public val refreshToken: Output<String>? = null,
) : ConvertibleToJava<com.pulumi.aws.cognito.inputs.UserPoolClientTokenValidityUnitsArgs> {
    override fun toJava(): com.pulumi.aws.cognito.inputs.UserPoolClientTokenValidityUnitsArgs =
        com.pulumi.aws.cognito.inputs.UserPoolClientTokenValidityUnitsArgs.builder()
            .accessToken(accessToken?.applyValue({ args0 -> args0 }))
            .idToken(idToken?.applyValue({ args0 -> args0 }))
            .refreshToken(refreshToken?.applyValue({ args0 -> args0 })).build()
}

/**
 * Builder for [UserPoolClientTokenValidityUnitsArgs].
 */
@PulumiTagMarker
public class UserPoolClientTokenValidityUnitsArgsBuilder internal constructor() {
    private var accessToken: Output<String>? = null

    private var idToken: Output<String>? = null

    private var refreshToken: Output<String>? = null

    /**
     * @param value Time unit in for the value in `access_token_validity`, defaults to `hours`.
     */
    @JvmName("ltwiqlimbhskrdur")
    public suspend fun accessToken(`value`: Output<String>) {
        this.accessToken = value
    }

    /**
     * @param value Time unit in for the value in `id_token_validity`, defaults to `hours`.
     */
    @JvmName("uhvumncdiqajkymi")
    public suspend fun idToken(`value`: Output<String>) {
        this.idToken = value
    }

    /**
     * @param value Time unit in for the value in `refresh_token_validity`, defaults to `days`.
     */
    @JvmName("jjxxlididqhnipmi")
    public suspend fun refreshToken(`value`: Output<String>) {
        this.refreshToken = value
    }

    /**
     * @param value Time unit in for the value in `access_token_validity`, defaults to `hours`.
     */
    @JvmName("dkfuqwpelhqertql")
    public suspend fun accessToken(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.accessToken = mapped
    }

    /**
     * @param value Time unit in for the value in `id_token_validity`, defaults to `hours`.
     */
    @JvmName("dycmecmsblnhrquy")
    public suspend fun idToken(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.idToken = mapped
    }

    /**
     * @param value Time unit in for the value in `refresh_token_validity`, defaults to `days`.
     */
    @JvmName("kiqqmpdcofsreqih")
    public suspend fun refreshToken(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.refreshToken = mapped
    }

    internal fun build(): UserPoolClientTokenValidityUnitsArgs = UserPoolClientTokenValidityUnitsArgs(
        accessToken = accessToken,
        idToken = idToken,
        refreshToken = refreshToken,
    )
}
