@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.aws.cognito.kotlin.inputs

import com.pulumi.aws.cognito.inputs.UserPoolDeviceConfigurationArgs.builder
import com.pulumi.core.Output
import com.pulumi.core.Output.of
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiTagMarker
import kotlin.Boolean
import kotlin.Suppress
import kotlin.jvm.JvmName

/**
 *
 * @property challengeRequiredOnNewDevice Whether a challenge is required on a new device. Only applicable to a new device.
 * @property deviceOnlyRememberedOnUserPrompt Whether a device is only remembered on user prompt. `false` equates to "Always" remember, `true` is "User Opt In," and not using a `device_configuration` block is "No."
 */
public data class UserPoolDeviceConfigurationArgs(
    public val challengeRequiredOnNewDevice: Output<Boolean>? = null,
    public val deviceOnlyRememberedOnUserPrompt: Output<Boolean>? = null,
) : ConvertibleToJava<com.pulumi.aws.cognito.inputs.UserPoolDeviceConfigurationArgs> {
    override fun toJava(): com.pulumi.aws.cognito.inputs.UserPoolDeviceConfigurationArgs =
        com.pulumi.aws.cognito.inputs.UserPoolDeviceConfigurationArgs.builder()
            .challengeRequiredOnNewDevice(challengeRequiredOnNewDevice?.applyValue({ args0 -> args0 }))
            .deviceOnlyRememberedOnUserPrompt(
                deviceOnlyRememberedOnUserPrompt?.applyValue({ args0 ->
                    args0
                }),
            ).build()
}

/**
 * Builder for [UserPoolDeviceConfigurationArgs].
 */
@PulumiTagMarker
public class UserPoolDeviceConfigurationArgsBuilder internal constructor() {
    private var challengeRequiredOnNewDevice: Output<Boolean>? = null

    private var deviceOnlyRememberedOnUserPrompt: Output<Boolean>? = null

    /**
     * @param value Whether a challenge is required on a new device. Only applicable to a new device.
     */
    @JvmName("kbjpljmugksecpqe")
    public suspend fun challengeRequiredOnNewDevice(`value`: Output<Boolean>) {
        this.challengeRequiredOnNewDevice = value
    }

    /**
     * @param value Whether a device is only remembered on user prompt. `false` equates to "Always" remember, `true` is "User Opt In," and not using a `device_configuration` block is "No."
     */
    @JvmName("nvqspxcilaxyiwud")
    public suspend fun deviceOnlyRememberedOnUserPrompt(`value`: Output<Boolean>) {
        this.deviceOnlyRememberedOnUserPrompt = value
    }

    /**
     * @param value Whether a challenge is required on a new device. Only applicable to a new device.
     */
    @JvmName("rephnvjgaubqiutd")
    public suspend fun challengeRequiredOnNewDevice(`value`: Boolean?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.challengeRequiredOnNewDevice = mapped
    }

    /**
     * @param value Whether a device is only remembered on user prompt. `false` equates to "Always" remember, `true` is "User Opt In," and not using a `device_configuration` block is "No."
     */
    @JvmName("uwgvxwjjheeenqbg")
    public suspend fun deviceOnlyRememberedOnUserPrompt(`value`: Boolean?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.deviceOnlyRememberedOnUserPrompt = mapped
    }

    internal fun build(): UserPoolDeviceConfigurationArgs = UserPoolDeviceConfigurationArgs(
        challengeRequiredOnNewDevice = challengeRequiredOnNewDevice,
        deviceOnlyRememberedOnUserPrompt = deviceOnlyRememberedOnUserPrompt,
    )
}
