@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.aws.cognito.kotlin.inputs

import com.pulumi.aws.cognito.inputs.UserPoolEmailConfigurationArgs.builder
import com.pulumi.core.Output
import com.pulumi.core.Output.of
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiTagMarker
import kotlin.String
import kotlin.Suppress
import kotlin.jvm.JvmName

/**
 *
 * @property configurationSet Email configuration set name from SES.
 * @property emailSendingAccount Email delivery method to use. `COGNITO_DEFAULT` for the default email functionality built into Cognito or `DEVELOPER` to use your Amazon SES configuration. Required to be `DEVELOPER` if `from_email_address` is set.
 * @property fromEmailAddress Sender’s email address or sender’s display name with their email address (e.g., `john@example.com`, `John Smith <john@example.com>` or `\"John Smith Ph.D.\" <john@example.com>`). Escaped double quotes are required around display names that contain certain characters as specified in [RFC 5322](https://tools.ietf.org/html/rfc5322).
 * @property replyToEmailAddress REPLY-TO email address.
 * @property sourceArn ARN of the SES verified email identity to use. Required if `email_sending_account` is set to `DEVELOPER`.
 */
public data class UserPoolEmailConfigurationArgs(
    public val configurationSet: Output<String>? = null,
    public val emailSendingAccount: Output<String>? = null,
    public val fromEmailAddress: Output<String>? = null,
    public val replyToEmailAddress: Output<String>? = null,
    public val sourceArn: Output<String>? = null,
) : ConvertibleToJava<com.pulumi.aws.cognito.inputs.UserPoolEmailConfigurationArgs> {
    override fun toJava(): com.pulumi.aws.cognito.inputs.UserPoolEmailConfigurationArgs =
        com.pulumi.aws.cognito.inputs.UserPoolEmailConfigurationArgs.builder()
            .configurationSet(configurationSet?.applyValue({ args0 -> args0 }))
            .emailSendingAccount(emailSendingAccount?.applyValue({ args0 -> args0 }))
            .fromEmailAddress(fromEmailAddress?.applyValue({ args0 -> args0 }))
            .replyToEmailAddress(replyToEmailAddress?.applyValue({ args0 -> args0 }))
            .sourceArn(sourceArn?.applyValue({ args0 -> args0 })).build()
}

/**
 * Builder for [UserPoolEmailConfigurationArgs].
 */
@PulumiTagMarker
public class UserPoolEmailConfigurationArgsBuilder internal constructor() {
    private var configurationSet: Output<String>? = null

    private var emailSendingAccount: Output<String>? = null

    private var fromEmailAddress: Output<String>? = null

    private var replyToEmailAddress: Output<String>? = null

    private var sourceArn: Output<String>? = null

    /**
     * @param value Email configuration set name from SES.
     */
    @JvmName("hdndtwgwpeaxchjo")
    public suspend fun configurationSet(`value`: Output<String>) {
        this.configurationSet = value
    }

    /**
     * @param value Email delivery method to use. `COGNITO_DEFAULT` for the default email functionality built into Cognito or `DEVELOPER` to use your Amazon SES configuration. Required to be `DEVELOPER` if `from_email_address` is set.
     */
    @JvmName("wlwtgfxxnbppgkab")
    public suspend fun emailSendingAccount(`value`: Output<String>) {
        this.emailSendingAccount = value
    }

    /**
     * @param value Sender’s email address or sender’s display name with their email address (e.g., `john@example.com`, `John Smith <john@example.com>` or `\"John Smith Ph.D.\" <john@example.com>`). Escaped double quotes are required around display names that contain certain characters as specified in [RFC 5322](https://tools.ietf.org/html/rfc5322).
     */
    @JvmName("whbfwurxqjrkxfos")
    public suspend fun fromEmailAddress(`value`: Output<String>) {
        this.fromEmailAddress = value
    }

    /**
     * @param value REPLY-TO email address.
     */
    @JvmName("rkgcbwujsukddcft")
    public suspend fun replyToEmailAddress(`value`: Output<String>) {
        this.replyToEmailAddress = value
    }

    /**
     * @param value ARN of the SES verified email identity to use. Required if `email_sending_account` is set to `DEVELOPER`.
     */
    @JvmName("tahtgcwhnojijcew")
    public suspend fun sourceArn(`value`: Output<String>) {
        this.sourceArn = value
    }

    /**
     * @param value Email configuration set name from SES.
     */
    @JvmName("igdiqmnxpnqgaodm")
    public suspend fun configurationSet(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.configurationSet = mapped
    }

    /**
     * @param value Email delivery method to use. `COGNITO_DEFAULT` for the default email functionality built into Cognito or `DEVELOPER` to use your Amazon SES configuration. Required to be `DEVELOPER` if `from_email_address` is set.
     */
    @JvmName("llglpqahipnpeurp")
    public suspend fun emailSendingAccount(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.emailSendingAccount = mapped
    }

    /**
     * @param value Sender’s email address or sender’s display name with their email address (e.g., `john@example.com`, `John Smith <john@example.com>` or `\"John Smith Ph.D.\" <john@example.com>`). Escaped double quotes are required around display names that contain certain characters as specified in [RFC 5322](https://tools.ietf.org/html/rfc5322).
     */
    @JvmName("poxoqmyuedoghyvn")
    public suspend fun fromEmailAddress(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.fromEmailAddress = mapped
    }

    /**
     * @param value REPLY-TO email address.
     */
    @JvmName("xgjgckclialdoxfk")
    public suspend fun replyToEmailAddress(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.replyToEmailAddress = mapped
    }

    /**
     * @param value ARN of the SES verified email identity to use. Required if `email_sending_account` is set to `DEVELOPER`.
     */
    @JvmName("jyxiufpdmfrcmvad")
    public suspend fun sourceArn(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.sourceArn = mapped
    }

    internal fun build(): UserPoolEmailConfigurationArgs = UserPoolEmailConfigurationArgs(
        configurationSet = configurationSet,
        emailSendingAccount = emailSendingAccount,
        fromEmailAddress = fromEmailAddress,
        replyToEmailAddress = replyToEmailAddress,
        sourceArn = sourceArn,
    )
}
