@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.aws.cognito.kotlin.inputs

import com.pulumi.aws.cognito.inputs.UserPoolLambdaConfigCustomEmailSenderArgs.builder
import com.pulumi.core.Output
import com.pulumi.core.Output.of
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiNullFieldException
import com.pulumi.kotlin.PulumiTagMarker
import kotlin.String
import kotlin.Suppress
import kotlin.jvm.JvmName

/**
 *
 * @property lambdaArn The Lambda Amazon Resource Name of the Lambda function that Amazon Cognito triggers to send email notifications to users.
 * @property lambdaVersion The Lambda version represents the signature of the "request" attribute in the "event" information Amazon Cognito passes to your custom email Lambda function. The only supported value is `V1_0`.
 */
public data class UserPoolLambdaConfigCustomEmailSenderArgs(
    public val lambdaArn: Output<String>,
    public val lambdaVersion: Output<String>,
) : ConvertibleToJava<com.pulumi.aws.cognito.inputs.UserPoolLambdaConfigCustomEmailSenderArgs> {
    override fun toJava(): com.pulumi.aws.cognito.inputs.UserPoolLambdaConfigCustomEmailSenderArgs =
        com.pulumi.aws.cognito.inputs.UserPoolLambdaConfigCustomEmailSenderArgs.builder()
            .lambdaArn(lambdaArn.applyValue({ args0 -> args0 }))
            .lambdaVersion(lambdaVersion.applyValue({ args0 -> args0 })).build()
}

/**
 * Builder for [UserPoolLambdaConfigCustomEmailSenderArgs].
 */
@PulumiTagMarker
public class UserPoolLambdaConfigCustomEmailSenderArgsBuilder internal constructor() {
    private var lambdaArn: Output<String>? = null

    private var lambdaVersion: Output<String>? = null

    /**
     * @param value The Lambda Amazon Resource Name of the Lambda function that Amazon Cognito triggers to send email notifications to users.
     */
    @JvmName("abfrymuqjereewsr")
    public suspend fun lambdaArn(`value`: Output<String>) {
        this.lambdaArn = value
    }

    /**
     * @param value The Lambda version represents the signature of the "request" attribute in the "event" information Amazon Cognito passes to your custom email Lambda function. The only supported value is `V1_0`.
     */
    @JvmName("wbqhxwaphnhemmln")
    public suspend fun lambdaVersion(`value`: Output<String>) {
        this.lambdaVersion = value
    }

    /**
     * @param value The Lambda Amazon Resource Name of the Lambda function that Amazon Cognito triggers to send email notifications to users.
     */
    @JvmName("psmvxlscmlghkdcx")
    public suspend fun lambdaArn(`value`: String) {
        val toBeMapped = value
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.lambdaArn = mapped
    }

    /**
     * @param value The Lambda version represents the signature of the "request" attribute in the "event" information Amazon Cognito passes to your custom email Lambda function. The only supported value is `V1_0`.
     */
    @JvmName("cghkknhdnochrmar")
    public suspend fun lambdaVersion(`value`: String) {
        val toBeMapped = value
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.lambdaVersion = mapped
    }

    internal fun build(): UserPoolLambdaConfigCustomEmailSenderArgs =
        UserPoolLambdaConfigCustomEmailSenderArgs(
            lambdaArn = lambdaArn ?: throw PulumiNullFieldException("lambdaArn"),
            lambdaVersion = lambdaVersion ?: throw PulumiNullFieldException("lambdaVersion"),
        )
}
