@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.aws.cognito.kotlin.inputs

import com.pulumi.aws.cognito.inputs.UserPoolLambdaConfigCustomSmsSenderArgs.builder
import com.pulumi.core.Output
import com.pulumi.core.Output.of
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiNullFieldException
import com.pulumi.kotlin.PulumiTagMarker
import kotlin.String
import kotlin.Suppress
import kotlin.jvm.JvmName

/**
 *
 * @property lambdaArn The Lambda Amazon Resource Name of the Lambda function that Amazon Cognito triggers to send SMS notifications to users.
 * @property lambdaVersion The Lambda version represents the signature of the "request" attribute in the "event" information Amazon Cognito passes to your custom SMS Lambda function. The only supported value is `V1_0`.
 */
public data class UserPoolLambdaConfigCustomSmsSenderArgs(
    public val lambdaArn: Output<String>,
    public val lambdaVersion: Output<String>,
) : ConvertibleToJava<com.pulumi.aws.cognito.inputs.UserPoolLambdaConfigCustomSmsSenderArgs> {
    override fun toJava(): com.pulumi.aws.cognito.inputs.UserPoolLambdaConfigCustomSmsSenderArgs =
        com.pulumi.aws.cognito.inputs.UserPoolLambdaConfigCustomSmsSenderArgs.builder()
            .lambdaArn(lambdaArn.applyValue({ args0 -> args0 }))
            .lambdaVersion(lambdaVersion.applyValue({ args0 -> args0 })).build()
}

/**
 * Builder for [UserPoolLambdaConfigCustomSmsSenderArgs].
 */
@PulumiTagMarker
public class UserPoolLambdaConfigCustomSmsSenderArgsBuilder internal constructor() {
    private var lambdaArn: Output<String>? = null

    private var lambdaVersion: Output<String>? = null

    /**
     * @param value The Lambda Amazon Resource Name of the Lambda function that Amazon Cognito triggers to send SMS notifications to users.
     */
    @JvmName("ewbubbdnhasmrukv")
    public suspend fun lambdaArn(`value`: Output<String>) {
        this.lambdaArn = value
    }

    /**
     * @param value The Lambda version represents the signature of the "request" attribute in the "event" information Amazon Cognito passes to your custom SMS Lambda function. The only supported value is `V1_0`.
     */
    @JvmName("lrsgqrtrmpprngqs")
    public suspend fun lambdaVersion(`value`: Output<String>) {
        this.lambdaVersion = value
    }

    /**
     * @param value The Lambda Amazon Resource Name of the Lambda function that Amazon Cognito triggers to send SMS notifications to users.
     */
    @JvmName("xemqudijgsctehvg")
    public suspend fun lambdaArn(`value`: String) {
        val toBeMapped = value
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.lambdaArn = mapped
    }

    /**
     * @param value The Lambda version represents the signature of the "request" attribute in the "event" information Amazon Cognito passes to your custom SMS Lambda function. The only supported value is `V1_0`.
     */
    @JvmName("qkourwqyrmrgotbt")
    public suspend fun lambdaVersion(`value`: String) {
        val toBeMapped = value
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.lambdaVersion = mapped
    }

    internal fun build(): UserPoolLambdaConfigCustomSmsSenderArgs =
        UserPoolLambdaConfigCustomSmsSenderArgs(
            lambdaArn = lambdaArn ?: throw PulumiNullFieldException("lambdaArn"),
            lambdaVersion = lambdaVersion ?: throw PulumiNullFieldException("lambdaVersion"),
        )
}
