@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.aws.cognito.kotlin.inputs

import com.pulumi.aws.cognito.inputs.UserPoolLambdaConfigPreTokenGenerationConfigArgs.builder
import com.pulumi.core.Output
import com.pulumi.core.Output.of
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiNullFieldException
import com.pulumi.kotlin.PulumiTagMarker
import kotlin.String
import kotlin.Suppress
import kotlin.jvm.JvmName

/**
 *
 * @property lambdaArn
 * @property lambdaVersion
 */
public data class UserPoolLambdaConfigPreTokenGenerationConfigArgs(
    public val lambdaArn: Output<String>,
    public val lambdaVersion: Output<String>,
) :
    ConvertibleToJava<com.pulumi.aws.cognito.inputs.UserPoolLambdaConfigPreTokenGenerationConfigArgs> {
    override fun toJava(): com.pulumi.aws.cognito.inputs.UserPoolLambdaConfigPreTokenGenerationConfigArgs =
        com.pulumi.aws.cognito.inputs.UserPoolLambdaConfigPreTokenGenerationConfigArgs.builder()
            .lambdaArn(lambdaArn.applyValue({ args0 -> args0 }))
            .lambdaVersion(lambdaVersion.applyValue({ args0 -> args0 })).build()
}

/**
 * Builder for [UserPoolLambdaConfigPreTokenGenerationConfigArgs].
 */
@PulumiTagMarker
public class UserPoolLambdaConfigPreTokenGenerationConfigArgsBuilder internal constructor() {
    private var lambdaArn: Output<String>? = null

    private var lambdaVersion: Output<String>? = null

    /**
     * @param value
     */
    @JvmName("cetxhjucilvvsdnf")
    public suspend fun lambdaArn(`value`: Output<String>) {
        this.lambdaArn = value
    }

    /**
     * @param value
     */
    @JvmName("sfmlpdjypwqllayg")
    public suspend fun lambdaVersion(`value`: Output<String>) {
        this.lambdaVersion = value
    }

    /**
     * @param value
     */
    @JvmName("rjeafdtblsxttvnb")
    public suspend fun lambdaArn(`value`: String) {
        val toBeMapped = value
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.lambdaArn = mapped
    }

    /**
     * @param value
     */
    @JvmName("kusaibnuciqsrthb")
    public suspend fun lambdaVersion(`value`: String) {
        val toBeMapped = value
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.lambdaVersion = mapped
    }

    internal fun build(): UserPoolLambdaConfigPreTokenGenerationConfigArgs =
        UserPoolLambdaConfigPreTokenGenerationConfigArgs(
            lambdaArn = lambdaArn ?: throw PulumiNullFieldException("lambdaArn"),
            lambdaVersion = lambdaVersion ?: throw PulumiNullFieldException("lambdaVersion"),
        )
}
