@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.aws.cognito.kotlin.inputs

import com.pulumi.aws.cognito.inputs.UserPoolSchemaArgs.builder
import com.pulumi.core.Output
import com.pulumi.core.Output.of
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiNullFieldException
import com.pulumi.kotlin.PulumiTagMarker
import com.pulumi.kotlin.applySuspend
import kotlin.Boolean
import kotlin.String
import kotlin.Suppress
import kotlin.Unit
import kotlin.jvm.JvmName

/**
 *
 * @property attributeDataType Attribute data type. Must be one of `Boolean`, `Number`, `String`, `DateTime`.
 * @property developerOnlyAttribute Whether the attribute type is developer only.
 * @property mutable Whether the attribute can be changed once it has been created.
 * @property name Name of the attribute.
 * @property numberAttributeConstraints Configuration block for the constraints for an attribute of the number type. Detailed below.
 * @property required Whether a user pool attribute is required. If the attribute is required and the user does not provide a value, registration or sign-in will fail.
 * @property stringAttributeConstraints Constraints for an attribute of the string type. Detailed below.
 */
public data class UserPoolSchemaArgs(
    public val attributeDataType: Output<String>,
    public val developerOnlyAttribute: Output<Boolean>? = null,
    public val mutable: Output<Boolean>? = null,
    public val name: Output<String>,
    public val numberAttributeConstraints: Output<UserPoolSchemaNumberAttributeConstraintsArgs>? =
        null,
    public val required: Output<Boolean>? = null,
    public val stringAttributeConstraints: Output<UserPoolSchemaStringAttributeConstraintsArgs>? =
        null,
) : ConvertibleToJava<com.pulumi.aws.cognito.inputs.UserPoolSchemaArgs> {
    override fun toJava(): com.pulumi.aws.cognito.inputs.UserPoolSchemaArgs =
        com.pulumi.aws.cognito.inputs.UserPoolSchemaArgs.builder()
            .attributeDataType(attributeDataType.applyValue({ args0 -> args0 }))
            .developerOnlyAttribute(developerOnlyAttribute?.applyValue({ args0 -> args0 }))
            .mutable(mutable?.applyValue({ args0 -> args0 }))
            .name(name.applyValue({ args0 -> args0 }))
            .numberAttributeConstraints(
                numberAttributeConstraints?.applyValue({ args0 ->
                    args0.let({ args0 ->
                        args0.toJava()
                    })
                }),
            )
            .required(required?.applyValue({ args0 -> args0 }))
            .stringAttributeConstraints(
                stringAttributeConstraints?.applyValue({ args0 ->
                    args0.let({ args0 ->
                        args0.toJava()
                    })
                }),
            ).build()
}

/**
 * Builder for [UserPoolSchemaArgs].
 */
@PulumiTagMarker
public class UserPoolSchemaArgsBuilder internal constructor() {
    private var attributeDataType: Output<String>? = null

    private var developerOnlyAttribute: Output<Boolean>? = null

    private var mutable: Output<Boolean>? = null

    private var name: Output<String>? = null

    private var numberAttributeConstraints: Output<UserPoolSchemaNumberAttributeConstraintsArgs>? =
        null

    private var required: Output<Boolean>? = null

    private var stringAttributeConstraints: Output<UserPoolSchemaStringAttributeConstraintsArgs>? =
        null

    /**
     * @param value Attribute data type. Must be one of `Boolean`, `Number`, `String`, `DateTime`.
     */
    @JvmName("msiwtarufiemicdw")
    public suspend fun attributeDataType(`value`: Output<String>) {
        this.attributeDataType = value
    }

    /**
     * @param value Whether the attribute type is developer only.
     */
    @JvmName("rqrmbpbxygsxmuvd")
    public suspend fun developerOnlyAttribute(`value`: Output<Boolean>) {
        this.developerOnlyAttribute = value
    }

    /**
     * @param value Whether the attribute can be changed once it has been created.
     */
    @JvmName("iidhmbpycyqnojov")
    public suspend fun mutable(`value`: Output<Boolean>) {
        this.mutable = value
    }

    /**
     * @param value Name of the attribute.
     */
    @JvmName("mqduqdunsvhsdses")
    public suspend fun name(`value`: Output<String>) {
        this.name = value
    }

    /**
     * @param value Configuration block for the constraints for an attribute of the number type. Detailed below.
     */
    @JvmName("smsqredeqmicrnqu")
    public suspend fun numberAttributeConstraints(`value`: Output<UserPoolSchemaNumberAttributeConstraintsArgs>) {
        this.numberAttributeConstraints = value
    }

    /**
     * @param value Whether a user pool attribute is required. If the attribute is required and the user does not provide a value, registration or sign-in will fail.
     */
    @JvmName("tvtavqvbphpnfbvk")
    public suspend fun required(`value`: Output<Boolean>) {
        this.required = value
    }

    /**
     * @param value Constraints for an attribute of the string type. Detailed below.
     */
    @JvmName("suwlvdgehljdkelm")
    public suspend fun stringAttributeConstraints(`value`: Output<UserPoolSchemaStringAttributeConstraintsArgs>) {
        this.stringAttributeConstraints = value
    }

    /**
     * @param value Attribute data type. Must be one of `Boolean`, `Number`, `String`, `DateTime`.
     */
    @JvmName("varlfmybqefmacks")
    public suspend fun attributeDataType(`value`: String) {
        val toBeMapped = value
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.attributeDataType = mapped
    }

    /**
     * @param value Whether the attribute type is developer only.
     */
    @JvmName("jvnthdshowxqdkpl")
    public suspend fun developerOnlyAttribute(`value`: Boolean?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.developerOnlyAttribute = mapped
    }

    /**
     * @param value Whether the attribute can be changed once it has been created.
     */
    @JvmName("byjedvwbpslohewm")
    public suspend fun mutable(`value`: Boolean?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.mutable = mapped
    }

    /**
     * @param value Name of the attribute.
     */
    @JvmName("hfdtettrbyeywasb")
    public suspend fun name(`value`: String) {
        val toBeMapped = value
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.name = mapped
    }

    /**
     * @param value Configuration block for the constraints for an attribute of the number type. Detailed below.
     */
    @JvmName("lhvlswtthxipfmjm")
    public suspend fun numberAttributeConstraints(`value`: UserPoolSchemaNumberAttributeConstraintsArgs?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.numberAttributeConstraints = mapped
    }

    /**
     * @param argument Configuration block for the constraints for an attribute of the number type. Detailed below.
     */
    @JvmName("dwuvtcpdsbtwisqt")
    public suspend fun numberAttributeConstraints(argument: suspend UserPoolSchemaNumberAttributeConstraintsArgsBuilder.() -> Unit) {
        val toBeMapped = UserPoolSchemaNumberAttributeConstraintsArgsBuilder().applySuspend {
            argument()
        }.build()
        val mapped = of(toBeMapped)
        this.numberAttributeConstraints = mapped
    }

    /**
     * @param value Whether a user pool attribute is required. If the attribute is required and the user does not provide a value, registration or sign-in will fail.
     */
    @JvmName("dclhhqlbmeobmhwe")
    public suspend fun required(`value`: Boolean?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.required = mapped
    }

    /**
     * @param value Constraints for an attribute of the string type. Detailed below.
     */
    @JvmName("sctbghwuvqvomcsp")
    public suspend fun stringAttributeConstraints(`value`: UserPoolSchemaStringAttributeConstraintsArgs?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.stringAttributeConstraints = mapped
    }

    /**
     * @param argument Constraints for an attribute of the string type. Detailed below.
     */
    @JvmName("gikajlvbcqexsuid")
    public suspend fun stringAttributeConstraints(argument: suspend UserPoolSchemaStringAttributeConstraintsArgsBuilder.() -> Unit) {
        val toBeMapped = UserPoolSchemaStringAttributeConstraintsArgsBuilder().applySuspend {
            argument()
        }.build()
        val mapped = of(toBeMapped)
        this.stringAttributeConstraints = mapped
    }

    internal fun build(): UserPoolSchemaArgs = UserPoolSchemaArgs(
        attributeDataType = attributeDataType ?: throw PulumiNullFieldException("attributeDataType"),
        developerOnlyAttribute = developerOnlyAttribute,
        mutable = mutable,
        name = name ?: throw PulumiNullFieldException("name"),
        numberAttributeConstraints = numberAttributeConstraints,
        required = required,
        stringAttributeConstraints = stringAttributeConstraints,
    )
}
