@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.aws.cognito.kotlin.inputs

import com.pulumi.aws.cognito.inputs.UserPoolSchemaStringAttributeConstraintsArgs.builder
import com.pulumi.core.Output
import com.pulumi.core.Output.of
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiTagMarker
import kotlin.String
import kotlin.Suppress
import kotlin.jvm.JvmName

/**
 *
 * @property maxLength Maximum length of an attribute value of the string type.
 * @property minLength Minimum length of an attribute value of the string type.
 */
public data class UserPoolSchemaStringAttributeConstraintsArgs(
    public val maxLength: Output<String>? = null,
    public val minLength: Output<String>? = null,
) : ConvertibleToJava<com.pulumi.aws.cognito.inputs.UserPoolSchemaStringAttributeConstraintsArgs> {
    override fun toJava(): com.pulumi.aws.cognito.inputs.UserPoolSchemaStringAttributeConstraintsArgs = com.pulumi.aws.cognito.inputs.UserPoolSchemaStringAttributeConstraintsArgs.builder()
        .maxLength(maxLength?.applyValue({ args0 -> args0 }))
        .minLength(minLength?.applyValue({ args0 -> args0 })).build()
}

/**
 * Builder for [UserPoolSchemaStringAttributeConstraintsArgs].
 */
@PulumiTagMarker
public class UserPoolSchemaStringAttributeConstraintsArgsBuilder internal constructor() {
    private var maxLength: Output<String>? = null

    private var minLength: Output<String>? = null

    /**
     * @param value Maximum length of an attribute value of the string type.
     */
    @JvmName("cnfeiligoigdfmdn")
    public suspend fun maxLength(`value`: Output<String>) {
        this.maxLength = value
    }

    /**
     * @param value Minimum length of an attribute value of the string type.
     */
    @JvmName("iaojtvabbfnagwnu")
    public suspend fun minLength(`value`: Output<String>) {
        this.minLength = value
    }

    /**
     * @param value Maximum length of an attribute value of the string type.
     */
    @JvmName("mqwbfynkxpcsvprd")
    public suspend fun maxLength(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.maxLength = mapped
    }

    /**
     * @param value Minimum length of an attribute value of the string type.
     */
    @JvmName("utenqluvsnmupcao")
    public suspend fun minLength(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.minLength = mapped
    }

    internal fun build(): UserPoolSchemaStringAttributeConstraintsArgs =
        UserPoolSchemaStringAttributeConstraintsArgs(
            maxLength = maxLength,
            minLength = minLength,
        )
}
