@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.aws.cognito.kotlin.inputs

import com.pulumi.aws.cognito.inputs.UserPoolSoftwareTokenMfaConfigurationArgs.builder
import com.pulumi.core.Output
import com.pulumi.core.Output.of
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiNullFieldException
import com.pulumi.kotlin.PulumiTagMarker
import kotlin.Boolean
import kotlin.Suppress
import kotlin.jvm.JvmName

/**
 *
 * @property enabled Boolean whether to enable software token Multi-Factor (MFA) tokens, such as Time-based One-Time Password (TOTP). To disable software token MFA When `sms_configuration` is not present, the `mfa_configuration` argument must be set to `OFF` and the `software_token_mfa_configuration` configuration block must be fully removed.
 */
public data class UserPoolSoftwareTokenMfaConfigurationArgs(
    public val enabled: Output<Boolean>,
) : ConvertibleToJava<com.pulumi.aws.cognito.inputs.UserPoolSoftwareTokenMfaConfigurationArgs> {
    override fun toJava(): com.pulumi.aws.cognito.inputs.UserPoolSoftwareTokenMfaConfigurationArgs =
        com.pulumi.aws.cognito.inputs.UserPoolSoftwareTokenMfaConfigurationArgs.builder()
            .enabled(enabled.applyValue({ args0 -> args0 })).build()
}

/**
 * Builder for [UserPoolSoftwareTokenMfaConfigurationArgs].
 */
@PulumiTagMarker
public class UserPoolSoftwareTokenMfaConfigurationArgsBuilder internal constructor() {
    private var enabled: Output<Boolean>? = null

    /**
     * @param value Boolean whether to enable software token Multi-Factor (MFA) tokens, such as Time-based One-Time Password (TOTP). To disable software token MFA When `sms_configuration` is not present, the `mfa_configuration` argument must be set to `OFF` and the `software_token_mfa_configuration` configuration block must be fully removed.
     */
    @JvmName("ivrqtffusxoariuu")
    public suspend fun enabled(`value`: Output<Boolean>) {
        this.enabled = value
    }

    /**
     * @param value Boolean whether to enable software token Multi-Factor (MFA) tokens, such as Time-based One-Time Password (TOTP). To disable software token MFA When `sms_configuration` is not present, the `mfa_configuration` argument must be set to `OFF` and the `software_token_mfa_configuration` configuration block must be fully removed.
     */
    @JvmName("wrldeunffpuuokuf")
    public suspend fun enabled(`value`: Boolean) {
        val toBeMapped = value
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.enabled = mapped
    }

    internal fun build(): UserPoolSoftwareTokenMfaConfigurationArgs =
        UserPoolSoftwareTokenMfaConfigurationArgs(
            enabled = enabled ?: throw PulumiNullFieldException("enabled"),
        )
}
