@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.aws.cognito.kotlin.inputs

import com.pulumi.aws.cognito.inputs.UserPoolUserAttributeUpdateSettingsArgs.builder
import com.pulumi.core.Output
import com.pulumi.core.Output.of
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiNullFieldException
import com.pulumi.kotlin.PulumiTagMarker
import kotlin.String
import kotlin.Suppress
import kotlin.collections.List
import kotlin.jvm.JvmName

/**
 *
 * @property attributesRequireVerificationBeforeUpdates A list of attributes requiring verification before update. If set, the provided value(s) must also be set in `auto_verified_attributes`. Valid values: `email`, `phone_number`.
 */
public data class UserPoolUserAttributeUpdateSettingsArgs(
    public val attributesRequireVerificationBeforeUpdates: Output<List<String>>,
) : ConvertibleToJava<com.pulumi.aws.cognito.inputs.UserPoolUserAttributeUpdateSettingsArgs> {
    override fun toJava(): com.pulumi.aws.cognito.inputs.UserPoolUserAttributeUpdateSettingsArgs =
        com.pulumi.aws.cognito.inputs.UserPoolUserAttributeUpdateSettingsArgs.builder()
            .attributesRequireVerificationBeforeUpdates(
                attributesRequireVerificationBeforeUpdates.applyValue({ args0 ->
                    args0.map({ args0 -> args0 })
                }),
            ).build()
}

/**
 * Builder for [UserPoolUserAttributeUpdateSettingsArgs].
 */
@PulumiTagMarker
public class UserPoolUserAttributeUpdateSettingsArgsBuilder internal constructor() {
    private var attributesRequireVerificationBeforeUpdates: Output<List<String>>? = null

    /**
     * @param value A list of attributes requiring verification before update. If set, the provided value(s) must also be set in `auto_verified_attributes`. Valid values: `email`, `phone_number`.
     */
    @JvmName("hitheoinninjdaje")
    public suspend fun attributesRequireVerificationBeforeUpdates(`value`: Output<List<String>>) {
        this.attributesRequireVerificationBeforeUpdates = value
    }

    @JvmName("hxlydjueaeyocclj")
    public suspend fun attributesRequireVerificationBeforeUpdates(vararg values: Output<String>) {
        this.attributesRequireVerificationBeforeUpdates = Output.all(values.asList())
    }

    /**
     * @param values A list of attributes requiring verification before update. If set, the provided value(s) must also be set in `auto_verified_attributes`. Valid values: `email`, `phone_number`.
     */
    @JvmName("wtaitnkimxiakyda")
    public suspend fun attributesRequireVerificationBeforeUpdates(values: List<Output<String>>) {
        this.attributesRequireVerificationBeforeUpdates = Output.all(values)
    }

    /**
     * @param value A list of attributes requiring verification before update. If set, the provided value(s) must also be set in `auto_verified_attributes`. Valid values: `email`, `phone_number`.
     */
    @JvmName("fomsbyflvrfspptj")
    public suspend fun attributesRequireVerificationBeforeUpdates(`value`: List<String>) {
        val toBeMapped = value
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.attributesRequireVerificationBeforeUpdates = mapped
    }

    /**
     * @param values A list of attributes requiring verification before update. If set, the provided value(s) must also be set in `auto_verified_attributes`. Valid values: `email`, `phone_number`.
     */
    @JvmName("tvckqwtbtvlbgroh")
    public suspend fun attributesRequireVerificationBeforeUpdates(vararg values: String) {
        val toBeMapped = values.toList()
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.attributesRequireVerificationBeforeUpdates = mapped
    }

    internal fun build(): UserPoolUserAttributeUpdateSettingsArgs =
        UserPoolUserAttributeUpdateSettingsArgs(
            attributesRequireVerificationBeforeUpdates = attributesRequireVerificationBeforeUpdates ?: throw
                PulumiNullFieldException("attributesRequireVerificationBeforeUpdates"),
        )
}
