@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.aws.cognito.kotlin.inputs

import com.pulumi.aws.cognito.inputs.UserPoolUsernameConfigurationArgs.builder
import com.pulumi.core.Output
import com.pulumi.core.Output.of
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiNullFieldException
import com.pulumi.kotlin.PulumiTagMarker
import kotlin.Boolean
import kotlin.Suppress
import kotlin.jvm.JvmName

/**
 *
 * @property caseSensitive Whether username case sensitivity will be applied for all users in the user pool through Cognito APIs.
 */
public data class UserPoolUsernameConfigurationArgs(
    public val caseSensitive: Output<Boolean>,
) : ConvertibleToJava<com.pulumi.aws.cognito.inputs.UserPoolUsernameConfigurationArgs> {
    override fun toJava(): com.pulumi.aws.cognito.inputs.UserPoolUsernameConfigurationArgs =
        com.pulumi.aws.cognito.inputs.UserPoolUsernameConfigurationArgs.builder()
            .caseSensitive(caseSensitive.applyValue({ args0 -> args0 })).build()
}

/**
 * Builder for [UserPoolUsernameConfigurationArgs].
 */
@PulumiTagMarker
public class UserPoolUsernameConfigurationArgsBuilder internal constructor() {
    private var caseSensitive: Output<Boolean>? = null

    /**
     * @param value Whether username case sensitivity will be applied for all users in the user pool through Cognito APIs.
     */
    @JvmName("gtpmpccdlfacwmbs")
    public suspend fun caseSensitive(`value`: Output<Boolean>) {
        this.caseSensitive = value
    }

    /**
     * @param value Whether username case sensitivity will be applied for all users in the user pool through Cognito APIs.
     */
    @JvmName("orukmuxnxbpbtutg")
    public suspend fun caseSensitive(`value`: Boolean) {
        val toBeMapped = value
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.caseSensitive = mapped
    }

    internal fun build(): UserPoolUsernameConfigurationArgs = UserPoolUsernameConfigurationArgs(
        caseSensitive = caseSensitive ?: throw PulumiNullFieldException("caseSensitive"),
    )
}
