@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.aws.cognito.kotlin.outputs

import kotlin.Boolean
import kotlin.String
import kotlin.Suppress
import kotlin.collections.List
import kotlin.collections.Map

/**
 * A collection of values returned by getIdentityPool.
 * @property allowClassicFlow Whether the classic / basic authentication flow is enabled.
 * @property allowUnauthenticatedIdentities Whether the identity pool supports unauthenticated logins or not.
 * @property arn ARN of the Pool.
 * @property cognitoIdentityProviders An array of Amazon Cognito Identity user pools and their client IDs.
 * @property developerProviderName The "domain" by which Cognito will refer to your users.
 * @property id The provider-assigned unique ID for this managed resource.
 * @property identityPoolName
 * @property openidConnectProviderArns Set of OpendID Connect provider ARNs.
 * @property samlProviderArns An array of Amazon Resource Names (ARNs) of the SAML provider for your identity.
 * @property supportedLoginProviders Key-Value pairs mapping provider names to provider app IDs.
 * @property tags A map of tags to assigned to the Identity Pool.
 */
public data class GetIdentityPoolResult(
    public val allowClassicFlow: Boolean,
    public val allowUnauthenticatedIdentities: Boolean,
    public val arn: String,
    public val cognitoIdentityProviders: List<GetIdentityPoolCognitoIdentityProvider>,
    public val developerProviderName: String,
    public val id: String,
    public val identityPoolName: String,
    public val openidConnectProviderArns: List<String>,
    public val samlProviderArns: List<String>,
    public val supportedLoginProviders: Map<String, String>,
    public val tags: Map<String, String>,
) {
    public companion object {
        public fun toKotlin(javaType: com.pulumi.aws.cognito.outputs.GetIdentityPoolResult): GetIdentityPoolResult = GetIdentityPoolResult(
            allowClassicFlow = javaType.allowClassicFlow(),
            allowUnauthenticatedIdentities = javaType.allowUnauthenticatedIdentities(),
            arn = javaType.arn(),
            cognitoIdentityProviders = javaType.cognitoIdentityProviders().map({ args0 ->
                args0.let({ args0 ->
                    com.pulumi.aws.cognito.kotlin.outputs.GetIdentityPoolCognitoIdentityProvider.Companion.toKotlin(args0)
                })
            }),
            developerProviderName = javaType.developerProviderName(),
            id = javaType.id(),
            identityPoolName = javaType.identityPoolName(),
            openidConnectProviderArns = javaType.openidConnectProviderArns().map({ args0 -> args0 }),
            samlProviderArns = javaType.samlProviderArns().map({ args0 -> args0 }),
            supportedLoginProviders = javaType.supportedLoginProviders().map({ args0 ->
                args0.key.to(args0.value)
            }).toMap(),
            tags = javaType.tags().map({ args0 -> args0.key.to(args0.value) }).toMap(),
        )
    }
}
