@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.aws.cognito.kotlin.outputs

import kotlin.Int
import kotlin.String
import kotlin.Suppress

/**
 * A collection of values returned by getUserGroup.
 * @property description Description of the user group.
 * @property id A comma-delimited string concatenating `name` and `user_pool_id`.
 * @property name
 * @property precedence Precedence of the user group.
 * @property roleArn ARN of the IAM role to be associated with the user group.
 * @property userPoolId
 */
public data class GetUserGroupResult(
    public val description: String,
    public val id: String,
    public val name: String,
    public val precedence: Int,
    public val roleArn: String,
    public val userPoolId: String,
) {
    public companion object {
        public fun toKotlin(javaType: com.pulumi.aws.cognito.outputs.GetUserGroupResult): GetUserGroupResult = GetUserGroupResult(
            description = javaType.description(),
            id = javaType.id(),
            name = javaType.name(),
            precedence = javaType.precedence(),
            roleArn = javaType.roleArn(),
            userPoolId = javaType.userPoolId(),
        )
    }
}
