@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.aws.cognito.kotlin.outputs

import kotlin.Int
import kotlin.String
import kotlin.Suppress

/**
 *
 * @property description Description of the user group.
 * @property groupName Name of the user group.
 * @property precedence Precedence of the user group.
 * @property roleArn ARN of the IAM role to be associated with the user group.
 */
public data class GetUserGroupsGroup(
    public val description: String,
    public val groupName: String,
    public val precedence: Int,
    public val roleArn: String,
) {
    public companion object {
        public fun toKotlin(javaType: com.pulumi.aws.cognito.outputs.GetUserGroupsGroup): GetUserGroupsGroup = GetUserGroupsGroup(
            description = javaType.description(),
            groupName = javaType.groupName(),
            precedence = javaType.precedence(),
            roleArn = javaType.roleArn(),
        )
    }
}
