@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.aws.cognito.kotlin.outputs

import kotlin.String
import kotlin.Suppress
import kotlin.collections.List

/**
 * A collection of values returned by getUserGroups.
 * @property groups List of groups. See `groups` below.
 * @property id User pool identifier.
 * @property userPoolId
 */
public data class GetUserGroupsResult(
    public val groups: List<GetUserGroupsGroup>,
    public val id: String,
    public val userPoolId: String,
) {
    public companion object {
        public fun toKotlin(javaType: com.pulumi.aws.cognito.outputs.GetUserGroupsResult): GetUserGroupsResult = GetUserGroupsResult(
            groups = javaType.groups().map({ args0 ->
                args0.let({ args0 ->
                    com.pulumi.aws.cognito.kotlin.outputs.GetUserGroupsGroup.Companion.toKotlin(args0)
                })
            }),
            id = javaType.id(),
            userPoolId = javaType.userPoolId(),
        )
    }
}
