@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.aws.cognito.kotlin.outputs

import kotlin.Boolean
import kotlin.Int
import kotlin.Suppress
import kotlin.collections.List

/**
 *
 * @property allowAdminCreateUserOnly - Whether only admins can create users.
 * @property inviteMessageTemplates
 * @property unusedAccountValidityDays - Number of days an unconfirmed user account remains valid.
 * * invite_message_template - Templates for invitation messages.
 */
public data class GetUserPoolAdminCreateUserConfig(
    public val allowAdminCreateUserOnly: Boolean,
    public val inviteMessageTemplates: List<GetUserPoolAdminCreateUserConfigInviteMessageTemplate>,
    public val unusedAccountValidityDays: Int,
) {
    public companion object {
        public fun toKotlin(javaType: com.pulumi.aws.cognito.outputs.GetUserPoolAdminCreateUserConfig): GetUserPoolAdminCreateUserConfig = GetUserPoolAdminCreateUserConfig(
            allowAdminCreateUserOnly = javaType.allowAdminCreateUserOnly(),
            inviteMessageTemplates = javaType.inviteMessageTemplates().map({ args0 ->
                args0.let({ args0 ->
                    com.pulumi.aws.cognito.kotlin.outputs.GetUserPoolAdminCreateUserConfigInviteMessageTemplate.Companion.toKotlin(args0)
                })
            }),
            unusedAccountValidityDays = javaType.unusedAccountValidityDays(),
        )
    }
}
