@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.aws.cognito.kotlin.outputs

import kotlin.Boolean
import kotlin.String
import kotlin.Suppress

/**
 *
 * @property applicationArn (Optional) Application ARN for an Amazon Pinpoint application. Conflicts with `external_id` and `role_arn`.
 * @property applicationId (Optional) Application ID for an Amazon Pinpoint application.
 * @property externalId (Optional) ID for the Analytics Configuration. Conflicts with `application_arn`.
 * @property roleArn (Optional) ARN of an IAM role that authorizes Amazon Cognito to publish events to Amazon Pinpoint analytics. Conflicts with `application_arn`.
 * @property userDataShared (Optional) If set to `true`, Amazon Cognito will include user data in the events it publishes to Amazon Pinpoint analytics.
 */
public data class GetUserPoolClientAnalyticsConfiguration(
    public val applicationArn: String,
    public val applicationId: String,
    public val externalId: String,
    public val roleArn: String,
    public val userDataShared: Boolean,
) {
    public companion object {
        public fun toKotlin(javaType: com.pulumi.aws.cognito.outputs.GetUserPoolClientAnalyticsConfiguration): GetUserPoolClientAnalyticsConfiguration = GetUserPoolClientAnalyticsConfiguration(
            applicationArn = javaType.applicationArn(),
            applicationId = javaType.applicationId(),
            externalId = javaType.externalId(),
            roleArn = javaType.roleArn(),
            userDataShared = javaType.userDataShared(),
        )
    }
}
