@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.aws.cognito.kotlin.outputs

import kotlin.Boolean
import kotlin.Int
import kotlin.String
import kotlin.Suppress
import kotlin.collections.List

/**
 * A collection of values returned by getUserPoolClient.
 * @property accessTokenValidity (Optional) Time limit, between 5 minutes and 1 day, after which the access token is no longer valid and cannot be used. This value will be overridden if you have entered a value in `token_validity_units`.
 * @property allowedOauthFlows (Optional) List of allowed OAuth flows (code, implicit, client_credentials).
 * @property allowedOauthFlowsUserPoolClient (Optional) Whether the client is allowed to follow the OAuth protocol when interacting with Cognito user pools.
 * @property allowedOauthScopes (Optional) List of allowed OAuth scopes (phone, email, openid, profile, and aws.cognito.signin.user.admin).
 * @property analyticsConfigurations (Optional) Configuration block for Amazon Pinpoint analytics for collecting metrics for this user pool. Detailed below.
 * @property callbackUrls (Optional) List of allowed callback URLs for the identity providers.
 * @property clientId
 * @property clientSecret Client secret of the user pool client.
 * @property defaultRedirectUri (Optional) Default redirect URI. Must be in the list of callback URLs.
 * @property enablePropagateAdditionalUserContextData
 * @property enableTokenRevocation (Optional) Enables or disables token revocation.
 * @property explicitAuthFlows (Optional) List of authentication flows (ADMIN_NO_SRP_AUTH, CUSTOM_AUTH_FLOW_ONLY, USER_PASSWORD_AUTH, ALLOW_ADMIN_USER_PASSWORD_AUTH, ALLOW_CUSTOM_AUTH, ALLOW_USER_PASSWORD_AUTH, ALLOW_USER_SRP_AUTH, ALLOW_REFRESH_TOKEN_AUTH).
 * @property generateSecret (Optional) Should an application secret be generated.
 * @property id The provider-assigned unique ID for this managed resource.
 * @property idTokenValidity (Optional) Time limit, between 5 minutes and 1 day, after which the ID token is no longer valid and cannot be used. This value will be overridden if you have entered a value in `token_validity_units`.
 * @property logoutUrls (Optional) List of allowed logout URLs for the identity providers.
 * @property name
 * @property preventUserExistenceErrors (Optional) Choose which errors and responses are returned by Cognito APIs during authentication, account confirmation, and password recovery when the user does not exist in the user pool. When set to `ENABLED` and the user does not exist, authentication returns an error indicating either the username or password was incorrect, and account confirmation and password recovery return a response indicating a code was sent to a simulated destination. When set to `LEGACY`, those APIs will return a `UserNotFoundException` exception if the user does not exist in the user pool.
 * @property readAttributes (Optional) List of user pool attributes the application client can read from.
 * @property refreshTokenValidity (Optional) Time limit in days refresh tokens are valid for.
 * @property supportedIdentityProviders (Optional) List of provider names for the identity providers that are supported on this client. Uses the `provider_name` attribute of `aws.cognito.IdentityProvider` resource(s), or the equivalent string(s).
 * @property tokenValidityUnits (Optional) Configuration block for units in which the validity times are represented in. Detailed below.
 * @property userPoolId
 * @property writeAttributes (Optional) List of user pool attributes the application client can write to.
 */
public data class GetUserPoolClientResult(
    public val accessTokenValidity: Int,
    public val allowedOauthFlows: List<String>,
    public val allowedOauthFlowsUserPoolClient: Boolean,
    public val allowedOauthScopes: List<String>,
    public val analyticsConfigurations: List<GetUserPoolClientAnalyticsConfiguration>,
    public val callbackUrls: List<String>,
    public val clientId: String,
    public val clientSecret: String,
    public val defaultRedirectUri: String,
    public val enablePropagateAdditionalUserContextData: Boolean,
    public val enableTokenRevocation: Boolean,
    public val explicitAuthFlows: List<String>,
    public val generateSecret: Boolean,
    public val id: String,
    public val idTokenValidity: Int,
    public val logoutUrls: List<String>,
    public val name: String,
    public val preventUserExistenceErrors: String,
    public val readAttributes: List<String>,
    public val refreshTokenValidity: Int,
    public val supportedIdentityProviders: List<String>,
    public val tokenValidityUnits: List<GetUserPoolClientTokenValidityUnit>,
    public val userPoolId: String,
    public val writeAttributes: List<String>,
) {
    public companion object {
        public fun toKotlin(javaType: com.pulumi.aws.cognito.outputs.GetUserPoolClientResult): GetUserPoolClientResult = GetUserPoolClientResult(
            accessTokenValidity = javaType.accessTokenValidity(),
            allowedOauthFlows = javaType.allowedOauthFlows().map({ args0 -> args0 }),
            allowedOauthFlowsUserPoolClient = javaType.allowedOauthFlowsUserPoolClient(),
            allowedOauthScopes = javaType.allowedOauthScopes().map({ args0 -> args0 }),
            analyticsConfigurations = javaType.analyticsConfigurations().map({ args0 ->
                args0.let({ args0 ->
                    com.pulumi.aws.cognito.kotlin.outputs.GetUserPoolClientAnalyticsConfiguration.Companion.toKotlin(args0)
                })
            }),
            callbackUrls = javaType.callbackUrls().map({ args0 -> args0 }),
            clientId = javaType.clientId(),
            clientSecret = javaType.clientSecret(),
            defaultRedirectUri = javaType.defaultRedirectUri(),
            enablePropagateAdditionalUserContextData = javaType.enablePropagateAdditionalUserContextData(),
            enableTokenRevocation = javaType.enableTokenRevocation(),
            explicitAuthFlows = javaType.explicitAuthFlows().map({ args0 -> args0 }),
            generateSecret = javaType.generateSecret(),
            id = javaType.id(),
            idTokenValidity = javaType.idTokenValidity(),
            logoutUrls = javaType.logoutUrls().map({ args0 -> args0 }),
            name = javaType.name(),
            preventUserExistenceErrors = javaType.preventUserExistenceErrors(),
            readAttributes = javaType.readAttributes().map({ args0 -> args0 }),
            refreshTokenValidity = javaType.refreshTokenValidity(),
            supportedIdentityProviders = javaType.supportedIdentityProviders().map({ args0 -> args0 }),
            tokenValidityUnits = javaType.tokenValidityUnits().map({ args0 ->
                args0.let({ args0 ->
                    com.pulumi.aws.cognito.kotlin.outputs.GetUserPoolClientTokenValidityUnit.Companion.toKotlin(args0)
                })
            }),
            userPoolId = javaType.userPoolId(),
            writeAttributes = javaType.writeAttributes().map({ args0 -> args0 }),
        )
    }
}
