@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.aws.cognito.kotlin.outputs

import kotlin.Boolean
import kotlin.Suppress

/**
 *
 * @property challengeRequiredOnNewDevice - Whether a challenge is required on new devices.
 * @property deviceOnlyRememberedOnUserPrompt - Whether devices are only remembered if the user prompts it.
 */
public data class GetUserPoolDeviceConfiguration(
    public val challengeRequiredOnNewDevice: Boolean,
    public val deviceOnlyRememberedOnUserPrompt: Boolean,
) {
    public companion object {
        public fun toKotlin(javaType: com.pulumi.aws.cognito.outputs.GetUserPoolDeviceConfiguration): GetUserPoolDeviceConfiguration = GetUserPoolDeviceConfiguration(
            challengeRequiredOnNewDevice = javaType.challengeRequiredOnNewDevice(),
            deviceOnlyRememberedOnUserPrompt = javaType.deviceOnlyRememberedOnUserPrompt(),
        )
    }
}
