@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.aws.cognito.kotlin.outputs

import kotlin.String
import kotlin.Suppress

/**
 *
 * @property configurationSet - Configuration set used for sending emails.
 * @property emailSendingAccount - Email sending account.
 * @property from - Email sender address.
 * @property replyToEmailAddress - Reply-to email address.
 * @property sourceArn - Source Amazon Resource Name (ARN) for emails.
 */
public data class GetUserPoolEmailConfiguration(
    public val configurationSet: String,
    public val emailSendingAccount: String,
    public val from: String,
    public val replyToEmailAddress: String,
    public val sourceArn: String,
) {
    public companion object {
        public fun toKotlin(javaType: com.pulumi.aws.cognito.outputs.GetUserPoolEmailConfiguration): GetUserPoolEmailConfiguration = GetUserPoolEmailConfiguration(
            configurationSet = javaType.configurationSet(),
            emailSendingAccount = javaType.emailSendingAccount(),
            from = javaType.from(),
            replyToEmailAddress = javaType.replyToEmailAddress(),
            sourceArn = javaType.sourceArn(),
        )
    }
}
