@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.aws.cognito.kotlin.outputs

import kotlin.String
import kotlin.Suppress
import kotlin.collections.List

/**
 *
 * @property createAuthChallenge
 * @property customEmailSenders
 * @property customMessage
 * @property customSmsSenders
 * @property defineAuthChallenge
 * @property kmsKeyId
 * @property postAuthentication
 * @property postConfirmation
 * @property preAuthentication
 * @property preSignUp
 * @property preTokenGeneration
 * @property preTokenGenerationConfigs
 * @property userMigration
 * @property verifyAuthChallengeResponse
 */
public data class GetUserPoolLambdaConfig(
    public val createAuthChallenge: String,
    public val customEmailSenders: List<GetUserPoolLambdaConfigCustomEmailSender>,
    public val customMessage: String,
    public val customSmsSenders: List<GetUserPoolLambdaConfigCustomSmsSender>,
    public val defineAuthChallenge: String,
    public val kmsKeyId: String,
    public val postAuthentication: String,
    public val postConfirmation: String,
    public val preAuthentication: String,
    public val preSignUp: String,
    public val preTokenGeneration: String,
    public val preTokenGenerationConfigs: List<GetUserPoolLambdaConfigPreTokenGenerationConfig>,
    public val userMigration: String,
    public val verifyAuthChallengeResponse: String,
) {
    public companion object {
        public fun toKotlin(javaType: com.pulumi.aws.cognito.outputs.GetUserPoolLambdaConfig): GetUserPoolLambdaConfig = GetUserPoolLambdaConfig(
            createAuthChallenge = javaType.createAuthChallenge(),
            customEmailSenders = javaType.customEmailSenders().map({ args0 ->
                args0.let({ args0 ->
                    com.pulumi.aws.cognito.kotlin.outputs.GetUserPoolLambdaConfigCustomEmailSender.Companion.toKotlin(args0)
                })
            }),
            customMessage = javaType.customMessage(),
            customSmsSenders = javaType.customSmsSenders().map({ args0 ->
                args0.let({ args0 ->
                    com.pulumi.aws.cognito.kotlin.outputs.GetUserPoolLambdaConfigCustomSmsSender.Companion.toKotlin(args0)
                })
            }),
            defineAuthChallenge = javaType.defineAuthChallenge(),
            kmsKeyId = javaType.kmsKeyId(),
            postAuthentication = javaType.postAuthentication(),
            postConfirmation = javaType.postConfirmation(),
            preAuthentication = javaType.preAuthentication(),
            preSignUp = javaType.preSignUp(),
            preTokenGeneration = javaType.preTokenGeneration(),
            preTokenGenerationConfigs = javaType.preTokenGenerationConfigs().map({ args0 ->
                args0.let({ args0 ->
                    com.pulumi.aws.cognito.kotlin.outputs.GetUserPoolLambdaConfigPreTokenGenerationConfig.Companion.toKotlin(args0)
                })
            }),
            userMigration = javaType.userMigration(),
            verifyAuthChallengeResponse = javaType.verifyAuthChallengeResponse(),
        )
    }
}
