@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.aws.cognito.kotlin.outputs

import kotlin.Int
import kotlin.String
import kotlin.Suppress
import kotlin.collections.List
import kotlin.collections.Map

/**
 * A collection of values returned by getUserPool.
 * @property accountRecoverySettings
 * @property adminCreateUserConfigs
 * @property arn ARN of the User Pool.
 * * account_recovery_setting - The available verified method a user can use to recover their password when they call ForgotPassword. You can use this setting to define a preferred method when a user has more than one method available. With this setting, SMS doesn't qualify for a valid password recovery mechanism if the user also has SMS multi-factor authentication (MFA) activated. In the absence of this setting, Amazon Cognito uses the legacy behavior to determine the recovery method where SMS is preferred through email.
 * * admin_create_user_config - The configuration for AdminCreateUser requests.
 * @property autoVerifiedAttributes The attributes that are auto-verified in a user pool.
 * @property creationDate The date and time, in ISO 8601 format, when the item was created.
 * @property customDomain A custom domain name that you provide to Amazon Cognito. This parameter applies only if you use a custom domain to host the sign-up and sign-in pages for your application. An example of a custom domain name might be auth.example.com.
 * @property deletionProtection When active, DeletionProtection prevents accidental deletion of your user pool. Before you can delete a user pool that you have protected against deletion, you must deactivate this feature.
 * * device_configuration - The device-remembering configuration for a user pool. A null value indicates that you have deactivated device remembering in your user pool.
 * @property deviceConfigurations
 * @property domain The domain prefix, if the user pool has a domain associated with it.
 * * email_configuration - The email configuration of your user pool. The email configuration type sets your preferred sending method, AWS Region, and sender for messages from your user pool.
 * @property emailConfigurations
 * @property estimatedNumberOfUsers A number estimating the size of the user pool.
 * * lambda_config - The AWS Lambda triggers associated with the user pool.
 * @property id
 * @property lambdaConfigs
 * @property lastModifiedDate The date and time, in ISO 8601 format, when the item was modified.
 * @property mfaConfiguration Can be one of the following values: `OFF` | `ON` | `OPTIONAL`
 * @property name - Name of the attribute.
 * @property schemaAttributes
 * @property smsAuthenticationMessage The contents of the SMS authentication message.
 * @property smsConfigurationFailure The reason why the SMS configuration can't send the messages to your users.
 * @property smsVerificationMessage The contents of the SMS authentication message.
 * @property userPoolId
 * @property userPoolTags The tags that are assigned to the user pool. A tag is a label that you can apply to user pools to categorize and manage them in different ways, such as by purpose, owner, environment, or other criteria.
 * @property usernameAttributes Specifies whether a user can use an email address or phone number as a username when they sign up.
 */
public data class GetUserPoolResult(
    public val accountRecoverySettings: List<GetUserPoolAccountRecoverySetting>,
    public val adminCreateUserConfigs: List<GetUserPoolAdminCreateUserConfig>,
    public val arn: String,
    public val autoVerifiedAttributes: List<String>,
    public val creationDate: String,
    public val customDomain: String,
    public val deletionProtection: String,
    public val deviceConfigurations: List<GetUserPoolDeviceConfiguration>,
    public val domain: String,
    public val emailConfigurations: List<GetUserPoolEmailConfiguration>,
    public val estimatedNumberOfUsers: Int,
    public val id: String,
    public val lambdaConfigs: List<GetUserPoolLambdaConfig>,
    public val lastModifiedDate: String,
    public val mfaConfiguration: String,
    public val name: String,
    public val schemaAttributes: List<GetUserPoolSchemaAttribute>,
    public val smsAuthenticationMessage: String,
    public val smsConfigurationFailure: String,
    public val smsVerificationMessage: String,
    public val userPoolId: String,
    public val userPoolTags: Map<String, String>,
    public val usernameAttributes: List<String>,
) {
    public companion object {
        public fun toKotlin(javaType: com.pulumi.aws.cognito.outputs.GetUserPoolResult): GetUserPoolResult = GetUserPoolResult(
            accountRecoverySettings = javaType.accountRecoverySettings().map({ args0 ->
                args0.let({ args0 ->
                    com.pulumi.aws.cognito.kotlin.outputs.GetUserPoolAccountRecoverySetting.Companion.toKotlin(args0)
                })
            }),
            adminCreateUserConfigs = javaType.adminCreateUserConfigs().map({ args0 ->
                args0.let({ args0 ->
                    com.pulumi.aws.cognito.kotlin.outputs.GetUserPoolAdminCreateUserConfig.Companion.toKotlin(args0)
                })
            }),
            arn = javaType.arn(),
            autoVerifiedAttributes = javaType.autoVerifiedAttributes().map({ args0 -> args0 }),
            creationDate = javaType.creationDate(),
            customDomain = javaType.customDomain(),
            deletionProtection = javaType.deletionProtection(),
            deviceConfigurations = javaType.deviceConfigurations().map({ args0 ->
                args0.let({ args0 ->
                    com.pulumi.aws.cognito.kotlin.outputs.GetUserPoolDeviceConfiguration.Companion.toKotlin(args0)
                })
            }),
            domain = javaType.domain(),
            emailConfigurations = javaType.emailConfigurations().map({ args0 ->
                args0.let({ args0 ->
                    com.pulumi.aws.cognito.kotlin.outputs.GetUserPoolEmailConfiguration.Companion.toKotlin(args0)
                })
            }),
            estimatedNumberOfUsers = javaType.estimatedNumberOfUsers(),
            id = javaType.id(),
            lambdaConfigs = javaType.lambdaConfigs().map({ args0 ->
                args0.let({ args0 ->
                    com.pulumi.aws.cognito.kotlin.outputs.GetUserPoolLambdaConfig.Companion.toKotlin(args0)
                })
            }),
            lastModifiedDate = javaType.lastModifiedDate(),
            mfaConfiguration = javaType.mfaConfiguration(),
            name = javaType.name(),
            schemaAttributes = javaType.schemaAttributes().map({ args0 ->
                args0.let({ args0 ->
                    com.pulumi.aws.cognito.kotlin.outputs.GetUserPoolSchemaAttribute.Companion.toKotlin(args0)
                })
            }),
            smsAuthenticationMessage = javaType.smsAuthenticationMessage(),
            smsConfigurationFailure = javaType.smsConfigurationFailure(),
            smsVerificationMessage = javaType.smsVerificationMessage(),
            userPoolId = javaType.userPoolId(),
            userPoolTags = javaType.userPoolTags().map({ args0 -> args0.key.to(args0.value) }).toMap(),
            usernameAttributes = javaType.usernameAttributes().map({ args0 -> args0 }),
        )
    }
}
