@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.aws.cognito.kotlin.outputs

import kotlin.Boolean
import kotlin.String
import kotlin.Suppress
import kotlin.collections.List

/**
 *
 * @property attributeDataType - Data type of the attribute (e.g., string, number).
 * @property developerOnlyAttribute - Whether the attribute is for developer use only.
 * @property mutable - Whether the attribute can be changed after user creation.
 * @property name - Name of the attribute.
 * @property numberAttributeConstraints
 * @property required - Whether the attribute is required during user registration.
 * * number_attribute_constraints - Constraints for numeric attributes.
 * * string_attribute_constraints - Constraints for string attributes.
 * @property stringAttributeConstraints
 */
public data class GetUserPoolSchemaAttribute(
    public val attributeDataType: String,
    public val developerOnlyAttribute: Boolean,
    public val mutable: Boolean,
    public val name: String,
    public val numberAttributeConstraints: List<GetUserPoolSchemaAttributeNumberAttributeConstraint>,
    public val required: Boolean,
    public val stringAttributeConstraints: List<GetUserPoolSchemaAttributeStringAttributeConstraint>,
) {
    public companion object {
        public fun toKotlin(javaType: com.pulumi.aws.cognito.outputs.GetUserPoolSchemaAttribute): GetUserPoolSchemaAttribute = GetUserPoolSchemaAttribute(
            attributeDataType = javaType.attributeDataType(),
            developerOnlyAttribute = javaType.developerOnlyAttribute(),
            mutable = javaType.mutable(),
            name = javaType.name(),
            numberAttributeConstraints = javaType.numberAttributeConstraints().map({ args0 ->
                args0.let({ args0 ->
                    com.pulumi.aws.cognito.kotlin.outputs.GetUserPoolSchemaAttributeNumberAttributeConstraint.Companion.toKotlin(args0)
                })
            }),
            required = javaType.required(),
            stringAttributeConstraints = javaType.stringAttributeConstraints().map({ args0 ->
                args0.let({ args0 ->
                    com.pulumi.aws.cognito.kotlin.outputs.GetUserPoolSchemaAttributeStringAttributeConstraint.Companion.toKotlin(args0)
                })
            }),
        )
    }
}
