@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.aws.cognito.kotlin.outputs

import kotlin.Boolean
import kotlin.String
import kotlin.Suppress

/**
 *
 * @property applicationArn Application ARN for an Amazon Pinpoint application. It conflicts with `external_id` and `role_arn`.
 * @property applicationId Unique identifier for an Amazon Pinpoint application.
 * @property externalId ID for the Analytics Configuration and conflicts with `application_arn`.
 * @property roleArn ARN of an IAM role that authorizes Amazon Cognito to publish events to Amazon Pinpoint analytics. It conflicts with `application_arn`.
 * @property userDataShared If `user_data_shared` is set to `true`, Amazon Cognito will include user data in the events it publishes to Amazon Pinpoint analytics.
 */
public data class ManagedUserPoolClientAnalyticsConfiguration(
    public val applicationArn: String? = null,
    public val applicationId: String? = null,
    public val externalId: String? = null,
    public val roleArn: String? = null,
    public val userDataShared: Boolean? = null,
) {
    public companion object {
        public fun toKotlin(javaType: com.pulumi.aws.cognito.outputs.ManagedUserPoolClientAnalyticsConfiguration): ManagedUserPoolClientAnalyticsConfiguration = ManagedUserPoolClientAnalyticsConfiguration(
            applicationArn = javaType.applicationArn().map({ args0 -> args0 }).orElse(null),
            applicationId = javaType.applicationId().map({ args0 -> args0 }).orElse(null),
            externalId = javaType.externalId().map({ args0 -> args0 }).orElse(null),
            roleArn = javaType.roleArn().map({ args0 -> args0 }).orElse(null),
            userDataShared = javaType.userDataShared().map({ args0 -> args0 }).orElse(null),
        )
    }
}
